/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-10-19 11:46:53 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_3_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_3_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_wp_3_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `wp_3_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_3_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=322 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=937 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_blogmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_blogs` (
  `blog_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `domain` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `public` tinyint(2) NOT NULL DEFAULT '1',
  `archived` tinyint(2) NOT NULL DEFAULT '0',
  `mature` tinyint(2) NOT NULL DEFAULT '0',
  `spam` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` tinyint(2) NOT NULL DEFAULT '0',
  `lang_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`blog_id`),
  KEY `domain` (`domain`(50),`path`(5)),
  KEY `lang_id` (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) DEFAULT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  `flag_group` tinyint(1) NOT NULL DEFAULT '0',
  `flag_dirty` tinyint(1) NOT NULL DEFAULT '0',
  `keywords` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_drafts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slider_id` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=40008 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6709 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3798 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_registration_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `IP` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `date_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ID`),
  KEY `IP` (`IP`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rsssl_csp_log` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `documenturi` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `violateddirective` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `blockeduri` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inpolicy` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_signups` (
  `signup_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `activation_key` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`signup_id`),
  KEY `activation_key` (`activation_key`),
  KEY `user_email` (`user_email`),
  KEY `user_login_email` (`user_login`,`user_email`),
  KEY `domain_path` (`domain`(140),`path`(51))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_site` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`(140),`path`(51))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sitemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `spam` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3793 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`,`meta_value`(100)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`,`meta_value`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpf_logging` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `user` bigint(8) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_3_actionscheduler_actions */
INSERT INTO `wp_3_actionscheduler_actions` VALUES("4", "action_scheduler/migration_hook", "complete", "2021-01-31 12:30:32", "2021-01-31 12:30:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1612096232;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1612096232;}", "1", "1", "2021-01-31 12:30:35", "2021-01-31 16:00:35", "0", NULL);

/* INSERT TABLE DATA: wp_3_actionscheduler_groups */
INSERT INTO `wp_3_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: wp_3_actionscheduler_logs */
INSERT INTO `wp_3_actionscheduler_logs` VALUES("1", "4", "ایجاد فعالیت", "2021-01-31 12:29:32", "2021-01-31 12:29:32");
INSERT INTO `wp_3_actionscheduler_logs` VALUES("2", "4", "action started via Async Request", "2021-01-31 12:30:35", "2021-01-31 16:00:35");
INSERT INTO `wp_3_actionscheduler_logs` VALUES("3", "4", "action complete via Async Request", "2021-01-31 12:30:35", "2021-01-31 16:00:35");

/* INSERT TABLE DATA: wp_3_comments */
INSERT INTO `wp_3_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "http://localhost/enfold/", "", "2021-01-31 15:59:23", "2021-01-31 12:29:23", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_3_options */
INSERT INTO `wp_3_options` VALUES("1", "siteurl", "http://localhost/enfold/construction", "yes");
INSERT INTO `wp_3_options` VALUES("2", "home", "http://localhost/enfold/construction", "yes");
INSERT INTO `wp_3_options` VALUES("3", "blogname", "ساخت و ساز", "yes");
INSERT INTO `wp_3_options` VALUES("4", "blogdescription", "یک پیش نمایش از انفولد", "yes");
INSERT INTO `wp_3_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_3_options` VALUES("6", "admin_email", "info@khatamwp.dev", "yes");
INSERT INTO `wp_3_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_3_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_3_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_3_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_3_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_3_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_3_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_3_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_3_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_3_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_3_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_3_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_3_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_3_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_3_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_3_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_3_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_3_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_3_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_3_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_3_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_3_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_3_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_3_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_3_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_3_options` VALUES("33", "active_plugins", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_3_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_3_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_3_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_3_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_3_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_3_options` VALUES("40", "template", "twentytwentyone", "yes");
INSERT INTO `wp_3_options` VALUES("41", "stylesheet", "twentytwentyone", "yes");
INSERT INTO `wp_3_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_3_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_3_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_3_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_3_options` VALUES("46", "db_version", "49752", "yes");
INSERT INTO `wp_3_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_3_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_3_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_3_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_3_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `wp_3_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_3_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_3_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_3_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_3_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_3_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_3_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_3_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_3_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_3_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_3_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_3_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_3_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_3_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_3_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_3_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_3_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_3_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_3_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_3_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_3_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_3_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_3_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_3_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("76", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_3_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_3_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_3_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `wp_3_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_3_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_3_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_3_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_3_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_3_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_3_options` VALUES("89", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `wp_3_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_3_options` VALUES("91", "admin_email_lifespan", "1627648163", "yes");
INSERT INTO `wp_3_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_3_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_3_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_3_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_3_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_3_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_3_options` VALUES("98", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_3_options` VALUES("99", "wp_3_user_roles", "a:12:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:30:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:17:\"assign_moderators\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:26:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:17:\"assign_moderators\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wp_3_options` VALUES("100", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("101", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("102", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("103", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("104", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("105", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_3_options` VALUES("106", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_3_options` VALUES("107", "duplicator_settings", "a:17:{s:7:\"version\";s:8:\"1.3.40.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:-1;}", "yes");
INSERT INTO `wp_3_options` VALUES("108", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wp_3_options` VALUES("109", "duplicator_version_plugin", "1.3.40.1", "yes");
INSERT INTO `wp_3_options` VALUES("110", "cron", "a:15:{i:1612096528;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1612099768;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1612099770;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1612099772;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1612099783;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1612106970;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1612117770;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1612126800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1612182568;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1612182571;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1612182578;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1612182580;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1612182634;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1613392230;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_3_options` VALUES("111", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"xs0a0fNsXbUc04SzS56NZELuPYZx3gDQ\";}", "yes");
INSERT INTO `wp_3_options` VALUES("112", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("113", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("114", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("115", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("116", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("117", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("118", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("122", "widget_bbp_login_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("123", "widget_bbp_views_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("124", "widget_bbp_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("125", "widget_bbp_forums_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("126", "widget_bbp_topics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("127", "widget_bbp_replies_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("128", "widget_bbp_stats_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("129", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("130", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("131", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("132", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("133", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("134", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("135", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("136", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("137", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("138", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("139", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("140", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("141", "action_scheduler_hybrid_store_demarkation", "3", "yes");
INSERT INTO `wp_3_options` VALUES("142", "schema-ActionScheduler_StoreSchema", "3.0.1612096168", "yes");
INSERT INTO `wp_3_options` VALUES("143", "schema-ActionScheduler_LoggerSchema", "2.0.1612096168", "yes");
INSERT INTO `wp_3_options` VALUES("145", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("146", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_3_options` VALUES("149", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wp_3_options` VALUES("150", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_3_options` VALUES("151", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_3_options` VALUES("152", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_3_options` VALUES("153", "woocommerce_default_country", "GB", "yes");
INSERT INTO `wp_3_options` VALUES("154", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_3_options` VALUES("155", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_3_options` VALUES("156", "woocommerce_all_except_countries", "", "yes");
INSERT INTO `wp_3_options` VALUES("157", "woocommerce_specific_allowed_countries", "", "yes");
INSERT INTO `wp_3_options` VALUES("158", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_3_options` VALUES("159", "woocommerce_specific_ship_to_countries", "", "yes");
INSERT INTO `wp_3_options` VALUES("160", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_3_options` VALUES("161", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_3_options` VALUES("162", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("163", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_3_options` VALUES("164", "woocommerce_currency", "GBP", "yes");
INSERT INTO `wp_3_options` VALUES("165", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wp_3_options` VALUES("166", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_3_options` VALUES("167", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_3_options` VALUES("168", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_3_options` VALUES("169", "woocommerce_shop_page_id", "4", "yes");
INSERT INTO `wp_3_options` VALUES("170", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_3_options` VALUES("171", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("172", "woocommerce_placeholder_image", "3", "yes");
INSERT INTO `wp_3_options` VALUES("173", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_3_options` VALUES("174", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_3_options` VALUES("175", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("176", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_3_options` VALUES("177", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_3_options` VALUES("178", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("179", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_3_options` VALUES("180", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("181", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_3_options` VALUES("182", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_3_options` VALUES("183", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_3_options` VALUES("184", "woocommerce_stock_email_recipient", "info@khatamwp.dev", "no");
INSERT INTO `wp_3_options` VALUES("185", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_3_options` VALUES("186", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_3_options` VALUES("187", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_3_options` VALUES("188", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_3_options` VALUES("189", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_3_options` VALUES("190", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_3_options` VALUES("191", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_3_options` VALUES("192", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("193", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_3_options` VALUES("194", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_3_options` VALUES("195", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_3_options` VALUES("196", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_3_options` VALUES("197", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_3_options` VALUES("198", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_3_options` VALUES("199", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_3_options` VALUES("200", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_3_options` VALUES("201", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_3_options` VALUES("202", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_3_options` VALUES("203", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_3_options` VALUES("204", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_3_options` VALUES("205", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_3_options` VALUES("206", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_3_options` VALUES("207", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_3_options` VALUES("208", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_3_options` VALUES("209", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_3_options` VALUES("210", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_3_options` VALUES("211", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_3_options` VALUES("212", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_3_options` VALUES("213", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_3_options` VALUES("214", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_3_options` VALUES("215", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_3_options` VALUES("216", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_3_options` VALUES("217", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_3_options` VALUES("218", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_3_options` VALUES("219", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_3_options` VALUES("220", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_3_options` VALUES("221", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_3_options` VALUES("222", "woocommerce_email_from_name", "ساخت و ساز", "no");
INSERT INTO `wp_3_options` VALUES("223", "woocommerce_email_from_address", "info@khatamwp.dev", "no");
INSERT INTO `wp_3_options` VALUES("224", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_3_options` VALUES("225", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_3_options` VALUES("226", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_3_options` VALUES("227", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_3_options` VALUES("228", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_3_options` VALUES("229", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_3_options` VALUES("230", "woocommerce_cart_page_id", "5", "no");
INSERT INTO `wp_3_options` VALUES("231", "woocommerce_checkout_page_id", "6", "no");
INSERT INTO `wp_3_options` VALUES("232", "woocommerce_myaccount_page_id", "7", "no");
INSERT INTO `wp_3_options` VALUES("233", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_3_options` VALUES("234", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_3_options` VALUES("235", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_3_options` VALUES("236", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_3_options` VALUES("237", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_3_options` VALUES("238", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_3_options` VALUES("239", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_3_options` VALUES("240", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_3_options` VALUES("241", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_3_options` VALUES("242", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_3_options` VALUES("243", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_3_options` VALUES("244", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_3_options` VALUES("245", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_3_options` VALUES("246", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_3_options` VALUES("247", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_3_options` VALUES("248", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_3_options` VALUES("249", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_3_options` VALUES("250", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_3_options` VALUES("251", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_3_options` VALUES("252", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_3_options` VALUES("253", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_3_options` VALUES("254", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("255", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_3_options` VALUES("256", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("257", "default_product_cat", "15", "yes");
INSERT INTO `wp_3_options` VALUES("258", "fresh_site", "0", "yes");
INSERT INTO `wp_3_options` VALUES("261", "woocommerce_version", "4.9.2", "yes");
INSERT INTO `wp_3_options` VALUES("262", "woocommerce_db_version", "4.9.2", "yes");
INSERT INTO `wp_3_options` VALUES("263", "_transient_timeout__woocommerce_upload_directory_status", "1612182571", "no");
INSERT INTO `wp_3_options` VALUES("264", "_transient__woocommerce_upload_directory_status", "protected", "no");
INSERT INTO `wp_3_options` VALUES("265", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_3_options` VALUES("266", "woocommerce_task_list_hidden", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("269", "woocommerce_admin_version", "1.8.3", "yes");
INSERT INTO `wp_3_options` VALUES("270", "woocommerce_admin_install_timestamp", "1612096171", "yes");
INSERT INTO `wp_3_options` VALUES("272", "_transient_wc_attribute_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("273", "_transient_timeout_as-post-store-dependencies-met", "1612182572", "no");
INSERT INTO `wp_3_options` VALUES("274", "_transient_as-post-store-dependencies-met", "yes", "no");
INSERT INTO `wp_3_options` VALUES("275", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1612096172", "yes");
INSERT INTO `wp_3_options` VALUES("276", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_3_options` VALUES("277", "action_scheduler_lock_async-request-runner", "1612096569", "yes");
INSERT INTO `wp_3_options` VALUES("278", "woocommerce_admin_notices", "a:1:{i:0;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `wp_3_options` VALUES("279", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_3_options` VALUES("280", "wc_remote_inbox_notifications_specs", "a:9:{s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Manage subscriber payments from your store\'s dashboard\";s:7:\"content\";s:643:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:10:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"1.7.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2020-11-18 14:00:00\";}i:7;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2020-12-07 00:00:00\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:26:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CO\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"FL\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"HI\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ID\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IN\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KS\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KY\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"LA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MA\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MN\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MT\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NE\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NV\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NH\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NM\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ND\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OH\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OR\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"PA\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SD\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TN\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TX\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VA\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WA\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WI\";}}}}}s:27:\"wcpay-subscriptions-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"wcpay-subscriptions-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Manage subscriber payments from your store\'s dashboard\";s:7:\"content\";s:643:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:10:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"1.7.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2020-11-18 14:00:00\";}i:7;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2020-12-07 00:00:00\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:24:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AL\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AK\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AZ\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AR\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CT\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DC\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IL\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ME\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MD\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MI\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MS\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MO\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NJ\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NY\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NC\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OK\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"RI\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SC\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UT\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VT\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WV\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WY\";}}}}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Get 50% off transaction fees with WooCommerce Payments\";s:7:\"content\";s:625:\"Keep more of your hard-earned cash by adding <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_exp20\" target=\"_blank\">WooCommerce Payments</a> to your store. Lock in a discounted rate of 1.5% + $0.15 for $25,000 of payments (or three months, whichever comes first). Limited time offer – don’t miss out! <br/><br/><em>By clicking \"Install now,\" you agree to our promotional <a href=\"https://woocommerce.com/terms-conditions/woocommerce-payments-promotion/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_exp20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:26:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CO\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"FL\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"HI\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ID\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IN\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KS\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"KY\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"LA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MA\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MN\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MT\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NE\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NV\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NH\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NM\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ND\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OH\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OR\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"PA\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SD\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TN\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"TX\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VA\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WA\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WI\";}}}}}s:27:\"wcpay-subscriptions-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"wcpay-subscriptions-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:43:\"Manage payments from your store\'s dashboard\";s:7:\"content\";s:560:\"Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>! Zero setup fees or monthly fees. Just pay-as-you-go, starting at just 2.9% + $0.30 per transaction for U.S.-issued cards. <br/><br/><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"install-now\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Install now\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:8:\"industry\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";}}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:10;}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:24:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AL\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AK\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AZ\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AR\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CT\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"DC\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IL\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IA\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ME\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MD\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MI\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MS\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"MO\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NJ\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NY\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NC\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"OK\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"RI\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"SC\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UT\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"VT\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WV\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:19:\"base_location_state\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"WY\";}}}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";}}}}", "yes");
INSERT INTO `wp_3_options` VALUES("281", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "yes");
INSERT INTO `wp_3_options` VALUES("282", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:8:\"approved\";s:1:\"1\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `wp_3_options` VALUES("283", "_bbp_db_version", "263", "yes");
INSERT INTO `wp_3_options` VALUES("284", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_3_options` VALUES("286", "_transient_timeout_wc_onboarding_product_data", "1612182580", "no");
INSERT INTO `wp_3_options` VALUES("287", "_transient_wc_onboarding_product_data", "a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:17:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 31 Jan 2021 12:30:27 GMT\";s:12:\"content-type\";s:31:\"application/json; charset=UTF-8\";s:14:\"content-length\";s:5:\"11477\";s:12:\"x-robots-tag\";s:7:\"noindex\";s:4:\"link\";s:60:\"<https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:29:\"access-control-expose-headers\";s:33:\"X-WP-Total, X-WP-TotalPages, Link\";s:28:\"access-control-allow-headers\";s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";s:13:\"cache-control\";s:10:\"max-age=60\";s:5:\"allow\";s:3:\"GET\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-rq\";s:16:\"hhn2 89 108 3089\";s:3:\"age\";s:2:\"14\";s:7:\"x-cache\";s:3:\"hit\";s:4:\"vary\";s:23:\"Accept-Encoding, Origin\";s:13:\"accept-ranges\";s:5:\"bytes\";}}s:4:\"body\";s:48093:\"{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Get live rates, discounted labels, tracking numbers, and more \\u2013 without leaving your dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Power up and protect your store with Jetpack\\r\\n\\r\\nFor free security, insights and monitoring, connect to Jetpack. It\'s everything you need for a strong, secure start.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"The only payment method designed exclusively for WooCommerce, by WooCommerce. Securely accept major credit and debit cards on your site. View and manage your transactions within your WordPress dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147},{\"title\":\"PayPal Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Dark.png\",\"excerpt\":\"PayPal Checkout now with Smart Payment Buttons\\u2122, dynamically displays, PayPal, Venmo, PayPal Credit, or other local payment options in a single stack giving customers the choice to pay with their preferred option.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"69e6cba62ac4021df9e117cc3f716d07\",\"slug\":\"woocommerce-gateway-paypal-express-checkout\",\"id\":1597922},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618},{\"title\":\"Google Ads &#038; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Give members access to restricted content or products, for a fee or for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-PB.png?v=1\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890},{\"title\":\"Multichannel for WooCommerce: Google, Amazon &amp; eBay Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/wooapplogoretina.png\",\"excerpt\":\"Get the official Google, Amazon and eBay extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate with 2000+ cloud apps and services today.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed product data to Google Merchant Center for setting up Google product listings &amp; product ads.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CP.png?v=1\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on time tax return filing. No more tracking sales tax rates, rules, or jurisdictional boundaries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741},{\"title\":\"eWAY\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/eway-logo-3000-2000.jpg\",\"excerpt\":\"Take credit card payments securely via eWay (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Advanced &amp; sequential order numbers with optional prefixes \\/ suffixes\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Save hours every month by putting your sales tax on autopilot. Automated, multi-state sales tax calculation, reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CSP.png?v=1\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"FirstData gateway for WooCommerce\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677},{\"title\":\"WooSlider\",\"image\":\"\",\"excerpt\":\"WooSlider is the ultimate responsive slideshow WordPress slider plugin\\r\\n\\r\\n\\u00a0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/wooslider\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/www.wooslider.com\\/\",\"price\":\"&#36;49.00\",\"hash\":\"209d98f3ccde6cc3de7e8732a2b20b6a\",\"slug\":\"wooslider\",\"id\":46506},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824},{\"title\":\"Opayo (Formerly SagePay)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo (formally SagePay).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599},{\"title\":\"EU VAT Number\",\"image\":\"\",\"excerpt\":\"Collect VAT numbers at checkout and remove the VAT charge for eligible EU businesses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eu-vat-number\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"d2720c4b4bb8d6908e530355b7a2d734\",\"slug\":\"woocommerce-eu-vat-number\",\"id\":18592},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762},{\"title\":\"QuickBooks Commerce (formerly TradeGecko)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/09\\/qbo-mark.png\",\"excerpt\":\"Get a wholesale and multichannel inventory &amp; order management platform for your WooCommerce store with QuickBooks Commerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tradegecko\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"21da7811f7fc1f13ee19daa7415f0ff3\",\"slug\":\"woocommerce-tradegecko\",\"id\":245960},{\"title\":\"WooCommerce Tab Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/11\\/Thumbnail-Tab-Manager-updated.png\",\"excerpt\":\"Gives you complete control over your product page tabs, create local and global tabs using a visual drag-and-drop interface, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tab-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"89a9ac74850855cfe772b4b4ee1e31e0\",\"slug\":\"woocommerce-tab-manager\",\"id\":132195},{\"title\":\"Jilt\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2017\\/12\\/Thumbnail-Jilt-updated.png\",\"excerpt\":\"All-in-one email marketing platform built for WooCommerce stores. Send newsletters, abandoned cart reminders, win-backs, welcome automations, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jilt\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b53aafb64dca33835e41ee06de7e9816\",\"slug\":\"jilt-for-woocommerce\",\"id\":2754876}]}\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:48093:\"{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Get live rates, discounted labels, tracking numbers, and more \\u2013 without leaving your dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Power up and protect your store with Jetpack\\r\\n\\r\\nFor free security, insights and monitoring, connect to Jetpack. It\'s everything you need for a strong, secure start.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"The only payment method designed exclusively for WooCommerce, by WooCommerce. Securely accept major credit and debit cards on your site. View and manage your transactions within your WordPress dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147},{\"title\":\"PayPal Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Dark.png\",\"excerpt\":\"PayPal Checkout now with Smart Payment Buttons\\u2122, dynamically displays, PayPal, Venmo, PayPal Credit, or other local payment options in a single stack giving customers the choice to pay with their preferred option.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"69e6cba62ac4021df9e117cc3f716d07\",\"slug\":\"woocommerce-gateway-paypal-express-checkout\",\"id\":1597922},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618},{\"title\":\"Google Ads &#038; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Give members access to restricted content or products, for a fee or for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-PB.png?v=1\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890},{\"title\":\"Multichannel for WooCommerce: Google, Amazon &amp; eBay Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/wooapplogoretina.png\",\"excerpt\":\"Get the official Google, Amazon and eBay extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate with 2000+ cloud apps and services today.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed product data to Google Merchant Center for setting up Google product listings &amp; product ads.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CP.png?v=1\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on time tax return filing. No more tracking sales tax rates, rules, or jurisdictional boundaries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741},{\"title\":\"eWAY\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/eway-logo-3000-2000.jpg\",\"excerpt\":\"Take credit card payments securely via eWay (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Advanced &amp; sequential order numbers with optional prefixes \\/ suffixes\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Save hours every month by putting your sales tax on autopilot. Automated, multi-state sales tax calculation, reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CSP.png?v=1\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"FirstData gateway for WooCommerce\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677},{\"title\":\"WooSlider\",\"image\":\"\",\"excerpt\":\"WooSlider is the ultimate responsive slideshow WordPress slider plugin\\r\\n\\r\\n\\u00a0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/wooslider\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/www.wooslider.com\\/\",\"price\":\"&#36;49.00\",\"hash\":\"209d98f3ccde6cc3de7e8732a2b20b6a\",\"slug\":\"wooslider\",\"id\":46506},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824},{\"title\":\"Opayo (Formerly SagePay)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo (formally SagePay).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599},{\"title\":\"EU VAT Number\",\"image\":\"\",\"excerpt\":\"Collect VAT numbers at checkout and remove the VAT charge for eligible EU businesses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eu-vat-number\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"d2720c4b4bb8d6908e530355b7a2d734\",\"slug\":\"woocommerce-eu-vat-number\",\"id\":18592},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762},{\"title\":\"QuickBooks Commerce (formerly TradeGecko)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/09\\/qbo-mark.png\",\"excerpt\":\"Get a wholesale and multichannel inventory &amp; order management platform for your WooCommerce store with QuickBooks Commerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tradegecko\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"21da7811f7fc1f13ee19daa7415f0ff3\",\"slug\":\"woocommerce-tradegecko\",\"id\":245960},{\"title\":\"WooCommerce Tab Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/11\\/Thumbnail-Tab-Manager-updated.png\",\"excerpt\":\"Gives you complete control over your product page tabs, create local and global tabs using a visual drag-and-drop interface, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tab-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"89a9ac74850855cfe772b4b4ee1e31e0\",\"slug\":\"woocommerce-tab-manager\",\"id\":132195},{\"title\":\"Jilt\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2017\\/12\\/Thumbnail-Jilt-updated.png\",\"excerpt\":\"All-in-one email marketing platform built for WooCommerce stores. Send newsletters, abandoned cart reminders, win-backs, welcome automations, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jilt\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b53aafb64dca33835e41ee06de7e9816\",\"slug\":\"jilt-for-woocommerce\",\"id\":2754876}]}\";s:3:\"raw\";s:48711:\"HTTP/1.1 200 OK\r\nServer: nginx\r\nDate: Sun, 31 Jan 2021 12:30:27 GMT\r\nContent-Type: application/json; charset=UTF-8\r\nContent-Length: 11477\r\nConnection: close\r\nX-Robots-Tag: noindex\r\nLink: <https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\r\nX-Content-Type-Options: nosniff\r\nAccess-Control-Expose-Headers: X-WP-Total, X-WP-TotalPages, Link\r\nAccess-Control-Allow-Headers: Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\r\nCache-Control: max-age=60\r\nAllow: GET\r\nContent-Encoding: gzip\r\nX-rq: hhn2 89 108 3089\r\nAge: 14\r\nX-Cache: hit\r\nVary: Accept-Encoding, Origin\r\nAccept-Ranges: bytes\r\n\r\n{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Get live rates, discounted labels, tracking numbers, and more \\u2013 without leaving your dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Power up and protect your store with Jetpack\\r\\n\\r\\nFor free security, insights and monitoring, connect to Jetpack. It\'s everything you need for a strong, secure start.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"The only payment method designed exclusively for WooCommerce, by WooCommerce. Securely accept major credit and debit cards on your site. View and manage your transactions within your WordPress dashboard.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147},{\"title\":\"PayPal Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Dark.png\",\"excerpt\":\"PayPal Checkout now with Smart Payment Buttons\\u2122, dynamically displays, PayPal, Venmo, PayPal Credit, or other local payment options in a single stack giving customers the choice to pay with their preferred option.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"69e6cba62ac4021df9e117cc3f716d07\",\"slug\":\"woocommerce-gateway-paypal-express-checkout\",\"id\":1597922},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618},{\"title\":\"Google Ads &#038; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Give members access to restricted content or products, for a fee or for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-PB.png?v=1\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890},{\"title\":\"Multichannel for WooCommerce: Google, Amazon &amp; eBay Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/wooapplogoretina.png\",\"excerpt\":\"Get the official Google, Amazon and eBay extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate with 2000+ cloud apps and services today.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed product data to Google Merchant Center for setting up Google product listings &amp; product ads.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CP.png?v=1\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on time tax return filing. No more tracking sales tax rates, rules, or jurisdictional boundaries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741},{\"title\":\"eWAY\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/eway-logo-3000-2000.jpg\",\"excerpt\":\"Take credit card payments securely via eWay (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Advanced &amp; sequential order numbers with optional prefixes \\/ suffixes\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Save hours every month by putting your sales tax on autopilot. Automated, multi-state sales tax calculation, reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/07\\/Logo-CSP.png?v=1\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"FirstData gateway for WooCommerce\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677},{\"title\":\"WooSlider\",\"image\":\"\",\"excerpt\":\"WooSlider is the ultimate responsive slideshow WordPress slider plugin\\r\\n\\r\\n\\u00a0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/wooslider\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/www.wooslider.com\\/\",\"price\":\"&#36;49.00\",\"hash\":\"209d98f3ccde6cc3de7e8732a2b20b6a\",\"slug\":\"wooslider\",\"id\":46506},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824},{\"title\":\"Opayo (Formerly SagePay)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo (formally SagePay).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599},{\"title\":\"EU VAT Number\",\"image\":\"\",\"excerpt\":\"Collect VAT numbers at checkout and remove the VAT charge for eligible EU businesses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eu-vat-number\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"d2720c4b4bb8d6908e530355b7a2d734\",\"slug\":\"woocommerce-eu-vat-number\",\"id\":18592},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762},{\"title\":\"QuickBooks Commerce (formerly TradeGecko)\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/09\\/qbo-mark.png\",\"excerpt\":\"Get a wholesale and multichannel inventory &amp; order management platform for your WooCommerce store with QuickBooks Commerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tradegecko\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"21da7811f7fc1f13ee19daa7415f0ff3\",\"slug\":\"woocommerce-tradegecko\",\"id\":245960},{\"title\":\"WooCommerce Tab Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/11\\/Thumbnail-Tab-Manager-updated.png\",\"excerpt\":\"Gives you complete control over your product page tabs, create local and global tabs using a visual drag-and-drop interface, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-tab-manager\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"89a9ac74850855cfe772b4b4ee1e31e0\",\"slug\":\"woocommerce-tab-manager\",\"id\":132195},{\"title\":\"Jilt\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2017\\/12\\/Thumbnail-Jilt-updated.png\",\"excerpt\":\"All-in-one email marketing platform built for WooCommerce stores. Send newsletters, abandoned cart reminders, win-backs, welcome automations, and more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jilt\\/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b53aafb64dca33835e41ee06de7e9816\",\"slug\":\"jilt-for-woocommerce\",\"id\":2754876}]}\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:17:{s:6:\"server\";a:1:{i:0;s:5:\"nginx\";}s:4:\"date\";a:1:{i:0;s:29:\"Sun, 31 Jan 2021 12:30:27 GMT\";}s:12:\"content-type\";a:1:{i:0;s:31:\"application/json; charset=UTF-8\";}s:14:\"content-length\";a:1:{i:0;s:5:\"11477\";}s:12:\"x-robots-tag\";a:1:{i:0;s:7:\"noindex\";}s:4:\"link\";a:1:{i:0;s:60:\"<https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\";}s:22:\"x-content-type-options\";a:1:{i:0;s:7:\"nosniff\";}s:29:\"access-control-expose-headers\";a:1:{i:0;s:33:\"X-WP-Total, X-WP-TotalPages, Link\";}s:28:\"access-control-allow-headers\";a:1:{i:0;s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";}s:13:\"cache-control\";a:1:{i:0;s:10:\"max-age=60\";}s:5:\"allow\";a:1:{i:0;s:3:\"GET\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:4:\"x-rq\";a:1:{i:0;s:16:\"hhn2 89 108 3089\";}s:3:\"age\";a:1:{i:0;s:2:\"14\";}s:7:\"x-cache\";a:1:{i:0;s:3:\"hit\";}s:4:\"vary\";a:1:{i:0;s:23:\"Accept-Encoding, Origin\";}s:13:\"accept-ranges\";a:1:{i:0;s:5:\"bytes\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.1;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:59:\"https://woocommerce.com/wp-json/wccom-extensions/1.0/search\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}", "no");
INSERT INTO `wp_3_options` VALUES("288", "_transient_woocommerce_reports-transient-version", "1612096180", "yes");
INSERT INTO `wp_3_options` VALUES("289", "_transient_timeout_orders-all-statuses", "1612700980", "no");
INSERT INTO `wp_3_options` VALUES("290", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1612096180\";s:5:\"value\";a:0:{}}", "no");
INSERT INTO `wp_3_options` VALUES("291", "_transient_timeout_wc_onboarding_themes", "1612182584", "no");
INSERT INTO `wp_3_options` VALUES("292", "_transient_wc_onboarding_themes", "a:26:{s:15:\"twentytwentyone\";a:6:{s:4:\"slug\";s:15:\"twentytwentyone\";s:5:\"title\";s:17:\"Twenty Twenty-One\";s:5:\"price\";s:4:\"0.00\";s:12:\"is_installed\";b:1;s:5:\"image\";s:85:\"http://localhost/enfold/construction/wp-content/themes/twentytwentyone/screenshot.png\";s:23:\"has_woocommerce_support\";b:1;}s:10:\"storefront\";a:11:{s:5:\"title\";s:10:\"Storefront\";s:5:\"image\";s:77:\"https://woocommerce.com/wp-content/themes/woo/images/storefront/feature-1.jpg\";s:7:\"excerpt\";s:161:\"Storefront is an intuitive &amp; flexible, free theme offering deep integration with WooCommerce.\r\n\r\nIt\'s the perfect platform for your next WooCommerce project.\";s:4:\"link\";s:103:\"https://woocommerce.com/products/storefront/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:42:\"https://themes.woocommerce.com/storefront/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"5714dad8f8d0b930bd6cc9c99657b930\";s:4:\"slug\";s:10:\"storefront\";s:2:\"id\";i:565154;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"overline\";a:11:{s:5:\"title\";s:8:\"Overline\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2020/11/overline.jpg\";s:7:\"excerpt\";s:181:\"Overline has been developed with the new generation of cosmetic makers and influencers opening their own e-commerce shops. Custom Gutenberg elements allow for increased flexibility.\";s:4:\"link\";s:101:\"https://woocommerce.com/products/overline/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:32:\"https://overline.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"6eab91f2-ca09-4f7e-9022-df55fd8540a9\";s:4:\"slug\";s:8:\"overline\";s:2:\"id\";i:7320744;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"agency\";a:11:{s:5:\"title\";s:6:\"Agency\";s:5:\"image\";s:70:\"https://woocommerce.com/wp-content/uploads/2020/10/agency-featured.jpg\";s:7:\"excerpt\";s:134:\"Agency is a Gutenberg and WooCommerce optimized WordPress theme for marketing, advertising, and creative agencies. Sell your services!\";s:4:\"link\";s:99:\"https://woocommerce.com/products/agency/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://organicthemes.com/demo/agency/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"4a3a3a22-a5f0-4fa4-8c09-4f37575602ef\";s:4:\"slug\";s:6:\"agency\";s:2:\"id\";i:6674855;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"rhodes\";a:11:{s:5:\"title\";s:6:\"Rhodes\";s:5:\"image\";s:66:\"https://woocommerce.com/wp-content/uploads/2020/09/rhodes-home.jpg\";s:7:\"excerpt\";s:193:\"The perfect WooCommerce theme for retailers. Whether you\'re selling high-street fashion, beauty products, or home accessories, Rhodes will just stand out of the way letting your products shine.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/rhodes/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:34:\"https://www.cssigniter.com/rhodes/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"b95c0103-23b9-43f3-af49-ee7eaa35e49b\";s:4:\"slug\";s:6:\"rhodes\";s:2:\"id\";i:6509339;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"restoration\";a:11:{s:5:\"title\";s:11:\"Restoration\";s:5:\"image\";s:78:\"https://woocommerce.com/wp-content/uploads/2020/09/restoration-woocommerce.jpg\";s:7:\"excerpt\";s:90:\"An elegant and sophisticated mobile-first, Gutenberg-powered theme for WooCommerce stores.\";s:4:\"link\";s:104:\"https://woocommerce.com/products/restoration/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://restoration.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"e793e6af-f338-4e92-b268-e0576ddb137b\";s:4:\"slug\";s:11:\"restoration\";s:2:\"id\";i:6454820;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"matthew\";a:11:{s:5:\"title\";s:7:\"Matthew\";s:5:\"image\";s:71:\"https://woocommerce.com/wp-content/uploads/2020/06/screenshot.png?w=620\";s:7:\"excerpt\";s:145:\"Matthew is a Gutenberg-powered WooCommerce theme designed for building a professional online store so that you can sell goods or services online.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/matthew/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://demo.themesharbor.com/matthew/\";s:5:\"price\";s:11:\"&#36;129.00\";s:4:\"hash\";s:36:\"b3983408-c4f6-4751-8bd7-ae65ae34cf3b\";s:4:\"slug\";s:7:\"matthew\";s:2:\"id\";i:6214538;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:11:\"fifthavenue\";a:11:{s:5:\"title\";s:12:\"Fifth Avenue\";s:5:\"image\";s:78:\"https://woocommerce.com/wp-content/uploads/2020/06/fifthavenue-woocommerce.jpg\";s:7:\"excerpt\";s:103:\"Beautiful Gutenberg powered WooCommerce theme designed to be easily customized for all types of stores.\";s:4:\"link\";s:105:\"https://woocommerce.com/products/fifth-avenue/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:35:\"https://fifthavenue.fuelthemes.net/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"9e093a9f-3d49-4fcd-bec7-c87b097d9df8\";s:4:\"slug\";s:11:\"fifthavenue\";s:2:\"id\";i:5989481;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"artisan\";a:11:{s:5:\"title\";s:7:\"Artisan\";s:5:\"image\";s:71:\"https://woocommerce.com/wp-content/uploads/2020/03/artisan-featured.jpg\";s:7:\"excerpt\";s:79:\"Sell your hand-crafted products online using the Artisan Theme for WooCommerce.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/artisan/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://organicthemes.com/demo/artisan/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"64529812-81f6-4efd-9686-ecb34e527421\";s:4:\"slug\";s:7:\"artisan\";s:2:\"id\";i:5576887;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"threads\";a:11:{s:5:\"title\";s:7:\"Threads\";s:5:\"image\";s:75:\"https://woocommerce.com/wp-content/uploads/2019/08/threads-home-cropped.jpg\";s:7:\"excerpt\";s:79:\"Create a stunning website for your apparel brand using Threads for WooCommerce.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/threads/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://organicthemes.com/demo/threads/\";s:5:\"price\";s:10:\"&#36;79.00\";s:4:\"hash\";s:36:\"7ca579a6-6aaf-498c-9ee7-e15280ace9e9\";s:4:\"slug\";s:7:\"threads\";s:2:\"id\";i:4663191;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"block-shop\";a:11:{s:5:\"title\";s:10:\"Block Shop\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/uploads/2019/08/block-shop-theme-preview.jpg\";s:7:\"excerpt\";s:154:\"A hassle-free Block-Editor-Era theme for your next WooCommerce project.\r\n\r\n&nbsp;\r\n\r\nPre-sale questions? Ask Get Bowtied: http://m.me/getbowtied\r\n\r\n&nbsp;\";s:4:\"link\";s:103:\"https://woocommerce.com/products/block-shop/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:34:\"https://blockshop.wp-theme.design/\";s:5:\"price\";s:10:\"&#36;59.00\";s:4:\"hash\";s:36:\"21fa433c-6c31-4be7-83ab-8d2cc8986130\";s:4:\"slug\";s:10:\"block-shop\";s:2:\"id\";i:4660093;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"bistro\";a:11:{s:5:\"title\";s:6:\"Bistro\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/07/bistro.png\";s:7:\"excerpt\";s:174:\"Bistro is a Storefront child theme designed for stores selling organic goods and other consumables. It features a friendly and warm design that lends itself to this industry.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/bistro/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://themes.woocommerce.com/bistro\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"58e753f91fddf40abe8ebe4486f8c378\";s:4:\"slug\";s:6:\"bistro\";s:2:\"id\";i:1822936;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:10:\"stationery\";a:11:{s:5:\"title\";s:10:\"Stationery\";s:5:\"image\";s:65:\"https://woocommerce.com/wp-content/uploads/2016/04/stationery.jpg\";s:7:\"excerpt\";s:186:\"Stationery is a Storefront child theme designed for stores selling office supplies and/or arts &amp; crafts. The design has subtle tactile decorations while also being clean and elegant.\";s:4:\"link\";s:103:\"https://woocommerce.com/products/stationery/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:42:\"https://themes.woocommerce.com/stationery/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"b939225b8b8ccdc7b14ffb6d7eab2ac2\";s:4:\"slug\";s:10:\"stationery\";s:2:\"id\";i:1629126;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"petshop\";a:11:{s:5:\"title\";s:7:\"Petshop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2016/03/petshop.png\";s:7:\"excerpt\";s:181:\"Petshop is a Storefront child theme designed for stores selling products in the pet industry. The design is organic and friendly, featuring many details that point to pet ownership.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/petshop/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/petshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"8060743c9031974326850f539aba5196\";s:4:\"slug\";s:7:\"petshop\";s:2:\"id\";i:1587689;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:5:\"hotel\";a:11:{s:5:\"title\";s:5:\"Hotel\";s:5:\"image\";s:69:\"https://woocommerce.com/wp-content/uploads/2016/03/hotel-featured.jpg\";s:7:\"excerpt\";s:246:\"Hotel is designed for businesses selling time, services and accommodation, offering unique integration with WooCommerce Bookings and Accommodation Bookings. The design is bold yet simple, allowing your content and imagery to do all the talking.\";s:4:\"link\";s:98:\"https://woocommerce.com/products/hotel/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:37:\"https://themes.woocommerce.com/hotel/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"0b0df891aa46f289f4e49bae2389bb04\";s:4:\"slug\";s:5:\"hotel\";s:2:\"id\";i:1554532;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"bookshop\";a:11:{s:5:\"title\";s:8:\"Bookshop\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2016/02/featured.png\";s:7:\"excerpt\";s:183:\"Bookshop comes with a unique homepage layout that prominently displays product categories and a variety of products in an arrangement that is popular with bookstores and collectibles.\";s:4:\"link\";s:101:\"https://woocommerce.com/products/bookshop/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/bookshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"9fe861227e3e82fde8fe5d7e8cc3340e\";s:4:\"slug\";s:8:\"bookshop\";s:2:\"id\";i:1508713;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"arcade\";a:11:{s:5:\"title\";s:6:\"Arcade\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/01/arcade.png\";s:7:\"excerpt\";s:216:\"Upgrade your video game shops look and feel with Arcade. It\'s bold and modern design will engage visitors and the unique homepage layout will present them with a variety of products as soon as they hit your homepage.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/arcade/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://themes.woocommerce.com/arcade/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"5af09d4e590eec977c6b9519b517f479\";s:4:\"slug\";s:6:\"arcade\";s:2:\"id\";i:1418260;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:9:\"homestore\";a:11:{s:5:\"title\";s:9:\"Homestore\";s:5:\"image\";s:64:\"https://woocommerce.com/wp-content/uploads/2015/12/homestore.jpg\";s:7:\"excerpt\";s:166:\"Give your Department Store a classic look with Homestore. Its clean and efficient design will work well whether you\'re a boutique independent or a high street giant.\";s:4:\"link\";s:102:\"https://woocommerce.com/products/homestore/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:41:\"https://themes.woocommerce.com/homestore/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"d79fe7a1beba26523aafa6ce6d3e1e85\";s:4:\"slug\";s:9:\"homestore\";s:2:\"id\";i:1365559;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"pharmacy\";a:11:{s:5:\"title\";s:8:\"Pharmacy\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2015/12/pharmacy.jpg\";s:7:\"excerpt\";s:235:\"Give your health store a professional, trust-worthy design with the Pharmacy Storefront Child Theme. Built upon our rock solid Storefront Parent theme you\'ll also enjoy reliable integration with current and future WooCommerce releases.\";s:4:\"link\";s:101:\"https://woocommerce.com/products/pharmacy/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/pharmacy/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"ebeff3c0f89cd3169fb6b3e7e137e513\";s:4:\"slug\";s:8:\"pharmacy\";s:2:\"id\";i:1365557;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"toyshop\";a:11:{s:5:\"title\";s:7:\"ToyShop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2015/09/toyshop.jpg\";s:7:\"excerpt\";s:269:\"Add some fun to your store with ToyShop. The engaging and colorful design of ToyShop makes it a perfect child theme or any store that sells exciting products that are aimed at customers that like to have fun. The outdoorsy style would even be perfect for a flower shop.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/toyshop/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/toyshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"3e2520021b41ee49a55b93362aaced98\";s:4:\"slug\";s:7:\"toyshop\";s:2:\"id\";i:1230716;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"outlet\";a:11:{s:5:\"title\";s:6:\"Outlet\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2015/09/outlet.jpg\";s:7:\"excerpt\";s:221:\"Overclock your tech store with Outlet! Whether you sell boutique iPad jewellery or the nuts and bolts of hardware itself, Outlet will give your shop a stylish look and feel while enjoying the stability of Storefront core.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/outlet/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:38:\"https://themes.woocommerce.com/outlet/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"4c311cb3a3131570946b8799715a0991\";s:4:\"slug\";s:6:\"outlet\";s:2:\"id\";i:1212805;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:7:\"proshop\";a:11:{s:5:\"title\";s:7:\"ProShop\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2015/06/proshop.jpg\";s:7:\"excerpt\";s:176:\"Unlock the true potential of your sports clothing and equipment store with ProShop! It\'s metropolitan design provides an active aesthetic giving your store oodles of character.\";s:4:\"link\";s:100:\"https://woocommerce.com/products/proshop/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:39:\"https://themes.woocommerce.com/proshop/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"1d51b8633bbd1782dc17fce15f8bd2af\";s:4:\"slug\";s:7:\"proshop\";s:2:\"id\";i:1000757;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"galleria\";a:11:{s:5:\"title\";s:8:\"Galleria\";s:5:\"image\";s:68:\"https://woocommerce.com/wp-content/uploads/2015/05/galleria-hero.png\";s:7:\"excerpt\";s:162:\"Galleria is a Storefront child theme perfect for fashion and design stores. Stylish and minimalist, it gives sites a classy look and keeps products center stage.\";s:4:\"link\";s:101:\"https://woocommerce.com/products/galleria/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/galleria/\";s:5:\"price\";s:10:\"&#36;39.00\";s:4:\"hash\";s:32:\"2429c1dde521031cd053886b15844bbf\";s:4:\"slug\";s:8:\"galleria\";s:2:\"id\";i:887931;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:4:\"deli\";a:11:{s:5:\"title\";s:4:\"Deli\";s:5:\"image\";s:59:\"https://woocommerce.com/wp-content/uploads/2015/03/deli.jpg\";s:7:\"excerpt\";s:135:\"Deli is a Storefront child theme featuring a texturised, earthy design, perfect for stores selling natural, organic or hand made goods.\";s:4:\"link\";s:97:\"https://woocommerce.com/products/deli/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:36:\"https://themes.woocommerce.com/deli/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"83c6db94c8ebf9da56b59fb97f724e88\";s:4:\"slug\";s:4:\"deli\";s:2:\"id\";i:784823;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:8:\"boutique\";a:11:{s:5:\"title\";s:8:\"Boutique\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2015/01/boutique.png\";s:7:\"excerpt\";s:168:\"Boutique is a simple, traditionally designed Storefront child theme, ideal for small stores or boutiques. Add your logo, create a unique color scheme and start selling!\";s:4:\"link\";s:101:\"https://woocommerce.com/products/boutique/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:8:\"demo_url\";s:40:\"https://themes.woocommerce.com/boutique/\";s:5:\"price\";s:9:\"&#36;0.00\";s:4:\"hash\";s:32:\"71815288e266d58031727d48d6deee25\";s:4:\"slug\";s:8:\"boutique\";s:2:\"id\";i:605777;s:12:\"is_installed\";b:0;s:23:\"has_woocommerce_support\";b:1;}s:6:\"enfold\";a:6:{s:4:\"slug\";s:6:\"enfold\";s:5:\"title\";s:6:\"Enfold\";s:5:\"price\";s:4:\"0.00\";s:12:\"is_installed\";b:1;s:5:\"image\";s:76:\"http://localhost/enfold/construction/wp-content/themes/enfold/screenshot.png\";s:23:\"has_woocommerce_support\";b:1;}}", "no");
INSERT INTO `wp_3_options` VALUES("294", "rewrite_rules", "a:255:{s:9:\"forums/?$\";s:25:\"index.php?post_type=forum\";s:39:\"forums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:34:\"forums/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:26:\"forums/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"topics/?$\";s:25:\"index.php?post_type=topic\";s:39:\"topics/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"topics/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"topics/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:28:\"forums/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:28:\"forums/topic/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:28:\"forums/reply/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:32:\"forums/topic-tag/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:48:\"forums/users/([^/]+)/topics/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:49:\"forums/users/([^/]+)/replies/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:51:\"forums/users/([^/]+)/favorites/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:55:\"forums/users/([^/]+)/subscriptions/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:53:\"forums/users/([^/]+)/engagements/page/?([0-9]{1,})/?$\";s:66:\"index.php?bbp_user=$matches[1]&bbp_engagements=1&paged=$matches[2]\";s:30:\"forums/users/([^/]+)/topics/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:31:\"forums/users/([^/]+)/replies/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:33:\"forums/users/([^/]+)/favorites/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:37:\"forums/users/([^/]+)/subscriptions/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:35:\"forums/users/([^/]+)/engagements/?$\";s:48:\"index.php?bbp_user=$matches[1]&bbp_engagements=1\";s:28:\"forums/users/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:23:\"forums/users/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:40:\"forums/view/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:27:\"forums/view/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:22:\"forums/view/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:34:\"forums/search/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:16:\"forums/search/?$\";s:20:\"index.php?bbp_search\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"forums/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"forums/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"forums/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"forums/forum/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"forums/forum/(.+?)/embed/?$\";s:38:\"index.php?forum=$matches[1]&embed=true\";s:31:\"forums/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:51:\"forums/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:46:\"forums/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:39:\"forums/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:46:\"forums/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:36:\"forums/forum/(.+?)/wc-api(/(.*))?/?$\";s:46:\"index.php?forum=$matches[1]&wc-api=$matches[3]\";s:42:\"forums/forum/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"forums/forum/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"forums/forum/(.+?)(?:/([0-9]+))?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:40:\"forums/topic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/topic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/topic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/topic/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/topic/([^/]+)/embed/?$\";s:38:\"index.php?topic=$matches[1]&embed=true\";s:33:\"forums/topic/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:53:\"forums/topic/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:48:\"forums/topic/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:41:\"forums/topic/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:48:\"forums/topic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:38:\"forums/topic/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?topic=$matches[1]&wc-api=$matches[3]\";s:44:\"forums/topic/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"forums/topic/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"forums/topic/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:29:\"forums/topic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/topic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/topic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/topic/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"forums/reply/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/reply/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"forums/reply/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"forums/reply/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"forums/reply/([^/]+)/embed/?$\";s:38:\"index.php?reply=$matches[1]&embed=true\";s:33:\"forums/reply/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:41:\"forums/reply/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:48:\"forums/reply/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:38:\"forums/reply/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?reply=$matches[1]&wc-api=$matches[3]\";s:44:\"forums/reply/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"forums/reply/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"forums/reply/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:29:\"forums/reply/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/reply/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"forums/reply/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"forums/reply/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"forums/topic-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:52:\"forums/topic-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:33:\"forums/topic-tag/([^/]+)/embed/?$\";s:42:\"index.php?topic-tag=$matches[1]&embed=true\";s:45:\"forums/topic-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:27:\"forums/topic-tag/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:42:\"forums/search/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:24:\"forums/search/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_3_options` VALUES("296", "_transient_timeout_wc_report_orders_stats_df7e44b418d15b3070d8dcda03f4b61c", "1612700988", "no");
INSERT INTO `wp_3_options` VALUES("297", "_transient_timeout_wc_report_orders_stats_0d4f2ad4187c4967a4b07772d393b386", "1612700988", "no");
INSERT INTO `wp_3_options` VALUES("298", "_transient_wc_report_orders_stats_df7e44b418d15b3070d8dcda03f4b61c", "a:2:{s:7:\"version\";s:10:\"1612096180\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-06\";s:10:\"date_start\";s:19:\"2021-01-31 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-01-30 20:30:00\";s:8:\"date_end\";s:19:\"2021-01-31 16:00:00\";s:12:\"date_end_gmt\";s:19:\"2021-01-31 12:30:00\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:1;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_3_options` VALUES("299", "_transient_wc_report_orders_stats_0d4f2ad4187c4967a4b07772d393b386", "a:2:{s:7:\"version\";s:10:\"1612096180\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-06\";s:10:\"date_start\";s:19:\"2021-01-30 03:30:00\";s:14:\"date_start_gmt\";s:19:\"2021-01-30 00:00:00\";s:8:\"date_end\";s:19:\"2021-01-30 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-01-30 20:29:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:1;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_3_options` VALUES("300", "_transient_timeout_wc_report_orders_stats_7b8c458ec0bf7838482ab4315d6b0e11", "1612700988", "no");
INSERT INTO `wp_3_options` VALUES("301", "_transient_timeout_wc_report_orders_stats_17a87eb00391ae18afaefac90a5fdc1a", "1612700988", "no");
INSERT INTO `wp_3_options` VALUES("302", "_transient_wc_report_orders_stats_7b8c458ec0bf7838482ab4315d6b0e11", "a:2:{s:7:\"version\";s:10:\"1612096180\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-06\";s:10:\"date_start\";s:19:\"2021-01-30 03:30:00\";s:14:\"date_start_gmt\";s:19:\"2021-01-30 00:00:00\";s:8:\"date_end\";s:19:\"2021-01-30 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2021-01-30 20:29:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:1;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_3_options` VALUES("303", "_transient_wc_report_orders_stats_17a87eb00391ae18afaefac90a5fdc1a", "a:2:{s:7:\"version\";s:10:\"1612096180\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2021-06\";s:10:\"date_start\";s:19:\"2021-01-31 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2021-01-30 20:30:00\";s:8:\"date_end\";s:19:\"2021-01-31 16:00:00\";s:12:\"date_end_gmt\";s:19:\"2021-01-31 12:30:00\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:1;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "no");
INSERT INTO `wp_3_options` VALUES("304", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `wp_3_options` VALUES("306", "new_admin_email", "info@khatamwp.dev", "yes");
INSERT INTO `wp_3_options` VALUES("309", "_transient_timeout_wc_low_stock_count", "1614688234", "no");
INSERT INTO `wp_3_options` VALUES("310", "_transient_wc_low_stock_count", "0", "no");
INSERT INTO `wp_3_options` VALUES("311", "_transient_timeout_wc_outofstock_count", "1614688234", "no");
INSERT INTO `wp_3_options` VALUES("312", "_transient_wc_outofstock_count", "0", "no");
INSERT INTO `wp_3_options` VALUES("313", "_transient_product_query-transient-version", "1612096234", "yes");
INSERT INTO `wp_3_options` VALUES("314", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_3_options` VALUES("315", "_transient_timeout_wc_report_sales_by_date", "1612182909", "no");
INSERT INTO `wp_3_options` VALUES("316", "_transient_wc_report_sales_by_date", "a:8:{s:32:\"afeda1a75db72ed44346aa8b357d1ba8\";a:0:{}s:32:\"b97a4d7fba26713bbf4be42a50faa154\";a:0:{}s:32:\"156ee7c6d8effbf5e3662232f20907fb\";a:0:{}s:32:\"c7bcc7b876cf23e227730efdfa22b570\";N;s:32:\"bdbe3384961e4f13ea5d298e325a3508\";a:0:{}s:32:\"c95e417afd693e82839891e3d868a6a9\";a:0:{}s:32:\"1d17029d52795e7fd51f159ef67f952e\";a:0:{}s:32:\"8cf605a9a82757bd2b56e250c6782a7b\";a:0:{}}", "no");
INSERT INTO `wp_3_options` VALUES("317", "_transient_timeout_wc_admin_report", "1612182909", "no");
INSERT INTO `wp_3_options` VALUES("318", "_transient_wc_admin_report", "a:1:{s:32:\"38d3181fdd504ce2d53494b150e71472\";a:0:{}}", "no");
INSERT INTO `wp_3_options` VALUES("319", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1612139438", "no");
INSERT INTO `wp_3_options` VALUES("320", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jan 2021 18:27:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.7-alpha-50081\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"People of WordPress: Thelma Mutete\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/01/people-of-wordpress-thelma-mutete/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Jan 2021 16:40:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"ContributorStory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:13:\"Web developer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9518\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"From writing her first line of code when she was 16, Thelma Mutete knew she wanted to work in IT. She shares her journey in web development and her discovery of WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8707:\"\n<p><em>WordPress is open source software, maintained by a global network of contributors. There are many examples of how WordPress has changed people’s lives for the better. In this monthly series, we share some of those lesser-known, amazing stories.</em></p>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><img loading=\"lazy\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/01/Thelma-Mutete.jpg?resize=500%2C750&#038;ssl=1\" alt=\"Thelma Mutete at a WordCamp\" class=\"wp-image-9564\" width=\"500\" height=\"750\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/01/Thelma-Mutete.jpg?w=667&amp;ssl=1 667w, https://i1.wp.com/wordpress.org/news/files/2021/01/Thelma-Mutete.jpg?resize=200%2C300&amp;ssl=1 200w\" sizes=\"(max-width: 500px) 100vw, 500px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>From a young age Thelma was encouraged by her father to ‘work hard, and dream big’. In High School, she pursued a career in Computer Science. She said: “I did not know what I would be doing or how I would get there but I just knew that I was going to pursue a career in information technology.”</p>\n\n\n\n<p>She wrote her first line of code at the age of 16 living in Zimbabwe, Africa. This was to mark the beginning of her enthusiasm for computer programming.</p>\n\n\n\n<p>When she joined the school’s computer class, Thelma thought she would learn Excel and Word. Instead, the assignment was to write her first program in C. She said: “It was not easy, but it was very exciting. l remember writing up simple code for a Video Club – a check-in/out for VHS tapes and CDs. Thus began my fascination with computers.”</p>\n\n\n\n<p>Seven years later, she went on to university to study for a Bachelors in Business Management and Information Technology. Her third year internship was at a local web design and hosting company. Though she had hoped her placement would be at a local bank or telecommunications company, the chance to discover website design turned out to be the best thing that could have happened.&nbsp;</p>\n\n\n\n<p>In 2017, Thelma went on to work for a company designing websites using HTML, CSS, PHP, JavaScript and Joomla. She had heard about WordPress but had not used it. She recalls: “People have this misconception that WordPress is not for real developers and it is not secure and at that time I was one of those people.”</p>\n\n\n\n<h2>Finding a local community</h2>\n\n\n\n<p>From a discussion with a member of the local WordPress community, <a href=\"https://heropress.com/essays/wordpress-opened-whole-new-world/\">Thabo Tswana</a>, about a striking swag gift from a WordCamp, Thelma’s interest was sparked.&nbsp;</p>\n\n\n\n<p>She started to find out more about WordPress and WooCommerce, and visited her local WordCamp Harare website. She was delighted to find that she could learn more about WordPress without needing any pre-existing knowledge, and wanted to be involved. So instead of just attending the camp, she volunteered too!&nbsp;</p>\n\n\n\n<p>Her response to her first WordPress event mirrors the experience of many others in the community. She said: “I only started using WordPress because of the awesome people that l had met at that WordCamp. Everyone was so welcoming.”</p>\n\n\n\n<p>A week later, with help from Thabo, she designed her first website using WordPress.</p>\n\n\n\n<p>She soon became more involved with the community and Meetups. Thelma participated in the first-ever ‘Women Who WordPress’ Meetup in 2018, with lots of women getting involved from bloggers to developers.&nbsp;</p>\n\n\n\n<p>She said: “We were free to talk and discuss a lot of things. We had more time to discuss the difference between WordPress.com and WordPress.org, we shared views on how to handle discrimination at work, how to promote your website and a whole lot of other things.”</p>\n\n\n\n<h2>Establishing roots in WordPress</h2>\n\n\n\n<p>In 2018, WordCamp Harare had its first-ever female Lead Organizer <a href=\"https://tapiwanashe.com/\">Tapiwanashe Manhobo</a>. Thelma was part of the organising team that year and was assigned to handle Harare’s first Kids Camp to take place eight months later. You can read more about her experiences of organizing a <a href=\"https://thelmachido.wordpress.com/2019/11/21/wordpress-juniours-first-edition/\"><strong>Kids Camp</strong></a> on her blog.</p>\n\n\n\n<p>She said: “After the first Kids Camp, we had several people in the local Zimbabwean WordPress community who were enthusiastic about encouraging young people to embrace ICT. In 2019, we had not planned to have a Kids Camp because of financial constraints but to our surprise, we had some anonymous donations and we managed to have a WordPress Community outreach to a youth centre, <a href=\"https://cttzim.org/\"><strong>Centre for Total Transformation</strong></a>, a week after our WordCamp. It is a non-formal school that caters for underprivileged and vulnerable children. The group were able to share practical skills about using WordPress, computer hardware and software.</p>\n\n\n\n<p>Thelma shares that she became hooked on WordPress because of its community. “I enjoy attending WordCamps, meeting new people and just learning new stuff. I have a huge list of WordCamps I would like to attend. Last year I managed to cross WordCamp Johannesburg off my list. When everything is back to normal my plan to travel to WordCamps will proceed (fingers crossed).”</p>\n\n\n\n<h2>Reaping the fruits of ongoing learning</h2>\n\n\n\n<p>Thelma is committed to ongoing development training. She said: “Even though I can still cook up code in C and Java, for now, I have also included WordPress PHP functions to the mix. It was not easy to get to this point, daring myself got me to this slightly better stage. I try to do my best where I can and I am happy to say it has paid off so far.”</p>\n\n\n\n<p>Thelma has continued her journey working in design and digital marketing last year with Trust Nhokovenzo who works in digital marketing and is active in&nbsp; the WordPress Community. He came across her name as a developer from talking with others involved in WordPress. She went to work with his team at a marketing agency.</p>\n\n\n\n<p>Her interest in the development of WordPress continued and she joined the <a href=\"https://wordpress.org/news/2020/12/simone/\">5.6 Release Squad</a> in the mid 2020.&nbsp;At the end of 2020, she moved to become a Happiness Engineer working with WordPress.com. Thelma’s fascination with the platform and the community continues to grow and her contributor story is ongoing.</p>\n\n\n\n<p>Find out more about the <a href=\"https://www.meetup.com/Harare-WordPress-Meetup\">Harare WordPress community</a> in Zimbabwe.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Nalini Thakor (<a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>) and Surendra Thakor (<a href=\'https://profiles.wordpress.org/sthakor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sthakor</a>), Yvette Sonneveld (<a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>), Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Larissa Murillo (<a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>), Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>), and Chloé Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>). Thank you to Thelma Mutete (<a href=\'https://profiles.wordpress.org/thelmachido/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thelmachido</a>) for sharing her #ContributorStory.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://lh4.googleusercontent.com/s24EVZGKbxVeafljPU1ubF1DjIwn98E3-wGx1LD2CWYk7zYQppFhXNpb0aUhGe01TStMdTwXrcYaxBZQHRgZJ10lvW2hsg61Ce37_pBGJuTRQlJ6r9iUxlJtvuDuwLhIvPo1MVEb\" alt=\"HeroPress logo\" /></figure>\n\n\n\n<p><em>This post is based on </em><a href=\"https://heropress.com/essays/hello-world-discovering-the-world-through-wordpress/\"><em>an article originally published on HeroPress.com</em></a><em>, a community initiative created by </em><a href=\"https://profiles.wordpress.org/topher1kenobe/\"><em>Topher DeRosia</em></a><em>. HeroPress highlights people in the WordPress community</em>.</p>\n\n\n\n<p>#ContributorStory #HeroPress</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9518\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress: December 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2021/01/the-month-in-wordpress-december-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Jan 2021 10:55:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9508\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"We bid goodbye to 2020 in style with the release of WordPress 5.6 and the launch of Learn WordPress. But these weren’t the only exciting updates from WordPress in December. Read on to learn more! WordPress 5.6 is here The latest major WordPress release, version 5.6 “Simone”, came out on December 8. The release ships [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11612:\"\n<p>We bid goodbye to 2020 in style with the release of WordPress 5.6 and the launch of Learn WordPress. But these weren’t the only exciting updates from WordPress in December. Read on to learn more!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.6 is here</h2>\n\n\n\n<p>The latest major WordPress release,<a href=\"https://wordpress.org/news/2020/12/simone/\"> version 5.6</a> “Simone”, came out on December 8. The release ships with a new default theme called <a href=\"https://wordpress.org/themes/twentytwentyone/\">Twenty Twenty One</a>. It offers a host of features, including:</p>\n\n\n\n<ul><li>Greater layout flexibility</li><li>More block patterns</li><li>Video captioning support</li><li>Auto-updates</li><li>Beta-compatibility for PHP 8.0</li><li>Application password support for the REST API</li><li>Updates to jQuery</li></ul>\n\n\n\n<p>In addition, WordPress 5.6 is now available in 55 languages. You can find more information about the release in the <a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">field guide</a>, and you can update to the latest version directly from your WordPress dashboard or by <a href=\"https://wordpress.org/download/\">downloading</a> it directly from WordPress.org. A total of 605 people hailing from 57 different countries contributed to the development of WordPress 5.6. <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> has <a href=\"https://jeanbaptisteaudras.com/en/2020/12/wordpress-5-6-core-stats-contributions-by-country-company/\">compiled many more stats like that</a>, showing what a tremendous group effort this was—they’re well worth a read!</p>\n\n\n\n<p>Want to contribute to upcoming WordPress releases? Join the WordPress <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel on the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a> and follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a> to learn the <a href=\"https://make.wordpress.org/core/2020/12/21/wordpress-5-7-planning-roundup/\">latest on WordPress 5.7</a>, which is <a href=\"https://wordpress.org/about/roadmap/\">slated to be out by March 9, 2021</a>. The Core team hosts weekly chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 a.m.</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 p.m.</a> UTC.</p>\n\n\n\n<h2>Watch the State of the Word 2020 recording</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/\">State of the Word 2020</a>, the annual keynote address delivered by WordPress co-founder Matt Mullenweg, was streamed online for the first time on December 17. It was followed by a live Q&amp;A from community members all across the world. You can find the stream recording on <a href=\"https://www.youtube.com/watch?v=QI3qCoiuG3w\">YouTube</a>, <a href=\"https://www.facebook.com/WordPress/videos/1281447442248369\">Facebook</a>, and <a href=\"https://twitter.com/i/broadcasts/1dRKZNvnrmdKB\">Twitter</a>. The <a href=\"https://wordpress.tv/2020/12/17/matt-mullenweg-2020-state-of-the-word/\">State of the Word</a> video and the <a href=\"https://wordpress.tv/2020/12/17/matt-mullenweg-2020-state-of-the-word-qa/\">Q&amp;A session</a> are also available on WordPress.tv.&nbsp;</p>\n\n\n\n<h2>Learn WordPress has launched</h2>\n\n\n\n<p>Learn WordPress, a new free, on-demand WordPress learning resource, launched officially on December 15. It offers <a href=\"https://learn.wordpress.org/workshops/\">workshops</a>, <a href=\"https://learn.wordpress.org/lesson-plans/\">lesson plans</a>, quizzes, and <a href=\"https://learn.wordpress.org/courses/\">courses</a> for anyone interested in publishing with, building for, or contributing to WordPress. WordPress enthusiasts can also <a href=\"https://www.meetup.com/learn-wordpress-discussions/\">participate in discussion groups</a> focused on specific topics to learn with and from each other.</p>\n\n\n\n<p>Want to participate in Learn WordPress? <a href=\"https://learn.wordpress.org/contribute/\">Here are four ways you can do so</a>! Additionally, contributors have <a href=\"https://make.wordpress.org/training/2020/12/03/learn-wordpress-blue-sky-thinking/\">launched a discussion</a> on the future of <a href=\"https://learn.wordpress.org/\">Learn WordPress</a>—feel free to share your thoughts in the comments. To help promote Learn WordPress, check out the <a href=\"https://make.wordpress.org/marketing/\">Marketing Team</a>’s <a href=\"https://make.wordpress.org/marketing/2020/12/09/help-us-promote-learn-wordpress/\">materials</a>, which detail a <a href=\"https://make.wordpress.org/marketing/2020/12/09/help-us-promote-learn-wordpress/\">range of fun and creative ways</a> to share this new resource.</p>\n\n\n\n<h2>Give feedback on the Full Site Editing project</h2>\n\n\n\n<p>Contributor teams have kicked off the <a href=\"https://make.wordpress.org/core/2020/12/11/the-fse-outreach-program-is-officially-starting/\">Full Site Editing (FSE) outreach program</a> for anyone who is building or maintaining a WordPress site so that they can give feedback on the upcoming <a href=\"https://make.wordpress.org/design/handbook/focuses/full-site-editing/\">FSE feature</a> that will be part of Gutenberg Phase 2. Your feedback will go a long way in improving FSE user flows. To participate, <a href=\"https://make.wordpress.org/test/2020/12/23/fse-program-testing-call-1-template-editing/\">check out the initial testing call</a> on the <a href=\"https://make.wordpress.org/test/\">Make/Test blog</a> and join the <a href=\"https://make.wordpress.org/core/tag/fse-outreach-experiment/\">#fse-outreach-experiment</a> Slack channel.<br><br>Want to follow updates on the FSE project? Check out <a href=\"https://make.wordpress.org/core/2020/05/20/ways-to-keep-up-with-full-site-editing-fse/\">this blog post</a>. You can find <a href=\"https://make.wordpress.org/core/2020/12/10/status-check-site-editing-and-customization/\">2020 updates to the FSE project</a> in the Make/Core blog.</p>\n\n\n\n<h2>BuddyPress 7.0 “Filippi” and 7.10 are now available</h2>\n\n\n\n<p><a href=\"https://buddypress.org/2020/12/buddypress-7-0-0-filippi/\">BuddyPress version 7.0</a> went live on December 9. Its features include:&nbsp;</p>\n\n\n\n<ul><li>New administration screens to manage Member and Group Types</li><li>New BP blocks for posts and pages</li><li>A default profile image for network sites</li><li>Improved BuddyPress Noveau support for the Twenty Twenty One theme.&nbsp;</li></ul>\n\n\n\n<p>A BuddyPress maintenance release (<a href=\"https://buddypress.org/2020/12/buddypress-7-1-0-maintenance-release/\">version 7.1</a>) launched on December 21.&nbsp;</p>\n\n\n\n<p>Want to provide feedback or suggestions for BuddyPress? Share your comments on the announcement posts for <a href=\"https://buddypress.org/2020/12/buddypress-7-0-0-filippi/\">7.0</a> or <a href=\"https://buddypress.org/2020/12/buddypress-7-1-0-maintenance-release/\">7.1</a>. If you find a bug, please report it in the <a href=\"https://buddypress.org/support/\">support forums</a>.&nbsp;</p>\n\n\n\n<h2>Gutenberg 9.5 and 9.6 released</h2>\n\n\n\n<p>The Core team launched <a href=\"https://make.wordpress.org/core/2020/12/02/whats-new-in-gutenberg-2-december/\">version 9.5</a> and <a href=\"https://make.wordpress.org/core/2020/12/23/whats-new-in-gutenberg-23-december/\">9.6</a> of Gutenberg last month. Both versions include several improvements to FSE flows, bug fixes, and feature upgrades. Version 9.5 introduces features like full height alignment and support for font sizes in the code block. Version 9.6 includes features like the ability to drag blocks from the inserter and a vertical layout for buttons.&nbsp;</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading</h2>\n\n\n\n<ul><li>The Community team <a href=\"https://make.wordpress.org/community/2020/12/01/discussion-how-can-the-wordpress-community-return-to-hosting-safe-in-person-events/\">kicked off a discussion</a> about what the WordPress Community can do to host safe, in-person events again, in light of the continuing pandemic. </li><li>The Polyglots team published its <a href=\"https://make.wordpress.org/polyglots/2020/12/30/polyglots-team-end-of-year-post-2020/\">end-of-year post</a>, along with the <a href=\"https://make.wordpress.org/polyglots/author/evarlese/\">results of its 2020 translator survey</a>.</li><li><a href=\"https://sevilla.wordcamp.org/2020/\">WordCamp Sevilla 2020</a> was held online from December 26-29. You can catch the recorded livestream playback on <a href=\"https://www.youtube.com/c/wordpresssevilla/live\">YouTube</a>. Videos of the event will <a href=\"https://wordpress.tv/event/wordcamp-sevilla-2020/\">soon be available on WordPress.tv</a>.</li><li>WordPress project executive director <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> and project co-founder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> will be jointly hosting <a href=\"https://make.wordpress.org/core/2020/12/15/regular-office-and-listening-hours/\">quarterly office and listening hours</a> in 2021. Sign-ups for the <a href=\"https://make.wordpress.org/core/2020/12/15/regular-office-and-listening-hours/\">first ones in January 2021</a> are almost filled up.</li><li>The Core team <a href=\"https://make.wordpress.org/core/2020/12/02/wp-notify-project-review/\">published updates</a> on the <a href=\"https://make.wordpress.org/core/tag/feature-notifications/\">WP Notify project</a>, which seeks to <a href=\"https://make.wordpress.org/core/2019/08/05/feature-project-proposal-wp-notify/\">improve the notifications system</a> in WordPress Core.</li><li>The Support team <a href=\"https://make.wordpress.org/support/2020/12/handling-potential-jquery-issues-in-wordpress-5-6/\">published a post</a> detailing jQuery issues in WordPress 5.6.</li><li><a href=\"https://india.wordcamp.org/2021/\">WordCamp India Online 2021</a> will be held over three weekends between January 30 and February 14. There will be workshops, a contributor event, and sessions (in that order). The calls for <a href=\"https://india.wordcamp.org/2021/call-for-sponsors/\">sponsors</a>, <a href=\"https://india.wordcamp.org/2021/call-for-workshops/\">workshop presenters</a>, <a href=\"https://india.wordcamp.org/2021/call-for-contributor-team-leads/\">contributor team leads</a>, and <a href=\"https://india.wordcamp.org/2021/call-for-volunteers/\">volunteers</a> are now open. Don’t forget to grab your <a href=\"https://india.wordcamp.org/2021/tickets/\">free tickets</a>!</li><li>The Documentation team <a href=\"https://make.wordpress.org/docs/2020/12/01/external-linking-policy-1st-review-of-plugin-developer-handbook/\">shared a first review</a> of its <a href=\"https://make.wordpress.org/docs/tag/external-linking-policy/\">external linking policy</a>. It is using the <a href=\"https://developer.wordpress.org/plugins/\">plugin developer handbook</a> as a test.</li></ul>\n\n\n\n<p><br><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Introducing Learn WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2020/12/introducing-learn-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Dec 2020 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"learnwordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"learnwp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9444\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"Learn WordPress is a learning resource providing workshops, quizzes, courses, and lesson plans to help you to do more with WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10336:\"\n<p><strong><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a learning resource providing workshops, quizzes, courses, lesson plans, and discussion groups so that anyone, from beginners to advanced users, can learn to do more with WordPress. Learning how to use, build for, and contribute to WordPress is essential for anyone wanting to dive deeper into the software and its community.&nbsp;</strong></p>\n\n\n\n<div class=\"wp-block-buttons aligncenter\">\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\" href=\"https://learn.wordpress.org/\">Learn WordPress</a></div>\n</div>\n\n\n\n<p>This cross-team initiative is part of the WordPress.org network and features content from contributors from the global community. It will be updated weekly and will help connect new and existing WordPress users with the broader community while they learn.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"331\" src=\"https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?resize=632%2C331&#038;ssl=1\" alt=\"\" class=\"wp-image-9457\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?resize=1024%2C537&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?resize=300%2C157&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?resize=768%2C403&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?resize=1536%2C806&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?w=1700&amp;ssl=1 1700w, https://i1.wp.com/wordpress.org/news/files/2020/12/learn-link-preview.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2>What can you learn about WordPress?</h2>\n\n\n\n<p>On Learn WordPress you can find a range of material and opportunities to use at the time which works for you.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/workshops/\"><strong>Workshops</strong></a> are practical, skills-based videos that show viewers how to do new things with WordPress, whether you publish, manage, develop with, or contribute to WordPress. Most workshops include quizzes for you to test your newly gained knowledge.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/discussion-groups/\"><strong>Discussion groups</strong></a> provide an opportunity for further collaborative learning with participants meeting together to discuss the workshop content &#8211; they take place online, either in video calls or Slack and accommodate all time zones.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/lesson-plans/\"><strong>Lesson plans</strong></a> are guides for facilitators to use while presenting at events or within educational environments. Facilitators will find learning objectives (telling people what they are going to learn), any prerequisite skills, assets such as screenshots and slide decks, and learning assessments.&nbsp;</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/courses/\"><strong>Courses</strong></a> are a series of interconnected lesson plans to be presented by a facilitator that will strategically focus on defined learning outcomes. Participants can go through these courses individually or as part of a group. After completing the learning, attendees should be able to apply their skills in the real world.</p>\n\n\n\n<p>In addition to the wealth of valuable content available on Learn WordPress, the platform provides an opportunity for individuals to learn alongside other community members and become connected with a global network of WordPress users, developers, and contributors.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe class=\'youtube-player\' width=\'632\' height=\'356\' src=\'https://www.youtube.com/embed?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent&#038;listType=playlist&#038;list=PLCVEqsAbLffeEXhn9T1yBVTMaHIMtlzFj\' allowfullscreen=\'true\' style=\'border:0;\' sandbox=\'allow-scripts allow-same-origin allow-popups allow-presentation\'></iframe>\n</div></figure>\n\n\n\n<p><a href=\"https://www.youtube.com/playlist?list=PLCVEqsAbLffeEXhn9T1yBVTMaHIMtlzFj\">Why you should use Learn WordPress</a> &#8211; videos from our community.</p>\n\n\n\n<h2>How can you get involved?</h2>\n\n\n\n<div class=\"wp-block-buttons aligncenter\">\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\" href=\"https://learn.wordpress.org/\">Start learning today!</a></div>\n</div>\n\n\n\n<p>Learn WordPress is an open-source platform available for anyone to contribute content in any areas mentioned above. <a href=\"https://learn.wordpress.org/contribute/\">Find out more about how you can get involved</a> with this initiative.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/marketing/2020/12/09/help-us-promote-learn-wordpress/\">Take part in our fun promotion campaigns</a> on social and with your local community.</p>\n\n\n\n<p><em>Hundreds of people spanning a number of years have contributed to the development of learning materials. Thanks to everyone who worked so hard to make Learn WordPress a reality.&nbsp;</em></p>\n\n\n\n<p><strong><em>Particular thanks to</em></strong>:</p>\n\n\n\n<p><strong><em>Training:</em></strong><em> <a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a>, <a href=\'https://profiles.wordpress.org/azhiyadev/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>azhiyadev</a>, <a href=\'https://profiles.wordpress.org/geheren/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>geheren</a>, <a href=\'https://profiles.wordpress.org/webtechpooja/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webtechpooja</a>, <a href=\'https://profiles.wordpress.org/jessecowens/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jessecowens</a>, <a href=\'https://profiles.wordpress.org/onealtr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>onealtr</a>, <a href=\'https://profiles.wordpress.org/rastaban/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rastaban</a>, <a href=\'https://profiles.wordpress.org/evarlese/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>evarlese</a>, <a href=\'https://profiles.wordpress.org/manzwebdesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>manzwebdesigns</a></em><br><strong><em>Meta: </em></strong><em><a href=\'https://profiles.wordpress.org/coreymckrill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coreymckrill</a>, <a href=\'https://profiles.wordpress.org/dufresnesteven/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dufresnesteven</a>, <em><a href=\'https://profiles.wordpress.org/jonoaldersonwp/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jonoaldersonwp</a></em></em><br><strong><em>Community:</em></strong><em> <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a>, <a href=\'https://profiles.wordpress.org/camikaos/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>camikaos</a>, <a href=\'https://profiles.wordpress.org/harishanker/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>harishanker</a>, <a href=\'https://profiles.wordpress.org/angelasjin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>angelasjin</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/courtneypk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courtneypk</a>, <a href=\'https://profiles.wordpress.org/andreamiddleton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>andreamiddleton</a>, <a href=\'https://profiles.wordpress.org/rmarks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmarks</a>, <a href=\'https://profiles.wordpress.org/sippis/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sippis</a></em><br><strong><em>Marketing: </em></strong><em><a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>,  <a href=\'https://profiles.wordpress.org/oglekler/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>oglekler</a>, <a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>, <a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>, <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/nalininonstopnewsuk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nalininonstopnewsuk</a>, <a href=\'https://profiles.wordpress.org/megphillips91/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>megphillips91</a>, <a href=\'https://profiles.wordpress.org/marks99/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marks99</a>, <em><a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a></em></em>, <em><a href=\'https://profiles.wordpress.org/antialiasfactory/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>antialiasfactory</a>, <a href=\'https://profiles.wordpress.org/herculespekkas/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>herculespekkas</a>, <a href=\'https://profiles.wordpress.org/chaion07/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chaion07</a></em><br><strong><em>Design:</em></strong><em> <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a> </em></p>\n\n\n\n<p><em>For a fuller list of the contributors who have been involved in training and Learn WordPress, visit <a href=\"https://make.wordpress.org/community/2020/08/12/learn-wordpress-is-live/\">the initial beta launch post</a>. Thanks to everyone who has been involved to date and will be in the future.&nbsp;</em></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/tag/learnwordpress\">#LearnWordPress</a> <a href=\"https://learn.wordpress.org/tag/learnwp\">#LearnWP</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9444\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 5.6 “Simone”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2020/12/simone/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Dec 2020 19:46:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"5.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9325\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:206:\"Meet Simone, our latest and greatest WordPress release. Named for the legendary performer Nina Simone. Fire up a playlist with her best work and read on to discover what WordPress 5.6 has in store for you. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:63951:\"\n<p>Meet Simone, our latest and greatest WordPress release. Named for the legendary performer Nina Simone, who is known for tunes like &#8220;Feeling Good&#8221;, &#8220;Young, Gifted and Black&#8221;, and &#8220;Four Women&#8221;. Fire up a playlist with her best work and read on to discover what we have in store for you. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"633\" src=\"https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?resize=632%2C633&#038;ssl=1\" alt=\"WordPress 5.6 Simone with a photo of Nina Simone\" class=\"wp-image-9416\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?resize=1022%2C1024&amp;ssl=1 1022w, https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?resize=300%2C300&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?resize=150%2C150&amp;ssl=1 150w, https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?resize=768%2C769&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2020/12/wordpress-5-6_cover-a11y.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<div class=\"wp-block-cover has-background-dim\" style=\"background-color:#d1e4dd;min-height:300px\"><div class=\"wp-block-cover__inner-container\">\n<p class=\"has-text-align-center has-black-color has-text-color has-background has-large-font-size\" style=\"background-color:#d1e4dd;padding: 10px\">Welcome to WordPress 5.6</p>\n<h3 class=\"has-text-align-center has-black-color has-text-color\">Sharing your stories has never been easier.</h3>\n</div></div>\n\n\n\n<p>WordPress 5.6 brings you countless ways to set your ideas free and bring them to life. With a brand-new default theme as your canvas, it supports an ever-growing collection of blocks as your brushes. Paint with words. Pictures. Sound. Or rich embedded media.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"234\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-1.jpeg?resize=632%2C234&#038;ssl=1\" alt=\"colored circles\" class=\"wp-image-9346\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-1.jpeg?resize=1024%2C379&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-1.jpeg?resize=300%2C111&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-1.jpeg?resize=768%2C284&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-1.jpeg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>Greater layout flexibility</h3>\n\n\n\n<p>Bring your stories to life with more tools that let you edit your layout with or without code. Single column blocks, designs using mixed widths and columns, full-width headers, and gradients in your cover block—make small changes or big statements with equal ease!</p>\n\n\n\n<h3>More block patterns</h3>\n\n\n\n<p>In some themes, preconfigured block patterns make setting up standard pages on your site a breeze. Let the power of patterns streamline your workflow and save you clicks. Plus, share these features with clients, editors, and more.</p>\n\n\n\n<h3>Better video captioning</h3>\n\n\n\n<p>To help you add subtitles or captions to your videos, you can now upload them within your post or page. This makes it easier than ever to make your videos accessible for anyone who needs or prefers to use subtitles.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"120\" src=\"https://i2.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-2.jpeg?resize=632%2C120&#038;ssl=1\" alt=\"black vertical line\" class=\"wp-image-9347\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-2.jpeg?resize=1024%2C194&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-2.jpeg?resize=300%2C57&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-2.jpeg?resize=768%2C146&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-2.jpeg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2>Twenty Twenty-One is here!</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"714\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=632%2C714&#038;ssl=1\" alt=\"Examples of block patterns available in Twenty Twenty-One.\" class=\"wp-image-9426\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=907%2C1024&amp;ssl=1 907w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=266%2C300&amp;ssl=1 266w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=768%2C867&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=1360%2C1536&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?resize=1814%2C2048&amp;ssl=1 1814w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?w=1975&amp;ssl=1 1975w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2020/12/TT1-Screenshots-Compressed.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<p>Twenty Twenty-One is a blank canvas for your ideas, and the block editor is the best brush. It is built for the block editor and packed with brand-new block patterns you can only get in the default themes. Try different layouts in a matter of seconds, and let the theme’s eye-catching, yet timeless design make your work shine.&nbsp;</p>\n\n\n\n<p>What’s more, this default theme puts accessibility at the heart of your website. It conforms to the <a href=\"https://make.wordpress.org/themes/handbook/review/accessibility/\">WordPress accessibility-ready guidelines</a> and addresses several more specialized standards from the <a href=\"https://www.w3.org/WAI/WCAG2AAA-Conformance\">Web Content Accessibility Guidelines (WCAG) 2.1 at level AAA</a>. It will help you meet the highest level of international accessibility standards when you create accessible content and choose plugins which are accessible too!</p>\n\n\n\n<h3>A rainbow of soft pastels</h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?ssl=1\"><img loading=\"lazy\" width=\"632\" height=\"167\" src=\"https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=632%2C167&#038;ssl=1\" alt=\"A mobile screenshot of each included color palette in Twenty Twenty-One, going in ROYGBIV order.\" class=\"wp-image-9424\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=1024%2C270&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=300%2C79&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=768%2C202&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=1536%2C405&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?resize=2048%2C540&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2020/12/Rainbow-Compressed.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<p>Perfect for a new year, Twenty Twenty-One gives you a range of pre-selected color palettes in pastel, all of which conform to AAA standards for contrast. You can also choose your own background color for the theme, and the theme chooses accessibility-conscious text colors for you — automatically!</p>\n\n\n\n<p>Need more flexibility than that? You can also choose your own color palette from the color picker.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"151\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-3.jpeg?resize=632%2C151&#038;ssl=1\" alt=\"colored circles\" class=\"wp-image-9351\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-3.jpeg?resize=1024%2C245&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-3.jpeg?resize=300%2C72&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-3.jpeg?resize=768%2C183&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress5-6-3.jpeg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2>Improvements for everyone</h2>\n\n\n\n<h3>Expanding auto-updates</h3>\n\n\n\n<p>For years, only developers have been able to update WordPress automatically. But now you have that option, right in your dashboard. If this is your first site, you have auto-updates ready to go, right now! Upgrading an existing site? No problem! Everything is the same as it was before.</p>\n\n\n\n<h3>Accessibility Statement&nbsp;</h3>\n\n\n\n<p>Even if you’re not an expert, you can start letting others know about your site’s commitment to accessibility! The new <a href=\"https://github.com/10degrees/accessibility-statement-plugin\">feature plugin</a> includes template copy for you to edit and publish, and it’s written to support different contexts and jurisdictions.&nbsp;&nbsp;</p>\n\n\n\n<h3>Built-in Patterns</h3>\n\n\n\n<p>If you’ve not had the chance to play with block patterns yet, all default themes now feature a range of block patterns that let you master complex layouts with minimal effort. Customize the patterns to your liking with the copy, images, and colors that fit your story or brand.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"185\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress-5-6-4.jpeg?resize=632%2C185&#038;ssl=1\" alt=\"colored and textured rectangles\" class=\"wp-image-9352\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress-5-6-4.jpeg?resize=1024%2C300&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress-5-6-4.jpeg?resize=300%2C88&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress-5-6-4.jpeg?resize=768%2C225&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2020/12/WordPress-5-6-4.jpeg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2>For developers</h2>\n\n\n\n<h3>REST API authentication with Application Passwords</h3>\n\n\n\n<p>Thanks to the API’s new Application Passwords authorization feature, third-party apps can connect to your site seamlessly and securely. This new REST API feature lets you see what apps are connecting to your site and control what they do.&nbsp;</p>\n\n\n\n<h3>More PHP 8 support</h3>\n\n\n\n<p>5.6 marks the first steps toward WordPress Core support for PHP 8. Now is a great time to start planning how your WordPress products, services, and sites can support the latest PHP version. For more information about what to expect next, <a href=\"https://make.wordpress.org/core/2020/11/23/wordpress-and-php-8-0/\">read the PHP 8 developer note</a>.</p>\n\n\n\n<h3>jQuery</h3>\n\n\n\n<p>Updates to jQuery in WordPress take place across three releases 5.5, 5.6, and 5.7. As we reach the mid-point of this process, <a href=\"https://wordpress.org/plugins/wp-jquery-update-test/\">run the update test plugin to check your sites for errors</a> ahead of time.&nbsp;&nbsp;&nbsp;&nbsp;</p>\n\n\n\n<p>If you find issues with the way your site looks ( e.g. a slider doesn’t work, a button is stuck — that sort of thing), install <a href=\"https://wordpress.org/plugins/enable-jquery-migrate-helper/\">the jQuery Migrate plugin</a>.</p>\n\n\n\n<h3>Check out the Field Guide</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">Read about the latest version of WordPress in this guide.</a> It highlights developer notes for each change in the release.&nbsp;</p>\n\n\n\n<div class=\"wp-block-cover has-background-dim\" style=\"background-color:#d1e4dd;min-height:300px\"><div class=\"wp-block-cover__inner-container\">\n<p class=\"has-text-align-center has-black-color has-text-color has-background has-large-font-size\" style=\"background-color:#d1e4dd;padding: 10px\">“It’s a new day, it’s a new life for me&#8230;.and I’m feeling good.”</p>\n<h3 class=\"has-text-align-center has-black-color has-text-color\">~Nina Simone</h3>\n</div></div>\n\n\n\n<h2>The Squad</h2>\n\n\n\n<p>The WordPress 5.6 release comes to you from an all-women and non-binary identifying release squad:  </p>\n\n\n\n<ul><li><strong>Release Lead:</strong> Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a>).&nbsp; Cohort: Chloé Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\">@cbringmann</a>) and Angela Jin (<a href=\"https://profiles.wordpress.org/angelasjin/\">@angelasjin</a>).</li><li><strong>Release Coordinator:</strong> Dee Teal (<a href=\"https://profiles.wordpress.org/thewebprincess/\">@thewebprincess</a>).&nbsp; Cohort: Thelma Mutete (<a href=\"https://profiles.wordpress.org/thelmachido/\">@thelmachido</a>) and Laura Nelson (<a href=\"https://profiles.wordpress.org/laurora/\">@laurora</a>).</li><li><strong>Triage Lead:</strong> Tonya Mork (<a href=\"https://profiles.wordpress.org/hellofromtonya/\">@hellofromtonya</a>).&nbsp;</li><li><strong>Core Tech Lead:</strong> Helen Hou-Sandì (<a href=\"https://profiles.wordpress.org/helen/\">@helen</a>).&nbsp; Cohort: Amy Kamala (<a href=\"https://profiles.wordpress.org/amykamala/\">@amykamala</a>) and Ebonie Butler (<a href=\"https://profiles.wordpress.org/metalandcoffee/\">@metalandcoffee</a>).</li><li><strong>Editor Tech Lead:</strong> Isabel Brison (<a href=\"https://profiles.wordpress.org/isabel_brison/\">@isabel_brison</a>).&nbsp; Cohort: Chandrika Guntur (<a href=\"https://profiles.wordpress.org/cguntur/\">@cguntur</a>), Anchen le Roux (<a href=\"https://profiles.wordpress.org/anchenlr/\">@anchenlr</a>), and Rebecca Hum (<a href=\"https://profiles.wordpress.org/rebasaurus/\">@rebasaurus</a>).</li><li><strong>Design Leads:</strong> Ellen Bauer (<a href=\"https://profiles.wordpress.org/elmastudio/\">@elmastudio</a>) and Tammie Lister (<a href=\"https://profiles.wordpress.org/karmatosed/\">@karmatosed</a>).&nbsp; Cohort: Anyssa Ferreira (<a href=\"https://profiles.wordpress.org/anyssa/\">@anyssa</a>), Estela Rueda (<a href=\"https://profiles.wordpress.org/estelaris/\">@estelaris</a>), Tracy Apps (<a href=\"https://profiles.wordpress.org/tray/\">@tray</a>), and Sophia DeRosia (<a href=\"https://profiles.wordpress.org/eringoblog/\">@eringoblog</a>).</li><li><strong>Design Tech Lead:</strong> Shital Marakana (<a href=\"https://profiles.wordpress.org/shital-patel/\">@shital-patel</a>).</li><li><strong>Accessibility Lead:</strong> Sarah Ricker (<a href=\"https://profiles.wordpress.org/sarahricker/\">@sarahricke<strong>r</strong></a>).&nbsp;Cohort: Hauwa Abashiya (<a href=\"https://profiles.wordpress.org/azhiyadev/\">@azhiyadev</a>).</li><li><strong>Marketing &amp; Communications Leads:</strong> Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a>) and Yvette Sonneveld (<a href=\"https://profiles.wordpress.org/yvettesonneveld/\">@yvettesonneveld</a>).&nbsp;Cohort: Nalini Thakor (<a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">@nalininonstopnewsuk</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\">@meher</a>), Olga Gleckler (<a href=\"https://profiles.wordpress.org/oglekler/\">@ogleckler</a>), Larissa Murrillo (<a href=\"https://profiles.wordpress.org/lmurillom/\">@lmurillom</a>), Michelle Frechette (<a href=\"https://profiles.wordpress.org/michelleames/\">@michelleames</a>), Breann McDede (<a href=\"https://profiles.wordpress.org/bmcdede/\">@bmcdede</a>), and Afshana Diya (<a href=\"https://profiles.wordpress.org/afshanadiya/\">@afshanadiya</a>).</li><li><strong>Documentation Lead: </strong>Shawntelle Coker (<a href=\"https://profiles.wordpress.org/sncoker/\">@sncoker</a>). Cohort: Daisy Olsen (<a href=\"https://profiles.wordpress.org/daisyo/\">@DaisyO</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\">@meher</a>), Winstina Hughes (<a href=\"https://profiles.wordpress.org/planningwrite/\">@planningwrite</a>).</li><li><strong>Documentation Review Lead:</strong> Michele Butcher-Jones (<a href=\"https://profiles.wordpress.org/m_butcher/\">@m_butcher</a>).&nbsp; Cohort: Nidhi Jain (<a href=\"https://profiles.wordpress.org/jainnidhi/\">@jainnidhi</a>), Laura Byrne Cristiano (<a href=\"https://wordpress.org/support/users/newyorkerlaura/\">@newyorkerlaura</a>).</li><li><strong>Default Theme Design Lead:</strong> Mel Choyce-Dwan (<a href=\"https://profiles.wordpress.org/melchoyce/\">@melchoyce</a>).&nbsp; Cohort: Ellen Bauer (<a href=\"https://profiles.wordpress.org/elmastudio/\">@elmastudio</a>).</li><li><strong>Default Theme Development Lead:</strong> Carolina Nymark (<a href=\"https://profiles.wordpress.org/poena/\">@poena</a>).&nbsp; Cohort: Kelly Choyce-Dwan (<a href=\"https://profiles.wordpress.org/ryelle/\">@ryelle</a>) and Jessica Lyschik (<a href=\"https://profiles.wordpress.org/luminuu/\">@luminuu</a>).</li><li><strong>Default Theme Wrangler:</strong> Jessica Lyschik (<a href=\"https://profiles.wordpress.org/luminuu/\">@luminuu</a>).</li><li><strong>Test Lead:</strong> Monika Rao (<a href=\"https://profiles.wordpress.org/monikarao/\">@monikarao</a>).&nbsp; Cohort: Allie Nimmons (<a href=\"https://profiles.wordpress.org/alliennimmons/\">@alliennimmons</a>).</li><li><strong>Support Lead:</strong> Bet Hannon (<a href=\"https://profiles.wordpress.org/bethannon1/\">@bethannon1</a>).</li></ul>\n\n\n\n<p>As always, this release reflects the hard work of 605 generous volunteer contributors. They collaborated on nearly 350 tickets on Trac and over 1,000 pull requests on GitHub.</p>\n\n\n\n<a href=\"https://profiles.wordpress.org/zgrkaralar/\">&#214;zg&#252;r KARALAR</a>, <a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/a5hleyrich/\">A5hleyRich</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">aaronrobertshaw</a>, <a href=\"https://profiles.wordpress.org/abderrahman/\">abderrahman</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/abhijitrakas/\">Abhijit Rakas</a>, <a href=\"https://profiles.wordpress.org/pokhriyal/\">Abhishek Pokhriyal</a>, <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a>, <a href=\"https://profiles.wordpress.org/adriandegrafreak/\">Adri&#225;n de Grafreak</a>, <a href=\"https://profiles.wordpress.org/adriantirusli/\">Adrianti Rusli</a>, <a href=\"https://profiles.wordpress.org/afshanadiya/\">Afshana Diya</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a>, <a href=\"https://profiles.wordpress.org/elgameel/\">Ahmed Elgameel</a>, <a href=\"https://profiles.wordpress.org/ajensen/\">ajensen</a>, <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, <a href=\"https://profiles.wordpress.org/aktasfatih/\">aktasfatih</a>, <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a>, <a href=\"https://profiles.wordpress.org/albertomake/\">albertomake</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/cawa-93/\">Alex Kozack</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a>, <a href=\"https://profiles.wordpress.org/alexstandiford/\">Alex Standiford</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/allancole/\">allancole</a>, <a href=\"https://profiles.wordpress.org/alliennimmons/\">Allie Nimmons</a>, <a href=\"https://profiles.wordpress.org/ambienthack/\">ambienthack</a>, <a href=\"https://profiles.wordpress.org/wpamitkumar/\">Amit Dudhat</a>, <a href=\"https://profiles.wordpress.org/amolv/\">Amol Vhankalas</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a>, <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a>, <a href=\"https://profiles.wordpress.org/anchenlr/\">Anchen le Roux</a>, <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a>, <a href=\"https://profiles.wordpress.org/nosolosw/\">Andr&#233; Maneiro</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/baicusandrei/\">Andrei Baicus</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/andy/\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/andystitt829/\">Andy Stitt</a>, <a href=\"https://profiles.wordpress.org/akissz/\">Angel Hess</a>, <a href=\"https://profiles.wordpress.org/angelasjin/\">Angela Jin</a>, <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a>, <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a>, <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a>, <a href=\"https://profiles.wordpress.org/anuj2/\">anuj2</a>, <a href=\"https://profiles.wordpress.org/anyssa/\">Anyssa Ferreira</a>, <a href=\"https://profiles.wordpress.org/apedog/\">apedog</a>, <a href=\"https://profiles.wordpress.org/apermo/\">Apermo</a>, <a href=\"https://profiles.wordpress.org/archduck/\">archduck</a>, <a href=\"https://profiles.wordpress.org/archon810/\">archon810</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/arippberger/\">arippberger</a>, <a href=\"https://profiles.wordpress.org/arjendejong/\">arjendejong</a>, <a href=\"https://profiles.wordpress.org/arnaudban/\">ArnaudBan</a>, <a href=\"https://profiles.wordpress.org/arpitgshah/\">Arpit G Shah</a>, <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Ahmed</a>, <a href=\"https://profiles.wordpress.org/akkspro/\">Arslan Ahmed Kalwar</a>, <a href=\"https://profiles.wordpress.org/asvinballoo/\">Asvin Balloo</a>, <a href=\"https://profiles.wordpress.org/tacitonic/\">Atharva Dhekne</a>, <a href=\"https://profiles.wordpress.org/austyfrosty/\">Austin Passy</a>, <a href=\"https://profiles.wordpress.org/austin880625/\">austin880625</a>, <a href=\"https://profiles.wordpress.org/avixansa/\">avixansa</a>, <a href=\"https://profiles.wordpress.org/ayesh/\">ayesh</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/backups/\">BackuPs</a>, <a href=\"https://profiles.wordpress.org/barry/\">Barry</a>, <a href=\"https://profiles.wordpress.org/bartczyz/\">Bart Czyz</a>, <a href=\"https://profiles.wordpress.org/bduclos/\">bduclos</a>, <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>, <a href=\"https://profiles.wordpress.org/benmeredithgmailcom/\">Ben Meredith</a>, <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/bethannon1/\">Bet Hannon</a>, <a href=\"https://profiles.wordpress.org/bethsoderberg/\">Beth Soderberg</a>, <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a>, <a href=\"https://profiles.wordpress.org/hareshlive/\">Bhagvan Mangukiya</a>, <a href=\"https://profiles.wordpress.org/bhautikvirani/\">bhautikvirani</a>, <a href=\"https://profiles.wordpress.org/bananastalktome/\">Billy S</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boldgrid/\">BoldGrid</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/ibdz/\">Boy Witthaya</a>, <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a>, <a href=\"https://profiles.wordpress.org/bmcdede/\">Breann McDede</a>, <a href=\"https://profiles.wordpress.org/bmillersw/\">Brent Miller</a>, <a href=\"https://profiles.wordpress.org/brentswisher/\">Brent Swisher</a>, <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a>, <a href=\"https://profiles.wordpress.org/brianhogg/\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/bridgetwillard/\">Bridget Willard</a>, <a href=\"https://profiles.wordpress.org/brijeshb42/\">brijeshb42</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calin/\">Calin Don</a>, <a href=\"https://profiles.wordpress.org/cvoell/\">Cameron Voell</a>, <a href=\"https://profiles.wordpress.org/campusboy1987/\">campusboy</a>, <a href=\"https://profiles.wordpress.org/carike/\">Carike</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/carolinegeven/\">Caroline</a>, <a href=\"https://profiles.wordpress.org/ceyhun0/\">ceyhun0</a>, <a href=\"https://profiles.wordpress.org/chadreitsma/\">Chad Reitsma</a>, <a href=\"https://profiles.wordpress.org/cguntur/\">Chandrika Guntur</a>, <a href=\"https://profiles.wordpress.org/cpapazoglou/\">Charalampos Papazoglou</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chexwarrior/\">chexwarrior</a>, <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a>, <a href=\"https://profiles.wordpress.org/chipsnyder/\">Chip Snyder</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a>, <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>, <a href=\"https://profiles.wordpress.org/alexandec/\">Chris Alexander</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/ctmartin0/\">Christian Martin</a>, <a href=\"https://profiles.wordpress.org/christophherr/\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/vimes1984/\">Christopher Churchill</a>, <a href=\"https://profiles.wordpress.org/chunkysteveo/\">chunkysteveo</a>, <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a>, <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a>, <a href=\"https://profiles.wordpress.org/collizo4sky/\">Collins Agbonghama</a>, <a href=\"https://profiles.wordpress.org/commeuneimage/\">Commeuneimage</a>, <a href=\"https://profiles.wordpress.org/copons/\">Copons</a>, <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a>, <a href=\"https://profiles.wordpress.org/cranewest/\">cranewest</a>, <a href=\"https://profiles.wordpress.org/littlebigthing/\">Csaba (LittleBigThings)</a>, <a href=\"https://profiles.wordpress.org/ctmartin/\">ctmartin</a>, <a href=\"https://profiles.wordpress.org/davidszabo/\">D&#225;vid Szab&#243;</a>, <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a>, <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a>, <a href=\"https://profiles.wordpress.org/dantahoua/\">dantahoua</a>, <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a>, <a href=\"https://profiles.wordpress.org/dmchale/\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a>, <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/davidjlaietta/\">David Wolfpaw</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">david.binda</a>, <a href=\"https://profiles.wordpress.org/davisshaver/\">Davis Shaver</a>, <a href=\"https://profiles.wordpress.org/dd32/\">dd32</a>, <a href=\"https://profiles.wordpress.org/p00ya/\">Dean</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/thewebprincess/\">Dee Teal</a>, <a href=\"https://profiles.wordpress.org/deepaklalwani/\">Deepak Lalwani</a>, <a href=\"https://profiles.wordpress.org/dekervit/\">dekervit</a>, <a href=\"https://profiles.wordpress.org/demetris/\">demetris (Demetris Kikizas)</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/designer023/\">Designer023</a>, <a href=\"https://profiles.wordpress.org/dfenton/\">dfenton</a>, <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a>, <a href=\"https://profiles.wordpress.org/dharmin16/\">Dharmin Shah</a>, <a href=\"https://profiles.wordpress.org/dhruvin/\">Dhruvin</a>, <a href=\"https://profiles.wordpress.org/dhulwells/\">Dhul Wells</a>, <a href=\"https://profiles.wordpress.org/dietpawel/\">dietpawel</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dingo_d/\">dingo-d</a>, <a href=\"https://profiles.wordpress.org/djzone/\">DjZoNe</a>, <a href=\"https://profiles.wordpress.org/dogwithblog/\">dogwithblog</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a>, <a href=\"https://profiles.wordpress.org/donsony/\">donsony</a>, <a href=\"https://profiles.wordpress.org/dossy/\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/dpacks/\">dpacks</a>, <a href=\"https://profiles.wordpress.org/raubvogel/\">Dr. Ronny Harbich</a>, <a href=\"https://profiles.wordpress.org/dratwas/\">dratwas</a>, <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dsifford/\">dsifford</a>, <a href=\"https://profiles.wordpress.org/dushakov/\">dushakov</a>, <a href=\"https://profiles.wordpress.org/dushanthi/\">dushanthi</a>, <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">Ebonie Butler</a>, <a href=\"https://profiles.wordpress.org/ediamin/\">Edi Amin</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/elmastudio/\">Ellen Bauer</a>, <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>, <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a>, <a href=\"https://profiles.wordpress.org/epiqueras/\">epiqueras</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a>, <a href=\"https://profiles.wordpress.org/erikjandelange/\">erikjandelange</a>, <a href=\"https://profiles.wordpress.org/folletto/\">Erin \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/eringoblog/\">eringoblog</a>, <a href=\"https://profiles.wordpress.org/eroraghav/\">eroraghav</a>, <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/etoledom/\">etoledom</a>, <a href=\"https://profiles.wordpress.org/thegp/\">EugeneBos</a>, <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">Evangelos Athanasiadis</a>, <a href=\"https://profiles.wordpress.org/fabifott/\">Fabian</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a>, <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/ferkho/\">Ferenc Forgacs</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/flymike/\">flymike</a>, <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett/\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">fullofcaffeine</a>, <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyc40/\">Gary Cao</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gchtr/\">gchtr</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/subscriptiongroup/\">George</a>, <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/geriux/\">geriux</a>, <a href=\"https://profiles.wordpress.org/glauberglauber/\">Glauber Mota</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Zi&#243;łkowski</a>, <a href=\"https://profiles.wordpress.org/guidooffermans/\">guidooffermans</a>, <a href=\"https://profiles.wordpress.org/gumacahin/\">gumacahin</a>, <a href=\"https://profiles.wordpress.org/hvar/\">H-var</a>, <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a>, <a href=\"https://profiles.wordpress.org/happiryu/\">happiryu</a>, <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a>, <a href=\"https://profiles.wordpress.org/isharis/\">Haris Zulfiqar</a>, <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a>, <a href=\"https://profiles.wordpress.org/harshbarach/\">harshbarach</a>, <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a>, <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/hoasi/\">HoaSi</a>, <a href=\"https://profiles.wordpress.org/hongnizzle/\">Hong Nga Nguyen</a>, <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a>, <a href=\"https://profiles.wordpress.org/gsayed786/\">Imran Sayed</a>, <a href=\"https://profiles.wordpress.org/ingereck/\">ingereck</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/iqbalbary/\">iqbalbary</a>, <a href=\"https://profiles.wordpress.org/ireneyoast/\">Irene Strikkers</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/jagirbaheshwp/\">jagirbaheshwp</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/twentyzerotwo/\">Jake Whiteley</a>, <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a>, <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a>, <a href=\"https://profiles.wordpress.org/jameslnewell/\">jameslnewell</a>, <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a>, <a href=\"https://profiles.wordpress.org/javidalkaruzi/\">Janvo Aldred</a>, <a href=\"https://profiles.wordpress.org/jaredcobb/\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jaswrks/\">Jason Caldwell</a>, <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a>, <a href=\"https://profiles.wordpress.org/javorszky/\">javorszky</a>, <a href=\"https://profiles.wordpress.org/jaydeep-rami/\">Jaydip Rami</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>, <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a>, <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/jeffikus/\">jeffikus</a>, <a href=\"https://profiles.wordpress.org/jellypixel/\">jellypixel</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeremyescott/\">Jeremy Scott</a>, <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a>, <a href=\"https://profiles.wordpress.org/jeroenrotty/\">Jeroen Rotty</a>, <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a>, <a href=\"https://profiles.wordpress.org/jeslen/\">Jeslen Bucci</a>, <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jfoulquier/\">jfoulquier</a>, <a href=\"https://profiles.wordpress.org/jimyaghi/\">jimyaghi</a>, <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelyoder/\">Joel Yoder</a>, <a href=\"https://profiles.wordpress.org/joelclimbsthings/\">joelclimbsthings</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johannadevos/\">Johanna de Vos</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a>, <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jonathanstegall/\">Jonathan Stegall</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a>, <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a>, <a href=\"https://profiles.wordpress.org/koke/\">Jorge Bernal</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/joseaneto/\">joseaneto</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a>, <a href=\"https://profiles.wordpress.org/joshlevinson/\">Josh Levinson</a>, <a href=\"https://profiles.wordpress.org/shelob9/\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a>, <a href=\"https://profiles.wordpress.org/tai/\">JOTAKI, Taisuke</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/junaidbhura/\">Junaid Bhura</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/justlevine/\">justlevine</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a>, <a href=\"https://profiles.wordpress.org/karthikbhatb/\">Karthik Bhat</a>, <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a>, <a href=\"https://profiles.wordpress.org/kelsu02/\">Kelly R</a>, <a href=\"https://profiles.wordpress.org/kellybleck/\">kellybleck</a>, <a href=\"https://profiles.wordpress.org/kellylawrence/\">kellylawrence</a>, <a href=\"https://profiles.wordpress.org/khag7/\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a>, <a href=\"https://profiles.wordpress.org/kipperlenny/\">Kipperlenny</a>, <a href=\"https://profiles.wordpress.org/kirilzh/\">Kiril Zhelyazkov</a>, <a href=\"https://profiles.wordpress.org/kburgoine/\">Kirsty Burgoine</a>, <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/ixkaito/\">Kite</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">KittMedia</a>, <a href=\"https://profiles.wordpress.org/kjbenk/\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/komagain/\">komagain</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa</a>, <a href=\"https://profiles.wordpress.org/kbjohnson90/\">Kyle B. Johnson</a>, <a href=\"https://profiles.wordpress.org/landau/\">landau</a>, <a href=\"https://profiles.wordpress.org/lmurillom/\">Larissa Murillo</a>, <a href=\"https://profiles.wordpress.org/latifi/\">latifi</a>, <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a>, <a href=\"https://profiles.wordpress.org/laurora/\">Laura Nelson</a>, <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a>, <a href=\"https://profiles.wordpress.org/leogermani/\">leogermani</a>, <a href=\"https://profiles.wordpress.org/gamerz/\">Lester Chan</a>, <a href=\"https://profiles.wordpress.org/leutrimh/\">Leutrim Husaj</a>, <a href=\"https://profiles.wordpress.org/limera1n/\">lim3ra</a>, <a href=\"https://profiles.wordpress.org/lpointet/\">Lionel Pointet</a>, <a href=\"https://profiles.wordpress.org/llizard/\">llizard</a>, <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a>, <a href=\"https://profiles.wordpress.org/lucagrandicelli/\">Luca Grandicelli</a>, <a href=\"https://profiles.wordpress.org/_luigi/\">Luigi Cavalieri</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lumne/\">Lumne</a>, <a href=\"https://profiles.wordpress.org/mager19/\">mager19</a>, <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>, <a href=\"https://profiles.wordpress.org/mahesh901122/\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mailnew2ster/\">mailnew2ster</a>, <a href=\"https://profiles.wordpress.org/shamimmoeen/\">Mainul Hassan Main</a>, <a href=\"https://profiles.wordpress.org/malinajirka/\">malinajirka</a>, <a href=\"https://profiles.wordpress.org/manzwebdesigns/\">manzwebdesigns</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/marekhrabe/\">Marek Hrabe</a>, <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a>, <a href=\"https://profiles.wordpress.org/marijnkoopman/\">Marijn Koopman</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius Jensen</a>, <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a>, <a href=\"https://profiles.wordpress.org/markscottrobson/\">Mark Robson</a>, <a href=\"https://profiles.wordpress.org/marks99/\">Mark Smallman</a>, <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep/\">markshep</a>, <a href=\"https://profiles.wordpress.org/m-e-h/\">Marty Helmick</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>, <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a>, <a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a>, <a href=\"https://profiles.wordpress.org/gothickgothickorguk/\">Matt Gibson</a>, <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a>, <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattchowning/\">mattchowning</a>, <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a>, <a href=\"https://profiles.wordpress.org/mattoperry/\">mattoperry</a>, <a href=\"https://profiles.wordpress.org/mayankmajeji/\">Mayank Majeji</a>, <a href=\"https://profiles.wordpress.org/meaganhanes/\">Meagan Hanes</a>, <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a>, <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a>, <a href=\"https://profiles.wordpress.org/mgrenierfarmmedia/\">mgrenierfarmmedia</a>, <a href=\"https://profiles.wordpress.org/michael-arestad/\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/m_butcher/\">Michele Butcher-Jones</a>, <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mihdan/\">mihdan</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikelopez/\">mikelopez</a>, <a href=\"https://profiles.wordpress.org/mikeyarce/\">Mikey Arce</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/eemitch/\">Mitchell Bennis</a>, <a href=\"https://profiles.wordpress.org/mmarco9/\">mmarco9</a>, <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">Monika Rao</a>, <a href=\"https://profiles.wordpress.org/mopsyd/\">mopsyd</a>, <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/gwendydd/\">Morgan Kay</a>, <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a>, <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a>, <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a>, <a href=\"https://profiles.wordpress.org/mrgrt/\">mrgrt</a>, <a href=\"https://profiles.wordpress.org/mrjoeldean/\">mrjoeldean</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/munyagu/\">munyagu</a>, <a href=\"https://profiles.wordpress.org/musicaljoeker/\">musicaljoeker</a>, <a href=\"https://profiles.wordpress.org/mweichert/\">mweichert</a>, <a href=\"https://profiles.wordpress.org/n5hzr/\">n5hzr</a>, <a href=\"https://profiles.wordpress.org/nabilmoqbel/\">Nabil Moqbel</a>, <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a>, <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/navanathbhosale/\">Navanath Bhosale</a>, <a href=\"https://profiles.wordpress.org/naveenkharwar/\">Naveen Kharwar</a>, <a href=\"https://profiles.wordpress.org/lcyh78/\">Neil James (lcyh78)</a>, <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a>, <a href=\"https://profiles.wordpress.org/krstarica/\">net</a>, <a href=\"https://profiles.wordpress.org/arealnobrainer/\">Netravnen</a>, <a href=\"https://profiles.wordpress.org/nicomollet/\">nicomollet</a>, <a href=\"https://profiles.wordpress.org/jainnidhi/\">Nidhi Jain</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/nikolam/\">Nikola</a>, <a href=\"https://profiles.wordpress.org/nbachiyski/\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/njbrown/\">njbrown</a>, <a href=\"https://profiles.wordpress.org/nlpro/\">nlpro</a>, <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a>, <a href=\"https://profiles.wordpress.org/noahshrader/\">noahshrader</a>, <a href=\"https://profiles.wordpress.org/nourma/\">nourma</a>, <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a>, <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>, <a href=\"https://profiles.wordpress.org/omarreiss/\">Omar Reiss</a>, <a href=\"https://profiles.wordpress.org/oolleegg55/\">oolleegg55</a>, <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/ovann86/\">ovann86</a>, <a href=\"https://profiles.wordpress.org/ovenall/\">ovenall</a>, <a href=\"https://profiles.wordpress.org/oxyc/\">oxyc</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/jhonqwerty/\">pabloselin</a>, <a href=\"https://profiles.wordpress.org/paddy/\">Paddy</a>, <a href=\"https://profiles.wordpress.org/pankajmohale/\">Pankaj Mohale</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pabline/\">Paul Bunkham</a>, <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/paulstonier/\">Paul Stonier</a>, <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a>, <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a>, <a href=\"https://profiles.wordpress.org/pentatonicfunk/\">pentatonicfunk</a>, <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a>, <a href=\"https://profiles.wordpress.org/pekz0r/\">Peter Elmered</a>, <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a>, <a href=\"https://profiles.wordpress.org/pierlo/\">Pierre Gordon</a>, <a href=\"https://profiles.wordpress.org/decrecementofeliz/\">Pilar Mera</a>, <a href=\"https://profiles.wordpress.org/wppinar/\">Pinar</a>, <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a>, <a href=\"https://profiles.wordpress.org/pishmishy/\">pishmishy</a>, <a href=\"https://profiles.wordpress.org/pkvillanueva/\">pkvillanueva</a>, <a href=\"https://profiles.wordpress.org/prashanttholia/\">prashanttholia</a>, <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik K. Yadav</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>, <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a>, <a href=\"https://profiles.wordpress.org/psealock/\">psealock</a>, <a href=\"https://profiles.wordpress.org/puneetsahalot/\">Puneet Sahalot</a>, <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rajanit2000/\">Rajan Vijayan</a>, <a href=\"https://profiles.wordpress.org/rajeshsingh520/\">rajeshsingh520</a>, <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/jontyravi/\">Ravi Vaghela</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a>, <a href=\"https://profiles.wordpress.org/redstar504/\">redstar504</a>, <a href=\"https://profiles.wordpress.org/regankhadgi/\">Regan Khadgi</a>, <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a>, <a href=\"https://profiles.wordpress.org/retlehs/\">retlehs</a>, <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>, <a href=\"https://profiles.wordpress.org/riaanlom/\">riaanlom</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">ribaricplusplus</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>, <a href=\"https://profiles.wordpress.org/rnaby/\">Rnaby</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>, <a href=\"https://profiles.wordpress.org/rogerlos/\">rogerlos</a>, <a href=\"https://profiles.wordpress.org/roikles/\">roikles</a>, <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a>, <a href=\"https://profiles.wordpress.org/ronakganatra/\">Ronak Ganatra</a>, <a href=\"https://profiles.wordpress.org/roo2/\">roo2</a>, <a href=\"https://profiles.wordpress.org/rtagliento/\">rtagliento</a>, <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a>, <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a>, <a href=\"https://profiles.wordpress.org/sabrinazeidan/\">Sabrina Zeidan</a>, <a href=\"https://profiles.wordpress.org/saeedfard/\">Saeed Fard</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla/\">salvoaranzulla</a>, <a href=\"https://profiles.wordpress.org/samful/\">Sam Fullalove</a>, <a href=\"https://profiles.wordpress.org/sswebster/\">Sam Webster</a>, <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sanzeeb3/\">Sanjeev Aryal</a>, <a href=\"https://profiles.wordpress.org/saqibameen/\">Saqib Ameen</a>, <a href=\"https://profiles.wordpress.org/sarahricker/\">Sarah Ricker</a>, <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a>, <a href=\"https://profiles.wordpress.org/sawanoboly/\">sawanoboly</a>, <a href=\"https://profiles.wordpress.org/scarolan/\">scarolan</a>, <a href=\"https://profiles.wordpress.org/l3rady/\">Scott Cariss</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanpaulrasmussen/\">seanpaulrasmussen</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sebsz/\">SeBsZ</a>, <a href=\"https://profiles.wordpress.org/senning/\">Senning</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/yakimun/\">Sergey Yakimov</a>, <a href=\"https://profiles.wordpress.org/sergioestevao/\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>, <a href=\"https://profiles.wordpress.org/sncoker/\">Shawntelle Coker</a>, <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/shramee/\">shramee</a>, <a href=\"https://profiles.wordpress.org/sresok/\">Simon Resok</a>, <a href=\"https://profiles.wordpress.org/sirreal/\">sirreal</a>, <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a>, <a href=\"https://profiles.wordpress.org/sproutchris/\">sproutchris</a>, <a href=\"https://profiles.wordpress.org/stulab/\">St&#233;phane Treilhou</a>, <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/garubi/\">Stefano Garuti</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a>, <a href=\"https://profiles.wordpress.org/sterndata/\">Steven Stern (sterndata)</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/sudoshreyansh/\">sudoshreyansh</a>, <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/utz119/\">TeBenachi</a>, <a href=\"https://profiles.wordpress.org/techboyg5/\">techboyg5</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a>, <a href=\"https://profiles.wordpress.org/thefarlilacfield/\">thefarlilacfield</a>, <a href=\"https://profiles.wordpress.org/thelmachido/\">Thelma Mutete</a>, <a href=\"https://profiles.wordpress.org/thib3113/\">thib3113</a>, <a href=\"https://profiles.wordpress.org/thijsvanloef/\">thijsvanloef</a>, <a href=\"https://profiles.wordpress.org/webzunft/\">Thomas M</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/thomaslhotta/\">thomaslhotta</a>, <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a>, <a href=\"https://profiles.wordpress.org/hedgefield/\">Tim Hengeveld</a>, <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timotijhof/\">TimoTijhof</a>, <a href=\"https://profiles.wordpress.org/tkama/\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tmdesigned/\">tmdesigned</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul I Chowdhury</a>, <a href=\"https://profiles.wordpress.org/tray/\">tracy apps</a>, <a href=\"https://profiles.wordpress.org/treibstoff/\">treibstoff</a>, <a href=\"https://profiles.wordpress.org/trisha_cornelius/\">Trisha Cornelius</a>, <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a>, <a href=\"https://profiles.wordpress.org/tzafrir/\">tzafrir</a>, <a href=\"https://profiles.wordpress.org/desaiuditd/\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/uxkai/\">uxkai</a>, <a href=\"https://profiles.wordpress.org/valentinbora/\">Valentin Bora</a>, <a href=\"https://profiles.wordpress.org/contact-banker/\">Varun Sharma</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">vcanales</a>, <a href=\"https://profiles.wordpress.org/ravivaddweb/\">vidhiaddweb</a>, <a href=\"https://profiles.wordpress.org/vinayakanivase/\">Vinayak Anivase</a>, <a href=\"https://profiles.wordpress.org/vinita29/\">Vinita Tandulkar</a>, <a href=\"https://profiles.wordpress.org/usestrict/\">Vinny</a>, <a href=\"https://profiles.wordpress.org/virgodesign/\">virgodesign</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/webmigrates/\">Webmigrates Technologies</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a>, <a href=\"https://profiles.wordpress.org/planningwrite/\">Winstina Hughes</a>, <a href=\"https://profiles.wordpress.org/wittich/\">wittich</a>, <a href=\"https://profiles.wordpress.org/worldweb/\">worldweb</a>, <a href=\"https://profiles.wordpress.org/y_kolev/\">Y_Kolev</a>, <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a>, <a href=\"https://profiles.wordpress.org/yoavf/\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yscik/\">yscik</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\">Yvette Sonneveld</a>, and <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a>.\n\n\n\n<p></p>\n\n\n\n<p>In addition, many thanks to all of the community volunteers who contribute in the <a href=\"https://wordpress.org/support/\">support forums</a>. They answer questions from people across the world, whether they are using WordPress for the first time, or they’ve been around since the first release all the way back in 2003. These releases are as successful as they are because of their efforts!</p>\n\n\n\n<p>Finally, thanks to all the community translators who helped make WordPress 5.6. available in 38 languages at the time of release. Our community translators are hard at work ensuring more languages are on their way (70 are already at 90%). If contributing to WordPress appeals to you, it’s easy to learn more. Check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> or the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9325\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"State of the Word 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2020/12/state-of-the-word-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Dec 2020 22:55:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9296\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"State of the Word will be streamed on Facebook, YouTube, and Twitter on Thursday, Dec 17th, 2020  at 1600 UTC.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1225:\"\n<p>State of the Word is an annual keynote address delivered by the project co-founder, Matt Mullenweg. Catch this year&#8217;s keynote in the video below!</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe class=\'youtube-player\' width=\'632\' height=\'356\' src=\'https://www.youtube.com/embed/QI3qCoiuG3w?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\' sandbox=\'allow-scripts allow-same-origin allow-popups allow-presentation\'></iframe>\n</div></figure>\n\n\n\n<h3>New to State of the Word?</h3>\n\n\n\n<p>If this is your first time hearing of this talk, you’re in luck! Check out previous recordings below.</p>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/2019/11/03/2019-state-of-the-word/\">State of the Word 2019 &#8211; WordCamp US, St. Louis</a></li><li><a href=\"https://wordpress.tv/2018/12/27/state-of-the-word-2018/\">State of the Word 2018 &#8211; WordCamp US, Nashville</a></li><li><a href=\"https://wordpress.tv/tag/state-of-the-word/\">All recordings</a></li></ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9296\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress: November 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2020/12/the-month-in-wordpress-november-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Dec 2020 09:13:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9283\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:304:\"November 2020 saw several updates to the WordPress 5.6 release. Read on to follow all the latest news from the WordPress world! WordPress 5.6 updates The Core team released WordPress 5.6 Beta 3 on Nov. 2, Beta 4 on Nov. 12, release candidate 1 on Nov. 17, and release candidate 2 on Dec. 1. You [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10892:\"\n<p>November 2020 saw several updates to the WordPress 5.6 release. Read on to follow all the latest news from the WordPress world!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.6 updates</h2>\n\n\n\n<p>The Core team released WordPress 5.6 <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\">Beta 3</a> on Nov. 2, <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-4/\">Beta 4</a> on Nov. 12, <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-release-candidate/\">release candidate</a> 1 on Nov. 17, and <a href=\"https://wordpress.org/news/2020/12/wordpress-5-6-release-candidate-2/\">release candidate 2</a> on Dec. 1. You can test the Beta versions and the release candidates by <a href=\"https://wordpress.org/wordpress-5.6-beta2.zip\">downloading them from WordPress.org</a> or by using the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin. Check out the <a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">WordPress 5.6 field guide</a> to understand the features of WordPress 5.6 and learn how you can incorporate them into your websites. WordPress 5.6 <a href=\"https://make.wordpress.org/core/5-6/\">will be out by Dec. 9, 2020</a>. </p>\n\n\n\n<p>But our work is never done: You can submit <a href=\"https://make.wordpress.org/core/2020/11/23/wordpress-5-7-whats-on-your-wishlist/\">feature suggestions for WordPress 5.7</a> by Dec. 15.&nbsp;</p>\n\n\n\n<p>Want to contribute to upcoming WordPress releases? Join the WordPress Core dev chats on Wednesdays at 5 a.m. and 8 p.m. UTC in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel on the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>, and <a href=\"https://make.wordpress.org/core/tag/dev-chat/\">catch up with recaps</a> on the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>. If you would like to help with WordPress 5.6 outreach, contact the <a href=\"https://make.wordpress.org/marketing/\">WordPress Marketing team</a> on the <a href=\"https://wordpress.slack.com/archives/C0GKJ7TFA\">#marketing</a> channel.</p>\n\n\n\n<h2>Gutenberg 9.3 and 9.4 are out</h2>\n\n\n\n<p>Contributor teams released Gutenberg <a href=\"https://make.wordpress.org/core/2020/11/04/whats-new-in-gutenberg-4-november/\">Version 9.3</a> on Nov. 4 and <a href=\"https://make.wordpress.org/core/2020/11/19/whats-new-in-gutenberg-18-november-2/\">Version 9.4</a> on Nov. 18. Both versions include&nbsp; several improvements to Full Site Editing (FSE) flows, in addition to bug fixes and feature upgrades. Version 9.3 is the first release that isn’t included entirely in WordPress 5.6; the version automatically enables FSE experiments when a block-based theme is active. Version 9.4 introduces some new features like percentage width for button blocks, block variation transformations, social icon support, and font size support for the list block. You can find out more about the Gutenberg roadmap in the <a href=\"https://make.wordpress.org/core/2020/11/02/whats-next-in-gutenberg-november-2020/\">What’s next in Gutenberg blog post</a>.</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Learn WordPress updates</h2>\n\n\n\n<p>WordPress contributor teams are all set to launch <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> in December. Community members can now watch<a href=\"https://learn.wordpress.org/workshops\"> video workshops</a> to learn about various WordPress topics, <a href=\"https://www.meetup.com/learn-wordpress-discussions/\">participate in discussion groups</a>, and use <a href=\"https://learn.wordpress.org/lesson-plans/\">lesson plans</a> for organizing their own workshops. Contributor teams have launched <a href=\"https://make.wordpress.org/community/2020/11/18/quizzes-are-now-live-on-learn-wordpress/\">quizzes</a> and are also working on <a href=\"https://make.wordpress.org/community/2020/11/18/standards-for-learn-wordpress-workshop-content/\">setting standards</a> for workshops.<br></p>\n\n\n\n<p>Want to contribute to Learn WordPress? You can now submit a <a href=\"https://learn.wordpress.org/workshop-presenter-application/\">workshop application</a> (submissions in languages other than English are welcome!), apply to become a <a href=\"https://learn.wordpress.org/discussion-group-leader-application/\">discussion group leader</a>, organize <a href=\"https://make.wordpress.org/community/handbook/virtual-events/organize-learn-wordpress-discussion-groups-for-your-wordpress-meetup/\">discussions for your local WordPress meetup group</a>, or <a href=\"https://make.wordpress.org/training/2020/11/25/high-priority-items-before-learn-wordpress-org-launch-part-2/\">help fix issues with existing lesson plans</a>.</p>\n\n\n\n<h2>WordPress 5.6 Translations and Polyglots survey</h2>\n\n\n\n<p>WordPress 5.6 is ready to be translated and is now at <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>. If you would like to contribute, <a href=\"https://make.wordpress.org/polyglots/2020/11/07/wordpress-5-6-ready-to-be-translated/\">check out these instructions</a> and ensure that <a href=\"https://make.wordpress.org/polyglots/handbook/translating/packaging-localized-wordpress/automated-release-packages/\">your locale is ready for an automated release</a>. The Polyglots team has also kicked off its <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">translator research survey</a>. Please <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">participate in the survey</a>, share the <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">survey link</a> with members of your locale, and help amplify the <a href=\"https://www.facebook.com/WPTranslationDay/posts/1275404086174610\">Facebook</a>, <a href=\"https://twitter.com/TranslateWP/status/1333342595913834496\">Twitter</a>, and <a href=\"https://www.linkedin.com/posts/wptranslationday_makewordpress-wordpress-activity-6739110862650523648-fX8R/\">LinkedIn</a> posts about it.</p>\n\n\n\n<p>Want to help WordPress speak your language? Follow <a href=\"https://make.wordpress.org/polyglots\">the Polyglots team blog</a> and join the <a href=\"https://wordpress.slack.com/archives/C02RP50LK\">#polyglots</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li><a href=\"https://www.php.net/releases/8.0/en.php\">PHP 8</a> is out, and WordPress 5.6 <a href=\"https://make.wordpress.org/core/2020/11/23/wordpress-and-php-8-0/\">aims to be &#8220;beta-compatible&#8221; with the latest PHP version</a>.</li><li>Contributor teams have kicked off <a href=\"https://make.wordpress.org/themes/2020/11/18/theme-previews-in-the-time-of-blocks/\">an ongoing discussion on starter content for WordPress themes</a>. Starter content for the <a href=\"http://wp-themes.com/twentytwentyone/\">Twenty Twenty One</a>, <a href=\"http://wp-themes.com/twentytwenty/\">Twenty Twenty</a>, and <a href=\"http://wp-themes.com/twentyseventeen/\">Twenty Seventeen</a> themes are now available.</li><li>The Accessibility team is <a href=\"https://github.com/10degrees/accessibility-statement-plugin\">testing a tool</a> to generate the structure of an accessibility statement for WordPress websites based on <a href=\"https://www.w3.org/WAI/planning/statements/generator/#create\">W3C standards</a>, and it is <a href=\"https://github.com/10degrees/accessibility-statement-plugin/issues\">requesting feedback from the community</a>.</li><li>The <a href=\"https://wordpressfoundation.org/\">WordPress Foundation</a> has published a <a href=\"https://wordpressfoundation.org/2020/open-source-workshops-november-2020-report/\">report on Open Source workshops</a> that were held online in 2020, based on the <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> platform.</li><li>The Docs team is actively <a href=\"https://make.wordpress.org/docs/2020/11/12/follow-up-on-gutenberg-developer-documentation-restructuring-proposal/\">following up</a> on a proposal to <a href=\"https://make.wordpress.org/docs/2020/08/13/plan-proposal-for-a-new-better-structured-gutenberg-developer-documentation/\">restructure the Gutenberg developer documentation</a>.</li><li>The Community team is back with <a href=\"https://make.wordpress.org/community/tag/tuesdaytrainings/\">Tuesday Trainings</a>. The team is <a href=\"https://make.wordpress.org/community/2020/11/16/community-team-goals-for-2021-share-your-suggestions/\">also inviting suggestions on team goals for 2021</a> with a deadline of Dec. 14.</li><li>The Support team is <a href=\"https://make.wordpress.org/support/2020/11/changing-up-the-forum-front-page/\">making changes to the forum page</a> to improve discoverability. </li><li>Two online WordCamps took place in November: <a href=\"https://finland.wordcamp.org/2020/\">WordCamp Finland Online</a> and <a href=\"https://mexico.wordcamp.org/2020/\">WordCamp Mexico Online</a>. You can find Livestream recaps of the events on their websites. Videos will soon be available on WordPress.tv as well.</li><li>The Themes team <a href=\"https://make.wordpress.org/themes/2020/11/11/meeting-notes-tuesday-november-10-2020/\">made some changes to WordPress theme requirements</a>. These include removing updated CSS guidelines and a proposed plan to make WordPress themes accessibility-ready. The team is also <a href=\"https://make.wordpress.org/themes/2020/11/19/feedback-requested-resolution-process-for-issues-found-in-live-themes/\">requesting feedback</a> on the resolution process for issues found in live themes.</li><li>WordPress 5.6 will feature a <a href=\"https://make.wordpress.org/core/2020/11/05/updating-core-jquery-to-version-3-part-2/\">major jQuery change</a>, with the bundled jQuery version being updated to Version 3.5.1 and jQuery Migrate being updated to Version 3.3.2.</li><li>The <a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">Diversity speaker training group</a> of the Community team is requesting feedback on reimagining their work. Please <a href=\"https://make.wordpress.org/community/2020/11/12/input-requested-re-imagining-the-work-of-the-diverse-speaker-training-group-wpdiversity/\">share your feedback as comments on the post</a> by Dec. 18.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 5.6 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2020/12/wordpress-5-6-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Dec 2020 22:09:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9274\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"The second release candidate for WordPress 5.6 is here! WordPress 5.6 is slated for release on December 8, 2020, and we need your help to get there—if you haven’t tried 5.6 yet, now is the time! You can test WordPress 5.6 release candidate 2 in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding edge nightlies” option). Or download the release [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2249:\"\n<p>The second release candidate for WordPress 5.6 is here!</p>\n\n\n\n<p>WordPress 5.6 is slated for release on <strong>December 8, 2020</strong>, and we need <em>your</em> help to get there—if you haven’t tried 5.6 yet, now is the time!</p>\n\n\n\n<p>You can test WordPress 5.6 release candidate 2 in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option).</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-RC2.zip\">download the release candidate here (zip)</a>.</li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta releases and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.6 and update the <em>Tested up to</em> version in the readme file to 5.6. If you find compatibility problems, please be sure to post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>. That way, those can be figured out before the final release. </p>\n\n\n\n<p>For a more detailed breakdown of the changes included in WordPress 5.6, check out the <a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-1/\">WordPress 5.6 beta 1 post</a>. The <a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">WordPress 5.6 Field Guide</a> is also out! It’s your source for details on all the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>Think you found a bug?</strong> Post it to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We would love to hear from you! If you’re comfortable writing a reproducible bug report you can <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>. Don&#8217;t forget to check <a href=\"https://core.trac.wordpress.org/tickets/major\">the list of known bugs</a></em>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 5.6 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2020/11/wordpress-5-6-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Nov 2020 22:43:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9258\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 5.6 Release Candidate is now available!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3349:\"\n<p>The first release candidate for WordPress 5.6 is now available!</p>\n\n\n\n<p>This is an important milestone in the community’s progress toward the final release of WordPress 5.6.</p>\n\n\n\n<p>“Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.6 is slated for release&nbsp;on&nbsp;<strong>December 8, 2020</strong>, but we need&nbsp;<em>your</em>&nbsp;help to get there—if you haven’t tried 5.6 yet,&nbsp;<strong>now is the time</strong>!</p>\n\n\n\n<p>You can test the WordPress 5.6 release candidate in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “Bleeding edge&#8221; channel and Beta/RC Only” stream options)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-RC1.zip\">download the release candidate here (zip)</a>.</li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta releases and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>What’s in WordPress 5.6?</h2>\n\n\n\n<p>The final release of 2020 continues the annual tradition of a new default theme that is custom built to showcase the new features and functionality of the software. Continued progress on the block editor is especially clear in this release, which brings more blocks to more places, and fewer clicks to implement your layouts.</p>\n\n\n\n<p>WordPress 5.6 also has lots of refinements to polish the developer experience. To learn more, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developer notes</a>&nbsp;tag for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.6 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme file to 5.6. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>,&nbsp;so those can be figured out before the final release.</p>\n\n\n\n<p>The&nbsp;WordPress 5.6 Field Guide, due very shortly, will give you a more detailed dive into the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;This release also marks the&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>&nbsp;point of the 5.6 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.6 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2020 23:49:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9249\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"WordPress 5.6 Beta 4 is now available for testing! This software is still in development,&#160;so we recommend that you run this version on a test site. You can test the WordPress 5.6 beta in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding edge nightlies” option). Or download the beta here (zip). The current target for the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5658:\"\n<p>WordPress 5.6 Beta 4 is now available for testing!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we recommend that you run this version on a test site.</p>\n\n\n\n<p>You can test the WordPress 5.6 beta in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option).</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-beta4.zip\">download the beta here (zip)</a>.</li></ul>\n\n\n\n<p>The current target for the final release is December 8, 2020. This is just over<strong> three weeks away</strong>, so your help is needed to ensure this release is tested properly.</p>\n\n\n\n<p>Thank you to all of the contributors that tested the <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\">beta 3</a> development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress.</p>\n\n\n\n<h2><strong>Some Highlights</strong></h2>\n\n\n\n<p>Since beta 3, <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">42 bugs</a> have been fixed. Here is a summary of a few changes included in beta 4:</p>\n\n\n\n<ul><li>There was a change to the auto-updates implementation for new installations of the software (<a href=\"https://core.trac.wordpress.org/ticket/50907\">#50907</a>). <em><a href=\"https://make.wordpress.org/core/2020/11/10/upgrade-install-component-meeting-summary-november-10-2020/\">Next steps</a>, and <a href=\"https://make.wordpress.org/core/2020/11/10/wp5-6-auto-update-implementation-change/\">rationale</a> are both available.</em></li><li>Added better handling of unexpected values in Site Health (<a href=\"https://core.trac.wordpress.org/ticket/50145\">#50145</a>).</li><li>Added a way for developers to filter the available authors list in Quick Edit (<a href=\"https://core.trac.wordpress.org/ticket/47685\">#47685</a>).</li><li>More accessible handling of the tag cloud widget (<a href=\"https://core.trac.wordpress.org/ticket/51455\">#51455</a>).</li><li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;component=Media&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">Multiple improvements in the Media component</a>.</li><li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;component=Build%2FTest+Tools&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">Multiple improvements in the Build/Test Tools component</a>.</li></ul>\n\n\n\n<p><em>To see all of the features for each Gutenberg release in detail, check out the release posts: <a href=\"https://make.wordpress.org/core/2020/07/22/whats-new-in-gutenberg-july-22/\">8.6</a>, <a href=\"https://make.wordpress.org/core/2020/08/05/whats-new-in-gutenberg-august-5/\">8.7</a>, <a href=\"https://make.wordpress.org/core/2020/08/19/whats-new-in-gutenberg-august-19/\">8.8</a>, <a href=\"https://make.wordpress.org/core/2020/09/03/whats-new-in-gutenberg-2-september/\">8.9</a>, <a href=\"https://make.wordpress.org/core/2020/09/16/whats-new-in-gutenberg-16-september/\">9.0</a>, <a href=\"https://make.wordpress.org/core/2020/10/01/whats-new-in-gutenberg-30-september/\">9.1</a>, <a href=\"https://make.wordpress.org/core/2020/10/21/whats-new-in-gutenberg-21-october/\">9.2</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v9.3.0-rc.1\">9.3</a>.</em></p>\n\n\n\n<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>\n\n\n\n<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.6 has lots of refinements to the developer experience. To keep up, subscribe to the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> and pay special attention to the <a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developers’ notes</a> for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>\n\n\n\n<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>\n\n\n\n<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=new&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">known bugs</a>.</p>\n\n\n\n<p><em>Props to @tonyamork, @audrasjb for technical notes and @angelasjin,<em> </em><a href=\"https://profiles.wordpress.org/yvettesonneveld/\">@yvettesonneveld</a><em>, </em><a href=\"https://profiles.wordpress.org/cguntur/\">@cguntur</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a> for final review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9249\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.6 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Nov 2020 21:23:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9234\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"WordPress 5.6 Beta 3 is now available for testing! This software is still in development,&#160;so we recommend that you run this version on a test site. You can test the WordPress 5.6 beta in two ways: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding edge nightlies” option). Or&#160;download the beta here&#160;(zip). The current target for the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5206:\"\n<p>WordPress 5.6 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we recommend that you run this version on a test site.</p>\n\n\n\n<p>You can test the WordPress 5.6 beta in two ways:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option).</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.6-beta3.zip\">download the beta here&nbsp;(zip)</a>.</li></ul>\n\n\n\n<p>The current target for the final release is December 8, 2020. This is just&nbsp;<strong>five weeks away</strong>, so your help is needed to ensure this release is tested properly.</p>\n\n\n\n<p>Thank you to all of the contributors that tested the&nbsp;<a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-2/\">beta 2&nbsp;</a>development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress.</p>\n\n\n\n<h2><strong>Some Highlights</strong></h2>\n\n\n\n<p>Since&nbsp;beta 2,&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2020..11%2F03%2F2020&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">20 bugs</a>&nbsp;have been fixed. Here is a summary of a few changes included in beta 3:</p>\n\n\n\n<ul><li>Added block patterns for Twenty Twenty (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51098\">#51098</a>) and Twenty Nineteen (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51099\">#51099</a>) themes.</li><li>Added theme support for navigation-widgets (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51445\">#51445</a>).</li><li>Fixed incorrect slashes in the URL if the parent is empty for REST API (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/44745\">#44745</a>).</li><li>Added a test to Site Health to verify that the&nbsp;<code>Authorization</code>&nbsp;header is working as expected for Application Passwords (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51638\">#51638</a>).</li><li>10 additional bugs fixed in the block editor (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://github.com/WordPress/gutenberg/pull/26588\">#26588</a>).</li></ul>\n\n\n\n<p>To see all of the features for each Gutenberg release in detail, check out the release posts:&nbsp;<a href=\"https://make.wordpress.org/core/2020/07/22/whats-new-in-gutenberg-july-22/\">8.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/08/05/whats-new-in-gutenberg-august-5/\">8.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/08/19/whats-new-in-gutenberg-august-19/\">8.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/09/03/whats-new-in-gutenberg-2-september/\">8.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/09/16/whats-new-in-gutenberg-16-september/\">9.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/10/01/whats-new-in-gutenberg-30-september/\">9.1</a>, <a href=\"https://make.wordpress.org/core/2020/10/21/whats-new-in-gutenberg-21-october/\">9.2</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v9.3.0-rc.1\">9.3</a>.</p>\n\n\n\n<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>\n\n\n\n<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.6 has lots of refinements to the developer experience as well. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developers’ notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>\n\n\n\n<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>\n\n\n\n<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=new&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">known bugs</a>.</p>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromtonya</a> for help and <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>  for final review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 31 Jan 2021 12:31:24 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 27 Jan 2021 18:27:09 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20201016172007\";}", "no");
INSERT INTO `wp_3_options` VALUES("321", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1612139438", "no");
INSERT INTO `wp_3_options` VALUES("322", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1612096238", "no");
INSERT INTO `wp_3_options` VALUES("323", "_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "1612139439", "no");
INSERT INTO `wp_3_options` VALUES("324", "_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2021/01/people-of-wordpress-thelma-mutete/\'>People of WordPress: Thelma Mutete</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2021/01/the-month-in-wordpress-december-2020/\'>The Month in WordPress: December 2020</a></li></ul></div><div class=\"rss-widget\"><p><strong>خطای RSS:</strong> WP HTTP Error: نشانی معتبر نیست.</p></div>", "no");
INSERT INTO `wp_3_options` VALUES("326", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_3_options` VALUES("327", "theme_mods_twentytwentyone", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "yes");

/* INSERT TABLE DATA: wp_3_postmeta */
INSERT INTO `wp_3_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_3_postmeta` VALUES("2", "3", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `wp_3_postmeta` VALUES("3", "3", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"woocommerce-placeholder-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

/* INSERT TABLE DATA: wp_3_posts */
INSERT INTO `wp_3_posts` VALUES("1", "1", "2021-01-31 15:59:23", "2021-01-31 12:29:23", "به <a href=\"http://localhost/enfold/\">انفولد</a> خوش آمدید.‌ این نخستین نوشته‌‌ی شماست. می‌توانید ویرایش یا پاکش کنید و پس از آن نوشتن را آغاز کنید!", "سلام دنیا!", "", "publish", "open", "open", "", "%d8%b3%d9%84%d8%a7%d9%85-%d8%af%d9%86%db%8c%d8%a7", "", "", "2021-01-31 15:59:23", "2021-01-31 12:29:23", "", "0", "http://localhost/enfold/construction/?p=1", "0", "post", "", "1");
INSERT INTO `wp_3_posts` VALUES("2", "1", "2021-01-31 15:59:23", "2021-01-31 12:29:23", "<!-- wp:paragraph -->\n<p>این یک برگهٔ نمونه است. این از یک نوشتهٔ وبلاگ متفاوت است زیرا در یک مکان باقی خواهد ماند و در راهبری سایتتان (در بیشتر پوسته‌ها) نشان داده خواهد شد. بیشتر مردم با یک برگه درباره که آن‌ها را به بازدیدکنندگان بالقوهٔ سایت معرفی می‌کند، آغاز می‌کنند. که ممکن است چیزی همانند این باشد:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>سلام! من یک پیام‌رسان دوچرخه‌سوار در روز، بازیگر مشتاق در شب هستم، و این وب‌سایت من است. من در لس آنجلس زندگی می‌کنم، یک سگ بزرگ به نام جک دارم، و من پینیا کولادا دوست دارم. (همچنین گرفتار شدن در باران را دوست دارم.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...یا چیزهایی مانند این:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>شرکت XYZ در سال ۱۹۷۱ تأسیس شد، و تا کنون چیزهای با کیفیتی را به عموم عرضه کرده است. این شرکت در شهر گاتهام واقع شده است، بیش از ۲۰۰۰ نفر در آن کار می‌کنند و همه نوع چیز عالی برای جامعه گاتهام انجام می‌دهد.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>به عنوان یک کاربر جدید وردپرس، برای حذف این برگه و ایجاد برگه‌های جدید برای محتوای خود شما باید به <a href=\"http://localhost/enfold/construction/wp-admin/\">پیشخوان</a> بروید. خوش بگذره!</p>\n<!-- /wp:paragraph -->", "برگه نمونه", "", "publish", "closed", "open", "", "برگه-نمونه", "", "", "2021-01-31 15:59:23", "2021-01-31 12:29:23", "", "0", "http://localhost/enfold/construction/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_3_posts` VALUES("3", "0", "2021-01-31 15:59:30", "2021-01-31 12:29:30", "", "woocommerce-placeholder", "", "inherit", "open", "closed", "", "woocommerce-placeholder", "", "", "2021-01-31 15:59:30", "2021-01-31 12:29:30", "", "0", "http://localhost/enfold/construction/wp-content/uploads/sites/3/2021/01/woocommerce-placeholder.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_3_posts` VALUES("4", "1", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "", "فروشگاه", "", "publish", "closed", "closed", "", "shop", "", "", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "", "0", "http://localhost/enfold/construction/shop/", "0", "page", "", "0");
INSERT INTO `wp_3_posts` VALUES("5", "1", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "<!-- wp:shortcode -->[woocommerce_cart]<!-- /wp:shortcode -->", "سبد خرید", "", "publish", "closed", "closed", "", "cart", "", "", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "", "0", "http://localhost/enfold/construction/cart/", "0", "page", "", "0");
INSERT INTO `wp_3_posts` VALUES("6", "1", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "<!-- wp:shortcode -->[woocommerce_checkout]<!-- /wp:shortcode -->", "پرداخت", "", "publish", "closed", "closed", "", "checkout", "", "", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "", "0", "http://localhost/enfold/construction/checkout/", "0", "page", "", "0");
INSERT INTO `wp_3_posts` VALUES("7", "1", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->", "حساب کاربری من", "", "publish", "closed", "closed", "", "my-account", "", "", "2021-01-31 15:59:31", "2021-01-31 12:29:31", "", "0", "http://localhost/enfold/construction/my-account/", "0", "page", "", "0");
INSERT INTO `wp_3_posts` VALUES("8", "1", "2021-01-31 16:00:34", "0000-00-00 00:00:00", "", "پیش‌نویس خودکار", "", "auto-draft", "open", "open", "", "", "", "", "2021-01-31 16:00:34", "0000-00-00 00:00:00", "", "0", "http://localhost/enfold/construction/?p=8", "0", "post", "", "0");

/* INSERT TABLE DATA: wp_3_term_relationships */
INSERT INTO `wp_3_term_relationships` VALUES("1", "1", "0");

/* INSERT TABLE DATA: wp_3_term_taxonomy */
INSERT INTO `wp_3_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");
INSERT INTO `wp_3_term_taxonomy` VALUES("2", "2", "product_type", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("3", "3", "product_type", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("4", "4", "product_type", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("5", "5", "product_type", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("6", "6", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("7", "7", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("8", "8", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("9", "9", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("10", "10", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("11", "11", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("12", "12", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("13", "13", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("14", "14", "product_visibility", "", "0", "0");
INSERT INTO `wp_3_term_taxonomy` VALUES("15", "15", "product_cat", "", "0", "0");

/* INSERT TABLE DATA: wp_3_terms */
INSERT INTO `wp_3_terms` VALUES("1", "دسته‌بندی نشده", "%d8%af%d8%b3%d8%aa%d9%87%e2%80%8c%d8%a8%d9%86%d8%af%db%8c-%d9%86%d8%b4%d8%af%d9%87", "0");
INSERT INTO `wp_3_terms` VALUES("2", "simple", "simple", "0");
INSERT INTO `wp_3_terms` VALUES("3", "grouped", "grouped", "0");
INSERT INTO `wp_3_terms` VALUES("4", "variable", "variable", "0");
INSERT INTO `wp_3_terms` VALUES("5", "external", "external", "0");
INSERT INTO `wp_3_terms` VALUES("6", "exclude-from-search", "exclude-from-search", "0");
INSERT INTO `wp_3_terms` VALUES("7", "exclude-from-catalog", "exclude-from-catalog", "0");
INSERT INTO `wp_3_terms` VALUES("8", "featured", "featured", "0");
INSERT INTO `wp_3_terms` VALUES("9", "outofstock", "outofstock", "0");
INSERT INTO `wp_3_terms` VALUES("10", "rated-1", "rated-1", "0");
INSERT INTO `wp_3_terms` VALUES("11", "rated-2", "rated-2", "0");
INSERT INTO `wp_3_terms` VALUES("12", "rated-3", "rated-3", "0");
INSERT INTO `wp_3_terms` VALUES("13", "rated-4", "rated-4", "0");
INSERT INTO `wp_3_terms` VALUES("14", "rated-5", "rated-5", "0");
INSERT INTO `wp_3_terms` VALUES("15", "بدون دسته‌بندی", "%d8%a8%d8%af%d9%88%d9%86-%d8%af%d8%b3%d8%aa%d9%87%e2%80%8c%d8%a8%d9%86%d8%af%db%8c", "0");

/* INSERT TABLE DATA: wp_3_wc_admin_note_actions */
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("1", "1", "yes-please", "بله لطفا!", "https://woocommerce.us8.list-manage.com/subscribe/post?u=2c1434dc56f9506bf3c3ecd21&amp;id=13860df971&amp;SIGNUPPAGE=plugin", "actioned", "0", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("2", "2", "open-marketing-hub", "باز کردن مرکز بازاریابی", "http://localhost/enfold/construction/wp-admin/admin.php?page=wc-admin&path=/marketing", "actioned", "0", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("3", "3", "set-up-concierge", "Schedule free session", "https://wordpress.com/me/concierge", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("4", "4", "learn-more", "Learn more", "https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox", "unactioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("5", "5", "learn-more-ecomm-unique-shopping-experience", "Learn more", "https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("6", "6", "install-now", "Install now", "admin.php?page=wc-admin&action=setup-woocommerce-payments", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("7", "7", "install-now", "Install now", "admin.php?page=wc-admin&action=setup-woocommerce-payments", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("8", "8", "install-now", "Install now", "admin.php?page=wc-admin&action=setup-woocommerce-payments", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("9", "9", "install-now", "Install now", "admin.php?page=wc-admin&action=setup-woocommerce-payments", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("10", "10", "watch-the-webinar", "Watch the webinar", "https://youtu.be/V_2XtCOyZ7o", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("11", "11", "learn-more", "Learn more", "https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox", "actioned", "1", "");
INSERT INTO `wp_3_wc_admin_note_actions` VALUES("12", "12", "connect", "اتصال", "?page=wc-addons&section=helper", "unactioned", "0", "");

/* INSERT TABLE DATA: wp_3_wc_admin_notes */
INSERT INTO `wp_3_wc_admin_notes` VALUES("1", "wc-admin-onboarding-email-marketing", "info", "en_US", "Tips, product updates, and inspiration", "ما برای شما اینجاییم - نکات آموزشی، بروزرسانی‌های محصول و طرح‌های تشویقی را در پست الکترونیک خود دریافت نمایید.", "{}", "unactioned", "woocommerce-admin", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("2", "wc-admin-marketing-intro", "info", "en_US", "با مخاطبانتان در ارتباط باشید.", "مشتریان بیشتری پیدا کرده و فروش تان را با استفاده از ابزارهای بازاریابی ایجاد شده در ووکامرس افزایش دهید.", "{}", "unactioned", "woocommerce-admin", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("3", "ecomm-need-help-setting-up-your-store", "info", "en_US", "Need help setting up your Store?", "Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("4", "woocommerce-services", "info", "en_US", "WooCommerce Shipping & Tax", "WooCommerce Shipping &amp; Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("5", "ecomm-unique-shopping-experience", "info", "en_US", "For a shopping experience as unique as your customers", "Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("6", "wcpay-promo-2020-11", "marketing", "en_US", "Manage subscriber payments from your store\'s dashboard", "Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br /><br /><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("7", "wcpay-subscriptions-2020-11", "marketing", "en_US", "Manage subscriber payments from your store\'s dashboard", "Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>  – now supporting <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Subscriptions</a>! <br /><br /><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("8", "wcpay-promo-2020-12", "marketing", "en_US", "Get 50% off transaction fees with WooCommerce Payments", "Keep more of your hard-earned cash by adding <a href=\"https://woocommerce.com/payments/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_exp20\" target=\"_blank\">WooCommerce Payments</a> to your store. Lock in a discounted rate of 1.5% + $0.15 for $25,000 of payments (or three months, whichever comes first). Limited time offer – don’t miss out! <br /><br /><em>By clicking \"Install now,\" you agree to our promotional <a href=\"https://woocommerce.com/terms-conditions/woocommerce-payments-promotion/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_exp20\" target=\"_blank\">Terms of Service</a>.</em>", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("9", "wcpay-subscriptions-2020-12", "marketing", "en_US", "Manage payments from your store\'s dashboard", "Securely accept cards and manage transactions right from your dashboard with <a href=\"https://woocommerce.com/payments/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">WooCommerce Payments</a>! Zero setup fees or monthly fees. Just pay-as-you-go, starting at just 2.9% + $0.30 per transaction for U.S.-issued cards. <br /><br /><em>By clicking \"Install now,\" you agree to our <a href=\"https://wordpress.com/tos/?utm_medium=notification&amp;utm_source=product&amp;utm_campaign=wcpay_ctrl20\" target=\"_blank\">Terms of Service</a>.</em>", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("10", "wc-admin-getting-started-in-ecommerce", "info", "en_US", "Getting Started in eCommerce - webinar", "We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("11", "your-first-product", "info", "en_US", "Your first product", "That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br /><br />Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.", "{}", "pending", "woocommerce.com", "2021-01-31 12:29:32", NULL, "0", "plain", "", "0", "info");
INSERT INTO `wp_3_wc_admin_notes` VALUES("12", "wc-admin-wc-helper-connection", "info", "en_US", "اتصال به WooCommerce.com", "Connect to get important product notifications and updates.", "{}", "unactioned", "woocommerce-admin", "2021-01-31 12:29:38", NULL, "0", "plain", "", "0", "info");

/* INSERT TABLE DATA: wp_3_wc_category_lookup */
INSERT INTO `wp_3_wc_category_lookup` VALUES("15", "15");

/* INSERT TABLE DATA: wp_3_wc_tax_rate_classes */
INSERT INTO `wp_3_wc_tax_rate_classes` VALUES("1", "نرخ کاهش", "%d9%86%d8%b1%d8%ae-%da%a9%d8%a7%d9%87%d8%b4");
INSERT INTO `wp_3_wc_tax_rate_classes` VALUES("2", "نرخ صفر", "%d9%86%d8%b1%d8%ae-%d8%b5%d9%81%d8%b1");

/* INSERT TABLE DATA: wp_3_woocommerce_sessions */
INSERT INTO `wp_3_woocommerce_sessions` VALUES("1", "1", "a:7:{s:4:\"cart\";s:6:\"a:0:{}\";s:11:\"cart_totals\";s:367:\"a:15:{s:8:\"subtotal\";i:0;s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";i:0;s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";i:0;s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";i:0;s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";i:0;s:9:\"total_tax\";i:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:8:\"customer\";s:731:\"a:26:{s:2:\"id\";s:1:\"1\";s:13:\"date_modified\";s:25:\"2021-01-31T09:31:31+03:30\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"GB\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"GB\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:17:\"info@khatamwp.dev\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";}\";}", "1612269035");

/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("302", "woocommerce_cleanup_draft_orders", "complete", "2024-09-12 11:02:15", "2024-09-12 15:32:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726138935;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726138935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-09-22 08:29:30", "2024-09-22 11:59:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("307", "woocommerce_cleanup_draft_orders", "complete", "2024-09-23 08:29:30", "2024-09-23 11:59:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727080170;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727080170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-10-02 08:24:37", "2024-10-02 11:54:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("308", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-09-22 08:29:46", "2024-09-22 11:59:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726993786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726993786;}", "4", "1", "2024-09-22 08:30:12", "2024-09-22 12:00:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("309", "woocommerce_cleanup_draft_orders", "complete", "2024-10-03 08:24:37", "2024-10-03 11:54:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727943877;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727943877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-10-09 06:25:13", "2024-10-09 09:55:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("310", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-10-02 08:24:44", "2024-10-02 11:54:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727857484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727857484;}", "4", "1", "2024-10-02 08:24:47", "2024-10-02 11:54:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("311", "woocommerce_cleanup_draft_orders", "complete", "2024-10-10 06:25:13", "2024-10-10 09:55:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728541513;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728541513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-10-13 19:06:51", "2024-10-13 22:36:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("312", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-10-09 06:26:11", "2024-10-09 09:56:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728455171;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728455171;}", "4", "1", "2024-10-09 06:26:15", "2024-10-09 09:56:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("313", "woocommerce_cleanup_draft_orders", "complete", "2024-10-14 19:06:51", "2024-10-14 22:36:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728932811;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728932811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-10-19 10:48:58", "2024-10-19 14:18:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("314", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-10-13 19:06:51", "2024-10-13 22:36:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728846411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728846411;}", "4", "1", "2024-10-13 19:06:55", "2024-10-13 22:36:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("315", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-10-13 19:24:02", "2024-10-13 22:54:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728847442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728847442;}", "2", "1", "2024-10-13 19:24:11", "2024-10-13 22:54:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("316", "woocommerce_run_update_callback", "complete", "2024-10-13 19:24:23", "2024-10-13 22:54:23", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728847463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728847463;}", "2", "1", "2024-10-13 19:25:02", "2024-10-13 22:55:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("317", "woocommerce_run_update_callback", "complete", "2024-10-13 19:24:24", "2024-10-13 22:54:24", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728847464;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728847464;}", "2", "1", "2024-10-13 19:25:02", "2024-10-13 22:55:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("318", "woocommerce_update_db_to_current_version", "complete", "2024-10-13 19:24:25", "2024-10-13 22:54:25", "{\"version\":\"9.3.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728847465;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728847465;}", "2", "1", "2024-10-13 19:25:02", "2024-10-13 22:55:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("319", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-10-13 20:10:08", "2024-10-13 23:40:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1728850208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1728850208;}", "4", "1", "2024-10-13 20:11:29", "2024-10-13 23:41:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("320", "woocommerce_cleanup_draft_orders", "pending", "2024-10-20 10:48:58", "2024-10-20 14:18:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1729421338;s:18:\"\0*\0first_timestamp\";i:1660998179;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1729421338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("321", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2024-10-19 10:49:15", "2024-10-19 14:19:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1729334955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1729334955;}", "4", "1", "2024-10-19 10:59:44", "2024-10-19 14:29:44", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "302", "ایجاد فعالیت", "2024-09-11 11:02:15", "2024-09-11 15:32:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("892", "302", "عملیات توسط WP Cron شروع شد", "2024-09-22 08:29:30", "2024-09-22 11:59:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("893", "302", "عملیات توسط WP Cron کامل شد", "2024-09-22 08:29:30", "2024-09-22 11:59:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("894", "307", "ایجاد فعالیت", "2024-09-22 08:29:30", "2024-09-22 11:59:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("895", "308", "ایجاد فعالیت", "2024-09-22 08:29:46", "2024-09-22 11:59:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("896", "308", "عملیات توسط WP Cron شروع شد", "2024-09-22 08:30:12", "2024-09-22 12:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("897", "308", "عملیات توسط WP Cron کامل شد", "2024-09-22 08:30:12", "2024-09-22 12:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("898", "307", "عملیات توسط WP Cron شروع شد", "2024-10-02 08:24:36", "2024-10-02 11:54:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("899", "307", "عملیات توسط WP Cron کامل شد", "2024-10-02 08:24:37", "2024-10-02 11:54:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("900", "309", "ایجاد فعالیت", "2024-10-02 08:24:37", "2024-10-02 11:54:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("901", "310", "ایجاد فعالیت", "2024-10-02 08:24:44", "2024-10-02 11:54:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("902", "310", "عملیات توسط Async Request شروع شد", "2024-10-02 08:24:47", "2024-10-02 11:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("903", "310", "عملیات توسط Async Request کامل شد", "2024-10-02 08:24:47", "2024-10-02 11:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("904", "309", "عملیات توسط Async Request شروع شد", "2024-10-09 06:25:13", "2024-10-09 09:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("905", "309", "عملیات توسط Async Request کامل شد", "2024-10-09 06:25:13", "2024-10-09 09:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("906", "311", "ایجاد فعالیت", "2024-10-09 06:25:13", "2024-10-09 09:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("907", "312", "ایجاد فعالیت", "2024-10-09 06:26:11", "2024-10-09 09:56:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("908", "312", "عملیات توسط Async Request شروع شد", "2024-10-09 06:26:15", "2024-10-09 09:56:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("909", "312", "عملیات توسط Async Request کامل شد", "2024-10-09 06:26:15", "2024-10-09 09:56:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("910", "311", "عملیات توسط WP Cron شروع شد", "2024-10-13 19:06:51", "2024-10-13 22:36:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("911", "311", "عملیات توسط WP Cron کامل شد", "2024-10-13 19:06:51", "2024-10-13 22:36:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("912", "313", "ایجاد فعالیت", "2024-10-13 19:06:51", "2024-10-13 22:36:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("913", "314", "ایجاد فعالیت", "2024-10-13 19:06:51", "2024-10-13 22:36:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("914", "314", "عملیات توسط Async Request شروع شد", "2024-10-13 19:06:55", "2024-10-13 22:36:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("915", "314", "عملیات توسط Async Request کامل شد", "2024-10-13 19:06:55", "2024-10-13 22:36:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("916", "315", "ایجاد فعالیت", "2024-10-13 19:24:01", "2024-10-13 22:54:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("917", "315", "عملیات توسط WP Cron شروع شد", "2024-10-13 19:24:10", "2024-10-13 22:54:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("918", "315", "عملیات توسط WP Cron کامل شد", "2024-10-13 19:24:11", "2024-10-13 22:54:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("919", "316", "ایجاد فعالیت", "2024-10-13 19:24:23", "2024-10-13 22:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("920", "317", "ایجاد فعالیت", "2024-10-13 19:24:23", "2024-10-13 22:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("921", "318", "ایجاد فعالیت", "2024-10-13 19:24:23", "2024-10-13 22:54:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("922", "316", "عملیات توسط WP Cron شروع شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("923", "316", "عملیات توسط WP Cron کامل شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("924", "317", "عملیات توسط WP Cron شروع شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("925", "317", "عملیات توسط WP Cron کامل شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("926", "318", "عملیات توسط WP Cron شروع شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("927", "318", "عملیات توسط WP Cron کامل شد", "2024-10-13 19:25:02", "2024-10-13 22:55:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("928", "319", "ایجاد فعالیت", "2024-10-13 20:10:08", "2024-10-13 23:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("929", "319", "عملیات توسط WP Cron شروع شد", "2024-10-13 20:11:29", "2024-10-13 23:41:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("930", "319", "عملیات توسط WP Cron کامل شد", "2024-10-13 20:11:29", "2024-10-13 23:41:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("931", "313", "عملیات توسط WP Cron شروع شد", "2024-10-19 10:48:58", "2024-10-19 14:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("932", "313", "عملیات توسط WP Cron کامل شد", "2024-10-19 10:48:58", "2024-10-19 14:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("933", "320", "ایجاد فعالیت", "2024-10-19 10:48:58", "2024-10-19 14:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("934", "321", "ایجاد فعالیت", "2024-10-19 10:49:15", "2024-10-19 14:19:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("935", "321", "عملیات توسط WP Cron شروع شد", "2024-10-19 10:59:44", "2024-10-19 14:29:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("936", "321", "عملیات توسط WP Cron کامل شد", "2024-10-19 10:59:44", "2024-10-19 14:29:44");

/* INSERT TABLE DATA: wp_blogs */
INSERT INTO `wp_blogs` VALUES("1", "1", "http://localhost/enfold", "/", "2021-01-31 15:32:22", "0000-00-00 00:00:00", "1", "0", "0", "0", "0", "0");
INSERT INTO `wp_blogs` VALUES("3", "1", "http://localhost/enfold", "/construction/", "2021-01-31 12:29:22", "2021-01-31 12:29:31", "1", "0", "0", "0", "0", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "1376", "شخص آزمایشی", "support@kriesi.at", "", "212.186.180.120", "2017-02-14 14:37:15", "2017-02-14 11:07:15", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "1376", "لورم ایپسوم", "office@kriesi.at", "", "212.186.180.120", "2017-02-14 14:38:03", "2017-02-14 11:08:03", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "68", "", "", "", "", "2014-08-24 17:14:26", "2014-08-24 12:44:26", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("15", "20230530_d8a7d986d981d988d984d8af", "d921f8fa72504dab1977_20241019114126", "25", "2024-10-19 11:46:51", "admin2", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-10-19 11:41:26\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.4.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:15;s:4:\"Name\";s:33:\"20230530_d8a7d986d981d988d984d8af\";s:4:\"Hash\";s:35:\"d921f8fa72504dab1977_20241019114126\";s:8:\"NameHash\";s:69:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:79:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"24.7\";s:6:\"WPUser\";s:6:\"admin2\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:81:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:21:\"D:/laragon/www/enfold\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1572;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14172;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-10-19 11:41:26\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.4.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:33:\"20230530_d8a7d986d981d988d984d8af\";s:4:\"Hash\";s:35:\"d921f8fa72504dab1977_20241019114126\";s:8:\"NameHash\";s:69:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:87:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:35:\"D:/laragon/www/enfold/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:82:\"20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:136:\"D:/laragon/www/enfold/wp-content/backups-dup-lite/tmp/20230530_d8a7d986d981d988d984d8af_d921f8fa72504dab1977_20241019114126_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:30:\"D:/laragon/www/enfold/wp-admin\";i:1;s:33:\"D:/laragon/www/enfold/wp-includes\";i:2;s:42:\"D:/laragon/www/enfold/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:21:\"D:/laragon/www/enfold\";i:1;s:21:\"D:/laragon/www/enfold\";i:2;s:32:\"D:/laragon/www/enfold/wp-content\";i:3;s:40:\"D:/laragon/www/enfold/wp-content/uploads\";i:4;s:40:\"D:/laragon/www/enfold/wp-content/plugins\";i:5;s:43:\"D:/laragon/www/enfold/wp-content/mu-plugins\";i:6;s:39:\"D:/laragon/www/enfold/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:53:\"D:/laragon/www/enfold/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", NULL, "1", "Enfold Reimagined", "", "{\"properties\":{\"sliderVersion\":\"7.11.1\",\"title\":\"Enfold Reimagined\",\"slug\":\"\",\"keywords\":\"\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"popupFitWidth\":\"\",\"popupFitHeight\":\"\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceTop\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceBottom\":\"10\",\"popupDistanceLeft\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"sceneHeight\":\"\",\"sceneSpeed\":\"100\",\"stickTo\":\"center\",\"smoothScrollDuration\":\"\",\"width\":1410,\"height\":850,\"maxwidth\":\"\",\"responsiveunder\":\"1410\",\"fullSizeMode\":\"normal\",\"marginTop\":\"\",\"marginBottom\":\"\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"calculateOffsetFrom\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"0\",\"hideover\":\"100000\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"fullwidth\",\"borderRadius\":\"\",\"sliderfadeinduration\":\"350\",\"firstSlideDuration\":\"\",\"firstSlideTimeShift\":\"\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"globalBGFor\":\"project\",\"backgroundcolor\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"tnFillMode\":\"contain\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"performanceMode\":\"inherit\",\"performanceModeThreshold\":\"20sh\",\"enhancedLazyLoad\":\"inherit\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"slideDuration\":\"\",\"slideTransitionDuration\":\"\",\"slideTimeShift\":\"0\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"scrollCenterLayers\":\"center\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":\"enabled\",\"preferBlendMode\":\"disabled\",\"playByScrollSpeed\":\"1\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"previewId\":\"\",\"preview\":\"\",\"allowFullscreen\":false,\"responsive\":true,\"animatefirstlayer\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"circletimer\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"all\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"0% 50%\",\"bgsize\":\"cover\",\"slidedelay\":\"7000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.1\",\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":\"500\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"backgroundId\":3130,\"background\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-bg-1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"skip\":false,\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-bg-1-300x159.jpg\",\"thumbnailThumb\":\"\",\"post_content\":false,\"customProperties\":[],\"schedule_start\":\"\",\"schedule_end\":\"\"},\"sublayers\":[{\"subtitle\":\"plant\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":27,\\\\\\\"top\\\\\\\":\\\\\\\"125px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1121px\\\\\\\"}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3132,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/plant-small-1.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/plant-small-1-206x300.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"dba25b51-b997-4d0e-96f7-2ac9fd34c2ac\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"img\",\"htmlLineBreak\":\"manual\"},{\"subtitle\":\"big img\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"000\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"-120px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-506px\\\\\\\"}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3131,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-300x131.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"013d8979-465c-408a-b486-369512ce7438\",\"htmlTag\":\"img\",\"htmlLineBreak\":\"manual\"},{\"subtitle\":\"overlay\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"300%\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"100%\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-700px\\\\\\\",\\\\\\\"background-color\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\"}\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"locked\":false,\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"uuid\":\"97a44bce-51bd-4892-8152-9fe354f9b9fa\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"div\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u0627\\u0646\\u0641\\u0648\\u0644\\u062f\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":128,\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"286px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"702px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0627\\u0646\\u0641\\u0648\\u0644\\u062f\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:normal; \\nfont-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"e757fef7-d61d-4b38-8ccd-db5d8a5715c6\",\"htmlTag\":\"h1\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"1399\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":128,\\\\\\\"color\\\\\\\":\\\\\\\"rgba(255, 255, 255, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"294px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"433px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"1403\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:bold; \\nfont-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"2efde940-e0eb-410a-bd83-07e98ca123ad\",\"htmlTag\":\"h1\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":23,\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"465px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"556px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"becfd69f-ef8b-4a65-a9a6-4539bec84f1f\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"style\":\"font-family: \'enfoldsans-1\';\",\"htmlTag\":\"p\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"1px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"font-size\\\\\\\":23,\\\\\\\"color\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"463px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"468px\\\\\\\",\\\\\\\"background-color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"53338407-7165-4ab9-935f-acf2ace775a7\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"p\",\"htmlLineBreak\":\"manual\",\"actions\":[]}],\"meta\":{\"activeLayers\":[2],\"undoStackIndex\":50},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"EnfoldSans\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":\"EnfoldSans\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"style\":\"font-weight:bold; \"},\"redo\":{\"style\":\"font-weight:bold; \\nfont-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"style\":\"font-weight:normal; \"},\"redo\":{\"style\":\"font-weight:normal; \\nfont-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"320px\",\"top\":\"356px\"},\"redo\":{\"left\":\"363px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"363px\",\"top\":\"356px\"},\"redo\":{\"left\":\"775px\",\"top\":\"296px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"296px\"},\"redo\":{\"left\":\"775px\",\"top\":\"336px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"336px\"},\"redo\":{\"left\":\"775px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"809px\",\"top\":\"356px\"},\"redo\":{\"left\":\"499px\",\"top\":\"306px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"286px\"},\"redo\":{\"left\":\"715px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"text-transform:uppercase;\"},\"redo\":{\"style\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"\"},\"redo\":{\"style\":\"font-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"style\":\"text-transform:uppercase;display:block;\"},\"redo\":{\"style\":\"font-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"328px\",\"top\":\"475px\"},\"redo\":{\"left\":\"578px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"903px\",\"top\":\"472px\"},\"redo\":{\"left\":\"443px\",\"top\":\"472px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"The best rated top seller on Themeforest.\"},\"redo\":{\"html\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"578px\",\"top\":\"475px\"},\"redo\":{\"left\":\"586px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"Reimagined\"},\"redo\":{\"html\":\"\\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"style\":\"font-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"font-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"style\":\"font-weight:bold; \\nfont-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-weight:bold; \\nfont-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"style\":\"font-weight:normal; \\nfont-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-weight:normal; \\nfont-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"120\"},\"redo\":{\"font-size\":\"128\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":\"EnfoldSans\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"120\"},\"redo\":{\"font-size\":\"128\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"443px\",\"top\":\"472px\"},\"redo\":{\"left\":\"459px\",\"top\":\"472px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"419px\",\"top\":\"306px\"},\"redo\":{\"left\":\"419px\",\"top\":\"304px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"419px\",\"top\":\"304px\"},\"redo\":{\"left\":\"419px\",\"top\":\"294px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"715px\",\"top\":\"286px\"},\"redo\":{\"left\":\"702px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"586px\",\"top\":\"475px\"},\"redo\":{\"left\":\"564px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\"},\"redo\":{\"html\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"564px\",\"top\":\"475px\"},\"redo\":{\"left\":\"556px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"468px\",\"top\":\"472px\"},\"redo\":{\"left\":\"468px\",\"top\":\"463px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"left\":\"-800px\"},\"redo\":{\"left\":\"-700px\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"parallaxtransformorigin\":\"50% 50% 0\"},\"redo\":{\"parallaxtransformorigin\":\"0% 0% 0\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"parallaxtransformorigin\":\"0% 0% 0\"},\"redo\":{\"parallaxtransformorigin\":\"50% 50% 0\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"50% 50%\"},\"redo\":{\"bgposition\":\"100% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"100% 50%\"},\"redo\":{\"bgposition\":\"0% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"0% 50%\"},\"redo\":{\"bgposition\":\"50% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"50% 50%\"},\"redo\":{\"bgposition\":\"0% 50%\"}}]},{\"cmd\":\"layer.general\",\"name\":\"LAYER_TYPE\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"media\":\"text\"},\"redo\":{\"media\":\"text\"}}},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum-bold\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":\"iransanswebfanum-bold\"},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.select\",\"name\":\"LAYER_SELECT\",\"updateInfo\":[],\"selectIndexSets\":{\"undo\":[0],\"redo\":[2]}},{\"cmd\":\"layer.general\",\"name\":\"LAYER_CONTENT\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"1399\"},\"redo\":{\"html\":\"1403\"}}],\"prop\":\"\"}]}]}", "1612073214", "1723921013", "0", "0", "0", "0", "0", "0", "0", "");
INSERT INTO `wp_layerslider` VALUES("2", NULL, "1", "Enfold Reimagined copy", "", "{\"properties\":{\"title\":\"Enfold Reimagined copy\",\"slug\":\"\",\"sliderVersion\":\"6.1.0\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":1410,\"height\":850,\"maxwidth\":\"\",\"responsiveunder\":\"1410\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"0\",\"hideover\":\"100000\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"fullwidth\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"allowFullscreen\":false,\"responsive\":true,\"animatefirstlayer\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"circletimer\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"all\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":3130,\"background\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-bg-1.jpg\",\"bgsize\":\"cover\",\"bgposition\":\"50% 50%\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"deeplink\":\"\",\"skip\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.1\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/test.kriesi.at\\/enfold-2017\\/wp-content\\/uploads\\/sites\\/24\\/2017\\/01\\/banner-big-bg-1-80x80.jpg\",\"thumbnailThumb\":\"\",\"post_content\":false},\"sublayers\":[{\"subtitle\":\"plant\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"27\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"125px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1121px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3132,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/plant-small-1.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/test.kriesi.at\\/enfold-2017\\/wp-content\\/uploads\\/sites\\/24\\/2017\\/01\\/plant-small-1-80x80.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"big img\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"000\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"-120px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-506px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3131,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/test.kriesi.at\\/enfold-2017\\/wp-content\\/uploads\\/sites\\/24\\/2017\\/01\\/banner-big-80x80.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"overlay\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"300%\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"100%\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-800px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"locked\":false,\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[]},{\"subtitle\":\"Enfold\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"120\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"356px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"320px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ENFOLD\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:normal; \",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"2017\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"120\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"rgba(255, 255, 255, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"356px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"809px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"2017\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:bold; \",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"The best rated top...\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"23\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"475px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"328px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"The best rated top seller on Themeforest.\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"text-transform:uppercase;\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false},{\"subtitle\":\"reimagined\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"1px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"23\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"472px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"903px\\\\\\\",\\\\\\\"wordwrap\\\\\\\":false}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Reimagined\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"text-transform:uppercase;display:block;\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false}],\"meta\":{\"activeLayers\":[5],\"undoStackIndex\":16},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnsscale\":\"1.2\"},\"redo\":{\"kenburnsscale\":\"1.1\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnsscale\":\"1.2\"},\"redo\":{\"kenburnsscale\":\"1\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnszoom\":\"disabled\"},\"redo\":{\"kenburnszoom\":\"out\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnszoom\":\"out\"},\"redo\":{\"kenburnszoom\":\"in\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnsscale\":\"1.2\"},\"redo\":{\"kenburnsscale\":\"1.1\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"kenburnszoom\":\"in\"},\"redo\":{\"kenburnszoom\":\"disabled\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"parallaxlevel\":\"5\"},\"redo\":{\"parallaxlevel\":\"15\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"parallaxlevel\":\"15\"},\"redo\":{\"parallaxlevel\":\"10\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"parallaxlevel\":\"5\"},\"redo\":{\"parallaxlevel\":\"10\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"parallaxlevel\":\"5\"},\"redo\":{\"parallaxlevel\":\"10\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"parallaxlevel\":\"5\"},\"redo\":{\"parallaxlevel\":\"10\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":5,\"undo\":{\"parallaxlevel\":\"3\"},\"redo\":{\"parallaxlevel\":\"7\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":6,\"undo\":{\"parallaxlevel\":\"1\"},\"redo\":{\"parallaxlevel\":\"3\"}}},{\"cmd\":\"layer.transition\",\"name\":\"Layer settings\",\"updateInfo\":{\"itemIndex\":5,\"undo\":{\"parallaxlevel\":\"7\"},\"redo\":{\"parallaxlevel\":\"6\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"100% 100%\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgsize\":\"100% 100%\"},\"redo\":{\"bgsize\":\"cover\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"bgposition\":\"inherit\"},\"redo\":{\"bgposition\":\"50% 50%\"}}}]}]}", "1612075795", "1612075795", "0", "0", "0", "1", "0", "0", "0", "");
INSERT INTO `wp_layerslider` VALUES("3", NULL, "1", "54165", "", "{\"properties\":{\"createdWith\":\"6.11.7\",\"sliderVersion\":\"6.11.7\",\"title\":\"54165\",\"new\":true},\"layers\":[[]]}", "1620450732", "1620450732", "0", "0", "0", "0", "0", "0", "0", "");
INSERT INTO `wp_layerslider` VALUES("4", NULL, "1", "1", "", "{\"properties\":{\"title\":\"1\",\"slug\":\"\",\"sliderVersion\":\"6.11.7\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":\"1280\",\"height\":\"720\",\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"enabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"fullwidth\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"createdWith\":\"6.11.7\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"customProperties\":[],\"post_content\":false},\"sublayers\":[],\"meta\":{\"undoStackIndex\":-1},\"history\":[]}]}", "1620451346", "1620451355", "0", "0", "0", "0", "0", "0", "0", "");

/* INSERT TABLE DATA: wp_layerslider_drafts */
INSERT INTO `wp_layerslider_drafts` VALUES("1", "1", "4", "{\"properties\":{\"sliderVersion\":\"7.11.1\",\"title\":\"Enfold Reimagined\",\"slug\":\"\",\"keywords\":\"\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"popupFitWidth\":\"\",\"popupFitHeight\":\"\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceTop\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceBottom\":\"10\",\"popupDistanceLeft\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"sceneHeight\":\"\",\"sceneSpeed\":\"100\",\"stickTo\":\"center\",\"smoothScrollDuration\":\"\",\"width\":1410,\"height\":850,\"maxwidth\":\"\",\"responsiveunder\":\"1410\",\"fullSizeMode\":\"normal\",\"marginTop\":\"\",\"marginBottom\":\"\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"calculateOffsetFrom\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"0\",\"hideover\":\"100000\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"fullwidth\",\"borderRadius\":\"\",\"sliderfadeinduration\":\"350\",\"firstSlideDuration\":\"\",\"firstSlideTimeShift\":\"\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"globalBGFor\":\"project\",\"backgroundcolor\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"tnFillMode\":\"contain\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"performanceMode\":\"inherit\",\"performanceModeThreshold\":\"20sh\",\"enhancedLazyLoad\":\"inherit\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"slideDuration\":\"\",\"slideTransitionDuration\":\"\",\"slideTimeShift\":\"0\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"scrollCenterLayers\":\"center\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":\"enabled\",\"preferBlendMode\":\"disabled\",\"playByScrollSpeed\":\"1\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"previewId\":\"\",\"preview\":\"\",\"allowFullscreen\":false,\"responsive\":true,\"animatefirstlayer\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"circletimer\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"all\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"0% 50%\",\"bgsize\":\"cover\",\"slidedelay\":\"7000\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.1\",\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":\"500\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"backgroundId\":3130,\"background\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-bg-1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"skip\":false,\"id\":\"\",\"backgroundThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-bg-1-300x159.jpg\",\"thumbnailThumb\":\"\",\"post_content\":false,\"customProperties\":[],\"schedule_start\":\"\",\"schedule_end\":\"\"},\"sublayers\":[{\"subtitle\":\"plant\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":27,\\\\\\\"top\\\\\\\":\\\\\\\"125px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1121px\\\\\\\"}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3132,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/plant-small-1.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/plant-small-1-206x300.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"dba25b51-b997-4d0e-96f7-2ac9fd34c2ac\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"img\",\"htmlLineBreak\":\"manual\"},{\"subtitle\":\"big img\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"000\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"-120px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-506px\\\\\\\"}\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3131,\"image\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big.png\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"imageThumb\":\"http:\\/\\/localhost\\/enfold\\/wp-content\\/uploads\\/layerslider\\/Enfold-Reimagined\\/banner-big-300x131.png\",\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"013d8979-465c-408a-b486-369512ce7438\",\"htmlTag\":\"img\",\"htmlLineBreak\":\"manual\"},{\"subtitle\":\"overlay\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"300%\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"100%\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"-700px\\\\\\\",\\\\\\\"background-color\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\"}\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"\",\"locked\":false,\"skip\":false,\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"uuid\":\"97a44bce-51bd-4892-8152-9fe354f9b9fa\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"div\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u0627\\u0646\\u0641\\u0648\\u0644\\u062f\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":128,\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"286px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"702px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0627\\u0646\\u0641\\u0648\\u0644\\u062f\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:normal; \\nfont-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"e757fef7-d61d-4b38-8ccd-db5d8a5715c6\",\"htmlTag\":\"h1\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"1399\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":128,\\\\\\\"color\\\\\\\":\\\\\\\"rgba(255, 255, 255, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"294px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"433px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"1403\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-weight:bold; \\nfont-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"uuid\":\"2efde940-e0eb-410a-bd83-07e98ca123ad\",\"htmlTag\":\"h1\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":23,\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"465px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"556px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"becfd69f-ef8b-4a65-a9a6-4539bec84f1f\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"style\":\"font-family: \'enfoldsans-1\';\",\"htmlTag\":\"p\",\"htmlLineBreak\":\"manual\",\"actions\":[]},{\"subtitle\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"0% 0% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutBack\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"1px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"3px\\\\\\\",\\\\\\\"font-size\\\\\\\":23,\\\\\\\"color\\\\\\\":\\\\\\\"rgba(0, 0, 0, 0.6)\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"463px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"468px\\\\\\\",\\\\\\\"background-color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"iransanswebfanum\\\\\\\"}\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\",\"post_text_length\":\"\",\"url\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"style\":\"font-family: \'enfoldsans-1\';\",\"innerAttributes\":[],\"outerAttributes\":[],\"hasTransforms\":false,\"meta\":[],\"locked\":false,\"uuid\":\"53338407-7165-4ab9-935f-acf2ace775a7\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"htmlTag\":\"p\",\"htmlLineBreak\":\"manual\",\"actions\":[]}],\"meta\":{\"activeLayers\":[2],\"undoStackIndex\":50},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"EnfoldSans\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":\"EnfoldSans\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"style\":\"font-weight:bold; \"},\"redo\":{\"style\":\"font-weight:bold; \\nfont-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"style\":\"font-weight:normal; \"},\"redo\":{\"style\":\"font-weight:normal; \\nfont-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"320px\",\"top\":\"356px\"},\"redo\":{\"left\":\"363px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"363px\",\"top\":\"356px\"},\"redo\":{\"left\":\"775px\",\"top\":\"296px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"296px\"},\"redo\":{\"left\":\"775px\",\"top\":\"336px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"336px\"},\"redo\":{\"left\":\"775px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"809px\",\"top\":\"356px\"},\"redo\":{\"left\":\"499px\",\"top\":\"306px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"775px\",\"top\":\"286px\"},\"redo\":{\"left\":\"715px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"text-transform:uppercase;\"},\"redo\":{\"style\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"\"},\"redo\":{\"style\":\"font-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"style\":\"text-transform:uppercase;display:block;\"},\"redo\":{\"style\":\"font-family: EnfoldSans;\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"328px\",\"top\":\"475px\"},\"redo\":{\"left\":\"578px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"903px\",\"top\":\"472px\"},\"redo\":{\"left\":\"443px\",\"top\":\"472px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"The best rated top seller on Themeforest.\"},\"redo\":{\"html\":\"\\u0628\\u0627\\u0644\\u0627\\u062a\\u0631\\u06cc\\u0646 \\u0627\\u0645\\u062a\\u06cc\\u0627\\u0632 \\u062f\\u0631 \\u0628\\u06cc\\u0646 \\u067e\\u0631\\u0641\\u0631\\u0648\\u0634 \\u0647\\u0627\\u06cc \\u062a\\u0645 \\u0641\\u0627\\u0631\\u0633\\u062a\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"578px\",\"top\":\"475px\"},\"redo\":{\"left\":\"586px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"Reimagined\"},\"redo\":{\"html\":\"\\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"style\":\"font-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"style\":\"font-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"style\":\"font-weight:bold; \\nfont-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-weight:bold; \\nfont-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"style\":\"font-weight:normal; \\nfont-family: EnfoldSans;\"},\"redo\":{\"style\":\"font-weight:normal; \\nfont-family: \'enfoldsans-1\';\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":\"Arial\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"120\"},\"redo\":{\"font-size\":\"128\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":\"EnfoldSans\"},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"120\"},\"redo\":{\"font-size\":\"128\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"443px\",\"top\":\"472px\"},\"redo\":{\"left\":\"459px\",\"top\":\"472px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"419px\",\"top\":\"306px\"},\"redo\":{\"left\":\"419px\",\"top\":\"304px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"419px\",\"top\":\"304px\"},\"redo\":{\"left\":\"419px\",\"top\":\"294px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"715px\",\"top\":\"286px\"},\"redo\":{\"left\":\"702px\",\"top\":\"286px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"586px\",\"top\":\"475px\"},\"redo\":{\"left\":\"564px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\\u0641\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0647\"},\"redo\":{\"html\":\"\\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"564px\",\"top\":\"475px\"},\"redo\":{\"left\":\"556px\",\"top\":\"475px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"468px\",\"top\":\"472px\"},\"redo\":{\"left\":\"468px\",\"top\":\"463px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"left\":\"-800px\"},\"redo\":{\"left\":\"-700px\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"parallaxtransformorigin\":\"50% 50% 0\"},\"redo\":{\"parallaxtransformorigin\":\"0% 0% 0\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"parallaxtransformorigin\":\"0% 0% 0\"},\"redo\":{\"parallaxtransformorigin\":\"50% 50% 0\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"50% 50%\"},\"redo\":{\"bgposition\":\"100% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"100% 50%\"},\"redo\":{\"bgposition\":\"0% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"0% 50%\"},\"redo\":{\"bgposition\":\"50% 50%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"bgposition\":\"50% 50%\"},\"redo\":{\"bgposition\":\"0% 50%\"}}]},{\"cmd\":\"layer.general\",\"name\":\"LAYER_TYPE\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"media\":\"text\"},\"redo\":{\"media\":\"text\"}}},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum-bold\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-family\":\"iransanswebfanum-bold\"},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"iransanswebfanum\"}}]},{\"cmd\":\"layer.select\",\"name\":\"LAYER_SELECT\",\"updateInfo\":[],\"selectIndexSets\":{\"undo\":[0],\"redo\":[2]}},{\"cmd\":\"layer.general\",\"name\":\"LAYER_CONTENT\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"1399\"},\"redo\":{\"html\":\"1403\"}}],\"prop\":\"\"}]}]}", "1645958277", "1723921013");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/enfold/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/enfold", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "انفولد", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک پیش نمایش از انفولد", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@khatamwp.dev", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "18", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:3:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:76:\"D:/laragon/www/enfold/wp-content/themes/enfold/config-woocommerce/config.php\";i:2;s:60:\"D:/laragon/www/enfold/wp-content/themes/enfold/functions.php\";i:3;s:56:\"D:/laragon/www/enfold/wp-content/themes/enfold/style.css\";i:4;s:110:\"D:/laragon/www/enfold/wp-content/themes/enfold/config-layerslider/LayerSlider/assets/templates/tmpl-addons.php\";i:5;s:56:\"D:/laragon/www/enfold/wp-content/themes/enfold/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "enfold", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "enfold", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "80", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "80", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1030", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1030", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:5:{i:2;a:4:{s:5:\"title\";s:24:\"لینک های مفید\";s:4:\"text\";s:456:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:13:\"دفتر ما\";s:4:\"text\";s:69:\"خیابان آزادی\r\n\r\nتهران\r\n\r\n0210000\r\n\r\ninfo@khatamwp.dev\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:24:\"ساعات کاری ما\";s:4:\"text\";s:91:\"شنبه تا چهارشنبه: 8 تا 19\r\nپنج شنبه: 8 تا 14\r\nجمعه: تعطیل\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:5;a:4:{s:5:\"title\";s:25:\"اطلاعات بیشتر\";s:4:\"text\";s:456:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:5:{i:0;b:0;s:125:\"home/khatamw1/domains/khatamwp.dev/public_html/enfold/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:93:\"D:/laragon/www/enfold/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}", "yes");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "206", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1729594794", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("99", "wp_user_roles", "a:12:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:0:{}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("100", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:6:\"meta-2\";i:1;s:10:\"archives-2\";i:2;s:8:\"search-2\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";}s:13:\"av_everywhere\";a:0:{}s:7:\"av_blog\";a:4:{i:0;s:8:\"search-3\";i:1;s:14:\"portfoliobox-2\";i:2;s:12:\"categories-3\";i:3;s:17:\"avia_fb_likebox-2\";}s:8:\"av_pages\";a:0:{}s:16:\"av_shop_overview\";a:7:{i:0;s:21:\"avia_partner_widget-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:33:\"woocommerce_layered_nav_filters-2\";i:3;s:25:\"woocommerce_layered_nav-2\";i:4;s:25:\"woocommerce_layered_nav-4\";i:5;s:25:\"woocommerce_layered_nav-3\";i:6;s:28:\"woocommerce_product_search-2\";}s:14:\"av_shop_single\";a:0:{}s:11:\"av_footer_1\";a:1:{i:0;s:6:\"text-2\";}s:11:\"av_footer_2\";a:1:{i:0;s:6:\"text-3\";}s:11:\"av_footer_3\";a:1:{i:0;s:6:\"text-5\";}s:11:\"av_footer_4\";a:1:{i:0;s:6:\"text-4\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("107", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:32:{i:1729338419;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1729338538;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1729338603;a:1:{s:31:\"ava_cron_admin_notices_clean_up\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1729339291;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1729339388;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1729339395;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1729339399;a:1:{s:21:\"update_network_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1729341788;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1729342138;a:1:{s:32:\"av_instagram_scheduled_filecheck\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1729344240;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1729360891;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1729363607;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1729365850;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729368370;a:1:{s:40:\"woocommerce_marketplace_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1729371471;a:1:{s:28:\"zhaket_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729371600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729372125;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729376640;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729404091;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729404100;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729404106;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729404188;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729418899;a:1:{s:32:\"rsslp_css_loader_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729423972;a:1:{s:48:\"zfusion_activate_zwp_integration_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729424588;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1729490491;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1729506600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1729569445;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1729758403;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1729941290;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1730143500;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "nonce_key", "|1XZcz}:oW{(i) !4mm1+rA!?^[uyx2(]FSDNDFo#v9xA52dPdrRL:x:l~5p&y^J", "no");
INSERT INTO `wp_options` VALUES("116", "nonce_salt", "~~#Rx,chTwQ*K~<?Av?my-hW:cs&m+dJ`1bz=oHxrat|.j-Y-dLatJx(UAh7~$z@", "no");
INSERT INTO `wp_options` VALUES("117", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("123", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1612072937;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "no");
INSERT INTO `wp_options` VALUES("125", "logged_in_key", "%-nf[h]Z^StW&z#790(_O.xz -q|0+a{ubV~n5SQ%f-+REA?MF&XSY*ZC$WaY_qL", "no");
INSERT INTO `wp_options` VALUES("126", "logged_in_salt", "zIGS $3m}SwF!r?TqH|T$kKxU,5AO`XcyjtgE0rIA&Ka=4aiRI:&/gz7zOqrE9PH", "no");
INSERT INTO `wp_options` VALUES("127", "action_scheduler_lock_async-request-runner", "67139c1f8b1d28.81975529|1729338459", "yes");
INSERT INTO `wp_options` VALUES("128", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("129", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `wp_options` VALUES("134", "auth_key", "aXU6y03hTs}@MkXE}nu#(j4JE>RR/qBHw+;u;|(Px?,$Nq5&+B#57`%>YT:0>}F9", "no");
INSERT INTO `wp_options` VALUES("135", "auth_salt", "Hz)HLwyr}:haADO4?1Y`RC]m,HE@p{zD#$|?FQMEhnyQQsj}aB<t^Bv4NO?,Km$w", "no");
INSERT INTO `wp_options` VALUES("157", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("158", "new_admin_email", "info@khatamwp.dev", "yes");
INSERT INTO `wp_options` VALUES("161", "current_theme", "انفولد", "yes");
INSERT INTO `wp_options` VALUES("162", "theme_mods_enfold", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:5:\"avia3\";i:29;s:4:\"avia\";i:30;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1643610338;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:6:\"meta-2\";i:1;s:10:\"archives-2\";i:2;s:8:\"search-2\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";}s:13:\"av_everywhere\";a:0:{}s:7:\"av_blog\";a:4:{i:0;s:8:\"search-3\";i:1;s:14:\"portfoliobox-2\";i:2;s:12:\"categories-3\";i:3;s:17:\"avia_fb_likebox-2\";}s:8:\"av_pages\";a:0:{}s:16:\"av_shop_overview\";a:7:{i:0;s:21:\"avia_partner_widget-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:33:\"woocommerce_layered_nav_filters-2\";i:3;s:25:\"woocommerce_layered_nav-2\";i:4;s:25:\"woocommerce_layered_nav-4\";i:5;s:25:\"woocommerce_layered_nav-3\";i:6;s:28:\"woocommerce_product_search-2\";}s:14:\"av_shop_single\";a:0:{}s:11:\"av_footer_1\";a:1:{i:0;s:6:\"text-2\";}s:11:\"av_footer_2\";a:1:{i:0;s:6:\"text-3\";}s:11:\"av_footer_3\";a:1:{i:0;s:6:\"text-5\";}s:11:\"av_footer_4\";a:1:{i:0;s:6:\"text-4\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("163", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("164", "widget_newsbox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("165", "widget_portfoliobox", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";s:1:\"4\";s:7:\"excerpt\";s:15:\"show title only\";s:3:\"cat\";N;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("166", "widget_avia_socialcount", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("167", "widget_avia_partner_widget", "a:2:{i:2;a:5:{s:5:\"title\";s:0:\"\";s:9:\"image_url\";s:0:\"\";s:7:\"ref_url\";s:0:\"\";s:10:\"image_url2\";s:0:\"\";s:8:\"ref_url2\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("168", "widget_avia_google_maps", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("169", "widget_avia_fb_likebox", "a:2:{i:2;a:10:{s:3:\"url\";s:34:\"https://www.facebook.com/kriesi.at\";s:5:\"title\";s:0:\"\";s:7:\"fb_link\";s:0:\"\";s:9:\"fb_banner\";s:0:\"\";s:10:\"page_title\";s:0:\"\";s:7:\"fb_logo\";s:0:\"\";s:7:\"content\";s:0:\"\";s:8:\"add_info\";s:50:\"به جامعه فیسبوک ما بپیوندید\";s:14:\"confirm_button\";s:67:\"برای بارگیری ابزارک فیسبوک کلیک کنید\";s:14:\"page_link_text\";s:60:\"همین حالا صفحه فیسبوک را باز کنید\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("170", "widget_avia-instagram-feed", "a:2:{i:1;a:1:{s:8:\"avia_key\";s:2:\"1-\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_avia_combo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("172", "widget_avia_auto_toc", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "widget_avia_mailchimp_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "ls-plugin-version", "7.12.4", "yes");
INSERT INTO `wp_options` VALUES("175", "ls-db-version", "7.9.0", "yes");
INSERT INTO `wp_options` VALUES("176", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("177", "ls-google-fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("178", "enfold_layerslider_state", "", "yes");
INSERT INTO `wp_options` VALUES("179", "ls-date-installed", "1612072938", "yes");
INSERT INTO `wp_options` VALUES("180", "ls_gsap_sandboxing", "1", "yes");
INSERT INTO `wp_options` VALUES("181", "enfold_layerslider_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("182", "enfold_layerslider_data_erased", "no", "yes");
INSERT INTO `wp_options` VALUES("183", "ls-show-support-notice", "0", "yes");
INSERT INTO `wp_options` VALUES("184", "ls_include_at_footer", "1", "yes");
INSERT INTO `wp_options` VALUES("185", "ls_conditional_script_loading", "1", "yes");
INSERT INTO `wp_options` VALUES("186", "Enfold_version", "6.0.6", "yes");
INSERT INTO `wp_options` VALUES("187", "enfold_initial_version", "4.7.6.4", "yes");
INSERT INTO `wp_options` VALUES("188", "enfold_fixed_random", "7", "yes");
INSERT INTO `wp_options` VALUES("189", "avia_permalink_settings", "a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}", "yes");
INSERT INTO `wp_options` VALUES("190", "av_alb_usage_app_store_button", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("191", "av_alb_usage_ss_appcard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("192", "av_alb_usage_ss_artframe", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("193", "av_alb_usage_av_cat_list", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("194", "av_alb_usage_av_color_picker", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("195", "av_alb_usage_av_copyright", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("196", "av_alb_usage_av_dl_button", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("197", "av_alb_usage_av_editnotes", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("198", "av_alb_usage_av_editlink", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("199", "av_alb_usage_av_elegant_title", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("200", "av_alb_usage_featured_img_modern", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("201", "av_alb_usage_filetype_icon", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("202", "av_alb_usage_avia_lipsum", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("203", "av_alb_usage_modal_button", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("204", "av_alb_usage_ss_moviecard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("205", "av_alb_usage_page_title", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("206", "av_alb_usage_wc_featurelist", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("207", "av_alb_usage_promo_modern", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("208", "av_alb_usage_ribbon_heading", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("209", "av_alb_usage_av_shortlink", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("210", "av_alb_usage_av_tag_list", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("211", "av_alb_usage_av_player", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("212", "av_alb_usage_av_blog", "a:7:{i:1334;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1080;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1040;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1037;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1034;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1028;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:600;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("213", "av_alb_usage_av_buttonrow", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("214", "av_alb_usage_av_button", "a:12:{i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:11;}i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1313;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:48;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:629;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}}", "yes");
INSERT INTO `wp_options` VALUES("215", "av_alb_usage_av_button_big", "a:1:{i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("216", "av_alb_usage_av_catalogue", "a:1:{i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}}", "yes");
INSERT INTO `wp_options` VALUES("217", "av_alb_usage_av_comments_list", "a:1:{i:1376;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("218", "av_alb_usage_av_contact", "a:8:{i:1331;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("219", "av_alb_usage_av_content_slider", "a:2:{i:1316;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("220", "av_alb_usage_av_countdown", "a:3:{i:1370;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3598;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("221", "av_alb_usage_av_gallery", "a:1:{i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("222", "av_alb_usage_av_horizontal_gallery", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("223", "av_alb_usage_av_google_map", "a:2:{i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("224", "av_alb_usage_av_cell_one_full", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("225", "av_alb_usage_av_cell_one_half", "a:5:{i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("226", "av_alb_usage_av_cell_one_third", "a:5:{i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:3497;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("227", "av_alb_usage_av_cell_two_third", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("228", "av_alb_usage_av_cell_one_fourth", "a:3:{i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("229", "av_alb_usage_av_cell_three_fourth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("230", "av_alb_usage_av_cell_one_fifth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("231", "av_alb_usage_av_cell_two_fifth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("232", "av_alb_usage_av_cell_three_fifth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("233", "av_alb_usage_av_cell_four_fifth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("234", "av_alb_usage_av_layout_row", "a:9:{i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:3497;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("235", "av_alb_usage_av_heading", "a:91:{i:1593;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1413;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1398;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1389;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1380;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1376;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1370;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1361;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1358;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1355;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1352;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1340;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1337;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1334;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1331;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1328;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1319;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1316;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1313;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1304;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1301;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1298;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1295;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1292;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:25;}i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1116;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1080;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1040;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1037;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1034;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1031;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1028;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:990;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:937;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:932;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:902;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:14;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:13;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:629;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:610;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:600;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:597;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:14;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:18;}}", "yes");
INSERT INTO `wp_options` VALUES("236", "av_alb_usage_av_headline_rotator", "a:1:{i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("237", "av_alb_usage_av_hr", "a:77:{i:1593;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1413;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1398;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1389;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1380;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1376;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1361;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1355;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1352;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1340;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1337;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1334;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1331;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1328;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1319;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1316;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1304;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1301;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1298;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1295;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1292;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:36;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1080;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1040;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1037;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1034;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1031;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1028;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:990;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:937;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:932;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:902;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:13;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:629;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:610;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:600;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:597;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:29;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:33;}}", "yes");
INSERT INTO `wp_options` VALUES("238", "av_alb_usage_av_font_icon", "a:6:{i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1301;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}}", "yes");
INSERT INTO `wp_options` VALUES("239", "av_alb_usage_av_icon_box", "a:6:{i:1304;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("240", "av_alb_usage_av_icongrid", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("241", "av_alb_usage_av_iconlist", "a:5:{i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("242", "av_alb_usage_av_image", "a:13:{i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}}", "yes");
INSERT INTO `wp_options` VALUES("243", "av_alb_usage_av_image_hotspot", "a:5:{i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("244", "av_alb_usage_av_partner", "a:1:{i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("245", "av_alb_usage_av_magazine", "a:1:{i:1337;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("246", "av_alb_usage_av_mailchimp", "a:3:{i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("247", "av_alb_usage_av_masonry_entries", "a:9:{i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1116;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1031;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:937;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:932;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("248", "av_alb_usage_av_masonry_gallery", "a:4:{i:1413;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:990;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("249", "av_alb_usage_av_submenu", "a:1:{i:1358;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("250", "av_alb_usage_av_notification", "a:1:{i:1319;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}}", "yes");
INSERT INTO `wp_options` VALUES("251", "av_alb_usage_av_animated_numbers", "a:4:{i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:11;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}}", "yes");
INSERT INTO `wp_options` VALUES("252", "av_alb_usage_av_portfolio", "a:13:{i:1340;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:914;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:902;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:597;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("253", "av_alb_usage_av_post_metadata", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("254", "av_alb_usage_av_postslider", "a:1:{i:1355;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("255", "av_alb_usage_av_progress", "a:3:{i:1352;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("256", "av_alb_usage_av_promobox", "a:1:{i:1328;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("257", "av_alb_usage_avia_sc_search", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("258", "av_alb_usage_av_slideshow", "a:4:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("259", "av_alb_usage_av_slideshow_accordion", "a:1:{i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("260", "av_alb_usage_av_feature_image_slider", "a:1:{i:1398;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("261", "av_alb_usage_av_fullscreen", "a:1:{i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("262", "av_alb_usage_av_slideshow_full", "a:5:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3752;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("263", "av_alb_usage_av_layerslider", "a:2:{i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("264", "av_alb_usage_av_social_share", "a:5:{i:1593;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("265", "av_alb_usage_av_tab_sub_section", "a:4:{i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:20;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}}", "yes");
INSERT INTO `wp_options` VALUES("266", "av_alb_usage_av_tab_section", "a:4:{i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("267", "av_alb_usage_av_table", "a:3:{i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3752;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("268", "av_alb_usage_av_tab_container", "a:4:{i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("269", "av_alb_usage_av_team_member", "a:1:{i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("270", "av_alb_usage_av_testimonials", "a:4:{i:1361;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("271", "av_alb_usage_av_timeline", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("272", "av_alb_usage_av_toggle_container", "a:6:{i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("273", "av_alb_usage_av_video", "a:1:{i:1389;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("274", "av_alb_usage_av_codeblock", "a:1:{i:1380;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("275", "av_alb_usage_av_one_full", "a:29:{i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1413;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1398;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1389;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1370;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1340;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1313;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1304;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:914;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("276", "av_alb_usage_av_one_half", "a:35:{i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1337;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1319;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1313;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1292;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:34;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:610;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:24;}}", "yes");
INSERT INTO `wp_options` VALUES("277", "av_alb_usage_av_one_third", "a:22:{i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1301;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("278", "av_alb_usage_av_two_third", "a:9:{i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("279", "av_alb_usage_av_one_fourth", "a:5:{i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("280", "av_alb_usage_av_three_fourth", "a:2:{i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("281", "av_alb_usage_av_one_fifth", "a:17:{i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("282", "av_alb_usage_av_two_fifth", "a:3:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}}", "yes");
INSERT INTO `wp_options` VALUES("283", "av_alb_usage_av_three_fifth", "a:16:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("284", "av_alb_usage_av_four_fifth", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("285", "av_alb_usage_av_postcontent", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("286", "av_alb_usage_av_section", "a:51:{i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1370;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1080;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1040;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1037;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1034;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1031;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1028;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:990;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:937;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:932;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:902;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:629;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:610;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:600;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:597;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}}", "yes");
INSERT INTO `wp_options` VALUES("287", "av_alb_usage_av_textblock", "a:91:{i:1593;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1413;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1410;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1404;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1398;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1389;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1383;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1380;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1376;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1370;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1367;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1361;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1358;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:10;}i:1355;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1352;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1343;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1340;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1337;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1334;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1331;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1328;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1319;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1316;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1304;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1301;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1298;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:5;}i:1295;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1292;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:1289;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:21;}i:1286;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:1283;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1277;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:22;}i:1116;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:1080;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1040;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1037;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1034;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1031;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:1028;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:990;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:937;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:932;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:919;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:907;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:902;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:897;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:14;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}i:644;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:629;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:610;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:600;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:597;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:16;}i:142;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:144;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:139;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:150;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}i:3497;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("288", "av_alb_usage_av_sidebar", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("289", "av_alb_usage_filetype_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("290", "av_alb_usage_wc_featurelist_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("291", "av_alb_usage_av_playlist_element", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("292", "av_alb_usage_av_buttonrow_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("293", "av_alb_usage_av_catalogue_item", "a:1:{i:1364;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}}", "yes");
INSERT INTO `wp_options` VALUES("294", "av_alb_usage_av_contact_field", "a:8:{i:1331;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:11;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:668;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:6;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("295", "av_alb_usage_av_content_slide", "a:2:{i:1316;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:3613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("296", "av_alb_usage_av_gmap_location", "a:2:{i:1416;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:11;}i:632;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("297", "av_alb_usage_av_rotator_item", "a:1:{i:1310;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:12;}}", "yes");
INSERT INTO `wp_options` VALUES("298", "av_alb_usage_av_icongrid_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("299", "av_alb_usage_av_iconlist_item", "a:5:{i:1307;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:33;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:47;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:47;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:27;}}", "yes");
INSERT INTO `wp_options` VALUES("300", "av_alb_usage_av_image_spot", "a:5:{i:1386;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:591;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}}", "yes");
INSERT INTO `wp_options` VALUES("301", "av_alb_usage_av_partner_logo", "a:1:{i:1407;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:15;}}", "yes");
INSERT INTO `wp_options` VALUES("302", "av_alb_usage_av_mailchimp_field", "a:3:{i:1373;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:606;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:603;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}}", "yes");
INSERT INTO `wp_options` VALUES("303", "av_alb_usage_av_submenu_item", "a:1:{i:1358;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}}", "yes");
INSERT INTO `wp_options` VALUES("304", "av_alb_usage_av_metadata_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("305", "av_alb_usage_av_progress_bar", "a:3:{i:1352;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:24;}i:665;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("306", "av_alb_usage_av_slide", "a:4:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:16;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("307", "av_alb_usage_av_slide_accordion", "a:1:{i:1401;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:18;}}", "yes");
INSERT INTO `wp_options` VALUES("308", "av_alb_usage_av_fullscreen_slide", "a:1:{i:1395;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("309", "av_alb_usage_av_slide_full", "a:5:{i:1392;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}i:3752;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("310", "av_alb_usage_av_row", "a:3:{i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:32;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:7;}i:3752;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("311", "av_alb_usage_av_cell", "a:3:{i:1346;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:107;}i:647;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:21;}i:3752;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:9;}}", "yes");
INSERT INTO `wp_options` VALUES("312", "av_alb_usage_av_tab", "a:4:{i:1322;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:16;}i:145;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:143;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:152;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("313", "av_alb_usage_av_team_icon", "a:1:{i:1349;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:8;}}", "yes");
INSERT INTO `wp_options` VALUES("314", "av_alb_usage_av_testimonial_single", "a:4:{i:1361;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:17;}i:650;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:626;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:4;}i:206;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("315", "av_alb_usage_av_timeline_item", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("316", "av_alb_usage_av_toggle", "a:6:{i:1325;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:26;}i:638;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:15;}i:635;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:15;}i:146;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:140;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}i:131;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("317", "av_alb_blog_elements_state", "a:165:{s:16:\"app_store_button\";b:0;s:10:\"ss_appcard\";b:0;s:11:\"ss_artframe\";b:0;s:11:\"av_cat_list\";b:0;s:15:\"av_color_picker\";b:0;s:12:\"av_copyright\";b:0;s:12:\"av_dl_button\";b:1;s:12:\"av_editnotes\";b:1;s:11:\"av_editlink\";b:0;s:16:\"av_elegant_title\";b:1;s:19:\"featured_img_modern\";b:0;s:13:\"filetype_icon\";b:0;s:11:\"avia_lipsum\";b:0;s:12:\"modal_button\";b:0;s:12:\"ss_moviecard\";b:0;s:10:\"page_title\";b:0;s:12:\"promo_modern\";b:0;s:14:\"ribbon_heading\";b:1;s:12:\"av_shortlink\";b:0;s:11:\"av_tag_list\";b:0;s:9:\"cat_promo\";b:0;s:9:\"gift_wrap\";b:0;s:14:\"av_prodgallery\";b:0;s:10:\"prod_promo\";b:0;s:15:\"av_wc_a2cbutton\";b:0;s:15:\"av_wc_prod_cats\";b:0;s:14:\"wc_featurelist\";b:0;s:19:\"av_sale_productgrid\";b:1;s:14:\"av_product_img\";b:0;s:21:\"wc_product_img_modern\";b:0;s:17:\"ss_product_modern\";b:0;s:8:\"wc_price\";b:0;s:15:\"wc_price_header\";b:0;s:15:\"av_wc_shortdesc\";b:0;s:12:\"av_wc_single\";b:0;s:6:\"wc_sku\";b:0;s:15:\"av_wc_prod_tags\";b:0;s:10:\"av_wcalert\";b:0;s:13:\"av_wctracking\";b:1;s:10:\"sold_count\";b:0;s:14:\"ss_wc_artframe\";b:1;s:9:\"av_player\";b:0;s:7:\"av_blog\";b:1;s:12:\"av_buttonrow\";b:0;s:9:\"av_button\";b:1;s:13:\"av_button_big\";b:1;s:12:\"av_catalogue\";b:1;s:8:\"av_chart\";b:0;s:12:\"av_codeblock\";b:1;s:11:\"av_one_full\";b:1;s:11:\"av_one_half\";b:1;s:12:\"av_one_third\";b:1;s:12:\"av_two_third\";b:1;s:13:\"av_one_fourth\";b:1;s:15:\"av_three_fourth\";b:1;s:12:\"av_one_fifth\";b:1;s:12:\"av_two_fifth\";b:1;s:14:\"av_three_fifth\";b:1;s:13:\"av_four_fifth\";b:0;s:16:\"av_comments_list\";b:1;s:10:\"av_contact\";b:1;s:17:\"av_content_slider\";b:1;s:12:\"av_countdown\";b:1;s:16:\"av_custom_layout\";b:0;s:16:\"av_dynamic_field\";b:0;s:10:\"av_gallery\";b:1;s:21:\"av_horizontal_gallery\";b:0;s:13:\"av_google_map\";b:1;s:13:\"av_layout_row\";b:1;s:16:\"av_cell_one_full\";b:0;s:16:\"av_cell_one_half\";b:1;s:17:\"av_cell_one_third\";b:1;s:17:\"av_cell_two_third\";b:0;s:18:\"av_cell_one_fourth\";b:1;s:20:\"av_cell_three_fourth\";b:0;s:17:\"av_cell_one_fifth\";b:0;s:17:\"av_cell_two_fifth\";b:0;s:19:\"av_cell_three_fifth\";b:0;s:18:\"av_cell_four_fifth\";b:0;s:10:\"av_heading\";b:1;s:19:\"av_headline_rotator\";b:1;s:5:\"av_hr\";b:1;s:12:\"av_font_icon\";b:1;s:15:\"av_icon_circles\";b:0;s:11:\"av_icon_box\";b:1;s:11:\"av_icongrid\";b:0;s:11:\"av_iconlist\";b:1;s:8:\"av_image\";b:1;s:13:\"av_image_diff\";b:0;s:16:\"av_image_hotspot\";b:1;s:10:\"av_partner\";b:1;s:9:\"av_lottie\";b:0;s:11:\"av_magazine\";b:1;s:12:\"av_mailchimp\";b:1;s:18:\"av_masonry_entries\";b:1;s:18:\"av_masonry_gallery\";b:1;s:10:\"av_submenu\";b:1;s:15:\"av_notification\";b:1;s:19:\"av_animated_numbers\";b:1;s:12:\"av_portfolio\";b:1;s:16:\"av_post_metadata\";b:0;s:14:\"av_postcontent\";b:0;s:13:\"av_postslider\";b:1;s:14:\"av_productgrid\";b:1;s:14:\"av_productlist\";b:0;s:17:\"av_product_button\";b:1;s:15:\"av_product_info\";b:0;s:17:\"av_product_review\";b:0;s:15:\"av_product_tabs\";b:1;s:18:\"av_product_upsells\";b:1;s:15:\"av_product_meta\";b:0;s:16:\"av_product_price\";b:0;s:16:\"av_productslider\";b:1;s:11:\"av_progress\";b:1;s:11:\"av_promobox\";b:1;s:14:\"avia_sc_search\";b:0;s:10:\"av_section\";b:1;s:12:\"av_slideshow\";b:1;s:22:\"av_slideshow_accordion\";b:1;s:23:\"av_feature_image_slider\";b:1;s:13:\"av_fullscreen\";b:1;s:17:\"av_slideshow_full\";b:1;s:14:\"av_layerslider\";b:1;s:15:\"av_social_share\";b:1;s:14:\"av_tab_section\";b:1;s:18:\"av_tab_sub_section\";b:1;s:8:\"av_table\";b:1;s:16:\"av_tab_container\";b:1;s:14:\"av_team_member\";b:1;s:15:\"av_testimonials\";b:1;s:12:\"av_textblock\";b:1;s:11:\"av_timeline\";b:0;s:19:\"av_toggle_container\";b:1;s:8:\"av_video\";b:1;s:10:\"av_sidebar\";b:0;s:13:\"filetype_item\";b:0;s:19:\"wc_featurelist_item\";b:0;s:19:\"av_playlist_element\";b:0;s:17:\"av_buttonrow_item\";b:0;s:17:\"av_catalogue_item\";b:1;s:16:\"av_chart_dataset\";b:0;s:16:\"av_contact_field\";b:1;s:16:\"av_content_slide\";b:1;s:16:\"av_gmap_location\";b:1;s:15:\"av_rotator_item\";b:1;s:19:\"av_icon_circle_item\";b:0;s:16:\"av_icongrid_item\";b:0;s:16:\"av_iconlist_item\";b:1;s:13:\"av_image_spot\";b:1;s:15:\"av_partner_logo\";b:1;s:18:\"av_mailchimp_field\";b:1;s:15:\"av_submenu_item\";b:1;s:16:\"av_metadata_item\";b:0;s:15:\"av_progress_bar\";b:1;s:8:\"av_slide\";b:1;s:18:\"av_slide_accordion\";b:1;s:19:\"av_fullscreen_slide\";b:1;s:13:\"av_slide_full\";b:1;s:6:\"av_row\";b:1;s:7:\"av_cell\";b:1;s:6:\"av_tab\";b:1;s:12:\"av_team_icon\";b:1;s:21:\"av_testimonial_single\";b:1;s:16:\"av_timeline_item\";b:0;s:9:\"av_toggle\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("318", "av_alb_element_mgr_update", "", "yes");
INSERT INTO `wp_options` VALUES("319", "av_alb_element_check_stat", "a:166:{s:16:\"app_store_button\";s:7:\"checked\";s:10:\"ss_appcard\";s:7:\"checked\";s:11:\"ss_artframe\";s:7:\"checked\";s:11:\"av_cat_list\";s:7:\"checked\";s:15:\"av_color_picker\";s:7:\"checked\";s:12:\"av_copyright\";s:7:\"checked\";s:12:\"av_dl_button\";s:7:\"checked\";s:12:\"av_editnotes\";s:7:\"checked\";s:11:\"av_editlink\";s:7:\"checked\";s:16:\"av_elegant_title\";s:7:\"checked\";s:19:\"featured_img_modern\";s:7:\"checked\";s:13:\"filetype_icon\";s:7:\"checked\";s:11:\"avia_lipsum\";s:7:\"checked\";s:12:\"modal_button\";s:7:\"checked\";s:12:\"ss_moviecard\";s:7:\"checked\";s:10:\"page_title\";s:7:\"checked\";s:14:\"wc_featurelist\";s:7:\"checked\";s:12:\"promo_modern\";s:7:\"checked\";s:14:\"ribbon_heading\";s:7:\"checked\";s:12:\"av_shortlink\";s:7:\"checked\";s:11:\"av_tag_list\";s:7:\"checked\";s:9:\"av_player\";s:7:\"checked\";s:7:\"av_blog\";s:7:\"checked\";s:12:\"av_buttonrow\";s:7:\"checked\";s:9:\"av_button\";s:7:\"checked\";s:13:\"av_button_big\";s:7:\"checked\";s:12:\"av_catalogue\";s:7:\"checked\";s:16:\"av_comments_list\";s:7:\"checked\";s:10:\"av_contact\";s:7:\"checked\";s:17:\"av_content_slider\";s:7:\"checked\";s:12:\"av_countdown\";s:7:\"checked\";s:10:\"av_gallery\";s:7:\"checked\";s:21:\"av_horizontal_gallery\";s:7:\"checked\";s:13:\"av_google_map\";s:7:\"checked\";s:16:\"av_cell_one_full\";s:7:\"checked\";s:16:\"av_cell_one_half\";s:7:\"checked\";s:17:\"av_cell_one_third\";s:7:\"checked\";s:17:\"av_cell_two_third\";s:7:\"checked\";s:18:\"av_cell_one_fourth\";s:7:\"checked\";s:20:\"av_cell_three_fourth\";s:7:\"checked\";s:17:\"av_cell_one_fifth\";s:7:\"checked\";s:17:\"av_cell_two_fifth\";s:7:\"checked\";s:19:\"av_cell_three_fifth\";s:7:\"checked\";s:18:\"av_cell_four_fifth\";s:7:\"checked\";s:13:\"av_layout_row\";s:7:\"checked\";s:10:\"av_heading\";s:7:\"checked\";s:19:\"av_headline_rotator\";s:7:\"checked\";s:5:\"av_hr\";s:7:\"checked\";s:12:\"av_font_icon\";s:7:\"checked\";s:11:\"av_icon_box\";s:7:\"checked\";s:11:\"av_icongrid\";s:7:\"checked\";s:11:\"av_iconlist\";s:7:\"checked\";s:8:\"av_image\";s:7:\"checked\";s:16:\"av_image_hotspot\";s:7:\"checked\";s:10:\"av_partner\";s:7:\"checked\";s:11:\"av_magazine\";s:7:\"checked\";s:12:\"av_mailchimp\";s:7:\"checked\";s:18:\"av_masonry_entries\";s:7:\"checked\";s:18:\"av_masonry_gallery\";s:7:\"checked\";s:10:\"av_submenu\";s:7:\"checked\";s:15:\"av_notification\";s:7:\"checked\";s:19:\"av_animated_numbers\";s:7:\"checked\";s:12:\"av_portfolio\";s:7:\"checked\";s:16:\"av_post_metadata\";s:7:\"checked\";s:13:\"av_postslider\";s:7:\"checked\";s:11:\"av_progress\";s:7:\"checked\";s:11:\"av_promobox\";s:7:\"checked\";s:14:\"avia_sc_search\";s:7:\"checked\";s:12:\"av_slideshow\";s:7:\"checked\";s:22:\"av_slideshow_accordion\";s:7:\"checked\";s:23:\"av_feature_image_slider\";s:7:\"checked\";s:13:\"av_fullscreen\";s:7:\"checked\";s:17:\"av_slideshow_full\";s:7:\"checked\";s:14:\"av_layerslider\";s:7:\"checked\";s:15:\"av_social_share\";s:7:\"checked\";s:18:\"av_tab_sub_section\";s:7:\"checked\";s:14:\"av_tab_section\";s:7:\"checked\";s:8:\"av_table\";s:7:\"checked\";s:16:\"av_tab_container\";s:7:\"checked\";s:14:\"av_team_member\";s:7:\"checked\";s:15:\"av_testimonials\";s:7:\"checked\";s:11:\"av_timeline\";s:7:\"checked\";s:19:\"av_toggle_container\";s:7:\"checked\";s:8:\"av_video\";s:7:\"checked\";s:12:\"av_codeblock\";s:7:\"checked\";s:11:\"av_one_full\";s:7:\"checked\";s:11:\"av_one_half\";s:7:\"checked\";s:12:\"av_one_third\";s:7:\"checked\";s:12:\"av_two_third\";s:7:\"checked\";s:13:\"av_one_fourth\";s:7:\"checked\";s:15:\"av_three_fourth\";s:7:\"checked\";s:12:\"av_one_fifth\";s:7:\"checked\";s:12:\"av_two_fifth\";s:7:\"checked\";s:14:\"av_three_fifth\";s:7:\"checked\";s:13:\"av_four_fifth\";s:7:\"checked\";s:14:\"av_postcontent\";s:7:\"checked\";s:10:\"av_section\";s:7:\"checked\";s:12:\"av_textblock\";s:7:\"checked\";s:10:\"av_sidebar\";s:7:\"checked\";s:13:\"filetype_item\";s:7:\"checked\";s:19:\"wc_featurelist_item\";s:7:\"checked\";s:19:\"av_playlist_element\";s:7:\"checked\";s:17:\"av_buttonrow_item\";s:7:\"checked\";s:17:\"av_catalogue_item\";s:7:\"checked\";s:16:\"av_contact_field\";s:7:\"checked\";s:16:\"av_content_slide\";s:7:\"checked\";s:16:\"av_gmap_location\";s:7:\"checked\";s:15:\"av_rotator_item\";s:7:\"checked\";s:16:\"av_icongrid_item\";s:7:\"checked\";s:16:\"av_iconlist_item\";s:7:\"checked\";s:13:\"av_image_spot\";s:7:\"checked\";s:15:\"av_partner_logo\";s:7:\"checked\";s:18:\"av_mailchimp_field\";s:7:\"checked\";s:15:\"av_submenu_item\";s:7:\"checked\";s:16:\"av_metadata_item\";s:7:\"checked\";s:15:\"av_progress_bar\";s:7:\"checked\";s:8:\"av_slide\";s:7:\"checked\";s:18:\"av_slide_accordion\";s:7:\"checked\";s:19:\"av_fullscreen_slide\";s:7:\"checked\";s:13:\"av_slide_full\";s:7:\"checked\";s:6:\"av_row\";s:7:\"checked\";s:7:\"av_cell\";s:7:\"checked\";s:6:\"av_tab\";s:7:\"checked\";s:12:\"av_team_icon\";s:7:\"checked\";s:21:\"av_testimonial_single\";s:7:\"checked\";s:16:\"av_timeline_item\";s:7:\"checked\";s:9:\"av_toggle\";s:7:\"checked\";s:9:\"cat_promo\";s:7:\"checked\";s:9:\"gift_wrap\";s:7:\"checked\";s:14:\"av_prodgallery\";s:7:\"checked\";s:10:\"prod_promo\";s:7:\"checked\";s:15:\"av_wc_a2cbutton\";s:7:\"checked\";s:15:\"av_wc_prod_cats\";s:7:\"checked\";s:19:\"av_sale_productgrid\";s:7:\"checked\";s:14:\"av_product_img\";s:7:\"checked\";s:21:\"wc_product_img_modern\";s:7:\"checked\";s:17:\"ss_product_modern\";s:7:\"checked\";s:8:\"wc_price\";s:7:\"checked\";s:15:\"wc_price_header\";s:7:\"checked\";s:15:\"av_wc_shortdesc\";s:7:\"checked\";s:12:\"av_wc_single\";s:7:\"checked\";s:6:\"wc_sku\";s:7:\"checked\";s:15:\"av_wc_prod_tags\";s:7:\"checked\";s:11:\"prod_header\";s:7:\"checked\";s:10:\"av_wcalert\";s:7:\"checked\";s:13:\"av_wctracking\";s:7:\"checked\";s:10:\"sold_count\";s:7:\"checked\";s:14:\"ss_wc_artframe\";s:7:\"checked\";s:17:\"av_product_button\";s:7:\"checked\";s:15:\"av_product_info\";s:7:\"checked\";s:17:\"av_product_review\";s:7:\"checked\";s:15:\"av_product_tabs\";s:7:\"checked\";s:18:\"av_product_upsells\";s:7:\"checked\";s:15:\"av_product_meta\";s:7:\"checked\";s:16:\"av_product_price\";s:7:\"checked\";s:16:\"av_productslider\";s:7:\"checked\";s:14:\"av_productgrid\";s:7:\"checked\";s:14:\"av_productlist\";s:7:\"checked\";s:15:\"av_icon_circles\";s:7:\"checked\";s:19:\"av_icon_circle_item\";s:7:\"checked\";s:8:\"av_chart\";s:3:\"new\";s:16:\"av_chart_dataset\";s:3:\"new\";s:13:\"av_image_diff\";s:3:\"new\";s:9:\"av_lottie\";s:3:\"new\";s:16:\"av_custom_layout\";s:3:\"new\";s:16:\"av_dynamic_field\";s:3:\"new\";}", "yes");
INSERT INTO `wp_options` VALUES("320", "av_alb_element_mgr", "1.0.1", "yes");
INSERT INTO `wp_options` VALUES("321", "avia_gutenberg_dyn_css_exists_enfold", "true", "yes");
INSERT INTO `wp_options` VALUES("322", "avia_options_enfold", "a:2:{s:4:\"avia\";a:470:{s:9:\"frontpage\";s:3:\"206\";s:8:\"blogpage\";s:3:\"600\";s:4:\"logo\";s:4:\"3003\";s:25:\"avia_transparency_options\";s:8:\"disabled\";s:23:\"header_replacement_logo\";s:4:\"3002\";s:23:\"header_replacement_menu\";s:7:\"#ffffff\";s:29:\"header_replacement_menu_hover\";s:0:\"\";s:7:\"favicon\";s:0:\"\";s:9:\"preloader\";s:9:\"preloader\";s:21:\"preloader_transitions\";s:8:\"disabled\";s:14:\"preloader_logo\";s:0:\"\";s:15:\"lightbox_active\";s:15:\"lightbox_active\";s:15:\"error404_custom\";s:0:\"\";s:13:\"error404_page\";s:0:\"\";s:16:\"maintenance_mode\";s:0:\"\";s:16:\"maintenance_page\";s:0:\"\";s:24:\"enable_wp_classic_editor\";s:0:\"\";s:16:\"color-body_style\";s:9:\"stretched\";s:17:\"color-frame_width\";s:2:\"20\";s:15:\"header_position\";s:10:\"header_top\";s:20:\"layout_align_content\";s:20:\"content_align_center\";s:18:\"sidebarmenu_sticky\";s:18:\"conditional_sticky\";s:19:\"sidebarmenu_widgets\";s:0:\"\";s:18:\"sidebarmenu_social\";s:8:\"disabled\";s:17:\"responsive_active\";s:17:\"responsive_active\";s:15:\"responsive_size\";s:6:\"1410px\";s:13:\"content_width\";s:2:\"73\";s:14:\"combined_width\";s:2:\"95\";s:12:\"color_scheme\";s:11:\"Enfold 2017\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#9cc2df\";s:31:\"colorset-header_color-secondary\";s:7:\"#9cc3df\";s:27:\"colorset-header_color-color\";s:7:\"#000000\";s:26:\"colorset-header_color-meta\";s:7:\"#969696\";s:29:\"colorset-header_color-heading\";s:7:\"#000000\";s:28:\"colorset-header_color-border\";s:7:\"#ebebeb\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#000000\";s:29:\"colorset-main_color-secondary\";s:7:\"#9cc3df\";s:25:\"colorset-main_color-color\";s:7:\"#b0b0b0\";s:24:\"colorset-main_color-meta\";s:7:\"#919191\";s:27:\"colorset-main_color-heading\";s:7:\"#222222\";s:26:\"colorset-main_color-border\";s:7:\"#ebebeb\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#f8f8f8\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#ffffff\";s:32:\"colorset-alternate_color-primary\";s:7:\"#000000\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#9cc3df\";s:30:\"colorset-alternate_color-color\";s:7:\"#999999\";s:29:\"colorset-alternate_color-meta\";s:7:\"#919191\";s:32:\"colorset-alternate_color-heading\";s:7:\"#222222\";s:31:\"colorset-alternate_color-border\";s:7:\"#ebebeb\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#35383c\";s:25:\"colorset-footer_color-bg2\";s:7:\"#52565c\";s:29:\"colorset-footer_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-footer_color-secondary\";s:7:\"#ebebeb\";s:27:\"colorset-footer_color-color\";s:7:\"#e8e8e8\";s:26:\"colorset-footer_color-meta\";s:7:\"#777777\";s:29:\"colorset-footer_color-heading\";s:7:\"#ffffff\";s:28:\"colorset-footer_color-border\";s:7:\"#35383c\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:13:\"center center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#282b2e\";s:25:\"colorset-socket_color-bg2\";s:7:\"#52565c\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#ebebeb\";s:27:\"colorset-socket_color-color\";s:7:\"#e8e8e8\";s:26:\"colorset-socket_color-meta\";s:7:\"#777777\";s:29:\"colorset-socket_color-heading\";s:7:\"#ffffff\";s:28:\"colorset-socket_color-border\";s:7:\"#282b2e\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:16:\"color-body_color\";s:7:\"#ffffff\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:14:\"google_webfont\";s:23:\"iransanswebfanum-custom\";s:12:\"default_font\";s:23:\"iransanswebfanum-custom\";s:29:\"styling_typo_chk_content-font\";s:8:\"disabled\";s:22:\"typo-default_font_size\";s:4:\"16px\";s:29:\"typo-default_font_size-medium\";s:0:\"\";s:28:\"typo-default_font_size-small\";s:0:\"\";s:27:\"typo-default_font_size-mini\";s:0:\"\";s:19:\"styling_typo_chk_h1\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h1\";s:0:\"\";s:31:\"typo-font-size-custom_h1-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h1-small\";s:0:\"\";s:29:\"typo-font-size-custom_h1-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h1\";s:0:\"\";s:33:\"typo-font-weight-custom_h1-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h1-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h1-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h1\";s:0:\"\";s:33:\"typo-line-height-custom_h1-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h1-small\";s:0:\"\";s:31:\"typo-line-height-custom_h1-mini\";s:0:\"\";s:21:\"typo-margin-custom_h1\";s:0:\"\";s:28:\"typo-margin-custom_h1-medium\";s:0:\"\";s:27:\"typo-margin-custom_h1-small\";s:0:\"\";s:26:\"typo-margin-custom_h1-mini\";s:0:\"\";s:19:\"styling_typo_chk_h2\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h2\";s:0:\"\";s:31:\"typo-font-size-custom_h2-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h2-small\";s:0:\"\";s:29:\"typo-font-size-custom_h2-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h2\";s:0:\"\";s:33:\"typo-font-weight-custom_h2-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h2-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h2-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h2\";s:0:\"\";s:33:\"typo-line-height-custom_h2-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h2-small\";s:0:\"\";s:31:\"typo-line-height-custom_h2-mini\";s:0:\"\";s:21:\"typo-margin-custom_h2\";s:0:\"\";s:28:\"typo-margin-custom_h2-medium\";s:0:\"\";s:27:\"typo-margin-custom_h2-small\";s:0:\"\";s:26:\"typo-margin-custom_h2-mini\";s:0:\"\";s:19:\"styling_typo_chk_h3\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h3\";s:0:\"\";s:31:\"typo-font-size-custom_h3-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h3-small\";s:0:\"\";s:29:\"typo-font-size-custom_h3-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h3\";s:0:\"\";s:33:\"typo-font-weight-custom_h3-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h3-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h3-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h3\";s:0:\"\";s:33:\"typo-line-height-custom_h3-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h3-small\";s:0:\"\";s:31:\"typo-line-height-custom_h3-mini\";s:0:\"\";s:21:\"typo-margin-custom_h3\";s:0:\"\";s:28:\"typo-margin-custom_h3-medium\";s:0:\"\";s:27:\"typo-margin-custom_h3-small\";s:0:\"\";s:26:\"typo-margin-custom_h3-mini\";s:0:\"\";s:19:\"styling_typo_chk_h4\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h4\";s:0:\"\";s:31:\"typo-font-size-custom_h4-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h4-small\";s:0:\"\";s:29:\"typo-font-size-custom_h4-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h4\";s:0:\"\";s:33:\"typo-font-weight-custom_h4-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h4-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h4-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h4\";s:0:\"\";s:33:\"typo-line-height-custom_h4-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h4-small\";s:0:\"\";s:31:\"typo-line-height-custom_h4-mini\";s:0:\"\";s:21:\"typo-margin-custom_h4\";s:0:\"\";s:28:\"typo-margin-custom_h4-medium\";s:0:\"\";s:27:\"typo-margin-custom_h4-small\";s:0:\"\";s:26:\"typo-margin-custom_h4-mini\";s:0:\"\";s:19:\"styling_typo_chk_h5\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h5\";s:0:\"\";s:31:\"typo-font-size-custom_h5-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h5-small\";s:0:\"\";s:29:\"typo-font-size-custom_h5-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h5\";s:0:\"\";s:33:\"typo-font-weight-custom_h5-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h5-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h5-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h5\";s:0:\"\";s:33:\"typo-line-height-custom_h5-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h5-small\";s:0:\"\";s:31:\"typo-line-height-custom_h5-mini\";s:0:\"\";s:21:\"typo-margin-custom_h5\";s:0:\"\";s:28:\"typo-margin-custom_h5-medium\";s:0:\"\";s:27:\"typo-margin-custom_h5-small\";s:0:\"\";s:26:\"typo-margin-custom_h5-mini\";s:0:\"\";s:19:\"styling_typo_chk_h6\";s:8:\"disabled\";s:24:\"typo-font-size-custom_h6\";s:0:\"\";s:31:\"typo-font-size-custom_h6-medium\";s:0:\"\";s:30:\"typo-font-size-custom_h6-small\";s:0:\"\";s:29:\"typo-font-size-custom_h6-mini\";s:0:\"\";s:26:\"typo-font-weight-custom_h6\";s:0:\"\";s:33:\"typo-font-weight-custom_h6-medium\";s:0:\"\";s:32:\"typo-font-weight-custom_h6-small\";s:0:\"\";s:31:\"typo-font-weight-custom_h6-mini\";s:0:\"\";s:26:\"typo-line-height-custom_h6\";s:0:\"\";s:33:\"typo-line-height-custom_h6-medium\";s:0:\"\";s:32:\"typo-line-height-custom_h6-small\";s:0:\"\";s:31:\"typo-line-height-custom_h6-mini\";s:0:\"\";s:21:\"typo-margin-custom_h6\";s:0:\"\";s:28:\"typo-margin-custom_h6-medium\";s:0:\"\";s:27:\"typo-margin-custom_h6-small\";s:0:\"\";s:26:\"typo-margin-custom_h6-mini\";s:0:\"\";s:9:\"quick_css\";s:0:\"\";s:26:\"block_editor_theme_support\";s:0:\"\";s:16:\"advanced_styling\";a:5:{i:0;a:11:{s:2:\"id\";s:12:\"headings_all\";s:5:\"color\";s:0:\"\";s:16:\"background_color\";s:0:\"\";s:11:\"font_family\";s:23:\"iransanswebfanum-custom\";s:11:\"font_weight\";s:0:\"\";s:14:\"text_transform\";s:4:\"none\";s:12:\"header_color\";s:4:\"true\";s:10:\"main_color\";s:4:\"true\";s:15:\"alternate_color\";s:4:\"true\";s:12:\"footer_color\";s:4:\"true\";s:12:\"socket_color\";s:4:\"true\";}i:1;a:10:{s:2:\"id\";s:7:\"buttons\";s:13:\"border_radius\";s:3:\"0px\";s:12:\"border_width\";s:3:\"2px\";s:18:\"padding_left_right\";s:0:\"\";s:18:\"padding_top_bottom\";s:0:\"\";s:11:\"font_family\";s:23:\"iransanswebfanum-custom\";s:9:\"font_size\";s:0:\"\";s:11:\"font_weight\";s:0:\"\";s:14:\"text_transform\";s:0:\"\";s:14:\"letter_spacing\";s:0:\"\";}i:2;a:13:{s:2:\"id\";s:2:\"h3\";s:5:\"color\";s:0:\"\";s:16:\"background_color\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:11:\"line_height\";s:0:\"\";s:11:\"font_family\";s:23:\"iransanswebfanum-custom\";s:11:\"font_weight\";s:6:\"normal\";s:14:\"text_transform\";s:0:\"\";s:12:\"header_color\";s:4:\"true\";s:10:\"main_color\";s:4:\"true\";s:15:\"alternate_color\";s:4:\"true\";s:12:\"footer_color\";s:4:\"true\";s:12:\"socket_color\";s:4:\"true\";}i:3;a:10:{s:2:\"id\";s:13:\"hover_overlay\";s:13:\"overlay_style\";s:4:\"none\";s:5:\"color\";s:0:\"\";s:10:\"icon_color\";s:0:\"\";s:16:\"background_color\";s:0:\"\";s:12:\"header_color\";s:4:\"true\";s:10:\"main_color\";s:4:\"true\";s:15:\"alternate_color\";s:4:\"true\";s:12:\"footer_color\";s:4:\"true\";s:12:\"socket_color\";s:4:\"true\";}i:4;a:11:{s:2:\"id\";s:9:\"main_menu\";s:5:\"color\";s:0:\"\";s:16:\"background_color\";s:0:\"\";s:12:\"border_color\";s:0:\"\";s:9:\"font_size\";s:4:\"14px\";s:11:\"font_family\";s:23:\"iransanswebfanum-custom\";s:14:\"text_transform\";s:0:\"\";s:14:\"letter_spacing\";s:0:\"\";s:11:\"font_weight\";s:0:\"\";s:12:\"hover_active\";s:8:\"disabled\";s:11:\"item_active\";s:8:\"disabled\";}}s:12:\"menu_display\";s:0:\"\";s:14:\"alternate_menu\";s:0:\"\";s:24:\"header_mobile_activation\";s:17:\"mobile_menu_phone\";s:29:\"header_mobile_device_handling\";s:0:\"\";s:18:\"header_menu_border\";s:0:\"\";s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:18:\"submenu_visibility\";s:42:\"av-submenu-hidden av-submenu-display-click\";s:13:\"submenu_clone\";s:16:\"av-submenu-clone\";s:11:\"burger_size\";s:20:\"av-small-burger-icon\";s:13:\"overlay_style\";s:39:\"av-overlay-side av-overlay-side-classic\";s:12:\"burger_color\";s:0:\"\";s:19:\"burger_flyout_width\";s:5:\"500px\";s:13:\"header_layout\";s:36:\"logo_right main_nav_header menu_left\";s:11:\"header_size\";s:4:\"slim\";s:18:\"header_custom_size\";s:3:\"150\";s:12:\"header_style\";s:36:\"minimal_header minimal_header_shadow\";s:16:\"header_title_bar\";s:20:\"title_bar_breadcrumb\";s:13:\"header_sticky\";s:13:\"header_sticky\";s:16:\"header_shrinking\";s:8:\"disabled\";s:23:\"header_shrinking_factor\";s:0:\"\";s:18:\"header_unstick_top\";s:18:\"header_unstick_top\";s:14:\"header_stretch\";s:8:\"disabled\";s:13:\"header_social\";s:16:\"icon_active_main\";s:21:\"header_secondary_menu\";s:0:\"\";s:19:\"header_phone_active\";s:0:\"\";s:5:\"phone\";s:63:\"&lt;a href=&#039;tel:09120000000&#039;&gt;09120000000&lt;/a&gt;\";s:16:\"reading_progress\";s:0:\"\";s:22:\"reading_progress_color\";s:0:\"\";s:14:\"archive_layout\";s:13:\"sidebar_right\";s:11:\"blog_layout\";s:13:\"sidebar_right\";s:13:\"single_layout\";s:13:\"sidebar_right\";s:11:\"page_layout\";s:8:\"fullsize\";s:15:\"archive_sidebar\";s:0:\"\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:16:\"page_nesting_nav\";s:15:\"sidebar_styling\";s:0:\"\";s:22:\"sidebar_left_textalign\";s:0:\"\";s:22:\"display_widgets_socket\";s:3:\"all\";s:11:\"footer_page\";s:3:\"632\";s:15:\"footer_behavior\";s:0:\"\";s:14:\"curtains_media\";s:2:\"80\";s:14:\"footer_columns\";s:1:\"4\";s:9:\"copyright\";s:96:\"&copy; کپی رایت - انفولد ارائه شده توسط خاتم در ژاکت [nolink]\";s:13:\"footer_social\";s:13:\"footer_social\";s:15:\"preview_disable\";s:8:\"disabled\";s:8:\"lock_alb\";s:8:\"disabled\";s:19:\"lock_alb_for_admins\";s:8:\"disabled\";s:30:\"avia_alb_show_advanced_options\";s:8:\"disabled\";s:21:\"alb_developer_options\";s:8:\"disabled\";s:22:\"alb_developer_ext_typo\";s:8:\"disabled\";s:24:\"alb_developer_debug_mode\";s:0:\"\";s:21:\"alb_use_custom_colors\";s:8:\"disabled\";s:24:\"alb_custom_color_palette\";s:0:\"\";s:19:\"alb_options_toggles\";s:0:\"\";s:17:\"layerslider_activ\";s:0:\"\";s:27:\"layerslider_default_options\";s:0:\"\";s:21:\"alb_element_templates\";s:3:\"all\";s:24:\"alb_locked_modal_options\";s:8:\"show_all\";s:29:\"alb_show_locked_modal_options\";s:0:\"\";s:26:\"custom_el_advanced_options\";s:8:\"disabled\";s:27:\"custom_el_shortcode_buttons\";s:0:\"\";s:32:\"custom_el_hierarchical_templates\";s:0:\"\";s:26:\"custom_el_subitem_handling\";s:0:\"\";s:20:\"custom_el_cpt_screen\";s:0:\"\";s:17:\"blog_global_style\";s:24:\"elegant-blog modern-blog\";s:10:\"blog_style\";s:6:\"custom\";s:16:\"disable_post_nav\";s:0:\"\";s:14:\"post_nav_swipe\";s:0:\"\";s:17:\"single_post_style\";s:10:\"single-big\";s:27:\"single_post_related_entries\";s:21:\"av-related-style-full\";s:16:\"blog-meta-author\";s:16:\"blog-meta-author\";s:18:\"blog-meta-comments\";s:18:\"blog-meta-comments\";s:18:\"blog-meta-category\";s:18:\"blog-meta-category\";s:14:\"blog-meta-date\";s:14:\"blog-meta-date\";s:19:\"blog-meta-html-info\";s:8:\"disabled\";s:13:\"blog-meta-tag\";s:13:\"blog-meta-tag\";s:14:\"share_facebook\";s:8:\"disabled\";s:13:\"share_twitter\";s:13:\"share_twitter\";s:22:\"share_square-x-twitter\";s:8:\"disabled\";s:14:\"share_whatsapp\";s:14:\"share_whatsapp\";s:15:\"share_pinterest\";s:8:\"disabled\";s:12:\"share_reddit\";s:8:\"disabled\";s:14:\"share_linkedin\";s:8:\"disabled\";s:12:\"share_tumblr\";s:8:\"disabled\";s:8:\"share_vk\";s:8:\"disabled\";s:10:\"share_yelp\";s:8:\"disabled\";s:10:\"share_mail\";s:8:\"disabled\";s:17:\"share_five_100_px\";s:8:\"disabled\";s:13:\"share_behance\";s:8:\"disabled\";s:14:\"share_dribbble\";s:8:\"disabled\";s:12:\"share_flickr\";s:8:\"disabled\";s:15:\"share_instagram\";s:8:\"disabled\";s:14:\"share_telegram\";s:14:\"share_telegram\";s:11:\"share_skype\";s:8:\"disabled\";s:16:\"share_soundcloud\";s:8:\"disabled\";s:12:\"share_tiktok\";s:8:\"disabled\";s:11:\"share_vimeo\";s:8:\"disabled\";s:10:\"share_xing\";s:8:\"disabled\";s:13:\"share_youtube\";s:8:\"disabled\";s:9:\"share_rss\";s:8:\"disabled\";s:31:\"single_post_share_buttons_style\";s:0:\"\";s:35:\"single_post_share_buttons_alignment\";s:0:\"\";s:12:\"social_icons\";a:2:{i:0;a:2:{s:11:\"social_icon\";s:9:\"instagram\";s:16:\"social_icon_link\";s:21:\"https://instagram.com\";}i:1;a:2:{s:11:\"social_icon\";s:8:\"telegram\";s:16:\"social_icon_link\";s:20:\"https://telegram.org\";}}s:9:\"merge_css\";s:4:\"none\";s:8:\"merge_js\";s:4:\"avia\";s:19:\"merge_show_advanced\";s:8:\"disabled\";s:19:\"old_browser_support\";s:0:\"\";s:17:\"merge_disable_ssl\";s:0:\"\";s:30:\"merge_disable_unique_timestamp\";s:0:\"\";s:34:\"remove_query_string_from_resources\";s:0:\"\";s:18:\"custom_font_source\";s:0:\"\";s:19:\"custom_font_display\";s:0:\"\";s:20:\"disable_alb_elements\";s:4:\"auto\";s:28:\"av_alb_disable_av_image_diff\";s:8:\"disabled\";s:30:\"av_alb_disable_av_icon_circles\";s:8:\"disabled\";s:26:\"av_alb_disable_av_icongrid\";s:8:\"disabled\";s:26:\"av_alb_disable_av_timeline\";s:8:\"disabled\";s:27:\"av_alb_disable_av_font_icon\";s:8:\"disabled\";s:28:\"av_alb_disable_filetype_icon\";s:8:\"disabled\";s:38:\"av_alb_disable_av_feature_image_slider\";s:8:\"disabled\";s:37:\"av_alb_disable_av_slideshow_accordion\";s:8:\"disabled\";s:28:\"av_alb_disable_av_fullscreen\";s:8:\"disabled\";s:32:\"av_alb_disable_av_content_slider\";s:8:\"disabled\";s:31:\"av_alb_disable_av_productslider\";s:8:\"disabled\";s:28:\"av_alb_disable_av_postslider\";s:8:\"disabled\";s:31:\"av_alb_disable_av_post_metadata\";s:8:\"disabled\";s:30:\"av_alb_disable_av_notification\";s:8:\"disabled\";s:24:\"av_alb_disable_av_lottie\";s:8:\"disabled\";s:27:\"av_alb_disable_av_slideshow\";s:8:\"disabled\";s:32:\"av_alb_disable_av_slideshow_full\";s:8:\"disabled\";s:29:\"av_alb_disable_av_tab_section\";s:8:\"disabled\";s:31:\"av_alb_disable_av_tab_container\";s:8:\"disabled\";s:23:\"av_alb_disable_av_image\";s:8:\"disabled\";s:20:\"av_alb_disable_av_hr\";s:8:\"disabled\";s:23:\"av_alb_disable_av_table\";s:8:\"disabled\";s:29:\"av_alb_disable_avia_sc_search\";s:8:\"disabled\";s:26:\"av_alb_disable_av_icon_box\";s:8:\"disabled\";s:26:\"av_alb_disable_av_promobox\";s:8:\"disabled\";s:28:\"av_alb_disable_av_button_big\";s:8:\"disabled\";s:27:\"av_alb_disable_av_buttonrow\";s:8:\"disabled\";s:25:\"av_alb_disable_av_submenu\";s:8:\"disabled\";s:27:\"av_alb_disable_av_countdown\";s:8:\"disabled\";s:34:\"av_alb_disable_av_animated_numbers\";s:8:\"disabled\";s:29:\"av_alb_disable_av_team_member\";s:8:\"disabled\";s:27:\"av_alb_disable_av_mailchimp\";s:8:\"disabled\";s:25:\"av_alb_disable_av_partner\";s:8:\"disabled\";s:25:\"av_alb_disable_av_heading\";s:8:\"disabled\";s:31:\"av_alb_disable_av_image_hotspot\";s:8:\"disabled\";s:25:\"av_alb_disable_av_contact\";s:8:\"disabled\";s:26:\"av_alb_disable_ss_artframe\";s:8:\"disabled\";s:29:\"av_alb_disable_av_layerslider\";s:8:\"disabled\";s:26:\"av_alb_disable_av_iconlist\";s:8:\"disabled\";s:26:\"av_alb_disable_av_magazine\";s:8:\"disabled\";s:34:\"av_alb_disable_av_toggle_container\";s:8:\"disabled\";s:30:\"av_alb_disable_av_testimonials\";s:8:\"disabled\";s:28:\"av_alb_disable_av_google_map\";s:8:\"disabled\";s:23:\"av_alb_disable_av_chart\";s:8:\"disabled\";s:27:\"av_alb_disable_av_portfolio\";s:8:\"disabled\";s:26:\"av_alb_disable_av_progress\";s:8:\"disabled\";s:24:\"av_alb_disable_av_player\";s:8:\"disabled\";s:33:\"av_alb_disable_av_masonry_entries\";s:8:\"disabled\";s:34:\"av_alb_disable_av_headline_rotator\";s:8:\"disabled\";s:27:\"av_alb_disable_av_catalogue\";s:8:\"disabled\";s:36:\"av_alb_disable_av_horizontal_gallery\";s:8:\"disabled\";s:33:\"av_alb_disable_av_masonry_gallery\";s:8:\"disabled\";s:29:\"scan_widgets_for_alb_elements\";s:0:\"\";s:20:\"disable_mediaelement\";s:0:\"\";s:29:\"disable_mobile_css_animations\";s:8:\"disabled\";s:13:\"disable_video\";s:8:\"disabled\";s:12:\"disable_blog\";s:8:\"disabled\";s:13:\"disable_emoji\";s:8:\"disabled\";s:18:\"disable_jq_migrate\";s:8:\"disabled\";s:16:\"jquery_in_footer\";s:8:\"disabled\";s:16:\"gfonts_in_footer\";s:8:\"disabled\";s:12:\"lazy_loading\";s:0:\"\";s:17:\"responsive_images\";s:17:\"responsive_images\";s:26:\"responsive_images_lightbox\";s:8:\"disabled\";s:24:\"responsive_images_thumbs\";s:8:\"disabled\";s:24:\"delete_assets_after_save\";s:8:\"disabled\";s:34:\"privacy_message_commentform_active\";s:8:\"disabled\";s:15:\"privacy_message\";s:0:\"\";s:34:\"privacy_message_contactform_active\";s:8:\"disabled\";s:23:\"privacy_message_contact\";s:0:\"\";s:32:\"privacy_message_mailchimp_active\";s:8:\"disabled\";s:25:\"privacy_message_mailchimp\";s:0:\"\";s:28:\"privacy_message_login_active\";s:8:\"disabled\";s:21:\"privacy_message_login\";s:0:\"\";s:35:\"privacy_message_registration_active\";s:8:\"disabled\";s:28:\"privacy_message_registration\";s:0:\"\";s:14:\"cookie_consent\";s:0:\"\";s:23:\"cookie_default_settings\";s:0:\"\";s:14:\"cookie_content\";s:188:\"این سایت از کوکی ها استفاده می کند. شما با ادامه مشاهده سایت، شما با استفاده ما از کوکی ها موافقت می کنید.\";s:15:\"cookie_position\";s:6:\"bottom\";s:15:\"msg_bar_buttons\";a:3:{i:0;a:4:{s:20:\"msg_bar_button_label\";s:29:\"پذیرفتن تنظیمات\";s:21:\"msg_bar_button_action\";s:0:\"\";s:19:\"msg_bar_button_link\";s:0:\"\";s:22:\"msg_bar_button_tooltip\";s:166:\"اجازه استفاده از کوکی ها را بده، شما می توانید کوکی های استفاده شده را در تنظیمات تغییر دهید\";}i:1;a:4:{s:20:\"msg_bar_button_label\";s:44:\"فقط اطلاعیه را نمایش نده\";s:21:\"msg_bar_button_action\";s:17:\"hide_notification\";s:19:\"msg_bar_button_link\";s:0:\"\";s:22:\"msg_bar_button_tooltip\";s:176:\"اجازه استفاده از کوکی ها را نده - ممکن است برخی قابلیت های سایتتان طوری که انتظار می رود کار نکنند.\";}i:2;a:4:{s:20:\"msg_bar_button_label\";s:14:\"تنظیمات\";s:21:\"msg_bar_button_action\";s:10:\"info_modal\";s:19:\"msg_bar_button_link\";s:0:\"\";s:22:\"msg_bar_button_tooltip\";s:169:\"اطلاعات بیشتری درباره کوکی ها کسب کنید و انتخاب کنید که کدام کوکی مجاز باشد و کدام کوکی نباشد.\";}}s:25:\"modal_popup_window_action\";s:0:\"\";s:26:\"modal_popup_window_buttons\";a:2:{i:0;a:4:{s:24:\"modal_popup_button_label\";s:29:\"پذیرفتن تنظیمات\";s:25:\"modal_popup_button_action\";s:0:\"\";s:23:\"modal_popup_button_link\";s:0:\"\";s:26:\"modal_popup_button_tooltip\";s:162:\"اجازه استفاده از کوکی ها را بده، همیشه می توانید کوکی ها و خدمات استفاده شده را تغییر دهید\";}i:1;a:4:{s:24:\"modal_popup_button_label\";s:44:\"فقط اطلاعیه را نمایش نده\";s:25:\"modal_popup_button_action\";s:17:\"hide_notification\";s:23:\"modal_popup_button_link\";s:0:\"\";s:26:\"modal_popup_button_tooltip\";s:198:\"اجازه استفاده از کوکی ها و خدمات را نده - ممکن است برخی از قابلیت های سایت ما آن طور که انتظار می رود، کار نکنند\";}}s:26:\"cookie_info_custom_content\";s:8:\"disabled\";s:27:\"cookie_info_content_heading\";s:27:\"Cookie and Privacy Settings\";s:19:\"cookie_info_content\";a:5:{i:0;a:2:{s:5:\"label\";s:63:\"ما چگونه از کوکی ها استفاده می کنیم\";s:7:\"content\";s:859:\"ممکن است کوکی هایی را برای تنظیم در دستگاهتان، درخواست کنیم. ما از کوکی ها استفاده می کنیم تا بدانیم شما چه زمانی از سایت ما بازدید می کنید، چگونه با ما تعامل دارید، تجربه کاربری شما را بهبود ببخشیم و رابطه شما با سایت خود را شخصی سازی کنیم.&lt;br&gt;&lt;br&gt;با کلیک روی عناوین مختلف می توانید اطلاعات بیشتری به دست آورید. همچنین می توانید برخی از تنظیمات خود را تغییر دهید. توحه داشته باشید که مسدود کردن برخی از کوکی ها روی ترجبه شما با سایت ما و خدماتی که ارائه می دهیم، تاثیر بگذارد.\";}i:1;a:2:{s:5:\"label\";s:35:\"کوکی های ضروری سایت\";s:7:\"content\";s:2089:\"&lt;p&gt;این کوکی ها برای ارائه خدمات موجود از طریق وب سایت ما و استفاده از برخی از ویژگی های آن کاملاً ضروری هستند.&lt;br /&gt;&lt;br /&gt;از آن جا که این کوکی ها برای ارائه وب سایت کاملا ضروری هستند، رد کردن آن ها در عملکرد سایت ما تاثیر می گذارد. شما همیشه می توانید با تغییر تنظیمات مرورگر خود کوکی ها را بلاک یا حذف کنید و حتی همه ی کوکی ها این وب سایت را به صورت اجباری بلاک کنید. اما این همیشه باعث می شود هنگام مرور مجدد سایت، کوکی ها را بپذیرید یا رد کنید.&lt;br /&gt;&lt;br /&gt;اگر می خواهید از استفاده از کوکی ها خودداری کنید، کاملا احترام می گذاریم اما برای اینکه دوباره از شما درخواست نکنیم، به ما اجازه دهید تا یک کوکی برای این کار ذخیره کنیم. شما می توانید هر زمان که بخواهید انصراف دهید یا کوکی های دیگر را انتخاب کنید تا تجربه بهتری داشته باشید. اگر کوکی ها را رد کنید، ما تمام کوکی های تنظیم شده را در دامنه خود حذف خواهیم کرد.&lt;br /&gt;&lt;br /&gt;ما یک لیست از کوکی ها ذخیره شده کامپیوتر شما را در سایت خود ذخیره می کنیم، بنابراین می توانید بررسی کنید که ما چه مواردی را ذخیره کرده ایم. به دلایل امنیتی ما نمی توانیم کوکی های دامنه های دیگر را تغییر یا نمایش دهیم. شما می توانید این مورد را در تنظیمات امنیتی مرورگر خود بررسی کنید.&lt;/p&gt;[av_privacy_allow_cookies]&lt;br /&gt;&lt;br /&gt;[av_privacy_accept_essential_cookies]\";}i:2;a:2:{s:5:\"label\";s:43:\"کوکی های گوگل آنالیتیکس\";s:7:\"content\";s:699:\"&lt;p&gt;این کوکی ها اطلاعاتی را جمع آوری می کنند که به صورت کلی برای کمک به ما در درک نحوه استفاده از وب سایتمان یا میزان کارآیی کمپین های بازاریابی استفاده می شوند یا به ما در شخصی سازی وب سایت و ارتقا آن برای شما و همچنین افزایش تجربه کمک می کند.&lt;br&gt;&lt;br&gt;اگر نمی خواهید ما بازدید شما در سایت خودمان را ردیابی کنید می توانید آن را در مرورگر خود در این قسمت غیرفعال کنید:&lt;/p&gt; [av_privacy_google_tracking]\";}i:3;a:2:{s:5:\"label\";s:30:\"سایر خدمات خارجی\";s:7:\"content\";s:1037:\"&lt;p&gt;ما همچنین از سرویس های خارجی مانند وب فونت های گوگل، نقشه های گوگب و سرویس دهنده های ویدیو خارجی استفاده می کنیم. از آن جا گه این ارائه دهندگان ممکن است اطلاعات شخصی شما مانند آی پی را جمع آوری کنند، ما به شما این امکان را می دهیم تا آن ها را مسدود کنید. لطفا توجه داشته باشید که این ممکن است عملکرد و ظاهر سایت ما را به شدت کاهش دهد. با بارگیری مجدد صفحه، تغییرات اعمال می شوند.&lt;br /&gt;&lt;br /&gt;تنظیمات وب فونت گوگل&lt;/p&gt;[av_privacy_google_webfonts]&lt;p&gt;تنظیمات نقشه گوگل&lt;/p&gt;[av_privacy_google_maps]&lt;p&gt;تنظیمات reCaptcha گوگل:&lt;/p&gt;[av_privacy_google_recaptcha]&lt;p&gt;جاسازی ویدیو ویمئو یا یویتیوب:&lt;/p&gt;[av_privacy_video_embeds]\";}i:4;a:2:{s:5:\"label\";s:37:\"سیاست حفظ حریم خصوصی\";s:7:\"content\";s:213:\"شما می توانید جزئیات کوکی ها و تنظیمات حریم خصوصی ما را در برگه سیاست حفظ حریم خصوصی مطالعه کنید. &lt;br&gt;&lt;br&gt; [av_privacy_link]\";}}s:28:\"cookie_show_advanced_options\";s:8:\"disabled\";s:23:\"cookie_message_bar_only\";s:0:\"\";s:20:\"cookie_consent_badge\";s:0:\"\";s:18:\"cookie_auto_reload\";s:0:\"\";s:26:\"cookie_refuse_button_alert\";s:564:\"زمانی که همه ی کوکی ها را رد می کنید، ممکن است این سایت مطابق انتظارتان کار نکند. لطفا برگه تنظیمات ما را بررسی کنید و کوکی هایی که نمی خواهید از آن ها استفاده کنید را لغو کنید و سایر کوکی ها را بپذیرید. هر بار که یک تب یا پنجره جدید باز می کنید، این پیام به شما نمایش داده می شود.\n\nآیا مطمئنید که می خواهید ادامه دهید؟\";s:14:\"custom_cookies\";a:1:{i:0;a:5:{s:11:\"cookie_name\";s:0:\"\";s:11:\"cookie_path\";s:0:\"\";s:14:\"cookie_content\";s:0:\"\";s:16:\"cookie_info_desc\";s:0:\"\";s:21:\"cookie_compare_action\";s:0:\"\";}}s:10:\"seo_robots\";s:0:\"\";s:6:\"markup\";s:0:\"\";s:31:\"preprocess_shortcodes_in_header\";s:0:\"\";s:21:\"alb_seo_qualify_links\";s:8:\"disabled\";s:13:\"mailchimp_api\";s:36:\"57f29718e23b98e7bc4fa665eeb38052-us4\";s:22:\"mailchimp_verified_key\";s:36:\"57f29718e23b98e7bc4fa665eeb38052-us4\";s:9:\"analytics\";s:0:\"\";s:12:\"gmap_enabled\";s:0:\"\";s:8:\"gmap_api\";s:39:\"AIzaSyA4xpRRaxibrfi3mnhbS8xO6v3oFoHSa8U\";s:17:\"gmap_verify_state\";s:0:\"\";s:17:\"gmap_verified_key\";s:39:\"AIzaSyA4xpRRaxibrfi3mnhbS8xO6v3oFoHSa8U\";s:22:\"avia_recaptcha_version\";s:0:\"\";s:22:\"avia_recaptcha_pkey_v2\";s:0:\"\";s:22:\"avia_recaptcha_skey_v2\";s:0:\"\";s:28:\"avia_recaptcha_key_verify_v2\";s:0:\"\";s:22:\"avia_recaptcha_pkey_v3\";s:0:\"\";s:22:\"avia_recaptcha_skey_v3\";s:0:\"\";s:20:\"avia_recaptcha_score\";s:1:\"5\";s:20:\"avia_recaptcha_badge\";s:20:\"contact_only_message\";s:28:\"avia_recaptcha_key_verify_v3\";s:0:\"\";s:26:\"recaptcha_verified_keys_v2\";s:0:\"\";s:26:\"recaptcha_verified_keys_v3\";s:0:\"\";s:9:\"cart_icon\";s:19:\"always_display_menu\";s:17:\"shop_account_icon\";s:0:\"\";s:19:\"add_to_cart_message\";s:0:\"\";s:14:\"product_layout\";s:7:\"minimal\";s:15:\"product_gallery\";s:0:\"\";s:11:\"shop_banner\";s:0:\"\";s:17:\"shop_banner_image\";s:0:\"\";s:25:\"shop_banner_overlay_color\";s:7:\"#000000\";s:27:\"shop_banner_overlay_opacity\";s:3:\"0.5\";s:19:\"shop_banner_message\";s:0:\"\";s:25:\"shop_banner_message_color\";s:7:\"#ffffff\";s:18:\"shop_banner_global\";s:8:\"disabled\";s:17:\"avia-nonce-import\";s:10:\"fea8429a62\";s:22:\"upload_filter_checkbox\";s:8:\"disabled\";s:21:\"upload_keep_quick_css\";s:8:\"disabled\";s:18:\"upload_filter_tabs\";s:0:\"\";s:18:\"config_file_upload\";s:0:\"\";s:20:\"reset_options_button\";s:0:\"\";s:21:\"reset_filter_checkbox\";s:8:\"disabled\";s:20:\"reset_keep_quick_css\";s:8:\"disabled\";s:17:\"reset_filter_tabs\";s:0:\"\";s:20:\"alb_templates_upload\";s:0:\"\";s:15:\"iconfont_upload\";s:0:\"\";s:15:\"typefont_upload\";s:0:\"\";s:20:\"updates_envato_token\";s:0:\"\";s:26:\"updates_envato_token_state\";s:0:\"\";s:29:\"updates_envato_verified_token\";s:0:\"\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";s:19:\"updates_envato_info\";s:0:\"\";s:19:\"alb_dynamic_content\";s:37:\"alb_dynamic_content alb_custom_layout\";}s:8:\"avia_ext\";a:17:{s:22:\"avia_ext_intro_heading\";s:0:\"\";s:19:\"Leaflet_maps_header\";s:0:\"\";s:27:\"leaflet_maps_enable_feature\";s:0:\"\";s:28:\"Leaflet_maps_container_start\";s:0:\"\";s:25:\"leaflet_maps_plugin_check\";s:0:\"\";s:28:\"leaflet_maps_settings_header\";s:0:\"\";s:20:\"leaflet_maps_js_file\";s:0:\"\";s:21:\"leaflet_maps_css_file\";s:0:\"\";s:28:\"Leaflet_maps_container_close\";s:0:\"\";s:20:\"accessibility_header\";s:0:\"\";s:25:\"accessibility_theme_start\";s:0:\"\";s:32:\"accessibility_conformance_option\";s:0:\"\";s:25:\"accessibility_theme_close\";s:0:\"\";s:27:\"accessibility_header_extern\";s:0:\"\";s:29:\"accessibility_container_start\";s:0:\"\";s:26:\"accessibility_plugin_check\";s:0:\"\";s:29:\"accessibility_container_close\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("323", "avia_rewrite_flush", "1", "yes");
INSERT INTO `wp_options` VALUES("324", "avia_stylesheet_dir_writableenfold", "true", "yes");
INSERT INTO `wp_options` VALUES("325", "avia_stylesheet_existsenfold", "true", "yes");
INSERT INTO `wp_options` VALUES("326", "avia_stylesheet_dynamic_versionenfold", "67138e966b42f", "yes");
INSERT INTO `wp_options` VALUES("331", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("332", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("333", "action_scheduler_hybrid_store_demarkation", "8", "yes");
INSERT INTO `wp_options` VALUES("334", "schema-ActionScheduler_StoreSchema", "7.0.1689680589", "yes");
INSERT INTO `wp_options` VALUES("335", "schema-ActionScheduler_LoggerSchema", "3.0.1643610505", "yes");
INSERT INTO `wp_options` VALUES("338", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("339", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("340", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("341", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("342", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("343", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("344", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("345", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("346", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("347", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("348", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("349", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("350", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("351", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("352", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("353", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("354", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("355", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("356", "woocommerce_price_decimal_sep", "", "yes");
INSERT INTO `wp_options` VALUES("357", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("358", "woocommerce_shop_page_id", "265", "yes");
INSERT INTO `wp_options` VALUES("359", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("360", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("361", "woocommerce_placeholder_image", "8", "yes");
INSERT INTO `wp_options` VALUES("362", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("363", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("364", "woocommerce_enable_reviews", "no", "yes");
INSERT INTO `wp_options` VALUES("365", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("366", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("367", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("368", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("369", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("370", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("371", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("372", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("373", "woocommerce_stock_email_recipient", "info@khatamwp.dev", "no");
INSERT INTO `wp_options` VALUES("374", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("375", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("376", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("377", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("378", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("379", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("380", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("381", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("382", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("383", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("384", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("385", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("386", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("387", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("388", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("389", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("390", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("391", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("392", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("393", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("394", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("395", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("396", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("397", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("398", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("399", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("400", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("401", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("402", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("403", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("404", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("405", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("406", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("407", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("408", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("409", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("410", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("411", "woocommerce_email_from_name", "انفولد", "no");
INSERT INTO `wp_options` VALUES("412", "woocommerce_email_from_address", "info@khatamwp.dev", "no");
INSERT INTO `wp_options` VALUES("413", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("414", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("415", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("416", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("417", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("418", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("419", "woocommerce_cart_page_id", "266", "no");
INSERT INTO `wp_options` VALUES("420", "woocommerce_checkout_page_id", "267", "no");
INSERT INTO `wp_options` VALUES("421", "woocommerce_myaccount_page_id", "268", "no");
INSERT INTO `wp_options` VALUES("422", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("423", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("424", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("425", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("426", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("427", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("428", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("429", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("430", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("431", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("432", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("433", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("434", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("435", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("436", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("437", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("438", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("439", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("440", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `wp_options` VALUES("441", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("442", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("443", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("444", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("445", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("446", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("450", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("453", "woocommerce_version", "9.3.3", "yes");
INSERT INTO `wp_options` VALUES("454", "woocommerce_db_version", "9.3.3", "yes");
INSERT INTO `wp_options` VALUES("458", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"ox83T5MywWKqte9lLVgWbCEE0yeDeM30\";}", "yes");
INSERT INTO `wp_options` VALUES("460", "widget_bbp_login_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("461", "widget_bbp_views_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("462", "widget_bbp_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("463", "widget_bbp_forums_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("464", "widget_bbp_topics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("465", "widget_bbp_replies_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("466", "widget_bbp_stats_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("467", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("468", "widget_woocommerce_layered_nav_filters", "a:2:{i:2;a:1:{s:5:\"title\";s:25:\"فیلترهای فعال\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("469", "widget_woocommerce_layered_nav", "a:4:{i:2;a:4:{s:5:\"title\";s:31:\"فیلتر بر اساس نوع\";s:9:\"attribute\";s:0:\"\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}i:3;a:4:{s:5:\"title\";s:33:\"فیلتر بر اساس برند\";s:9:\"attribute\";s:0:\"\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}i:4;a:4:{s:5:\"title\";s:37:\"فیلتر بر اساس اندازه\";s:9:\"attribute\";s:0:\"\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("470", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("471", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("472", "widget_woocommerce_product_search", "a:2:{i:2;a:1:{s:5:\"title\";s:31:\"جست و جوی محصولات\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("473", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("474", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("475", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("476", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("477", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("478", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("482", "woocommerce_admin_install_timestamp", "1612072988", "yes");
INSERT INTO `wp_options` VALUES("486", "wc_admin_note_home_screen_feedback_homescreen_accessed", "1612072990", "yes");
INSERT INTO `wp_options` VALUES("488", "_bbp_db_version", "263", "yes");
INSERT INTO `wp_options` VALUES("489", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("490", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("491", "enfold_woo_settings_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("492", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("493", "shop_single_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("494", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("495", "avia_woocommerce_column_count", "3", "yes");
INSERT INTO `wp_options` VALUES("496", "avia_woocommerce_product_count", "15", "yes");
INSERT INTO `wp_options` VALUES("497", "woocommerce_single_image_crop", "no", "yes");
INSERT INTO `wp_options` VALUES("510", "av_alb_usage_cat_promo", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("511", "av_alb_usage_gift_wrap", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("512", "av_alb_usage_av_prodgallery", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("513", "av_alb_usage_prod_promo", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("514", "av_alb_usage_av_wc_a2cbutton", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("515", "av_alb_usage_av_wc_prod_cats", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("516", "av_alb_usage_av_sale_productgrid", "a:1:{i:3613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("517", "av_alb_usage_av_product_img", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("518", "av_alb_usage_wc_product_img_modern", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("519", "av_alb_usage_ss_product_modern", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("520", "av_alb_usage_wc_price", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("521", "av_alb_usage_wc_price_header", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("522", "av_alb_usage_av_wc_shortdesc", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("523", "av_alb_usage_av_wc_single", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("524", "av_alb_usage_wc_sku", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("525", "av_alb_usage_av_wc_prod_tags", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("526", "av_alb_usage_prod_header", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("527", "av_alb_usage_av_wcalert", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("528", "av_alb_usage_av_wctracking", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("529", "av_alb_usage_sold_count", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("530", "av_alb_usage_ss_wc_artframe", "a:1:{i:3498;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("531", "av_alb_usage_av_product_button", "a:1:{i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("532", "av_alb_usage_av_product_info", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("533", "av_alb_usage_av_product_review", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("534", "av_alb_usage_av_product_tabs", "a:1:{i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("535", "av_alb_usage_av_product_upsells", "a:1:{i:1101;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("536", "av_alb_usage_av_product_meta", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("537", "av_alb_usage_av_product_price", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("538", "av_alb_usage_av_productslider", "a:2:{i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}i:3613;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("539", "av_alb_usage_av_productgrid", "a:1:{i:1113;a:2:{s:7:\"version\";s:3:\"1.0\";s:5:\"count\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("540", "av_alb_usage_av_productlist", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("541", "av_demo_content_imported", "1", "yes");
INSERT INTO `wp_options` VALUES("544", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("568", "avia_custom_type_fonts", "a:1:{s:16:\"iransanswebfanum\";a:4:{s:6:\"folder\";s:45:\"dynamic_avia/avia_type_fonts/iransanswebfanum\";s:6:\"config\";a:2:{i:0;a:6:{s:4:\"name\";s:16:\"IRANSansWebFaNum\";s:5:\"style\";s:6:\"normal\";s:6:\"weight\";i:400;s:8:\"filename\";s:22:\"iransansweb(fanum).ttf\";s:9:\"full_name\";s:16:\"IRANSansWebFaNum\";s:5:\"files\";a:4:{s:3:\"eot\";s:22:\"iransansweb(fanum).eot\";s:3:\"ttf\";s:22:\"iransansweb(fanum).ttf\";s:4:\"woff\";s:23:\"iransansweb(fanum).woff\";s:5:\"woff2\";s:24:\"iransansweb(fanum).woff2\";}}s:3:\"key\";s:16:\"iransanswebfanum\";}s:10:\"origin_url\";s:43:\"http://localhost/enfold/wp-content/uploads/\";s:10:\"origin_dir\";s:41:\"D:\\laragon\\www\\enfold/wp-content/uploads/\";}}", "yes");
INSERT INTO `wp_options` VALUES("616", "ls-store-last-updated", "1629623534", "yes");
INSERT INTO `wp_options` VALUES("617", "ls-store-data", "a:4:{s:12:\"last_updated\";s:10:\"2020-11-18\";s:7:\"sliders\";a:93:{s:15:\"back-to-the-80s\";a:7:{s:8:\"released\";s:10:\"2020-09-29\";s:4:\"name\";s:15:\"Back To The 80s\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:54:\"new,premium,sliders,parallax,loop,blend,specialeffects\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/back-to-the-80s/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/back-to-the-80s.jpg\";}s:17:\"love-with-flowers\";a:7:{s:8:\"released\";s:10:\"2020-07-28\";s:4:\"name\";s:17:\"LOVE with Flowers\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:38:\"new,free,landing,sliders,parallax,loop\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/love-with-flowers/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/love-with-flowers.jpg\";}s:6:\"people\";a:7:{s:8:\"released\";s:10:\"2020-07-13\";s:4:\"name\";s:6:\"People\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:47:\"new,premium,landing,blend,static,specialeffects\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/people/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/people.jpg\";}s:16:\"music-is-my-life\";a:7:{s:8:\"released\";s:10:\"2020-07-06\";s:4:\"name\";s:16:\"Music Is My Life\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:24:\"new,premium,slider,blend\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/music-is-my-life/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/music-is-my-life.jpg\";}s:21:\"product-showcase-dark\";a:7:{s:8:\"released\";s:10:\"2020-07-01\";s:4:\"name\";s:25:\"Product Showcase – Dark\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:18:\"new,premium,slider\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/sliders/product-showcase-dark/\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-dark.jpg\";}s:13:\"team-showcase\";a:7:{s:8:\"released\";s:10:\"2020-06-24\";s:4:\"name\";s:13:\"Team Showcase\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:25:\"new,premium,slider,static\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/team-showcase/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/team-showcase.jpg\";}s:14:\"furniture-shop\";a:7:{s:8:\"released\";s:10:\"2020-06-09\";s:4:\"name\";s:14:\"Furniture Shop\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:27:\"new,premium,landing,website\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/furniture-shop/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-shop.jpg\";}s:14:\"product-banner\";a:7:{s:8:\"released\";s:10:\"2020-06-02\";s:4:\"name\";s:14:\"Product Banner\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/product-banner/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-banner.jpg\";}s:19:\"architecture-slider\";a:7:{s:8:\"released\";s:10:\"2020-05-26\";s:4:\"name\";s:19:\"Architecture Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/architecture-slider/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/architecture-slider.jpg\";}s:22:\"product-showcase-light\";a:7:{s:8:\"released\";s:10:\"2020-05-18\";s:4:\"name\";s:26:\"Product Showcase – Light\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:25:\"new,premium,slider,static\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/product-showcase-light/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/product-showcase-light.jpg\";}s:12:\"fashion-shop\";a:7:{s:8:\"released\";s:10:\"2020-05-12\";s:4:\"name\";s:12:\"Fashion Shop\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:22:\"new,free,slider,static\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/fashion-shop/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/fashion-shop.jpg\";}s:12:\"pixel-agency\";a:7:{s:8:\"released\";s:10:\"2020-05-05\";s:4:\"name\";s:12:\"PIXEL Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:55:\"new,premium,fullwidth,landing,website,text,popup,static\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/pixel-agency/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/pixel-agency.jpg\";}s:11:\"mode-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-28\";s:4:\"name\";s:11:\"Mode Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:30:\"new,free,fullwidth,slider,text\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/mode-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mode-slider.jpg\";}s:13:\"mountain-bike\";a:7:{s:8:\"released\";s:10:\"2020-04-22\";s:4:\"name\";s:13:\"Mountain Bike\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.11.1\";s:6:\"groups\";s:45:\"premium,new,fullsize,landing,pack,static,text\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/mountain-bike/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/mountain-bike.jpg\";}s:18:\"aerial-photography\";a:7:{s:8:\"released\";s:10:\"2020-04-14\";s:4:\"name\";s:18:\"Aerial Photography\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,new,slider,static,text,kenburns\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/aerial-photography/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/aerial-photography.jpg\";}s:24:\"simple-fullscreen-slider\";a:7:{s:8:\"released\";s:10:\"2020-04-07\";s:4:\"name\";s:24:\"Simple Fullscreen Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:46:\"free,new,fullsize,landing,static,text,kenburns\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/sliders/simple-fullscreen-slider/\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-fullscreen-slider.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/#covid-19-notification\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/popups/#top-bar-notice\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-snow-globe.jpg\";}s:9:\"xmas-2019\";a:7:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:9:\"Xmas 2019\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:32:\"free,parallax,slider,loop,filter\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/xmas-2019/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas-2019.jpg\";}s:18:\"creative-portraits\";a:7:{s:8:\"released\";s:10:\"2019-12-09\";s:4:\"name\";s:18:\"Creative Portraits\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/creative-portraits/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-portraits.jpg\";}s:13:\"parallax-city\";a:7:{s:8:\"released\";s:10:\"2019-12-02\";s:4:\"name\";s:13:\"Parallax City\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:58:\"premium,landing,pack,parallax,text,blend,fullwidth,website\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/parallax-city/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/parallax-city.jpg\";}s:10:\"cybertruck\";a:7:{s:8:\"released\";s:10:\"2019-11-28\";s:4:\"name\";s:10:\"Cybertruck\";s:7:\"premium\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:39:\"premium,fullsize,landing,specialeffects\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/cybertruck/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/cybertruck.jpg\";}s:17:\"summer-collection\";a:7:{s:8:\"released\";s:10:\"2019-11-21\";s:4:\"name\";s:17:\"Summer Collection\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:21:\"free,fullwidth,slider\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/summer-collection/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/summer-collection.jpg\";}s:18:\"nature-slider-pack\";a:7:{s:8:\"released\";s:10:\"2019-11-14\";s:4:\"name\";s:18:\"Nature Slider PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.9.0\";s:6:\"groups\";s:62:\"premium,text,blend,fullwidth,media,landing,packs,popup,website\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/nature-slider-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/nature-slider-pack.jpg\";}s:20:\"catering-xmas-slider\";a:7:{s:8:\"released\";s:10:\"2017-12-22\";s:4:\"name\";s:25:\"Catering Christmas Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:32:\"premium,static,text,blend,slider\";s:3:\"url\";s:72:\"https://layerslider.kreaturamedia.com/sliders/catering-christmas-slider/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/catering-xmas-slider.jpg\";}s:20:\"discover-the-details\";a:7:{s:8:\"released\";s:10:\"2017-12-19\";s:4:\"name\";s:20:\"Discover the Details\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,loop,parallax,blendmode,specialeffects,slider\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/discover-the-details/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/discover-the-details.jpg\";}s:10:\"rainforest\";a:7:{s:8:\"released\";s:10:\"2017-12-17\";s:4:\"name\";s:10:\"Rainforest\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:57:\"free,loop,filter,blendmode,fullsize,specialeffects,slider\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/rainforest/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/rainforest.jpg\";}s:30:\"ecommerce-global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-12-15\";s:4:\"name\";s:30:\"eCommerce Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:26:\"premium,experiments,slider\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/sliders/ecommerce-global-hover-example/\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce-global-hover-example.jpg\";}s:20:\"3d-canyon-experience\";a:7:{s:8:\"released\";s:10:\"2017-12-13\";s:4:\"name\";s:20:\"3D Canyon Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:40:\"premium,parallax,experiments,text,slider\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/3d-canyon-experience/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/3d-canyon-experience.jpg\";}s:14:\"vintage-photos\";a:7:{s:8:\"released\";s:10:\"2017-12-08\";s:4:\"name\";s:14:\"Vintage Photos\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.6.0\";s:6:\"groups\";s:50:\"premium,fullsize,loop,filter,specialeffects,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/vintage-photos/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/vintage-photos.jpg\";}s:8:\"aquarium\";a:7:{s:8:\"released\";s:10:\"2017-12-04\";s:4:\"name\";s:8:\"Aquarium\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:71:\"premium,parallax,fullsize,loop,filter,experiments,specialeffects,slider\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/aquarium/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/aquarium.jpg\";}s:16:\"what-is-the-time\";a:7:{s:8:\"released\";s:10:\"2017-08-25\";s:4:\"name\";s:17:\"What is the time?\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:54:\"premium,parallax,text,blendmode,experiments,api,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/what-is-the-time/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/what-is-the-time.jpg\";}s:18:\"personal-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-23\";s:4:\"name\";s:18:\"Personal Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,text,parallax,packs,website\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/personal-page-pack/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/personal-page-pack.jpg\";}s:19:\"marketing-page-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-21\";s:4:\"name\";s:19:\"Marketing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:69:\"premium,fullsize,fullwidth,landing,parallax,static,loop,packs,website\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/marketing-page-pack/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/marketing-page-pack.jpg\";}s:14:\"dynamic-slider\";a:7:{s:8:\"released\";s:10:\"2017-08-18\";s:4:\"name\";s:14:\"Dynamic Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:32:\"premium,fullwidth,landing,static\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/dynamic-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-slider.jpg\";}s:14:\"colorful-cases\";a:7:{s:8:\"released\";s:10:\"2017-08-16\";s:4:\"name\";s:14:\"Colorful Cases\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:50:\"premium,text,loop,parallax,static,blendmode,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/colorful-cases/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/colorful-cases.jpg\";}s:16:\"beauty-shop-pack\";a:7:{s:8:\"released\";s:10:\"2017-08-14\";s:4:\"name\";s:16:\"Beauty Shop PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:44:\"premium,fullwidth,text,landing,packs,website\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beauty-shop-pack/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beauty-shop-pack.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/popups/#discount-popup\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:17:\"premium,popup,api\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#social-share-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/popups/#popup-guide-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,loop\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:22:\"premium,popup,kenburns\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:20:\"premium,popup,static\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/popups/#popup-modal-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,experiments,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:43:\"premium,popup,experiments,fullsize,parallax\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:25:\"premium,popup,experiments\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#conversation-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}s:20:\"global-hover-example\";a:7:{s:8:\"released\";s:10:\"2017-05-02\";s:4:\"name\";s:20:\"Global Hover Example\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.4.0\";s:6:\"groups\";s:55:\"premium,experiments,specialeffects,parallax,text,slider\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/sliders/global-hover-example/\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/global-hover-example.jpg\";}s:10:\"gastronomy\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:10:\"Gastronomy\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.2.2\";s:6:\"groups\";s:35:\"premium,kenburns,filter,text,slider\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/gastronomy/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/gastronomy.jpg\";}s:13:\"police-lights\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:13:\"Police Lights\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:50:\"free,specialeffects,loop,blendmode,parallax,slider\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/police-lights/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/police-lights.jpg\";}s:16:\"beautiful-sunset\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Beautiful Sunset\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:41:\"free,specialeffects,loop,blendmode,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/beautiful-sunset/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/beautiful-sunset.jpg\";}s:23:\"blend-mode-experiment-1\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:23:\"Blend Mode Experiment 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:67:\"free,specialeffects,text,blendmode,experiments,loop,parallax,slider\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/sliders/blend-mode-experiment-1/\";s:7:\"preview\";s:84:\"https://repository.kreaturamedia.com/v4/sliders/packages/blend-mode-experiment-1.jpg\";}s:16:\"flying-banners-2\";a:7:{s:8:\"released\";s:10:\"2017-03-29\";s:4:\"name\";s:16:\"Flying Banners 2\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"premium,parallax,specialeffects,fullsize,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-2/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-2.jpg\";}s:14:\"layerslider-v6\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:14:\"LayerSlider v6\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.6\";s:6:\"groups\";s:75:\"premium,specialeffects,parallax,fullsize,landing,loop,text,media,api,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v6/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/layerslider-v6.jpg\";}s:16:\"flying-banners-1\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:16:\"Flying Banners 1\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:45:\"free,parallax,loop,text,specialeffects,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/flying-banners-1/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/flying-banners-1.jpg\";}s:18:\"anniversary-slider\";a:7:{s:8:\"released\";s:10:\"2017-03-08\";s:4:\"name\";s:18:\"Anniversary Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:47:\"free,parallax,experiments,specialeffects,slider\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/anniversary-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/anniversary-slider.jpg\";}s:7:\"origami\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:7:\"Origami\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:61:\"premium,experiments,specialeffects,3dtransition,slider,addons\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/origami/\";s:7:\"preview\";s:68:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami.jpg\";}s:17:\"origami-buildings\";a:7:{s:8:\"released\";s:10:\"2016-12-07\";s:4:\"name\";s:17:\"Origami Buildings\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.1.0\";s:6:\"groups\";s:70:\"premium,experiments,specialeffects,kenburns,3dtransition,slider,addons\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/origami-buildings/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/origami-buildings.jpg\";}s:17:\"autumn-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:17:\"Autumn Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:52:\"experiments,free,loop,parallax,specialeffects,slider\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/sliders/autumn-experiment/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/autumn-experiment.jpg\";}s:28:\"features-parallax-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:32:\"Features | A Parallax Experiment\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:47:\"experiments,free,parallax,specialeffects,slider\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/sliders/features-parallax-experiment/\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/features-parallax-experiment.jpg\";}s:16:\"furniture-slider\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:16:\"Furniture Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:40:\"fullwidth,parallax,premium,static,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/furniture-slider/\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/furniture-slider.jpg\";}s:15:\"room-experiment\";a:7:{s:8:\"released\";s:10:\"2016-11-28\";s:4:\"name\";s:15:\"Room Experiment\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.6\";s:6:\"groups\";s:72:\"api,experiments,media,parallax,premium,specialeffects,static,text,slider\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/room-experiment/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/room-experiment.jpg\";}s:11:\"drag-n-drop\";a:6:{s:4:\"name\";s:11:\"Drag & Drop\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:44:\"premium,fullwidth,specialeffects,text,slider\";s:3:\"url\";s:58:\"https://layerslider.kreaturamedia.com/sliders/drag-n-drop/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/drag-n-drop.jpg\";}s:10:\"headphones\";a:6:{s:4:\"name\";s:10:\"Headphones\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:21:\"premium,static,slider\";s:3:\"url\";s:57:\"https://layerslider.kreaturamedia.com/sliders/headphones/\";s:7:\"preview\";s:71:\"https://repository.kreaturamedia.com/v4/sliders/packages/headphones.jpg\";}s:14:\"play-by-scroll\";a:6:{s:4:\"name\";s:19:\"Play By Scroll demo\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.4\";s:6:\"groups\";s:80:\"premium,fullsize,text,experiments,specialeffects,playbyscroll,loop,slider,addons\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/play-by-scroll/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/play-by-scroll.jpg\";}s:3:\"sky\";a:6:{s:4:\"name\";s:14:\"Sky Experience\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:70:\"premium,fullwidth,text,experiments,parallax,specialeffects,loop,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/sky-experience/\";s:7:\"preview\";s:64:\"https://repository.kreaturamedia.com/v4/sliders/packages/sky.jpg\";}s:9:\"halloween\";a:6:{s:4:\"name\";s:16:\"Happy Halloween!\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"6.0.3\";s:6:\"groups\";s:42:\"free,fullsize,text,experiments,loop,slider\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/happy-halloween/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/halloween.jpg\";}s:15:\"creative-agency\";a:6:{s:4:\"name\";s:6:\"Agency\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:49:\"premium,fullsize,kenburns,parallax,landing,filter\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/creative-agency/\";s:7:\"preview\";s:76:\"https://repository.kreaturamedia.com/v4/sliders/packages/creative-agency.jpg\";}s:18:\"interactive-slider\";a:6:{s:4:\"name\";s:18:\"Interactive Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,kenburns,text,landing\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/interactive-slider/\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/interactive-slider.jpg\";}s:9:\"ecommerce\";a:6:{s:4:\"name\";s:9:\"eCommerce\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:56:\"https://layerslider.kreaturamedia.com/sliders/ecommerce/\";s:7:\"preview\";s:70:\"https://repository.kreaturamedia.com/v4/sliders/packages/ecommerce.jpg\";}s:17:\"landing-page-pack\";a:6:{s:4:\"name\";s:17:\"Landing Page PACK\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:62:\"premium,fullsize,fullwidth,landing,parallax,text,packs,website\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/landing-page/\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/landing-page-pack.jpg\";}s:6:\"hiking\";a:6:{s:4:\"name\";s:6:\"Hiking\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:53:\"https://layerslider.kreaturamedia.com/sliders/hiking/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/hiking.jpg\";}s:12:\"movie-slider\";a:6:{s:4:\"name\";s:12:\"Movie Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/movie-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/movie-slider.jpg\";}s:12:\"photo-studio\";a:6:{s:4:\"name\";s:12:\"Photo Studio\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:70:\"premium,fullsize,filter,text,parallax,specialeffects,blendmode,landing\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/photo-studio/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/photo-studio.jpg\";}s:5:\"shoes\";a:6:{s:4:\"name\";s:5:\"Shoes\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:42:\"premium,fullwidth,parallax,carousel,slider\";s:3:\"url\";s:52:\"https://layerslider.kreaturamedia.com/sliders/shoes/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/shoes.jpg\";}s:11:\"mini-cooper\";a:6:{s:4:\"name\";s:18:\"Mini Cooper Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:47:\"premium,fullsize,parallax,specialeffects,slider\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/sliders/mini-cooper-slider/\";s:7:\"preview\";s:72:\"https://repository.kreaturamedia.com/v4/sliders/packages/mini-cooper.jpg\";}s:4:\"xmas\";a:6:{s:4:\"name\";s:16:\"Merry Christmas!\";s:7:\"premium\";b:0;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:64:\"free,parallax,filter,experiments,specialeffects,text,loop,slider\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/merry-christmas/\";s:7:\"preview\";s:65:\"https://repository.kreaturamedia.com/v4/sliders/packages/xmas.jpg\";}s:5:\"clock\";a:6:{s:4:\"name\";s:32:\"Vintage Clock | shows valid time\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:44:\"premium,fullsize,api,experiments,loop,slider\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/vintage-clock/\";s:7:\"preview\";s:66:\"https://repository.kreaturamedia.com/v4/sliders/packages/clock.jpg\";}s:8:\"car-show\";a:6:{s:4:\"name\";s:8:\"Car Show\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:45:\"premium,fullwidth,experiments,api,loop,slider\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/car-show/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/car-show.jpg\";}s:8:\"carousel\";a:6:{s:4:\"name\";s:8:\"Carousel\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:20:\"free,carousel,slider\";s:3:\"url\";s:55:\"https://layerslider.kreaturamedia.com/sliders/carousel/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/carousel.jpg\";}s:14:\"fancy-parallax\";a:6:{s:4:\"name\";s:21:\"Fancy Parallax Slider\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:33:\"premium,fullwidth,parallax,slider\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/parallax-slider/\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/fancy-parallax.jpg\";}s:13:\"simple-slider\";a:6:{s:4:\"name\";s:13:\"Simple Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/sliders/simple-slider/\";s:7:\"preview\";s:74:\"https://repository.kreaturamedia.com/v4/sliders/packages/simple-slider.jpg\";}s:12:\"image-slider\";a:6:{s:4:\"name\";s:12:\"Image Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/sliders/image-slideshow/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/image-slider.jpg\";}s:19:\"client-testimonials\";a:6:{s:4:\"name\";s:19:\"Client Testimonials\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:24:\"premium,fullwidth,slider\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/sliders/client-testimonials/\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/client-testimonials.jpg\";}s:8:\"fixed-bg\";a:6:{s:4:\"name\";s:16:\"Fixed Background\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"6.0.0\";s:6:\"groups\";s:30:\"premium,fullwidth,media,slider\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/sliders/fixed-background/\";s:7:\"preview\";s:69:\"https://repository.kreaturamedia.com/v4/sliders/packages/fixed-bg.jpg\";}s:22:\"dynamic-content-slider\";a:6:{s:4:\"name\";s:22:\"Dynamic Content Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:11:\"free,slider\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/sliders/dynamic-content-slider/\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/dynamic-content-slider.jpg\";}s:6:\"old-3d\";a:6:{s:4:\"name\";s:14:\"LayerSlider v4\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:30:\"free,3dtransition,media,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/3d-demo-slider/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/old-3d.jpg\";}s:2:\"v5\";a:6:{s:4:\"name\";s:14:\"LayerSlider v5\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:26:\"free,parallax,media,slider\";s:3:\"url\";s:61:\"https://layerslider.kreaturamedia.com/sliders/layerslider-v5/\";s:7:\"preview\";s:63:\"https://repository.kreaturamedia.com/v4/sliders/packages/v5.jpg\";}s:12:\"video-slider\";a:6:{s:4:\"name\";s:12:\"Video Slider\";s:7:\"premium\";b:0;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:17:\"free,media,slider\";s:3:\"url\";s:59:\"https://layerslider.kreaturamedia.com/sliders/video-slider/\";s:7:\"preview\";s:73:\"https://repository.kreaturamedia.com/v4/sliders/packages/video-slider.jpg\";}s:6:\"resort\";a:6:{s:4:\"name\";s:6:\"Resort\";s:7:\"premium\";b:1;s:8:\"requires\";s:5:\"5.0.0\";s:6:\"groups\";s:14:\"premium,slider\";s:3:\"url\";s:54:\"https://layerslider.kreaturamedia.com/sliders/restort/\";s:7:\"preview\";s:67:\"https://repository.kreaturamedia.com/v4/sliders/packages/resort.jpg\";}}s:15:\"kreatura-popups\";a:16:{s:17:\"black-friday-2020\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday 2020\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/popups/#black-friday-2020\";s:7:\"preview\";s:78:\"https://repository.kreaturamedia.com/v4/sliders/packages/black-friday-2020.jpg\";}s:21:\"covid-19-notification\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:21:\"COVID-19 Notification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/#covid-19-notification\";s:7:\"preview\";s:82:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-notification.jpg\";}s:19:\"covid-19-bottom-bar\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:19:\"COVID-19 Bottom Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/#covid-19-bottom-bar\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/covid-19-bottom-bar.jpg\";}s:14:\"top-bar-notice\";a:8:{s:8:\"released\";s:10:\"2020-04-01\";s:4:\"name\";s:14:\"Top Bar Notice\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:17:\"premium,new,popup\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/popups/#top-bar-notice\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/top-bar-notice.jpg\";}s:20:\"christmas-snow-globe\";a:8:{s:8:\"released\";s:10:\"2019-12-19\";s:4:\"name\";s:20:\"Christmas Snow Globe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:34:\"premium,parallax,popup,loop,filter\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/popups/#christmas-snow-globe\";s:7:\"preview\";s:81:\"https://repository.kreaturamedia.com/v4/sliders/packages/christmas-snow-globe.jpg\";}s:14:\"discount-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-10\";s:4:\"name\";s:14:\"Discount Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:13:\"premium,popup\";s:3:\"url\";s:60:\"https://layerslider.kreaturamedia.com/popups/#discount-popup\";s:7:\"preview\";s:75:\"https://repository.kreaturamedia.com/v4/sliders/packages/discount-popup.jpg\";}s:18:\"social-share-popup\";a:8:{s:8:\"released\";s:10:\"2017-12-06\";s:4:\"name\";s:18:\"Social Share Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.5\";s:6:\"groups\";s:17:\"premium,popup,api\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#social-share-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/social-share-popup.jpg\";}s:16:\"popup-guide-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Guide Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/popups/#popup-guide-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-guide-demo.jpg\";}s:18:\"popup-welcome-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Welcome Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-welcome-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-welcome-demo.jpg\";}s:22:\"popup-transparent-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:22:\"Popup Transparent Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:27:\"premium,popup,parallax,loop\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/#popup-transparent-demo\";s:7:\"preview\";s:83:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-transparent-demo.jpg\";}s:18:\"popup-sidebar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Sidebar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:40:\"premium,popup,experiments,blendmode,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-sidebar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-sidebar-demo.jpg\";}s:19:\"popup-photo-gallery\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:19:\"Popup Photo Gallery\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:22:\"premium,popup,kenburns\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/#popup-photo-gallery\";s:7:\"preview\";s:80:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-photo-gallery.jpg\";}s:16:\"popup-modal-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:16:\"Popup Modal Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:20:\"premium,popup,static\";s:3:\"url\";s:62:\"https://layerslider.kreaturamedia.com/popups/#popup-modal-demo\";s:7:\"preview\";s:77:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-modal-demo.jpg\";}s:18:\"popup-infobar-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Popup Infobar Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:30:\"premium,popup,experiments,text\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#popup-infobar-demo\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-infobar-demo.jpg\";}s:24:\"popup-fullsize-desk-demo\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:24:\"Popup Fullsize Desk Demo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:43:\"premium,popup,experiments,fullsize,parallax\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/#popup-fullsize-desk-demo\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/popup-fullsize-desk-demo.jpg\";}s:18:\"conversation-popup\";a:8:{s:8:\"released\";s:10:\"2017-06-11\";s:4:\"name\";s:18:\"Conversation Popup\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:5:\"6.5.0\";s:6:\"groups\";s:25:\"premium,popup,experiments\";s:3:\"url\";s:64:\"https://layerslider.kreaturamedia.com/popups/#conversation-popup\";s:7:\"preview\";s:79:\"https://repository.kreaturamedia.com/v4/sliders/packages/conversation-popup.jpg\";}}s:19:\"webshopworks-popups\";a:67:{s:17:\"black-friday-sale\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:17:\"Black Friday Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:76:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-sale\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-sale.jpg\";}s:16:\"black-friday-bar\";a:8:{s:8:\"released\";s:10:\"2020-11-18\";s:4:\"name\";s:16:\"Black Friday Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.11.2\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-bar\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-bar.jpg\";}s:16:\"reveal-your-deal\";a:7:{s:4:\"name\";s:16:\"Reveal Your Deal\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:31:\"sales,coupon,seasonal,promotion\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#reveal-your-deal\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/reveal-your-deal.jpg\";}s:27:\"christmas-sidebar-countdown\";a:7:{s:4:\"name\";s:27:\"Christmas Sidebar Countdown\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:86:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#christmas-sidebar-countdown\";s:7:\"preview\";s:108:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sidebar-countdown.jpg\";}s:20:\"christmas-sale-santa\";a:7:{s:4:\"name\";s:20:\"Christmas Sale Santa\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:79:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#christmas-sale-santa\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sale-santa.jpg\";}s:11:\"santa-walks\";a:7:{s:4:\"name\";s:11:\"Santa Walks\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#santa-walks\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/santa-walks.jpg\";}s:14:\"christmas-sale\";a:7:{s:4:\"name\";s:14:\"Christmas Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"seasonal,sales\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#christmas-sale\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-sale.jpg\";}s:12:\"gift-voucher\";a:7:{s:4:\"name\";s:12:\"Gift Voucher\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"newsletter,coupon,sales,seasonal\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#gift-voucher\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/gift-voucher.jpg\";}s:16:\"christmas-topbar\";a:7:{s:4:\"name\";s:17:\"Christmas Top Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#christmas-topbar\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/christmas-topbar.jpg\";}s:14:\"black-friday-9\";a:7:{s:4:\"name\";s:15:\"Black Friday #9\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-9\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-9.jpg\";}s:14:\"black-friday-8\";a:7:{s:4:\"name\";s:15:\"Black Friday #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-8\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-8.jpg\";}s:20:\"black-friday-premium\";a:7:{s:4:\"name\";s:20:\"Black Friday Premium\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:79:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-premium\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-premium.jpg\";}s:14:\"black-friday-7\";a:7:{s:4:\"name\";s:15:\"Black Friday #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-7\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-7.jpg\";}s:11:\"todays-sale\";a:7:{s:4:\"name\";s:14:\"Today’s Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#todays-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/todays-sale.jpg\";}s:9:\"sign-up-6\";a:7:{s:4:\"name\";s:10:\"Sign Up #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-6\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-6.jpg\";}s:9:\"sign-up-7\";a:7:{s:4:\"name\";s:10:\"Sign Up #7\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-7\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-7.jpg\";}s:9:\"sign-up-8\";a:7:{s:4:\"name\";s:10:\"Sign Up #8\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-8\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-8.jpg\";}s:20:\"get-in-touch-with-us\";a:7:{s:4:\"name\";s:20:\"Get in Touch with Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:79:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#get-in-touch-with-us\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/get-in-touch-with-us.jpg\";}s:17:\"top-bar-subscribe\";a:7:{s:4:\"name\";s:17:\"Top Bar Subscribe\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:76:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#top-bar-subscribe\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/top-bar-subscribe.jpg\";}s:7:\"sign-up\";a:7:{s:4:\"name\";s:7:\"Sign Up\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:66:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up\";s:7:\"preview\";s:88:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up.jpg\";}s:14:\"black-friday-6\";a:7:{s:4:\"name\";s:15:\"Black Friday #6\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-6\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-6.jpg\";}s:14:\"black-friday-5\";a:7:{s:4:\"name\";s:15:\"Black Friday #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-5\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-5.jpg\";}s:14:\"black-friday-4\";a:7:{s:4:\"name\";s:15:\"Black Friday #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-4\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-4.jpg\";}s:14:\"black-friday-1\";a:7:{s:4:\"name\";s:15:\"Black Friday #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-1\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-1.jpg\";}s:17:\"spring-super-sale\";a:7:{s:4:\"name\";s:17:\"Spring Super Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:76:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#spring-super-sale\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/spring-super-sale.jpg\";}s:8:\"discount\";a:7:{s:4:\"name\";s:8:\"Discount\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#discount\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount.jpg\";}s:9:\"sign-up-3\";a:7:{s:4:\"name\";s:10:\"Sign Up #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-3\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-3.jpg\";}s:22:\"sidebar-countdown-sale\";a:7:{s:4:\"name\";s:22:\"Sidebar Countdown Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:22:\"sales,promotion,coupon\";s:3:\"url\";s:81:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sidebar-countdown-sale\";s:7:\"preview\";s:103:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sidebar-countdown-sale.jpg\";}s:15:\"countdown-timer\";a:7:{s:4:\"name\";s:15:\"Countdown Timer\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:14:\"sales,seasonal\";s:3:\"url\";s:74:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#countdown-timer\";s:7:\"preview\";s:96:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/countdown-timer.jpg\";}s:10:\"discount-5\";a:7:{s:4:\"name\";s:11:\"Discount #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#discount-5\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-5.jpg\";}s:10:\"discount-2\";a:7:{s:4:\"name\";s:10:\"Discount 2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#discount-2\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-2.jpg\";}s:11:\"subscribe-5\";a:7:{s:4:\"name\";s:12:\"Subscribe #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:23:\"newsletter,sales,coupon\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#subscribe-5\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-5.jpg\";}s:9:\"mega-sale\";a:7:{s:4:\"name\";s:9:\"Mega Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#mega-sale\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mega-sale.jpg\";}s:10:\"discount-4\";a:7:{s:4:\"name\";s:10:\"Discount 4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:15:\"sales,promotion\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#discount-4\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-4.jpg\";}s:8:\"info-bar\";a:7:{s:4:\"name\";s:8:\"Info Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#info-bar\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/info-bar.jpg\";}s:11:\"subscribe-4\";a:7:{s:4:\"name\";s:12:\"Subscribe #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:20:\"newsletter,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#subscribe-4\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-4.jpg\";}s:10:\"contact-us\";a:7:{s:4:\"name\";s:10:\"Contact Us\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#contact-us\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/contact-us.jpg\";}s:10:\"discount-3\";a:7:{s:4:\"name\";s:10:\"Discount 3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:5:\"sales\";s:3:\"url\";s:69:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#discount-3\";s:7:\"preview\";s:91:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/discount-3.jpg\";}s:9:\"sign-up-4\";a:7:{s:4:\"name\";s:10:\"Sign Up #4\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-4\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-4.jpg\";}s:4:\"mail\";a:7:{s:4:\"name\";s:4:\"Mail\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:63:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#mail\";s:7:\"preview\";s:85:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mail.jpg\";}s:18:\"kitchen-appliances\";a:7:{s:4:\"name\";s:18:\"Kitchen Appliances\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#kitchen-appliances\";s:7:\"preview\";s:99:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/kitchen-appliances.jpg\";}s:11:\"subscribe-3\";a:7:{s:4:\"name\";s:12:\"Subscribe #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#subscribe-3\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-3.jpg\";}s:6:\"ticket\";a:7:{s:4:\"name\";s:6:\"Ticket\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:12:\"sales,coupon\";s:3:\"url\";s:65:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#ticket\";s:7:\"preview\";s:87:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/ticket.jpg\";}s:8:\"hey-wait\";a:7:{s:4:\"name\";s:10:\"Hey, wait!\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"exit-intent,newsletter,sales,coupon\";s:3:\"url\";s:67:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#hey-wait\";s:7:\"preview\";s:89:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/hey-wait.jpg\";}s:9:\"subscribe\";a:7:{s:4:\"name\";s:12:\"Subscribe #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#subscribe\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe.jpg\";}s:11:\"subscribe-2\";a:7:{s:4:\"name\";s:12:\"Subscribe #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"newsletter,fullscreen\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#subscribe-2\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/subscribe-2.jpg\";}s:16:\"age-verification\";a:7:{s:4:\"name\";s:16:\"Age Verification\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:27:\"age-verification,fullscreen\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#age-verification\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/age-verification.jpg\";}s:12:\"get-in-touch\";a:7:{s:4:\"name\";s:12:\"Get in Touch\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"contact-us\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#get-in-touch\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/get-in-touch.jpg\";}s:14:\"social-share-2\";a:7:{s:4:\"name\";s:15:\"Social Share #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#social-share-2\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/social-share-2.jpg\";}s:9:\"sign-up-2\";a:7:{s:4:\"name\";s:10:\"Sign Up #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-2\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-2.jpg\";}s:11:\"watch-promo\";a:7:{s:4:\"name\";s:11:\"Watch Promo\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:21:\"promotion,exit-intent\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#watch-promo\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/watch-promo.jpg\";}s:19:\"product-accessories\";a:7:{s:4:\"name\";s:19:\"Product Accessories\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:9:\"promotion\";s:3:\"url\";s:78:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#product-accessories\";s:7:\"preview\";s:100:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/product-accessories.jpg\";}s:9:\"sign-up-5\";a:7:{s:4:\"name\";s:10:\"Sign Up #5\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:10:\"newsletter\";s:3:\"url\";s:68:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#sign-up-5\";s:7:\"preview\";s:90:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/sign-up-5.jpg\";}s:14:\"black-friday-2\";a:7:{s:4:\"name\";s:15:\"Black Friday #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-2\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-2.jpg\";}s:14:\"black-friday-3\";a:7:{s:4:\"name\";s:15:\"Black Friday #3\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#black-friday-3\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/black-friday-3.jpg\";}s:16:\"halloween-sale-2\";a:7:{s:4:\"name\";s:17:\"Halloween Sale #2\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#halloween-sale-2\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/halloween-sale-2.jpg\";}s:16:\"halloween-sale-1\";a:7:{s:4:\"name\";s:17:\"Halloween Sale #1\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:75:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#halloween-sale-1\";s:7:\"preview\";s:97:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/halloween-sale-1.jpg\";}s:12:\"pumpkin-sale\";a:7:{s:4:\"name\";s:12:\"Pumpkin Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:71:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#pumpkin-sale\";s:7:\"preview\";s:93:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/pumpkin-sale.jpg\";}s:11:\"spring-sale\";a:7:{s:4:\"name\";s:11:\"Spring Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#spring-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/spring-sale.jpg\";}s:11:\"mothers-day\";a:7:{s:4:\"name\";s:14:\"Mother’s Day\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:35:\"sales,seasonal,promotion,fullscreen\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#mothers-day\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/mothers-day.jpg\";}s:20:\"easter-subscribe-bar\";a:7:{s:4:\"name\";s:20:\"Easter Subscribe Bar\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:25:\"sales,seasonal,newsletter\";s:3:\"url\";s:79:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#easter-subscribe-bar\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-subscribe-bar.jpg\";}s:14:\"easter-welcome\";a:7:{s:4:\"name\";s:14:\"Easter Welcome\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:8:\"seasonal\";s:3:\"url\";s:73:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#easter-welcome\";s:7:\"preview\";s:95:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-welcome.jpg\";}s:17:\"easter-newsletter\";a:7:{s:4:\"name\";s:17:\"Easter Newsletter\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:32:\"sales,seasonal,newsletter,coupon\";s:3:\"url\";s:76:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#easter-newsletter\";s:7:\"preview\";s:98:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-newsletter.jpg\";}s:11:\"season-sale\";a:7:{s:4:\"name\";s:11:\"Season Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#season-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/season-sale.jpg\";}s:11:\"easter-sale\";a:7:{s:4:\"name\";s:11:\"Easter Sale\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:70:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#easter-sale\";s:7:\"preview\";s:92:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-sale.jpg\";}s:20:\"easter-sale-surprise\";a:7:{s:4:\"name\";s:20:\"Easter Sale Surprise\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:24:\"sales,seasonal,promotion\";s:3:\"url\";s:79:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#easter-sale-surprise\";s:7:\"preview\";s:101:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/easter-sale-surprise.jpg\";}s:18:\"join-the-community\";a:7:{s:4:\"name\";s:18:\"Join the Community\";s:7:\"premium\";b:1;s:5:\"popup\";b:1;s:8:\"requires\";s:6:\"6.10.0\";s:6:\"groups\";s:6:\"social\";s:3:\"url\";s:77:\"https://layerslider.kreaturamedia.com/popups/webshopworks/#join-the-community\";s:7:\"preview\";s:99:\"https://repository.kreaturamedia.com/v4/sliders/packages/webshopworks-popups/join-the-community.jpg\";}}}", "no");
INSERT INTO `wp_options` VALUES("631", "portfolio_entries_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("782", "layerslider_update_info", "O:8:\"stdClass\":7:{s:5:\"basic\";O:8:\"stdClass\":13:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:93:\"D:/laragon/www/enfold/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:7:\"version\";s:6:\"7.12.5\";s:8:\"released\";s:10:\"2024-10-08\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:24:\"https://layerslider.com/\";s:7:\"package\";s:0:\"\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:5:\"5.4.0\";s:14:\"upgrade_notice\";s:56:\"This update contains general improvements and bug fixes.\";s:11:\"new_version\";s:6:\"7.12.5\";}s:4:\"full\";O:8:\"stdClass\":21:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:24:\"https://layerslider.com/\";s:5:\"p_url\";s:32:\"https://layerslider.com/pricing/\";s:7:\"version\";s:6:\"7.12.5\";s:12:\"last_updated\";s:10:\"2024-10-08\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:5:\"5.4.0\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:3208;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:56:\"This update contains general improvements and bug fixes.\";s:4:\"beta\";s:56:\"This update contains general improvements and bug fixes.\";s:4:\"edge\";s:56:\"This update contains general improvements and bug fixes.\";}s:6:\"author\";s:71:\"<a href=\"https://kreaturamedia.com/\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:24:\"https://layerslider.com/\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:329:\"<p style=\"text-align: justify;\">\n	<a href=\"https://layerslider.com/release-log/\" target=\"_blank\">Click here to see the release log.</a> Don’t forget, the release log and all product-related news are also integrated right into LayerSlider. Look for the “LayerSlider News” section at the bottom of its main admin screen.\n</p>\";s:12:\"installation\";s:549:\"<p style=\"text-align: justify;\">\n	Updating the plugin won’t touch your sliders or settings. New versions always have backward compatibility. You don’t have to worry about losing your work. Not sure how to update? Check the <a href=\"https://layerslider.com/documentation/#updating\" target=\"_blank\">Updating</a> section of our online documentation.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you’re experiencing unwanted changes, it is always a good idea to check your settings since there are probably new options to control those changes.\n</p>\";s:3:\"faq\";s:537:\"<p style=\"text-align: justify;\">\n	Please visit our <a href=\"https://layerslider.com/help/\" target=\"_blank\">Help</a> page, where you can find all sorts of useful assets like <a href=\"https://layerslider.com/faq/\" target=\"_blank\">FAQs</a>, <a href=\"https://layerslider.com/documentation/\" target=\"_blank\">online documentation</a>, <a href=\"https://layerslider.com/documentation/#troubleshooting\" target=\"_blank\">troubleshooting</a>, and <a href=\"https://layerslider.com/documentation/#support\" target=\"_blank\">support</a> information.\n</p>\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:6:\"7.12.5\";s:17:\"_important_notice\";a:9:{s:4:\"date\";s:10:\"2023-12-06\";s:5:\"title\";s:1:\" \";s:7:\"message\";s:557:\"<b>UPDATE REQUIRED:</b> You’re using an outdated version of LayerSlider, which lacks crucial fixes needed to be secure and compatible with the latest versions of PHP, WordPress, and popular 3rd party applications. The latest updates contain important security fixes, new features, countless improvements, and bug fixes. Please see the <a target=\"_blank\" href=\"https://layerslider.kreaturamedia.com/how-to-update/\">update instructions</a> or <a target=\"_blank\" href=\"https://layerslider.kreaturamedia.com/contact/\">contact us</a> if you have any questions.\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:0:\"\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:2135:\"\n\n		<style>\n			@import url(\"https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;800&display=swap\");\n		</style>\n		<style>\n\n			body .layerslider_notice_img .dashicons-dismiss {\n				top: 0 !important;\n				right: 20px !important;\n			}\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				margin: 0 auto !important;\n				background: rgb(106,58,233);\n				background: linear-gradient(153deg, rgba(106,58,233,1) 0%, rgba(1,148,233,1) 100%);\n				border-radius: 0.8rem;\n   				border-radius: calc( 0.7rem + 0.1vw );\n			}\n\n			body .layerslider_notice_img {\n				padding-left: 0 !important;\n			}\n\n			body.toplevel_page_layerslider .layerslider_notice_img {\n				padding-left: 30px !important;\n			}\n\n			.lspr-nowrap {\n				white-space: nowrap;\n			}\n\n			.lspr-highlight {\n				font-weight: bold;\n				text-transform: uppercase;\n			}\n\n			.lspr-text {\n				position: relative;\n				margin: 0 auto 0 auto;\n				padding: calc( 1.3rem + 0.1vw );\n				color: white;\n				font-family: Nunito, sans-serif;\n				font-size: 1rem;\n				font-size: calc( 0.9rem + 0.1vw );\n				line-height: normal;\n				text-align: justify;\n			}\n\n			.lspr-text a {\n				font-weight: 600;\n				text-decoration: none;\n				color: inherit;\n				box-sizing: content-box;\n				border-bottom: 2px solid currentColor;\n			}\n\n			.layerslider_notice_img  .dashicons-dismiss {\n				right: 30px;\n			}\n\n			.lspr-bold {\n				font-weight: 800 !important;\n			}\n\n		</style>\n		<div id=\"lspr-inner\">\n\n			<div class=\"lspr-text\">\n				<span><span class=\"lspr-highlight\">Update Required:</span> You’re using an outdated version of LayerSlider, which lacks crucial fixes needed to be secure and compatible with the latest versions of PHP, WordPress, and popular 3rd party applications. The latest updates contain important security fixes, new features, countless improvements, and bug fixes. Please see the <a href=\"https://layerslider.kreaturamedia.com/how-to-update/\" target=\"_blank\" class=\"lspr-nowrap\">update instructions</a> or <a href=\"https://layerslider.kreaturamedia.com/contact/\" target=\"_blank\" class=\"lspr-nowrap\">contact us</a> if you have any questions.\n				</span>\n			</div>\n\n		</div>\n		\";}s:11:\"min_version\";s:0:\"\";s:11:\"max_version\";s:5:\"7.2.0\";s:11:\"unactivated\";b:0;s:10:\"url_filter\";s:33:\"layerslider index.php plugins.php\";}s:14:\"_not_activated\";b:1;s:16:\"_sub_deactivated\";b:0;s:7:\"checked\";i:1728847427;}", "yes");
INSERT INTO `wp_options` VALUES("792", "ls-latest-version", "7.12.5", "yes");
INSERT INTO `wp_options` VALUES("793", "ls-p-url", "https://layerslider.com/pricing/", "yes");
INSERT INTO `wp_options` VALUES("803", "classic-editor-replace", "classic", "yes");
INSERT INTO `wp_options` VALUES("804", "classic-editor-allow-users", "disallow", "yes");
INSERT INTO `wp_options` VALUES("811", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("812", "duplicator_version_plugin", "1.5.11.1", "yes");
INSERT INTO `wp_options` VALUES("1221", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1417", "wpp_settings", "a:19:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:11:\"conv_arabic\";s:6:\"enable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:6:\"enable\";s:13:\"woo_per_price\";s:6:\"enable\";s:10:\"edd_prices\";s:7:\"disable\";s:12:\"edd_rial_fix\";s:7:\"disable\";s:9:\"dis_input\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1418", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1419", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1428", "rewrite_rules", "a:207:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:9:\"shop-2/?$\";s:27:\"index.php?post_type=product\";s:39:\"shop-2/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:34:\"shop-2/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:26:\"shop-2/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-item/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:51:\"portfolio-item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"portfolio-item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"portfolio-item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"portfolio-item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"portfolio-item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:34:\"portfolio_entries/([^/]+)/embed/?$\";s:50:\"index.php?portfolio_entries=$matches[1]&embed=true\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=206&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("1430", "dash_font_settings", "a:1:{s:12:\"dashmwfcfont\";s:7:\"Shabnam\";}", "yes");
INSERT INTO `wp_options` VALUES("1586", "av_mailchimp_owner", "iVira", "yes");
INSERT INTO `wp_options` VALUES("1874", "av_chimplist", "a:1:{s:10:\"6fde9d4c62\";a:2:{s:4:\"name\";s:5:\"iVira\";s:5:\"stats\";O:8:\"stdClass\":16:{s:12:\"member_count\";i:4;s:17:\"unsubscribe_count\";i:0;s:13:\"cleaned_count\";i:0;s:23:\"member_count_since_send\";i:15;s:28:\"unsubscribe_count_since_send\";i:11;s:24:\"cleaned_count_since_send\";i:0;s:14:\"campaign_count\";i:2;s:18:\"campaign_last_sent\";s:0:\"\";s:17:\"merge_field_count\";i:5;s:12:\"avg_sub_rate\";i:0;s:14:\"avg_unsub_rate\";i:0;s:15:\"target_sub_rate\";i:0;s:9:\"open_rate\";i:0;s:10:\"click_rate\";i:0;s:13:\"last_sub_date\";s:25:\"2020-12-11T07:59:16+00:00\";s:15:\"last_unsub_date\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("1875", "av_chimplist_field", "a:1:{s:10:\"6fde9d4c62\";a:6:{i:0;O:8:\"stdClass\":12:{s:4:\"name\";s:13:\"Email Address\";s:6:\"public\";b:1;s:4:\"show\";b:1;s:8:\"helptext\";N;s:10:\"components\";a:0:{}s:4:\"size\";s:2:\"25\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"merge_id\";i:0;s:8:\"required\";b:1;s:4:\"type\";s:5:\"email\";s:13:\"display_order\";s:1:\"1\";s:13:\"default_value\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:4:\"name\";s:10:\"First Name\";s:6:\"public\";b:1;s:4:\"show\";b:1;s:8:\"helptext\";s:0:\"\";s:10:\"components\";a:0:{}s:4:\"size\";s:2:\"25\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"merge_id\";i:1;s:8:\"required\";b:0;s:4:\"type\";s:4:\"text\";s:13:\"display_order\";s:1:\"2\";s:13:\"default_value\";s:0:\"\";}i:2;O:8:\"stdClass\":12:{s:4:\"name\";s:9:\"Last Name\";s:6:\"public\";b:1;s:4:\"show\";b:1;s:8:\"helptext\";s:0:\"\";s:10:\"components\";a:0:{}s:4:\"size\";s:2:\"25\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"merge_id\";i:2;s:8:\"required\";b:0;s:4:\"type\";s:4:\"text\";s:13:\"display_order\";s:1:\"3\";s:13:\"default_value\";s:0:\"\";}i:3;O:8:\"stdClass\":15:{s:4:\"name\";s:7:\"Address\";s:6:\"public\";b:0;s:4:\"show\";b:1;s:8:\"helptext\";s:0:\"\";s:10:\"components\";a:6:{i:0;s:5:\"addr1\";i:1;s:5:\"addr2\";i:2;s:4:\"city\";i:3;s:5:\"state\";i:4;s:3:\"zip\";i:5;s:7:\"country\";}s:4:\"size\";s:2:\"25\";s:14:\"defaultcountry\";i:164;s:17:\"defaultcountry_cc\";s:2:\"US\";s:19:\"defaultcountry_name\";s:3:\"USA\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"merge_id\";i:3;s:8:\"required\";b:0;s:4:\"type\";s:7:\"address\";s:13:\"display_order\";s:1:\"4\";s:13:\"default_value\";s:0:\"\";}i:4;O:8:\"stdClass\":13:{s:4:\"name\";s:12:\"Phone Number\";s:6:\"public\";b:0;s:4:\"show\";b:1;s:8:\"helptext\";s:0:\"\";s:10:\"components\";a:0:{}s:4:\"size\";s:2:\"25\";s:11:\"phoneformat\";s:0:\"\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"merge_id\";i:4;s:8:\"required\";b:0;s:4:\"type\";s:5:\"phone\";s:13:\"display_order\";s:1:\"5\";s:13:\"default_value\";s:0:\"\";}i:5;O:8:\"stdClass\":13:{s:4:\"name\";s:8:\"Birthday\";s:6:\"public\";b:1;s:4:\"show\";b:1;s:8:\"helptext\";s:0:\"\";s:10:\"components\";a:0:{}s:4:\"size\";s:2:\"25\";s:10:\"dateformat\";s:5:\"MM/DD\";s:3:\"tag\";s:8:\"BIRTHDAY\";s:8:\"merge_id\";i:5;s:8:\"required\";b:0;s:4:\"type\";s:8:\"birthday\";s:13:\"display_order\";s:1:\"6\";s:13:\"default_value\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("2240", "avia_instagram_widgets_cache", "{\"last_updated\":1729334938,\"instances\":{\"1-\":[]}}", "yes");
INSERT INTO `wp_options` VALUES("2455", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"info@khatamwp.dev\";s:7:\"version\";s:5:\"6.6.2\";s:9:\"timestamp\";i:1726052562;}", "off");
INSERT INTO `wp_options` VALUES("2705", "secure_auth_key", "-cl-4-a|(&JeItEL`aq`tm8~Cke9~k#[HM#2|f0xfttngasDWwxXEIS6kO_qgLW<", "no");
INSERT INTO `wp_options` VALUES("2706", "secure_auth_salt", "tE<B}Z&HLbm7pV4Le0Qr1QY}wu]vRZZC._x^I/8NVq3J;H [2x)EP#Q<G`L!R12=", "no");
INSERT INTO `wp_options` VALUES("2719", "842bcd2f096f3285c29019c3b7292ff7", "{\"starter\":\"ODY4MmI3MDItZTI5NC00YTFmLTg2YTItNjJmMzYxZmRlZjNj\",\"action\":1,\"message\":\"License code is valid.\",\"timer\":1612512405}", "yes");
INSERT INTO `wp_options` VALUES("2780", "bsr_data", "a:8:{s:13:\"select_tables\";a:94:{i:0;s:28:\"wp_3_actionscheduler_actions\";i:1;s:27:\"wp_3_actionscheduler_claims\";i:2;s:27:\"wp_3_actionscheduler_groups\";i:3;s:25:\"wp_3_actionscheduler_logs\";i:4;s:16:\"wp_3_commentmeta\";i:5;s:13:\"wp_3_comments\";i:6;s:24:\"wp_3_duplicator_packages\";i:7;s:10:\"wp_3_links\";i:8;s:12:\"wp_3_options\";i:9;s:13:\"wp_3_postmeta\";i:10;s:10:\"wp_3_posts\";i:11;s:23:\"wp_3_term_relationships\";i:12;s:18:\"wp_3_term_taxonomy\";i:13;s:13:\"wp_3_termmeta\";i:14;s:10:\"wp_3_terms\";i:15;s:26:\"wp_3_wc_admin_note_actions\";i:16;s:19:\"wp_3_wc_admin_notes\";i:17;s:23:\"wp_3_wc_category_lookup\";i:18;s:23:\"wp_3_wc_customer_lookup\";i:19;s:20:\"wp_3_wc_download_log\";i:20;s:27:\"wp_3_wc_order_coupon_lookup\";i:21;s:28:\"wp_3_wc_order_product_lookup\";i:22;s:19:\"wp_3_wc_order_stats\";i:23;s:24:\"wp_3_wc_order_tax_lookup\";i:24;s:27:\"wp_3_wc_product_meta_lookup\";i:25;s:22:\"wp_3_wc_reserved_stock\";i:26;s:24:\"wp_3_wc_tax_rate_classes\";i:27;s:16:\"wp_3_wc_webhooks\";i:28;s:25:\"wp_3_woocommerce_api_keys\";i:29;s:37:\"wp_3_woocommerce_attribute_taxonomies\";i:30;s:49:\"wp_3_woocommerce_downloadable_product_permissions\";i:31;s:20:\"wp_3_woocommerce_log\";i:32;s:31:\"wp_3_woocommerce_order_itemmeta\";i:33;s:28:\"wp_3_woocommerce_order_items\";i:34;s:34:\"wp_3_woocommerce_payment_tokenmeta\";i:35;s:31:\"wp_3_woocommerce_payment_tokens\";i:36;s:25:\"wp_3_woocommerce_sessions\";i:37;s:40:\"wp_3_woocommerce_shipping_zone_locations\";i:38;s:38:\"wp_3_woocommerce_shipping_zone_methods\";i:39;s:31:\"wp_3_woocommerce_shipping_zones\";i:40;s:35:\"wp_3_woocommerce_tax_rate_locations\";i:41;s:26:\"wp_3_woocommerce_tax_rates\";i:42;s:26:\"wp_actionscheduler_actions\";i:43;s:25:\"wp_actionscheduler_claims\";i:44;s:25:\"wp_actionscheduler_groups\";i:45;s:23:\"wp_actionscheduler_logs\";i:46;s:11:\"wp_blogmeta\";i:47;s:8:\"wp_blogs\";i:48;s:14:\"wp_commentmeta\";i:49;s:11:\"wp_comments\";i:50;s:22:\"wp_duplicator_packages\";i:51;s:14:\"wp_layerslider\";i:52;s:24:\"wp_layerslider_revisions\";i:53;s:8:\"wp_links\";i:54;s:10:\"wp_options\";i:55;s:11:\"wp_postmeta\";i:56;s:8:\"wp_posts\";i:57;s:19:\"wp_registration_log\";i:58;s:10:\"wp_signups\";i:59;s:7:\"wp_site\";i:60;s:11:\"wp_sitemeta\";i:61;s:21:\"wp_term_relationships\";i:62;s:16:\"wp_term_taxonomy\";i:63;s:11:\"wp_termmeta\";i:64;s:8:\"wp_terms\";i:65;s:11:\"wp_usermeta\";i:66;s:8:\"wp_users\";i:67;s:24:\"wp_wc_admin_note_actions\";i:68;s:17:\"wp_wc_admin_notes\";i:69;s:21:\"wp_wc_category_lookup\";i:70;s:21:\"wp_wc_customer_lookup\";i:71;s:18:\"wp_wc_download_log\";i:72;s:25:\"wp_wc_order_coupon_lookup\";i:73;s:26:\"wp_wc_order_product_lookup\";i:74;s:17:\"wp_wc_order_stats\";i:75;s:22:\"wp_wc_order_tax_lookup\";i:76;s:25:\"wp_wc_product_meta_lookup\";i:77;s:20:\"wp_wc_reserved_stock\";i:78;s:22:\"wp_wc_tax_rate_classes\";i:79;s:14:\"wp_wc_webhooks\";i:80;s:23:\"wp_woocommerce_api_keys\";i:81;s:35:\"wp_woocommerce_attribute_taxonomies\";i:82;s:47:\"wp_woocommerce_downloadable_product_permissions\";i:83;s:18:\"wp_woocommerce_log\";i:84;s:29:\"wp_woocommerce_order_itemmeta\";i:85;s:26:\"wp_woocommerce_order_items\";i:86;s:32:\"wp_woocommerce_payment_tokenmeta\";i:87;s:29:\"wp_woocommerce_payment_tokens\";i:88;s:23:\"wp_woocommerce_sessions\";i:89;s:38:\"wp_woocommerce_shipping_zone_locations\";i:90;s:36:\"wp_woocommerce_shipping_zone_methods\";i:91;s:29:\"wp_woocommerce_shipping_zones\";i:92;s:33:\"wp_woocommerce_tax_rate_locations\";i:93;s:24:\"wp_woocommerce_tax_rates\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:2:\"on\";s:7:\"dry_run\";s:3:\"off\";s:10:\"search_for\";s:18:\"info@dominodev.com\";s:12:\"replace_with\";s:17:\"info@khatamwp.dev\";s:15:\"completed_pages\";i:94;s:11:\"total_pages\";i:94;}", "yes");
INSERT INTO `wp_options` VALUES("2831", "updraft_task_manager_dbversion", "1.1", "yes");
INSERT INTO `wp_options` VALUES("2895", "79cbe367d6ba99c9929e5709fef87670", "{\"starter\":\"ODY4MmI3MDItZTI5NC00YTFmLTg2YTItNjJmMzYxZmRlZjNj\",\"action\":1,\"message\":\"\\u06a9\\u062f \\u0644\\u0627\\u06cc\\u0633\\u0646\\u0633 \\u0645\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0633\\u062a.\",\"timer\":1612516042}", "yes");
INSERT INTO `wp_options` VALUES("2900", "e53c3ea32d63919c2d1d1c007766d1f1", "{\"starter\":\"ODY4MmI3MDItZTI5NC00YTFmLTg2YTItNjJmMzYxZmRlZjNj\",\"action\":1,\"message\":\"\\u0644\\u0627\\u06cc\\u0633\\u0646\\u0633 \\u0645\\u0639\\u062a\\u0628\\u0631 \\u0645\\u06cc\\u0628\\u0627\\u0634\\u062f.\",\"timer\":1612516512}", "yes");
INSERT INTO `wp_options` VALUES("2904", "3be7bc8aee55758c16de48df3d18dbb5", "{\"starter\":\"MTgzYjAwNTQtNjM0NS00ODc4LWJlYTYtZTUwNDc3ODdiNzcx\",\"action\":1,\"message\":\"\\u06a9\\u062f \\u0644\\u0627\\u06cc\\u0633\\u0646\\u0633 \\u0645\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0633\\u062a.\",\"timer\":1612516613}", "yes");
INSERT INTO `wp_options` VALUES("2972", "recovery_mode_email_last_sent", "1728847269", "yes");
INSERT INTO `wp_options` VALUES("4269", "woocommerce_merchant_email_notifications", "yes", "no");
INSERT INTO `wp_options` VALUES("4272", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("4299", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `wp_options` VALUES("5421", "vc_version", "6.5.0", "yes");
INSERT INTO `wp_options` VALUES("5422", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("5426", "elementor_version", "3.1.1", "yes");
INSERT INTO `wp_options` VALUES("5427", "elementor_install_history", "a:1:{s:5:\"3.1.1\";i:1613737060;}", "yes");
INSERT INTO `wp_options` VALUES("5429", "_elementor_installed_time", "1613737067", "yes");
INSERT INTO `wp_options` VALUES("5430", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:12:{i:0;s:8:\"Business\";i:1;s:5:\"Ebook\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:14:\"Online Service\";i:7;s:7:\"Product\";i:8;s:11:\"Real Estate\";i:9;s:18:\"Social Involvement\";i:10;s:14:\"Thank You Page\";i:11;s:6:\"Travel\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:858:{i:0;a:14:{s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:211;s:11:\"trend_index\";i:164;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:1;a:14:{s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:580;s:11:\"trend_index\";i:312;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:2;a:14:{s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:259;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:3;a:14:{s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:173;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:4;a:14:{s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:439;s:11:\"trend_index\";i:139;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:5;a:14:{s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:393;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:6;a:14:{s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:522;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:7;a:14:{s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:266;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:8;a:14:{s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:681;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:9;a:14:{s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:253;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:10;a:14:{s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:364;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:11;a:14:{s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:465;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:12;a:14:{s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:670;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:13;a:14:{s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:249;s:11:\"trend_index\";i:152;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:14;a:14:{s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:703;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:15;a:14:{s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:250;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:16;a:14:{s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:764;s:11:\"trend_index\";i:689;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:17;a:14:{s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:389;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:18;a:14:{s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:386;s:11:\"trend_index\";i:387;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:19;a:14:{s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:766;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:20;a:14:{s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:536;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:21;a:14:{s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:443;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:22;a:14:{s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:603;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:23;a:14:{s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:249;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:24;a:14:{s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:356;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:25;a:14:{s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:625;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:26;a:14:{s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:510;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:27;a:14:{s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:538;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:28;a:14:{s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:585;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:29;a:14:{s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:590;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:30;a:14:{s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:472;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:31;a:14:{s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:691;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:32;a:14:{s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:686;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:33;a:14:{s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:614;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:34;a:14:{s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:313;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:35;a:14:{s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:702;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:36;a:14:{s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:688;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:37;a:14:{s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:798;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:38;a:14:{s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:729;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:39;a:14:{s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:469;s:11:\"trend_index\";i:577;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:40;a:14:{s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:415;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:41;a:14:{s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:800;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:42;a:14:{s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:469;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:43;a:14:{s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:458;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:44;a:14:{s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:727;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:45;a:14:{s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:696;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:46;a:14:{s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:350;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:47;a:14:{s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:775;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:48;a:14:{s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:595;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:49;a:14:{s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:12;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:50;a:14:{s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:473;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:51;a:14:{s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:816;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:52;a:14:{s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:720;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:53;a:14:{s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:828;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:54;a:14:{s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:364;s:11:\"trend_index\";i:310;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:55;a:14:{s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:557;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:56;a:14:{s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:632;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:57;a:14:{s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:644;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:58;a:14:{s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:693;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:59;a:14:{s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:719;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:60;a:14:{s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:755;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:61;a:14:{s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:459;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:62;a:14:{s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:471;s:11:\"trend_index\";i:490;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:63;a:14:{s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:610;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:64;a:14:{s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:639;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:65;a:14:{s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:581;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:66;a:14:{s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:315;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:67;a:14:{s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:751;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:68;a:14:{s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:504;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:69;a:14:{s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:409;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:70;a:14:{s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:753;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:71;a:14:{s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:647;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:72;a:14:{s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:747;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:73;a:14:{s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:827;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:74;a:14:{s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:687;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:75;a:14:{s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:745;s:11:\"trend_index\";i:742;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:76;a:14:{s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:486;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:77;a:14:{s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:575;s:11:\"trend_index\";i:737;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:78;a:14:{s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:760;s:11:\"trend_index\";i:830;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:79;a:14:{s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:80;a:14:{s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:433;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:81;a:14:{s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:608;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:82;a:14:{s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:636;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:83;a:14:{s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:562;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:84;a:14:{s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:767;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:85;a:14:{s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:574;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:86;a:14:{s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:685;s:11:\"trend_index\";i:752;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:87;a:14:{s:2:\"id\";i:1190;s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1490707391;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:2;s:11:\"trend_index\";i:2;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:88;a:14:{s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:89;a:14:{s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:234;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:90;a:14:{s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:213;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:91;a:14:{s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:666;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:92;a:14:{s:2:\"id\";i:225;s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";i:1470829872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:1;s:11:\"trend_index\";i:1;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:93;a:14:{s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/conference-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:328;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:94;a:14:{s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:376;s:11:\"trend_index\";i:89;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:95;a:14:{s:2:\"id\";i:463;s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";i:1477388340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:4;s:11:\"trend_index\";i:3;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:96;a:14:{s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:725;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:97;a:14:{s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:342;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:98;a:14:{s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:781;s:11:\"trend_index\";i:604;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:99;a:14:{s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:236;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:100;a:14:{s:2:\"id\";i:181;s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";i:1470826567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:3;s:11:\"trend_index\";i:4;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:101;a:14:{s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:615;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:102;a:14:{s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:460;s:11:\"trend_index\";i:177;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:103;a:14:{s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:758;s:11:\"trend_index\";i:811;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:104;a:14:{s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/beauty-salon-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:232;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:105;a:14:{s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/online-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:779;s:11:\"trend_index\";i:593;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:106;a:14:{s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:455;s:11:\"trend_index\";i:222;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:107;a:14:{s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:108;a:14:{s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:125;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:109;a:14:{s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:788;s:11:\"trend_index\";i:652;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:110;a:14:{s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:263;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:111;a:14:{s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:79;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:112;a:14:{s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:798;s:11:\"trend_index\";i:622;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:113;a:14:{s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:315;s:11:\"trend_index\";i:141;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:114;a:14:{s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/beauty-salon-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:49;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:115;a:14:{s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:757;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:116;a:14:{s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:490;s:11:\"trend_index\";i:390;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:117;a:14:{s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:507;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:118;a:14:{s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/beauty-salon-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:256;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:119;a:14:{s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:772;s:11:\"trend_index\";i:278;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:120;a:14:{s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:509;s:11:\"trend_index\";i:491;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:121;a:14:{s:2:\"id\";i:150;s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";i:1470829879;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/product-app-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:6;s:11:\"trend_index\";i:5;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:122;a:14:{s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:436;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:123;a:14:{s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:17;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:124;a:14:{s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:43;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:125;a:14:{s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/travel-blog-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:275;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:126;a:14:{s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"medical\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:502;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:127;a:14:{s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-blog-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:482;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:128;a:14:{s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:768;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:129;a:14:{s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:58;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:130;a:14:{s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-blog-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:220;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:131;a:14:{s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:809;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:132;a:14:{s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:106;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:133;a:14:{s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:289;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:134;a:14:{s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:135;a:14:{s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:94;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:136;a:14:{s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:87;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:137;a:14:{s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:642;s:11:\"trend_index\";i:362;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:138;a:14:{s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:671;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:139;a:14:{s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:23;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:140;a:14:{s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:314;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:141;a:14:{s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:791;s:11:\"trend_index\";i:672;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:142;a:14:{s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:772;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:143;a:14:{s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:525;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:144;a:14:{s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:678;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:145;a:14:{s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:11;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:146;a:14:{s