<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * ACF Repeater Display
 * Displays a simple Advanced Custom Field repeater value.
 */


function avia_please_install_acf_repeat()
{
	$url = network_site_url( 'wp-admin/plugin-install.php?tab=search&type=term&s=Advanced+Custom+Fields&plugin-search-input=Search+Plugins');
	$output = "<p class='please-install-woo' style='display:block; text-align:center; clear:both;'><strong>You need to install and activate the <a href='$url' style='text-decoration:underline;'>Advanced Custom Fields</a> plugin to display ACF values.</strong></p>";
	return $output;
}

if( !class_exists('acf') ) {
	add_shortcode('av_acf_repeater', 'avia_please_install_acf_repeat');
	return;
} 


if ( !class_exists( 'avia_sc_acf_repeater' ) )
{
	class avia_sc_acf_repeater extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('ACF Repeater', 'avia_framework' );
			$this->config['tab']		= __('ACF', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."acf-repeater.png";
			$this->config['order']		= 19;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'largescreen');
			$this->config['shortcode'] 	= 'av_acf_repeater';
			$this->config['tooltip'] 	= __('Displays a simple Advanced Custom Field repeater values.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}
		
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					array(	
						"name" 	=> __("Title", 'avia_framework' ),
						"desc" 	=> __("Optional title displayed above your repeater group. Leave blank to disable.", 'avia_framework' ),
						"id" 	=> "repeater_title",
						"std" 	=> "",
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Title Wrapper", 'avia_framework' ),
						"desc" 	=> __("Define what element you would like to wrap the title (i.e. h2 or h3). Insert the tag without <>", 'avia_framework' ),
						"id" 	=> "title_wrapper",
						"std" 	=> __("h2", 'avia_framework' ),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Repeater Name", 'avia_framework' ),
						"desc" 	=> __("Enter the slug set for the repeater group.", 'avia_framework' ),
						"id" 	=> "repeater_name",
						"std" 	=> "",
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Repeater Wrapper", 'avia_framework' ),
						"desc" 	=> __("Optionally define an additional wrapper for the entire repeater group (i.e. ul if you set li as the field wrapper). Insert the tag without <>. Leave blank to disable.", 'avia_framework' ),
						"id" 	=> "repeater_wrapper",
						"std" 	=> __("ul", 'avia_framework' ),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Sub Field Name", 'avia_framework' ),
						"desc" 	=> __("Enter the slug for the repeater field.", 'avia_framework' ),
						"id" 	=> "subfield_name",
						"std" 	=> "",
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Field Wrapper", 'avia_framework' ),
						"desc" 	=> __("Define what element you would like to wrap the repeater element values (i.e. li or p tag). Insert the tag without <>", 'avia_framework' ),
						"id" 	=> "wrapper",
						"std" 	=> __("li", 'avia_framework' ),
						"type" 	=> "input"),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('repeater_title'=>'', 'title_wrapper'=>'', 'repeater_wrapper'=>'', 'repeater_name'=>'', 'subfield_name'=>'', 'wrapper'=>'li'), $atts, $this->config['shortcode']));
			
			// check if the repeater field has rows of data
$rows = get_field($repeater_name);
if($rows)
{
	if($repeater_title){$output .= '<'.$title_wrapper.'>'.$repeater_title.'</'.$title_wrapper.'>';}
	if($repeater_wrapper){$output .= '<'.$repeater_wrapper.'>';}
	foreach($rows as $row)
	{
        // display a sub field value
        $output .= '<'.$wrapper.'>'.$row[$subfield_name].'</'.$wrapper.'>';
	}
	if($repeater_wrapper){$output .= '</'.$repeater_wrapper.'>';}
			$meta['el_class'];
						
			return $output;
		}}
	}
}
