<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * ACF Testimonials
 * Display testimonials via ACF Pro Repeater Fields.
 */


function avia_please_install_acf_testimonials()
{
	$url = network_site_url( 'wp-admin/plugin-install.php?tab=search&type=term&s=Advanced+Custom+Fields&plugin-search-input=Search+Plugins');
	$output = "<p class='please-install-woo' style='display:block; text-align:center; clear:both;'><strong>You need to install and activate the <a href='$url' style='text-decoration:underline;'>Advanced Custom Fields</a> plugin to display ACF values.</strong></p>";
	return $output;
}

if( !class_exists('acf') ) {
	add_shortcode('av_acf_testimonials', 'avia_please_install_acf_testimonials');
	return;
} 


if ( !class_exists( 'avia_sc_acf_testimonials' ) )
{
	class avia_sc_acf_testimonials extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('ACF Testimonials', 'avia_framework' );
			$this->config['tab']		= __('ACF', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."acf-testimonials.png";
			$this->config['order']		= 19;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_acf_testimonials';
			$this->config['tooltip'] 	= __('Display testimonials via ACF Pro Repeater Fields.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= "large";
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				
				$template_url = get_stylesheet_directory_uri();
				$child_sc = $template_url.'/shortcodes/spiderfly-elements/';
				
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Styling" , 'avia_framework'),
							'nodescription' => true
						),
					array(	
							"name" 	=> __("Testimonial Style", 'avia_framework' ),
							"desc" 	=> __("Select a layout for the testimonials.", 'avia_framework' ),
							"id" 	=> "style",
							"container_class" => 'av_half',
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array("Center Top"=>'centop',"Center Bottom"=>'cenbot',"Left Top"=>'midtop',"Left Bottom"=>'midbot')
						),
					array
						(	"name" 	=> __("Testimonial Font Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the text size in pixels.", 'avia_framework' ),
				            "id" 	=> "t_size",
							"container_class" => 'av_half',
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(12,20,1, array( __("Default Size", 'avia_framework' )=>'16')),
				            "std" => ""
						),
					array
						(	"name" 	=> __("Author Name Font Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the author name text size in pixels.", 'avia_framework' ),
				            "id" 	=> "a_size",
							"container_class" => 'av_half',
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(18,25,1, array( __("Default Size", 'avia_framework' )=>'20')),
				            "std" => ""
						),
					array
						(	"name" 	=> __("Author Subtext Font Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the author subtext size in pixels.", 'avia_framework' ),
				            "id" 	=> "asub_size",
							"container_class" => 'av_half',
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(12,20,1, array( __("Default Size", 'avia_framework' )=>'14')),
				            "std" => ""
						),
					array(	
							"name" 	=> __("Testimonial Font Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the testimonial text.", 'avia_framework' ),
							"id" 	=> "testimonial_font",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#000000",
						),
					array(	
							"name" 	=> __("Testimonial Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the testimonial background.", 'avia_framework' ),
							"id" 	=> "testimonial_bg",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#fafafa",
						),
					array(	
							"name" 	=> __("Testimonial Border Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the testimonial border.", 'avia_framework' ),
							"id" 	=> "testimonial_border",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#dddddd",
						),
					array(	
							"name" 	=> __("Author Name Font Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the author name.", 'avia_framework' ),
							"id" 	=> "author_font",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#000000",
						),
					array(	
							"name" 	=> __("Author Subtext Font Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the author subtext.", 'avia_framework' ),
							"id" 	=> "author_subfont",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#a5a5a5",
						),
					array(	
							"name" 	=> __("Avatar Border Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the testimonial text.", 'avia_framework' ),
							"id" 	=> "avatar_border",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#dddddd",
						),

					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),
								
					array(
							"type" 	=> "tab",
							"name"  => __('<strong style="color:#e65100;">'."READ ME".'</strong>' , 'avia_framework'),
							'nodescription' => true
						),
						
					array(
							"name" 	=> __("<span style='color:#0074a2;'>PREVIEW DISPLAY</span>",'avia_framework' ),
							"desc" 	=> __("If the preview to the right isn't displaying correctly, you will need to do a slight mod to a core file of the Enfold theme. Once the Enfold devs provide a way to load additional CSS files dynamically this fix will no longer be required.<br />&nbsp;<br /><strong>Go to:</strong> themes > enfold > config-templatebuilder > avia-template-builder > php > template-builder.class.php<br />&nbsp;<br />Look for the following commented out line:<pre>//if no user defined css is available load all the default frontend css</pre>Add a new line at the bottom of the CSS array and add the following:<pre>get_stylesheet_directory_uri() . '/shortcodes/css/spiderfly.css' => 1,</pre>", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
					array(
							"name" 	=> __("<span style='color:#0074a2;'>ACF PRO SETUP</span>",'avia_framework' ),
							"desc" 	=> __("&nbsp;<br /><strong>STEP ONE</strong><br />In order to get this to work correctly, you must first have the ACF Pro options page setup. Learn how to quickly set that up here: <a href='https://www.advancedcustomfields.com/resources/options-page/' style='color:#0074a2;' target='_blank'>https://www.advancedcustomfields.com/resources/options-page/</a><br />&nbsp;<br /><strong>STEP TWO</strong><br />When creating the field group, make sure you set the location rules to Options Page/is equal to/Options. You will then need to create specific fields with specific slugs.<br /> (Type/Name/Slug):<br />Repeater Field/Testimonials/testimonial<br /><span style='padding-left:25px;'>Text Field/Name/name</span><br /><span style='padding-left:25px;'>Text Field/Link/link</span><br /><span style='padding-left:25px;'>Text Field/Sub Field/sub_field</span><br /><span style='padding-left:25px;'>Text Area/Testimonial/content</span><br /><span style='padding-left:25px;'>Image/Image/image</span><br />&nbsp;<br />Or you can download and import the following file which will populate all the required fields.<br /><a href='".$child_sc."/spiderfly-elements/acf-testimonials.json' style='color:#0074a2;' target='_blank'>DOWNLOAD IMPORT FILE</a>", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),	
						
					array(
									"type" 	=> "close_div",
									'nodescription' => true
								),
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			$atts = shortcode_atts(array('testimonial_font'=>'', 't_size'=>'', 'a_size'=>'', 'asub_size'=>'', 'author_font'=>'', 'author_subfont'=>'', 'style'=>'', 'testimonial_bg'=>'', 'testimonial_border'=>'', 'avatar_border'=>''), $atts, $this->config['shortcode']);
			
// check if the repeater field has rows of data
$a_subfont  = $atts['author_subfont'];
$rows = get_field('testimonial', 'option');
$rand_row = $rows[ array_rand( $rows ) ]; // get a random row
$rand_row_name = $rand_row['name'];
$rand_row_link = $rand_row['link'];
if ($rand_row_link){$linkstart = '<a href="'.$rand_row_link.'" style="color:'.$a_subfont.'; text-decoration:none;" target="_blank">';}else{$linkstart = '';};
if ($rand_row_link){$linkend = '</a>';}else{$linkend = '';};
$rand_row_sub = $rand_row['sub_field'];
$rand_row_content = $rand_row['content'];
$rand_row_img = $rand_row['image'];
if ($rand_row_img){$image = $rand_row_img['sizes']['square'];}else{$image = get_stylesheet_directory_uri().'/shortcodes/images/user.png';};

if($rows)
{
$t_font  = $atts['testimonial_font'];
$t_size = $atts['t_size'];
$a_size = $atts['a_size'];
$asub_size = $atts['asub_size'];
$t_bg = $atts['testimonial_bg'];
$t_border = $atts['testimonial_border'];
$a_font  = $atts['author_font'];
$a_subfont  = $atts['author_subfont'];
$a_border = $atts['avatar_border'];
$style  = $atts['style'];

if($style == 'centop'){
$output .=
'<figure class="centop '.$av_display_classes.'">
  <img src="'.$image.'" style="box-shadow:0 0 1pt 1pt '.$a_border.', inset 0 0 1pt 1pt '.$a_border.';"/>
  <blockquote style="background-color:'.$t_bg.'; box-shadow:0 0 1pt 1pt '.$t_border.'; color:'.$t_font.'; font-size:'.$t_size.'px;">'.$rand_row_content.'</blockquote>
  <div class="author">
    <h3 style="color:'.$a_font.'; font-size:'.$a_size.'px;">'.$rand_row_name.'</h3><span style="color:'.$a_subfont.'; font-size:'.$asub_size.'px;">'.$linkstart . $rand_row_sub . $linkend.'</span>
  </div>
</figure>';}
if($style == 'cenbot'){
$output .=
'<figure class="cenbot '.$av_display_classes.'">
  <blockquote style="background-color:'.$t_bg.'; box-shadow:0 0 1pt 1pt '.$t_border.'; color:'.$t_font.'; font-size:'.$t_size.'px;">'.$rand_row_content.'</blockquote>
  <div class="author">
    <img src="'.$image.'" style="box-shadow:0 0 1pt 1pt '.$a_border.', inset 0 0 1pt 1pt '.$a_border.';"/>
    <h3 style="color:'.$a_font.'; font-size:'.$a_size.'px;">'.$rand_row_name.'</h3><span style="color:'.$a_subfont.'; font-size:'.$asub_size.'px;">'.$linkstart . $rand_row_sub . $linkend.'</span>
  </div>
</figure>';}
if($style == 'midbot'){
$output .=
'<figure class="midbot '.$av_display_classes.'">
  <blockquote style="background-color:'.$t_bg.'; box-shadow:0 0 1pt 1pt '.$t_border.'; color:'.$t_font.'; font-size:'.$t_size.'px;">'.$rand_row_content.'</blockquote>
  <div class="author">
    <img src="'.$image.'" style="box-shadow:0 0 1pt 1pt '.$a_border.', inset 0 0 1pt 1pt '.$a_border.';"/>
    <h3 style="color:'.$a_font.'; font-size:'.$a_size.'px;">'.$rand_row_name.'</h3><span style="color:'.$a_subfont.'; font-size:'.$asub_size.'px;">'.$linkstart . $rand_row_sub . $linkend.'</span>
  </div>
</figure>';}
if($style == 'midtop'){
$output .=
'<figure class="midtop '.$av_display_classes.'">
  <div class="author">
    <img src="'.$image.'" style="box-shadow:0 0 1pt 1pt '.$a_border.', inset 0 0 1pt 1pt '.$a_border.';"/>
    <h3 style="color:'.$a_font.'; font-size:'.$a_size.'px;">'.$rand_row_name.'</h3><span style="color:'.$a_subfont.'; font-size:'.$asub_size.'px;">'.$linkstart . $rand_row_sub . $linkend.'</span>
  </div>
  <blockquote style="background-color:'.$t_bg.'; box-shadow:0 0 1pt 1pt '.$t_border.'; color:'.$t_font.'; font-size:'.$t_size.'px;">'.$rand_row_content.'</blockquote>
</figure>';}
}
			$meta['el_class'];
						
			return $output;
		}
	}
}
