<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Movie Card
 * Displays a responsive app info card.
 */
 

if ( !class_exists( 'ss_appcard' ) )
{
	class ss_appcard extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('App Card', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."app-card.png";
			$this->config['order']		= 24;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'ss_appcard';
			$this->config['modal_data'] = array('modal_class' => 'ssmed');
			$this->config['tooltip'] 	= __('Displays a responsive app info card.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= true;
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()):
					wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all');
				else:
					if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
				endif;	
				
			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			if(is_rtl()):
				wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all');
			else:
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			endif;	
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Content",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Card Style", 'avia_framework' ),
							"desc" 	=> __("Choose between a fully responsive banner or lock the layout into a portrait style.", 'avia_framework' ),
							"id" 	=> "card",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "",
							"subtype" => array( __("Horizontal Banner", 'avia_framework' )=>'banner', __("Portrait Card", 'avia_framework' )=>'portrait')), 
							
					array(	
							"name" 	=> __("App Name", 'avia_framework' ),
							"desc" 	=> __("Enter the name of the app.", 'avia_framework' ),
							"id" 	=> "title",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(
							"name" 	=> __("Choose App Icon",'avia_framework' ),
							"desc" 	=> __("&nbsp;",'avia_framework' ),
							"id" 	=> "appicon",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> AviaBuilder::$path['imagesURL']."placeholder.jpg"),
				
					array(
							"name" 	=> __("Choose Card Background Image",'avia_framework' ),
							"desc" 	=> __("&nbsp;",'avia_framework' ),
							"id" 	=> "bgart",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> AviaBuilder::$path['imagesURL']."placeholder.jpg"),
				
					array(	
							"name" 	=> __("Currency Code", 'avia_framework' ),
							"desc" 	=> __("Set your default currency code. eg. 'USD'", 'avia_framework' ),
							"id" 	=> "currencycode",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "USD",),
				
					array(	
							"name" 	=> __("Currency Symbol", 'avia_framework' ),
							"desc" 	=> __("Set your default currency symbol. eg. '$'", 'avia_framework' ),
							"id" 	=> "currencysym",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "$",),
				
					array(	
							"name" 	=> __("Price", 'avia_framework' ),
							"desc" 	=> __("Set the price of the app without a symbol eg '1.99'.", 'avia_framework' ),
							"id" 	=> "price",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Version Number", 'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "version",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Last Updated", 'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "updated",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
									
					array(	
							"name" 	=> __("App Type", 'avia_framework' ),
							"desc" 	=> __("Select the overall type of the app.", 'avia_framework' ),
							"id" 	=> "apptype",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "",
							"subtype" => array("Game"=>'GameApplication',"Social Network"=>'SocialNetworkingApplication',"Travel"=>'TravelApplication',"Shopping"=>'ShoppingApplication',"Sports"=>'SportsApplication',"Lifestyle"=>'LifestyleApplication',"Business"=>'BusinessApplication',"Design"=>'DesignApplication',"Developer"=>'DeveloperApplication',"Driver"=>'DriverApplication',"Educational"=>'EducationalApplication',"Health"=>'HealthApplication',"Finance"=>'FinanceApplication',"Security"=>'SecurityApplication',"Browser"=>'BrowserApplication',"Communication"=>'CommunicationApplication',"Desktop Enhancement"=>'DesktopEnhancementApplication',"Entertainment"=>'EntertainmentApplication',"Multimedia"=>'MultimediaApplication',"Home"=>'HomeApplication',"Utilities"=>'UtilitiesApplication',"Reference"=>'ReferenceApplication')
							),
				
					array(	
							"name" 	=> __("Category", 'avia_framework' ),
							"desc" 	=> __("Enter all categories that apply with a separator.", 'avia_framework' ),
							"id" 	=> "appcat",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Star Rating", 'avia_framework' ),
							"desc" 	=> __("Select the star rating of the app.", 'avia_framework' ),
							"id" 	=> "rating",
							"type" 	=> "select",
							"container_class" => 'av_third',
							"std" 	=> "",
							"subtype" => array("5 Stars"=>'5star',"4.5 Stars"=>'45star',"4 Stars"=>'4star',"3.5 Stars"=>'35star',"3 Stars"=>'3star',"2.5 Stars"=>'25star',"2 Stars"=>'2star',"1.5 Stars"=>'15star',"1 Star"=>'1star',"0.5 Star"=>'05star')
							),
				
					array(	
							"name" 	=> __("Custom Rating", 'avia_framework' ),
							"desc" 	=> __("Leave blank to use star rating.", 'avia_framework' ),
							"id" 	=> "specificrating",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Rating Count", 'avia_framework' ),
							"desc" 	=> __("Enter the total number of ratings.", 'avia_framework' ),
							"id" 	=> "ratingcount",
							"container_class" => 'av_third',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Developer Name", 'avia_framework' ),
							"desc" 	=> __("&nbsp;", 'avia_framework' ),
							"id" 	=> "credits",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Corner Ribbon", 'avia_framework' ),
							"desc" 	=> __("Display a corner ribbon. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "ribbon",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Promo Video Link", 'avia_framework' ),
							"desc" 	=> __("Link directly to a YouTube video. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "trailer",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Promo Button Text", 'avia_framework' ),
							"desc" 	=> __("Set the text you would like for the promo button.", 'avia_framework' ),
							"id" 	=> "trailer_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "VIEW PROMO",),
				
					array(	
							"name" 	=> __("Second Link", 'avia_framework' ),
							"desc" 	=> __("Optional second link. Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "alt_link",
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(	
												__('Hide Button', 'avia_framework' ) =>'hidebtn',
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												__('Taxonomy Overview Page',  'avia_framework' )=>'taxonomy',
												),
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Second Button Text", 'avia_framework' ),
							"desc" 	=> __("Set the text you would like for the second button.", 'avia_framework' ),
							"id" 	=> "alt_btn",
							"type" 	=> "input",
							"std" 	=> "LEARN MORE",),

					array(	
							"name" 	=> __("Description", 'avia_framework' ),
							"desc" 	=> __("Enter a brief description of the featured video.", 'avia_framework' ),
							"id" 	=> "description",
							"type" 	=> "textarea",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Apple Store Link", 'avia_framework' ),
							"desc" 	=> __("Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "apple_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Play Store Link", 'avia_framework' ),
							"desc" 	=> __("Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "google_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Amazon Store Link", 'avia_framework' ),
							"desc" 	=> __("Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "amazon_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
				
					array(	
							"name" 	=> __("Windows Store Link", 'avia_framework' ),
							"desc" 	=> __("Leave blank to hide.", 'avia_framework' ),
							"id" 	=> "windows_btn",
							"container_class" => 'av_half',
							"type" 	=> "input",
							"std" 	=> "",),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true),
				
					array(
							"type" 	=> "tab",
							"name"	=> __("Styling",'avia_framework' ),
							'nodescription' => true),
				
					array(	
							"name" 	=> __("Title Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the title in pixels.", 'avia_framework' ),
						    "container_class" => 'av_half',
				            "id" 	=> "title_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(16,60,1, array( __("Default Size", 'avia_framework' )=>'32')),
				            "std" => "32"),
					array(	
							"name" 	=> __("Title Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "title_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#ffffff",),
					array(	
							"name" 	=> __("Developer Name Text Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the title in pixels.", 'avia_framework' ),
						    "container_class" => 'av_half',
				            "id" 	=> "credit_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,25,1, array( __("Default Size", 'avia_framework' )=>'13')),
				            "std" => "14"),
					array(	
							"name" 	=> __("Developer Name Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the developer name text.", 'avia_framework' ),
							"id" 	=> "credit_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#9ac7fa",),
					array(	
							"name" 	=> __("Ribbon Text Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "ribbon_text",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#fff",),
					array(	
							"name" 	=> __("Ribbon Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the title text.", 'avia_framework' ),
							"id" 	=> "ribbon_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#39d",),
				
					array(
							"type" 	=> "close_div",
							'nodescription' => true),
						
					array(
							"type" 	=> "tab",
							"name"	=> __("Screen Options",'avia_framework' ),
							'nodescription' => true),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('card'=>'', 'title'=>'', 'appicon'=>'', 'bgart'=>'', 'updated'=>'', 'credits'=>'', 'version'=>'', 'appcat'=>'', 'trailer'=>'', 'trailer_btn'=>'', 'alt_link'=>'', 'alt_btn'=>'', 'description'=>'', 'apple_btn'=>'', 'google_btn'=>'', 'amazon_btn'=>'', 'windows_btn'=>'', 'title_size'=>'', 'title_color'=>'', 'credit_size'=>'', 'credit_color'=>'', 'ribbon'=>'', 'ribbon_text'=>'', 'ribbon_color'=>'', 'rating'=>'', 'price'=>'', 'apptype'=>'', 'ratingcount'=>'', 'specificrating'=>'', 'currencycode'=>'', 'currencysym'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			
			$fstar = '<img src="'.$child_sc_imgs.'fstar.png" width="20px" />';
			$hstar = '<img src="'.$child_sc_imgs.'hstar.png" width="20px" />';
			$estar = '<img src="'.$child_sc_imgs.'estar.png" width="20px" />';
			
			if($rating == '5star'){$apprating = $fstar.$fstar.$fstar.$fstar.$fstar;}
			if($rating == '45star'){$apprating = $fstar.$fstar.$fstar.$fstar.$hstar;}
			if($rating == '4star'){$apprating = $fstar.$fstar.$fstar.$fstar.$estar;}
			if($rating == '35star'){$apprating = $fstar.$fstar.$fstar.$hstar.$estar;}
			if($rating == '3star'){$apprating = $fstar.$fstar.$fstar.$estar.$estar;}
			if($rating == '25star'){$apprating = $fstar.$fstar.$hstar.$estar.$estar;}
			if($rating == '2star'){$apprating = $fstar.$fstar.$estar.$estar.$estar;}
			if($rating == '15star'){$apprating = $fstar.$hstar.$estar.$estar.$estar;}
			if($rating == '1star'){$apprating = $fstar.$estar.$estar.$estar.$estar;}
			if($rating == '05star'){$apprating = $hstar.$estar.$estar.$estar.$estar;}
			
			if(($rating == '5star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">5.0</span>';}
			if(($rating == '45star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">4.5</span>';}
			if(($rating == '4star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">4.0</span>';}
			if(($rating == '35star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">3.5</span>';}
			if(($rating == '3star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">3.0</span>';}
			if(($rating == '25star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">2.5</span>';}
			if(($rating == '2star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">2.0</span>';}
			if(($rating == '15star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">1.5</span>';}
			if(($rating == '1star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">1.0</span>';}
			if(($rating == '05star') && !($specificrating)){$avrating = '<span itemprop="ratingValue">0.5</span>';}
			if($specificrating){$avrating = '<span itemprop="ratingValue">'.$specificrating.'</span>';}
			
			if($apple_btn) {$apple = '<a itemprop="downloadUrl" href="'.$apple_btn.'" target="_blank"><img class="apple" src="'.$child_sc_imgs.'iosbutton.png" /></a>';}
			if($google_btn) {$google = '<a itemprop="downloadUrl" href="'.$google_btn.'" target="_blank"><img class="google" src="'.$child_sc_imgs.'playbutton.png" /></a>';}
			if($amazon_btn) {$amazon = '<a itemprop="downloadUrl" href="'.$amazon_btn.'" target="_blank"><img class="amazon" src="'.$child_sc_imgs.'amazonbutton.png" /></a>';}
			if($windows_btn) {$windows = '<a itemprop="downloadUrl" href="'.$windows_btn.'" target="_blank"><img class="windows" src="'.$child_sc_imgs.'windowsbutton.png" /></a>';}
			
			if(($apple_btn) && !($google_btn && $windows_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">iOS</span>';}
			if(($google_btn) && !($apple_btn && $windows_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">Android</span>';}
			if(($windows_btn) && !($apple_btn && $google_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">Windows</span>';}
			if(($google_btn) && ($apple_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">Android, iOS</span>';}
			if(($google_btn) && ($windows_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">Android, Windows</span>';}
			if(($apple_btn) && ($windows_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">iOS, Windows</span>';}
			if(($apple_btn) && ($windows_btn) && ($google_btn)) {$software = '<span itemprop="operatingSystem" style="display:none;">Android, iOS, Windows</span>';}
			
			if($price){$seoprice = $price;}
			if($price == 'free'){$seoprice = '0';}
			if($price == 'Free'){$seoprice = '0';}
			if($price == 'FREE'){$seoprice = '0';}
			if($price == ''){$seoprice = '0';}
			if($price == '0'){$seoprice = '0';}
			
			if($price == 'free'){$currencysym = '';}
			if($price == 'Free'){$currencysym = '';}
			if($price == 'FREE'){$currencysym = '';}
			if($price == ''){$currencysym = '';}
						
			if(!empty($appicon)) $coverart = '<img class="appicon" src="'.$appicon.'"/>';
			if($card == 'banner'){$mingen = '</div><div class="app_subheader"><span class="version">'.$currencysym.$price.' &nbsp;&middot;&nbsp; <span itemprop="softwareVersion">'.$version.'</span></span><div class="rating">'.$apprating.'</div></div>';}
			if($card == 'portrait'){$mingen = '</div><div class="app_subheader"><span class="version">'.$currencysym.$price.' &nbsp;&middot;&nbsp; <span itemprop="softwareVersion">'.$version.'</span></span><div class="rating">'.$apprating.'</div></div>';}
			if(!empty($trailer)) $trailer_link = '<a href="'.$trailer.'?iframe=true">'.$trailer_btn.'</a>';
			if($alt_link != 'hidebtn') {$second_link = '<a href="'.$alt_link.'">'.$alt_btn.'</a>';}else{$second_link = '';}
			if($ribbon) {$cornerribbon = '<div class="corner-ribbon top-right-app sticky" style="background-color:'.$ribbon_color.'!important; color:'.$ribbon_text.'!important;">'.$ribbon.'</div>';}
			if(is_rtl()){
				if($updated){$updated = '<div class="appcat" style="float:right; margin-left:25px;"><small><span style="color:#9ac7fa;">Last updated: &nbsp;</span> '.$updated.'</small></div>';}
			} else {
				if($updated){$updated = '<div class="appcat" style="float:left; margin-right:25px;"><small><span style="color:#9ac7fa;">Last updated: &nbsp;</span> '.$updated.'</small></div>';}
			}
			
			//html markup
	        $output .= '<div class="app_card '.$extraClass.' '.$av_display_classes.'" id="'.$card.'" itemscope itemtype="https://schema.org/SoftwareApplication">
  			<div class="info_section">
  			'.$cornerribbon.'
    		<div class="app_header">
      		'.$coverart.'
      		<h1 style="font-size:'.$title_size.'px; color:'.$title_color.';" itemprop="name">'.$title.'</h1>
      		<p class="type" style="font-size:'.$credit_size.'px; color:'.$credit_color.'; display:block !important; text-shadow:1px 1px #000; font-weight:600;">&nbsp;'.$credits.'</p>
      		'.$mingen.'
			<div class="appbut">'.$trailer_link.$second_link.'</div>
			<p class="appcat" itemprop="applicationSubCategory">'.$appcat.'</p>
			'.$updated.'
			<link itemprop="applicationCategory" href="https://schema.org/'.$apptype.'"/>
			<div itemprop="aggregateRating" itemscope itemtype="https://schema.org/AggregateRating">
			<div class="appcat"><small><span style="color:#9ac7fa;">'.$avrating.' &nbsp;</span> (<span itemprop="ratingCount">'.$ratingcount.'</span>)</small></div></div>
			
			<div itemprop="offers" itemscope itemtype="https://schema.org/Offer" style="display:none;">
    		<span itemprop="price">'.$seoprice.'</span>
    		<meta itemprop="priceCurrency" content="'.$currencycode.'" />
  			</div>		
			
    		<div class="app_desc">
      		<p class="text" itemprop="description">'.$description.'</p>
    		</div>
			'.$software.'
			<div class="appbuttons">'.$apple.$google.$amazon.$windows.'</div>
  			</div>
  			<div class="blur_back" style="background-image: url('.$bgart.') !important;"></div>
			</div>';
			return $output;
		}
	}
}
