<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Artwork Frame
 * Displays artwork in a nice CSS frame.
 */
 
if ( !class_exists( 'spiderfly_artframe' ) )
{
	class spiderfly_artframe extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Artwork Frame', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."artframe.png";
			$this->config['order']		= 92;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'ss_artframe';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays artwork in a nice CSS frame.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview']	= "large";
            $this->config['disabling_allowed'] = true;
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$template_url = get_stylesheet_directory_uri();
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Content",'avia_framework' ),
							'nodescription' => true
						), 
				
					array(
							"name" 	=> __("<strong style='color:red;'>REQUIRED</strong>",'avia_framework' ),
							"desc" 	=> __("Regardless if you wish to have the artwork title displayed on the front-end, an unique title is required. We will use it to provide each element instance a unique ID in order to retain your custom styling of each instance.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
								),
				
					array(
							"name" 	=> __("Artwork Title", 'avia_framework' ),
							"desc" 	=> __("Enter the artwork title here.", 'avia_framework' ) ,
							"id" 	=> "title",
							"std" 	=> "Three Horses",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(
							"name" 	=> __("Artwork Byline", 'avia_framework' ),
							"desc" 	=> __("Display the artist's name and give attribution.", 'avia_framework' ) ,
							"id" 	=> "byline",
							"std" 	=> "Brigitte Werner",
							"container_class" => 'av_half',
							"type" 	=> "input"),
				
					array(	
							"desc" 	=> __("Hide the title and byline on the front-end.", 'avia_framework'),
							"id" 	=> "byline_hide",
							"std" 	=> "display",
							"type" 	=> "select",
							"subtype" => array("Display"=>'block',"Hide"=>'none')),
						
					array(
							"name" 	=> __("Choose Image",'avia_framework' ),
							"desc" 	=> __("Either upload a new, or choose an existing image from your media library",'avia_framework' ),
							"id" 	=> "src",
							"type" 	=> "image",
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> $template_url."/shortcodes/images/horses.jpg",), 
				
					array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "bg_pos",
							"type" 	=> "select",
							"std" 	=> "center center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
				
					 array(
							"name" 	=> __("Image Link?", 'avia_framework' ),
							"desc" 	=> __("Where should your image link to?", 'avia_framework' ),
							"id" 	=> "link",
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(
												__('No Link', 'avia_framework' ) =>'none',
												__('Lightbox', 'avia_framework' ) =>'lightbox',
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												),
							"std" 	=> "none"),
							
					array(	
							"name" 	=> __("Open Link in new Window?", 'avia_framework' ),
							"desc" 	=> __("Select here if you want to open the linked page in a new window", 'avia_framework' ),
							"id" 	=> "link_target",
							"type" 	=> "select",
							"required" => array('link','equals','manually'),
							"std" 	=> "",
							"subtype" => AviaHtmlHelper::linking_options()),
				
					array(	
							"name" 	=> __("Alternate Lightbox Image?", 'avia_framework' ),
							"desc" 	=> __("Choose if you would like to use the artwork image you have already chosen above for the lightbox display, or select and alternative (like a watermarked version).", 'avia_framework' ),
							"id" 	=> "altdisplay",
							"type" 	=> "select",
							"required" => array('link','equals','lightbox'),
							"std" 	=> "none",
							"subtype" => array("None"=>'none',"Alternative Image"=>'alt-image')
							),
				
					array(
							"name" 	=> __("Choose Alternate Image",'avia_framework' ),
							"desc" 	=> __("Either upload a new, or choose an existing image from your media library as an alternate version of your artwork to display in the lightbox modal. Such as a different size image or a watermarked version.",'avia_framework' ),
							"id" 	=> "altsrc",
							"type" 	=> "image",
							"required" => array('altdisplay','equals','alt-image'),
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> "",), 
				
					array(
							"name" 	=> __("Why are the height & width required?",'avia_framework' ),
							"desc" 	=> __("The frame and mat are generated purely with CSS and require defined dimensions in order to retain the effect. Don't worry, you can define optional dimensions for tablets and phones in the screen options section.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
								),
				
					array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
							"id" 	=> "width",
							"std" 	=> "450",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
							"id" 	=> "height",
							"std" 	=> "300",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
							
				array(
						"type" 	=> "close_div",
						'nodescription' => true
					),
				
				array(
						"type" 	=> "tab",
						"name"	=> __("Colors",'avia_framework' ),
						'nodescription' => true
					),
				
					array(	
							"name" 	=> __("Frame Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "frame_color",
							"type" 	=> "colorpicker",
					   		"container_class" => 'av_half',
							"std" 	=> "#22130c",
						),
							
					array(	
							"name" 	=> __("Mat Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "mat_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#fff5e5",
						),
				
					array(	
							"name" 	=> __("Title Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "title_color",
							"type" 	=> "colorpicker",
					   		"container_class" => 'av_half',
							"std" 	=> "#252525",
						),
							
					array(	
							"name" 	=> __("Byline Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "byline_color",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#252525",
						),
				
				array(
						"type" 	=> "close_div",
						'nodescription' => true
					),
							
				array(
						"type" 	=> "tab",
						"name"	=> __("Screen Options",'avia_framework' ),
						'nodescription' => true
					),
				
						array(
							"name" 	=> __("Tablet Dimensions",'avia_framework' ),
							"desc" 	=> __("Set the dimensions for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
				
						array(
							"name" 	=> __("Maximum Tablet Width Break Point", 'avia_framework' ),
							"desc" 	=> __("Enter the width breaking point between tablet and desktop displays.", 'avia_framework' ) ,
							"id" 	=> "tab_break",
							"std" 	=> "989",
							"type" 	=> "input"),

						array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Set the width for when viewed on a tablet.", 'avia_framework' ) ,
							"id" 	=> "twidth",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   		array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Set the height for when viewed on a tablet.", 'avia_framework' ) ,
							"id" 	=> "theight",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
								
						array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "tablet_bg_pos",
							"type" 	=> "select",
							"std" 	=> "center-center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
				
						array(
							"name" 	=> __("Phone Dimensions",'avia_framework' ),
							"desc" 	=> __("Set the dimensions for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
							),
				
						array(
							"name" 	=> __("Maximum Phone Width Break Point", 'avia_framework' ),
							"desc" 	=> __("Enter the width breaking point between phone and tablet displays.", 'avia_framework' ) ,
							"id" 	=> "phone_break",
							"std" 	=> "767",
							"type" 	=> "input"),
						array(
							"name" 	=> __("Width", 'avia_framework' ),
							"desc" 	=> __("Set the width for when viewed on a phone.", 'avia_framework' ) ,
							"id" 	=> "pwidth",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
				   		array(
							"name" 	=> __("Height", 'avia_framework' ),
							"desc" 	=> __("Set the height for when viewed on a phone.", 'avia_framework' ) ,
							"id" 	=> "pheight",
							"std" 	=> "",
					   		"container_class" => 'av_half',
							"type" 	=> "input"),
				
						array(	
							"name" 	=> __("Image Position", 'avia_framework' ),
							"desc" 	=> __("Because the image is hard cropped to fit the dimensions you set, this adjustment will allow you to position the graphic optimally.", 'avia_framework' ),
							"id" 	=> "phone_bg_pos",
							"type" 	=> "select",
							"std" 	=> "center-center",
							"subtype" => array("Left Top"=>'left top',"Left Center"=>'left center',"Left Bottom"=>'left bottom',"Right Top"=>'right top',"Right Center"=>'right center',"Right Bottom"=>'right bottom',"Center Top"=>'center top',"Center Center"=>'center center',"Center Bottom"=>'center bottom')
							),
								
						array(
							"name" 	=> __("Element Visibility",'avia_framework' ),
							"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
							),
							
						array(	
							"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
							"id" 	=> "av-desktop-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
								
						array(	
							"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
							"id" 	=> "av-medium-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
										
						array(	
							"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
							"id" 	=> "av-small-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
										
						array(	
							"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
							"id" 	=> "av-mini-hide",
							"std" 	=> "",
							"container_class" => 'av-multi-checkbox',
							"type" 	=> "checkbox"),
									
					array(
						"type" 	=> "close_div",
						'nodescription' => true
						),	
								
				array(
					"type" 	=> "close_div",
					'nodescription' => true
					),	
				

				);
		}
		
		public function is_nested_self_closing( $shortcode )
		{return true;}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('src'=>'', 'altsrc'=>'', 'title'=>'', 'byline'=>'', 'link'=>'', 'link_target'=>'', 'bg_pos'=>'center center', 'tablet_bg_pos'=>'center center', 'phone_bg_pos'=>'center center', 'width'=>'', 'twidth'=>'', 'pwidth'=>'', 'height'=>'', 'theight'=>'', 'pheight'=>'', 'frame_color'=>'', 'mat_color'=>'', 'title_color'=>'', 'byline_color'=>'', 'byline_hide'=>'', 'tab_break'=>'', 'phone_break'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			if($atts['src']){$src == $atts['src'];}else{$src == get_stylesheet_directory_uri()."/shortcodes/spiderfly-elements/images/horses.jpg";}
			
			$title_id = str_replace(' ', '_', $title);
			
			$styling = "<style>
			#{$title_id} .artframe {width:{$width}px; height:{$height}px;}
			#{$title_id} .artframe:before {background-color: {$frame_color} !important;}
			#{$title_id} .artframe:after {background-color: {$mat_color} !important;}
			#{$title_id} .artframe li {background-image:url({$src});background-size:cover !important; background-position:{$bg_pos} !important; height:calc({$height}px - 14px); width:calc({$width}px - 14px);}
			</style>";
			$p1 = "1";
			$phone_break = $atts['phone_break'];
			$min_tab == $phone_break+$p1;
			
			$byline_display = $atts['byline_hide'];
			
			$tstyling = "<style>@media only screen and (min-width: {$min_tab}px),(max-width: {$tab_break}px){#{$title_id} .artframe { width:{$twidth}px !important; height:{$theight}px !important;} #{$title_id} .artframe li {height:calc({$theight}px - 14px) !important; width:calc({$twidth}px - 14px) !important; background-size:cover !important; background-position:{$tablet_bg_pos} !important;} }}</style>";
			
			$pstyling = "<style>@media only screen and (max-width: {$phone_break}px){#{$title_id} .artframe { width:{$pwidth}px !important; height:{$pheight}px !important;} #{$title_id} .artframe li {height:calc({$pheight}px - 14px) !important; width:calc({$pwidth}px - 14px) !important; background-size:cover !important; background-position:{$phone_bg_pos} !important;}}</style>";
			
			
			if($atts['link'] == "manually"){
			$blank = strpos($atts['link_target'], '_blank') !== false ? ' target="_blank" ' : "";
			$blank .= strpos($atts['link_target'], 'nofollow') !== false ? ' rel="nofollow" ' : "";
			}else{"";}

			$link  = AviaHelper::get_url($atts['link']);
			$link  = ( ( $link == "http://" ) || ( $link == "manually" ) ) ? "" : $link;
			
			if($atts['link'] == "none"){
				$artdisplay = "<ul class='artframe'><li></li></ul>";
			}
			if($atts['link'] == "manually"){
				$artdisplay = "<a href='".$link."'{$blank}><ul class='artframe'><li></li></ul></a>";
			}
			if($atts['link'] == "single"){
				$artdisplay = "<a href='".$link."'><ul class='artframe'><li></li></ul></a>";
			}
			if(($atts['link'] == "lightbox") && ($atts['altdisplay'] == "alt-image")) {
				$artdisplay = "<a rel='lightbox' data-rel='gallery-1' class='lightbox' href='".$altsrc."'><ul class='artframe'><li></li></ul></a>";
			}
			if(($atts['link'] == "lightbox") && ($atts['altdisplay'] == "none")) {
				$artdisplay = "<a rel='lightbox' data-rel='gallery-1' class='lightbox' href='".$src."'><ul class='artframe'><li></li></ul></a>";
			}
							
			//html markup
	        $output = "";
			$output .= $styling;
			$output .= $tstyling;
			$output .= $pstyling;
			$output .= "<div id='{$title_id}'>{$artdisplay}<p class='art_title' style='display:{$byline_display} !important;'><i><span style='color:{$title_color};'>&quot;{$title}&quot;</span> ~ by <span style='color:{$byline_color};'>{$byline}</span></i></p></div>";
			
			return $output;
		}
	}
}
