<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Color Picker
 * Displays a custom color picker.
 */

// Add color picker script to header
add_action('wp_head','get_custom_color');
function get_custom_color( ){
	$template_url = get_stylesheet_directory_uri();
	echo '<script src="'.$template_url.'/shortcodes/spiderfly-elements/color-picker/custom-color.js"></script>';
	echo '<script src="'.$template_url.'/shortcodes/spiderfly-elements/color-picker/jscolor.js"></script>';
}

// Create color picker shortcode
function get_colorpicker() {
	$misccode = "{onFineChange:'update(this)',valueElement:null,value:'66ccff'}";
	if(is_rtl()):
		return '<div style="padding-top:8px!important;"><button class="jscolor '. $misccode .'" style="width:40px; height:40px; border: 1px solid #e1e1e1; float: right; margin: 0px 5px 15px 10px; border-radius:3px;"></button><div style="font-size:20px!important; margin-top:8px;"><span id="hex-str" style="color:#959595!important;"><span style="font-size:50px!important; vertical-align:text-top!important; color:#959595!important;">&#9754;</span> Choose a color...</span></div></div>';
	else:
		return '<div style="padding-top:8px!important;"><button class="jscolor '. $misccode .'" style="width:40px; height:40px; border: 1px solid #e1e1e1; float: left; margin: 0px 10px 15px 5px; border-radius:3px;"></button><div style="font-size:20px!important; margin-top:8px;"><span id="hex-str" style="color:#959595!important;"><span style="font-size:50px!important; vertical-align:text-top!important; color:#959595!important;">&#9754;</span> Choose a color...</span></div></div>';
	endif;
}
add_shortcode( 'color_picker', 'get_colorpicker' );

if ( !class_exists( 'avia_color_picker' ) )
{
	class avia_color_picker extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Color Picker', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."color-picker.png";
			$this->config['order']		= 82;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_color_picker';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays a custom color picker that will generage a hex code.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}
		
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				  
				);

			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			$output = "<div class='{$av_display_classes}'>".do_shortcode( '[color_picker]' )."</div>";
			$meta['el_class'];
			
			return $output;
		}
	}
}
