<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Elegant Quote
 * Displays an elegant, animated title element.
 */
 			
add_action('wp_head','elegant_title_style');
function elegant_title_style( ){
	$template_url = get_stylesheet_directory_uri();
	echo '<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:800,300" /><link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Great+Vibes" />';
	}

if ( !class_exists( 'avia_elegant_title' ) )
{
	class avia_elegant_title extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Elegant Quote', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."elegant-title.png";
			$this->config['order']		= 98;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_elegant_title';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays an elegant, animated quote element.', 'avia_framework' );
			$this->config['preview'] 	= false;
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			
		}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
		array("type" 	=> "tab_container", 'nodescription' => true),
				
			array( "type" 	=> "tab",
				   "name"   => __("Content" , 'avia_framework'),
				   'nodescription' => true),
				
				array(
							"name" 	=> __("<span style='color:#0074a2;'>IN DEVELOPMENT</span>",'avia_framework' ),
							"desc" 	=> __("This element is 99% complete. It is completely usable and stable as it is. The remaining future update is simply cosmetic as to force the animated aspects to start only when in view. Current recommended use of this element would be at the top of the a page or post.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
					
				array(	"name" 	=> __("Main Title", 'avia_framework' ),
						"desc" 	=> "",
				        "id" 	=> "main",
				        "type" 	=> "input",
				        "std"   => __("with eyes like the sea", 'avia_framework' )),
				
				array(	"name" 	=> __("Top Subheading", 'avia_framework' ),
						"desc" 	=> "",
				        "id" 	=> "top_sub",
				        "type" 	=> "input",
					  	"container_class" => 'av_half',
				        "std"   => __("perfect and poor...", 'avia_framework' )),
				
				array(	"name" 	=> __("Bottom Subheading", 'avia_framework' ),
						"desc" 	=> "",
				        "id" 	=> "btm_sub",
				        "type" 	=> "input",
					  	"container_class" => 'av_half',
				        "std"   => __("...after a storm.", 'avia_framework' )),
				
				array(	"name" 	=> __("Top Subheading Shift", 'avia_framework' ),
						"desc" 	=> __("Use a negative number to shift it to the left and a positive number to shift it right.", 'avia_framework' ),
				        "id" 	=> "top_sub_shift",
				        "type" 	=> "input",
					  	"container_class" => 'av_half',
				        "std"   => __("-180", 'avia_framework' )),
				
				array(	"name" 	=> __("Bottom Subheading Shift", 'avia_framework' ),
						"desc" 	=> __("Use a negative number to shift it to the left and a positive number to shift it right.", 'avia_framework' ),
				        "id" 	=> "btm_sub_shift",
				        "type" 	=> "input",
					  	"container_class" => 'av_half',
				        "std"   => __("200", 'avia_framework' )),
				
			array( 	"type" 	=> "close_div",
					'nodescription' => true),
				
				
			array(  "type" 	=> "tab",
					"name"	=> __("Colors",'avia_framework' ),
					'nodescription' => true), 
						
				array(	"name" 	=> __("Main Title Font Color", 'avia_framework' ),
						"desc" 	=> __("Select a custom font color for your main title text.", 'avia_framework' ),
						"id" 	=> "main_font",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#e6f9ff",
					 	),
				
				array(	"name" 	=> __("Background Color", 'avia_framework' ),
						"desc" 	=> __("Select a custom color for the element background.", 'avia_framework' ),
						"id" 	=> "bg_color",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#201c29",
						),
							
				array(	"name" 	=> __("Top Subheding Font Color", 'avia_framework' ),
						"desc" 	=> __("Select a custom font color for top subheading text.", 'avia_framework' ),
						"id" 	=> "top_font",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#66ffff",
						),
				
				array(	"name" 	=> __("Bottom Subheding Font Color", 'avia_framework' ),
						"desc" 	=> __("Select a custom font color for bottom subheading text.", 'avia_framework' ),
						"id" 	=> "btm_font",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#66ffff",
						),
				
				array(	"name" 	=> __("Gradient 1", 'avia_framework' ),
						"desc" 	=> __("Select a custom color for the first bracket gradient.", 'avia_framework' ),
						"id" 	=> "gradient1",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#3399ff",
						),
				
				array(	"name" 	=> __("Gradient 2", 'avia_framework' ),
						"desc" 	=> __("Select a custom color for the second bracket gradient.", 'avia_framework' ),
						"id" 	=> "gradient2",
						"container_class" => 'av_half',
						"type" 	=> "colorpicker",
						"std" 	=> "#66ffff",
						),
							
			array(	"type" 	=> "close_div",
					'nodescription' => true),
						
						
				array(	"type" 	=> "tab",
						"name"	=> __("Screen Options",'avia_framework' ),
						'nodescription' => true),
																
				array(	"name" 	=> __("Element Visibility",'avia_framework' ),
						"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
						"type" 	=> "heading",
						"description_class" => "av-builder-note av-neutral",),
							
				array(	"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
						"id" 	=> "av-desktop-hide",
						"std" 	=> "",
						"container_class" => 'av-multi-checkbox',
						"type" 	=> "checkbox"),
								
				array(	"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
						"id" 	=> "av-medium-hide",
						"std" 	=> "",
						"container_class" => 'av-multi-checkbox',
						"type" 	=> "checkbox"),
										
				array(	"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
						"id" 	=> "av-small-hide",
						"std" 	=> "",
						"container_class" => 'av-multi-checkbox',
						"type" 	=> "checkbox"),
										
				array(	"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
						"id" 	=> "av-mini-hide",
						"std" 	=> "",
						"container_class" => 'av-multi-checkbox',
						"type" 	=> "checkbox"),
									
				array(	"type" 	=> "close_div",
						'nodescription' => true),
				
				array(
							"type" 	=> "tab",
							"name"  => __('<strong style="color:#e65100;">'."ADVANCED STYLING".'</strong>' , 'avia_framework'),
							'nodescription' => true
						),
						
					array(
							"name" 	=> __("<span style='color:#0074a2;'>CHANGING FONTS?</span>",'avia_framework' ),
							"desc" 	=> __("This element uses Google Fonts to achieve that elegant look. Would you like to use different fonts? Follow the instructions below and you can easily switch things up.<br />&nbsp;<br />In the Enfold Theme Options, head to the Google Services tab and paste the import code for the font you like into the text area. It will look like:<br /><pre>&lt;link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Great+Vibes' /&gt;</pre><br />The next step is to declare the CSS font family. Google Fonts will give you this code as well. Enter it into the field below. It will look like:<br /><pre>font-family: 'Great Vibes', cursive;</pre>", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
					
					array(	"name" 	=> __("Google Font CSS (Heading)", 'avia_framework' ),
							"desc" 	=> __("Changes the Google Font used for the main heading.", 'avia_framework' ),
						  	"id" 	=> "googfont1",
				        	"type" 	=> "input",
							"container_class" => 'av_half',
				        	"std"   => __("font-family: 'Great Vibes', cursive;", 'avia_framework' )),
					array(	"name" 	=> __("Google Font CSS (Subheading)", 'avia_framework' ),
							"desc" 	=> __("Changes the Google Font used for the subheadings.", 'avia_framework' ),
				        	"id" 	=> "googfont2",
				        	"type" 	=> "input",
							"container_class" => 'av_half',
				        	"std"   => __("font-family: 'Open Sans';", 'avia_framework' )),
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the main heading in pixels.", 'avia_framework' ),
				            "id" 	=> "heading_size",
				            "type" 	=> "select",
						    "container_class" => 'av_half',
				            "subtype" => AviaHtmlHelper::number_array(20,100,1, array( __("Default Size", 'avia_framework' )=>'80')),
				            "std" => ""),
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the subheadings in pixels.", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
						    "container_class" => 'av_half',
				            "subtype" => AviaHtmlHelper::number_array(12,69,1, array( __("Default Size", 'avia_framework' )=>'24')),
				            "std" => ""),
						
				array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
		
				array(  "type" 	=> "close_div",
						'nodescription' => true),	
				
				);
		}
		



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('main'=>'', 'top_sub'=>'', 'top_sub_shift'=>'', 'btm_sub'=>'', 'btm_sub_shift'=>'', 'main_font'=>'', 'top_font'=>'', 'btm_font'=>'', 'bg_color'=>'', 'gradient1'=>'', 'gradient2'=>'', 'googfont1'=>'', 'googfont2', 'heading_size'=>'', 'subheading_size'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			// styling
			if(is_rtl()):
				$top_shift = "right:{$top_sub_shift}px !important;";
				$btm_shift = "right:{$btm_sub_shift}px !important;";
			else:
				$top_shift = "left:{$top_sub_shift}px !important;";
				$btm_shift = "left:{$btm_sub_shift}px !important;";
			endif;
			$top_color = "color:{$top_font} !important;";
			$top_size = "font-size:{$subheading_size}px !important;";
			$btm_color = "color:{$btm_font} !important;";
			$btm_size = "font-size:{$subheading_size}px !important;";
			$main_color = "color:{$main_font} !important;";
			$main_size = "font-size:{$heading_size}px !important;";
			$bgcolor = "background:{$bg_color} !important;'";

			
			$bg_style = " style='{$bgcolor}'";	
			$top_style = " style='{$top_shift}{$top_color}{$top_size}'";
			$btm_style = " style='{$btm_shift}{$btm_color}{$btm_size}'";
			$main_style = " style='{$main_color}{$main_size}'";
			$circle_style = " style='background:{$gradient2} !important;'";
			$bracket_style = " style='background-image: linear-gradient(45deg, {$gradient1}, {$gradient2}, {$gradient1} 100%);'";
					
			//html markup
	        		$output .= "<style>#elegant-title .bracket.right:before, #elegant-title .bracket.right:after, #elegant-title .bracket.left:before, #elegant-title .bracket.left:after {background: ".$gradient1." !important;}</style><div class='{$av_display_classes}'><div id='elegant-title' class='frame'".$bg_style."><div class='circle avia_animate_when_almost_visible'".$circle_style."></div><div class='line left avia_animate_when_almost_visible'".$circle_style."></div><div class='line right avia_animate_when_almost_visible'".$circle_style."></div><div class='bracket left avia_animate_when_almost_visible'".$bracket_style."></div><div class='bracket right avia_animate_when_almost_visible'".$bracket_style."></div><div class='small top avia_animate_when_almost_visible'".$top_style.">".$top_sub."</div><div class='big avia_animate_when_almost_visible'".$main_style.">".$main."</div><div class='small bottom avia_animate_when_almost_visible'".$btm_style.">".$btm_sub."</div><div class='hide top avia_animate_when_almost_visible'".$bg_style."></div><div class='hide bottom avia_animate_when_almost_visible'".$bg_style."></div></div></div>";
			return $output;
		}
	}
}
