<?php
/**
 * Icon List Shortcode
 * 
 * Creates a list with nice icons beside
 */
if ( ! defined( 'ABSPATH' ) ) {  exit;  }    // Exit if accessed directly

if ( !class_exists( 'avia_filetype_icon' ) )
{
	class avia_filetype_icon extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$this->config['self_closing']	=	'no';
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Filetype Icons', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."filetype.png";
				$this->config['order']		= 90;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'filetype_icon';
				$this->config['shortcode_nested'] = array('filetype_item');
				$this->config['tooltip'] 	= __('Creates a list with nice icons beside', 'avia_framework' );
				$this->config['preview'] 	= true;
				$this->config['disabling_allowed'] = true;

			}
			
			public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}

			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
						array(
							"name" 	=> __("Icon Height", 'avia_framework' ),
							"desc" 	=> __("Set the icon height in pixels.", 'avia_framework' ) ,
							"id" 	=> "height",
							"std" 	=> "50",
							"container_class" => 'av_half',
							"type" 	=> "input"),
								
						array(
							"name" 	=> __("Icon Width", 'avia_framework' ),
							"desc" 	=> __("Set the icon width in pixels.", 'avia_framework' ) ,
							"id" 	=> "width",
							"std" 	=> "40",
							"container_class" => 'av_half',
							"type" 	=> "input"),

						array(
							"name" => __("Add/Edit Filetype Icons", 'avia_framework' ),
							"desc" => __("Here you can add, remove and edit the items of your item list.", 'avia_framework' ),
							"type" 			=> "modal_group",
							"id" 			=> "content",
							"modal_title" 	=> __("Edit List Item", 'avia_framework' ),
							"std"			=> array(

													array('title'=>__('PSD', 'avia_framework' ), 'icon_bg_color'=>'#4285f4', 'filetype_color'=>'#ffffff', 'corner_bg_color'=>'#ffffff'),
													array('title'=>__('PDF', 'avia_framework' ), 'icon_bg_color'=>'#b02b2c', 'filetype_color'=>'#ffffff', 'corner_bg_color'=>'#ffffff'),
													array('title'=>__('AI', 'avia_framework' ), 'icon_bg_color'=>'#edae44', 'filetype_color'=>'#ffffff', 'corner_bg_color'=>'#ffffff'),

													),


							'subelements' 	=> array(

									array(
									"name" 	=> __("Filetype", 'avia_framework' ),
									"desc" 	=> __("Enter the list item title here (Better keep it short)", 'avia_framework' ) ,
									"id" 	=> "title",
									"std" 	=> "",
									"type" 	=> "input"),
								
									array(
									"name" 	=> __("File URL",'avia_framework' ),
									"desc" 	=> __("Insert the direct URL to the file.<br />Do you need to find the URL from or upload a file to your media gallery?  Click the button below to open your media gallery in a new tab.<br /><br /><a class='button' href='/wp-admin/upload.php
' target='_blank'>Open Media Library</a>",'avia_framework' ),
									"id" 	=> "src",
									"type" 	=> "input",
									"std" 	=> ""),

                                	array(	
									"name" 	=> __("Label Color", 'avia_framework' ),"name" 	=> __("Filetype Icon & Font Color", 'avia_framework' ),
									"desc" 	=> __("Select a custom font color for your filetype icon and font.", 'avia_framework' ),
									"id" 	=> "filetype_color",
									"type" 	=> "colorpicker",
									"std" 	=> "#ffffff",
					 				),
								
									array(	
									"name" 	=> __("Icon Background Color", 'avia_framework' ),
									"desc" 	=> __("Select a custom background color for your icon.", 'avia_framework' ),
									"id" 	=> "icon_bg_color",
									"type" 	=> "colorpicker",
									"std" 	=> "#4285f4",
					 				),
									
									array(	
									"name" 	=> __("Icon Corner Background Color", 'avia_framework' ),
									"desc" 	=> __("Select a custom background color for the icon corner effect. By default it is set to white, but if your container background is set to a specific color, adjust this to match.", 'avia_framework' ),
									"id" 	=> "corner_bg_color",
									"type" 	=> "colorpicker",
									"std" 	=> "#ffffff",
					 				),
                                ),
					),


					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),

								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),
					
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),

				);


			}
		
		
public function is_nested_self_closing( $shortcode )
{
   return true;
}

			/**
			 * Editor Sub Element - this function defines the visual appearance of an element that is displayed within a modal window and on click opens its own modal window
			 * Works in the same way as Editor Element
			 * @param array $params this array holds the default values for $content and $args.
			 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
			 */
			function editor_sub_element($params)
			{
				$template = $this->update_template("title", __("Filetype", 'avia_framework' ). ": {{title}}");

				$params['innerHtml']  = "";
				$params['innerHtml'] .= "<div class='avia_title_container'>";
				$params['innerHtml'] .= "<span {$template} >".__("Filetype", 'avia_framework' ).": ".$params['args']['title']."</span></div>";

				return $params;
			}



			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				$this->screen_options = AviaHelper::av_mobile_sizes($atts);
				extract($this->screen_options); //return $av_font_classes, $av_title_font_classes and $av_display_classes
				
				extract(shortcode_atts(array(
				
				'title'=>'',
				'height'=>'',
				'width'=>'',
				'src'=>'',
				'filetype_color'=>'', 
				'icon_bg_color'=>'',
				'corner_bg_color'=>'',
				
				), $atts, $this->config['shortcode']));
				
				$height  = $atts['height'];
				$width  = $atts['width'];
					
				$output  = "";
				$output .= "<style>#filetype.icons .icon {height:{$height}px !important; width:{$width}px !important;}</style>";
				$output .= "<div id='filetype' class='icons ".$meta['el_class']." {$av_display_classes}'>";
				$output .= ShortcodeHelper::avia_remove_autop( $content, true );
				$output .= "</div>";
				return $output;
			}

			function filetype_item($atts, $content = "", $shortcodename = "")
			{
				
				extract($this->screen_options); //return $av_font_classes, $av_title_font_classes and $av_display_classes
				
                $atts =  shortcode_atts(array('title' => '', 'height' => '', 'width' => '', 'filetype_color' => '', 'src' => '', 'icon_bg_color'=>'', 'corner_bg_color'=>''), $atts, 'filetype_item');
					
				$filetype  = $atts['title'];
				$height  = $atts['height'];
				$width  = $atts['width'];
				$src  = $atts['src'];
				$icon_bg_color = $atts['icon_bg_color'];
				$filetype_color = $atts['filetype_color'];
				$corner = $atts['corner_bg_color'];
				$filetype_class = ".".$filetype;
								
				$output	 = "";
				$output .= "<style>#filetype.icons i.".$filetype."::after {content:'".$filetype."' !important;}</style>";
				$output .= "<a href='".$src."'>";
				$output .= "<div class='icon' style='background-color:";
				$output .= $icon_bg_color;
				if(is_rtl()):
					$output .= " !important;'><div class='corner' style='border-left:12px solid ";
				else:
					$output .= " !important;'><div class='corner' style='border-right:12px solid ";
				endif;
				$output .= $corner;
				$output .= " !important;'></div><i class='";
				$output .= $filetype;
				$output .= "' style='color:";
				$output .= $filetype_color;
				$output .= " !important;' title='Download ";
				$output .= $filetype;
				$output .= "'></i></div></a>";

				return $output;
			}


	}
}
