<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * WooCommerce Gift Wrap
 * Displays an option to add gift wrapping to your cart.
 */

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('gift_wrap', 'avia_please_install_woo');
	return;
}

 
if ( !class_exists( 'avia_gift_wrap' ) ) 
{
	class avia_gift_wrap extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Gift Wrap', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."gift-wrap.png";
				$this->config['order']		= 92;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'gift_wrap';
				$this->config['tooltip'] 	= __('Displays an option to add gift wrapping to your cart.', 'avia_framework' );
				$this->config['tinyMCE']    = array('tiny_always'=>true);
				$this->config['preview'] 	= true;
				$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
			}
		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(
						"name" 	=> __("Which Product?", 'avia_framework' ),
						"desc" 	=> __("Select which product should be added to the cart. For desired results, ensure you select a <strong>Simple Product</strong> from the list.", 'avia_framework' ),
						"id" 	=> "link",
						"type" 	=> "select",
						"taxonomy" => "single",
						"subtype" => "product",
						"multiple"	=> 6
						),
						
					array(	
							"name" 	=> __("Gift Wrap Image", 'avia_framework' ),
							"desc" 	=> __("Choose the image you'd like on the left.", 'avia_framework' ),
							"id" 	=> "giftwrap",
							"type" 	=> "select",
							"std" 	=> "gift1",
							"subtype" => array(
								__('Option 1',   'avia_framework' ) =>'gift1',
								__('Option 2',   'avia_framework' ) =>'gift2',
								__('Option 3',   'avia_framework' ) =>'gift3',
								__('Option 4',   'avia_framework' ) =>'gift4',
								__('Option 5',   'avia_framework' ) =>'gift5',
								__('Option 6',   'avia_framework' ) =>'gift6',
								__('Option 7',   'avia_framework' ) =>'gift7',
								__('Option 8',   'avia_framework' ) =>'gift8',
							)),	
							
					array(	"name" 	=> __("Heading Text", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your button.", 'avia_framework' ),
				            "id" 	=> "heading_label",
				            "type" 	=> "input",
				            "std" => __("GIFT WRAP", 'avia_framework' )),					
					
				    array(
						"name" 	=> __("Gift Wrap Text",'avia_framework' ),
						"desc" 	=> __("A brief promo blurb to tell your customers about the gift wrap add-on option.",'avia_framework' ),
						"id" 	=> "gifttext",
						"type" 	=> "textarea",
						"std" 	=> "Are you getting this product as a gift for someone else? Allow us to gift wrap and deliver it for you.  This product will be packaged in its own box, professionally wrapped, and delivered to the destination of your choice."),  
						
					array(	"name" 	=> __("Button Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your button.", 'avia_framework' ),
				            "id" 	=> "label",
				            "type" 	=> "input",
				            "std" => __("ADD TO CART", 'avia_framework' )),
					
					array(	
							"name" 	=> __("Button Size", 'avia_framework' ),
							"desc" 	=> __("Choose the size of your button here", 'avia_framework' ),
							"id" 	=> "size",
							"type" 	=> "select",
							"std" 	=> "small",
							"subtype" => array(
								__('Small',   'avia_framework' ) =>'small',
								__('Medium',  'avia_framework' ) =>'medium',
								__('Large',   'avia_framework' ) =>'large',
								__('X Large',   'avia_framework' ) =>'x-large',
							)),
							
					array(	
							"name" 	=> __("Button Icon", 'avia_framework' ),
							"desc" 	=> __("Should an icon be displayed at the left side of the button", 'avia_framework' ),
							"id" 	=> "icon_select",
							"type" 	=> "select",
							"std" 	=> "no",
							"subtype" => array(
								__('No Icon',  'avia_framework' ) =>'no',
								__('Yes, display Icon to the left',  'avia_framework' ) => 'yes' ,	
								__('Yes, display Icon to the right',  'avia_framework' ) =>'yes-right-icon',
								)),
					array(	
							"name" 	=> __("Icon Visibility",'avia_framework' ),
							"desc" 	=> __("Check to only display icon on hover",'avia_framework' ),
							"id" 	=> "icon_hover",
							"type" 	=> "checkbox",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(	
							"name" 	=> __("Button Icon",'avia_framework' ),
							"desc" 	=> __("Select an icon for your Button below",'avia_framework' ),
							"id" 	=> "icon",
							"type" 	=> "iconfont",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "heading_color",
							"type" 	=> "select",
							"std" 	=> "default-heading",
							"subtype" => array( __("Default", 'avia_framework' )=>'default-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_heading_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('heading_color','equals','custom-color-heading')
						),
						
					array(	
							"name" 	=> __("Special Background Color", 'avia_framework' ),
							"desc" 	=> __("Some aspects of the header have a background color attached in order to give the overall effect. This option allows you to adjust it to suit the particular design of your setup.", 'avia_framework' ),
							"id" 	=> "bgcolor",
							"type" 	=> "select",
							"std" 	=> "default-bgcolor",
							"subtype" => array( __("Default", 'avia_framework' )=>'default-bgcolor', __("Custom Color", 'avia_framework' )=>'custom-bgcolor')
							), 
					
					array(	
							"name" 	=> __("Custom Background Color", 'avia_framework' ),
							"desc" 	=> __("Adjust the Special Background Color here.", 'avia_framework' ),
							"id" 	=> "custom_bg_color",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('bgcolor','equals','custom-bgcolor')
						),
					
					array(	
							"name" 	=> __("Button Color", 'avia_framework' ),
							"desc" 	=> __("Choose a color for your button here", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "grey",
							"subtype" => array(	
												__('Translucent Buttons', 'avia_framework' ) => array(
													__('Light Transparent', 'avia_framework' )=>'light',
													__('Dark Transparent', 'avia_framework' )=>'dark',
												),
														
												__('Colored Buttons', 'avia_framework' ) => array(
												__('Theme Color', 'avia_framework' )=>'theme-color',
												__('Theme Color Highlight', 'avia_framework' )=>'theme-color-highlight',
												__('Theme Color Subtle', 'avia_framework' )=>'theme-color-subtle',
												__('Blue', 'avia_framework' )=>'blue',
												__('Red',  'avia_framework' )=>'red',
												__('Green', 'avia_framework' )=>'green',
												__('Orange', 'avia_framework' )=>'orange',
												__('Aqua', 'avia_framework' )=>'aqua',
												__('Teal', 'avia_framework' )=>'teal',
												__('Purple', 'avia_framework' )=>'purple',
												__('Pink', 'avia_framework' )=>'pink',
												__('Silver', 'avia_framework' )=>'silver',
												__('Grey', 'avia_framework' )=>'grey',
												__('Black', 'avia_framework' )=>'black',
												__('Custom Color', 'avia_framework' )=>'custom',
												)),
								),

							
					array(	
							"name" 	=> __("Custom Background Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#444444",
							"required" => array('color','equals','custom')
						),	
						
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
							"required" => array('color','equals','custom')
						),	
											
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $gifttext = "", $shortcodename = "", $meta = "")
			{
				$template_url = get_stylesheet_directory_uri();
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('heading_label' => 'GIFT WRAP',
			   								 'label' => 'ADD TO CART', 
			                                 'link' => '', 
			                                 'color' => 'grey',
			                                 'custom_bg' => '#444444',
			                                 'custom_font' => '#ffffff',
			                                 'size' => 'medium',
			                                 'icon_select' => 'no',
			                                 'icon' => '', 
			                                 'font' =>'',
			                                 'icon_hover' => '',
											 'giftwrap' => '',
											 'gifttext' => '',
											 'custom_heading_font' => '',
											 'heading_color' => '',
											 'bgcolor' => '',
											 'custom_bg_color' => '',
			                                 ), $atts, $this->config['shortcode']);
											 
				$display_char 	= av_icon($atts['icon'], $atts['font']);
				$extraClass 	= $atts['icon_hover'] ? "av-icon-on-hover" : "";
				
				if($atts['icon_select'] == "yes") $atts['icon_select'] = "yes-left-icon";
				
				$style = "";
				if($atts['color'] == "custom") 
				{
					$style .= "style='background-color:".$atts['custom_bg']."; border-color:".$atts['custom_bg']."; color:".$atts['custom_font']."; '";
				}
				if($atts['giftwrap'] == "gift1") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift1.png';
				}
				if($atts['giftwrap'] == "gift2") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift2.png';
				}
				if($atts['giftwrap'] == "gift3") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift3.png';
				}
				if($atts['giftwrap'] == "gift4") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift4.png';
				}
				if($atts['giftwrap'] == "gift5") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift5.png';
				}
				if($atts['giftwrap'] == "gift6") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift6.png';
				}
				if($atts['giftwrap'] == "gift7") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift7.png';
				}
				if($atts['giftwrap'] == "gift8") 
				{
					$giftwrapimg .= $template_url.'/shortcodes/spiderfly-elements/images/gift8.png';
				}
				
			    $link  = AviaHelper::get_url($atts['link']);

			    $content_html = "";
			    if('yes-left-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_left ' {$display_char}></span>";
				$content_html .= "<span class='avia_iconbox_title' >".$atts['label']."</span>";
			    if('yes-right-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_right' {$display_char}></span>";
				
				if($atts['heading_color'] == "custom-color-heading")  
	        		{$customcolor = $atts['custom_heading_font'];}
			    if($atts['heading_color'] == "default-heading")  
	        		{$customcolor = "#d54e21";}
					
				if($atts['bgcolor'] == "custom-bgcolor")  
	        		{$specialbg = $atts['custom_bg_color'];}
			    if($atts['bgcolor'] == "default-bgcolor")  
	        		{$specialbg = "#ffffff";}
			    
				global $product;
				$product_id = $atts['link'];
				$product = new WC_Product($product_id);
				$price = $product->get_price();
				
				$output  = "";
				$output .= "<a href='?add-to-cart={$link}' class='avia-button {$extraClass} {$av_display_classes} ".$this->class_by_arguments('icon_select, color, size' , $atts, true)."' {$blank} {$style} >";
				$output .= $content_html;
				$output .= "</a>";
				if(is_rtl()):
					$output =  "<div class='av-catalogue-container av-catalogue-container-woo catalogue-mod {$av_display_classes}'><ul class='av-catalogue-list'><li><img  style='width:70px !important; float:right !important; margin-left:15px !important;' width='180' height='180' src='".$giftwrapimg."' alt='Gift Wrap' /><div class='av-catalogue-item-inner'><div class='av-catalogue-title-container'><div class='av-catalogue-title av-cart-update-title' style='padding-left: 10px !important; z-index: 10; position: absolute; top: 0; right: 0;'><strong style='color:".$customcolor."; background-color:".$specialbg."; z-index:10; padding-right:10px;'>".$atts['heading_label']."</strong></div><div style='border-bottom:1px dotted ".$customcolor."; transform: translateY(-48%); height:25px;'></div><div class='av-catalogue-price av-cart-update-price' style='padding-right: 10px;'><span class='woocommerce-Price-amount amount'><strong style='color:".$customcolor."; background-color:".$specialbg."; z-index:10; padding-right:10px;'><small style='color:#000; opacity:0.4;'>ONLY&nbsp;</small> <span class='woocommerce-Price-currencySymbol'>$</span>".$price."</strong></span></div></div><div>".$atts['gifttext']."</div><div style='margin-top:10px;' class='avia-button-wrap avia-button-left ".$meta['el_class']."'>".$output."</div></div><span class='image-overlay overlay-type-extern' style='display: none;'><span class='image-overlay-inside'></span></span></li></ul></div>";
				else:
					$output =  "<div class='av-catalogue-container av-catalogue-container-woo catalogue-mod {$av_display_classes}'><ul class='av-catalogue-list'><li><img  style='width:70px !important; float:left !important; margin-right:15px !important;' width='180' height='180' src='".$giftwrapimg."' alt='Gift Wrap' /><div class='av-catalogue-item-inner'><div class='av-catalogue-title-container'><div class='av-catalogue-title av-cart-update-title' style='padding-right: 10px !important; z-index: 10; position: absolute; top: 0; left: 0;'><strong style='color:".$customcolor."; background-color:".$specialbg."; z-index:10; padding-right:10px;'>".$atts['heading_label']."</strong></div><div style='border-bottom:1px dotted ".$customcolor."; transform: translateY(-48%); height:25px;'></div><div class='av-catalogue-price av-cart-update-price' style='padding-left: 10px;'><span class='woocommerce-Price-amount amount'><strong style='color:".$customcolor."; background-color:".$specialbg."; z-index:10; padding-left:10px;'><small style='color:#000; opacity:0.4;'>ONLY&nbsp;</small> <span class='woocommerce-Price-currencySymbol'>$</span>".$price."</strong></span></div></div><div>".$atts['gifttext']."</div><div style='margin-top:10px;' class='avia-button-wrap avia-button-left ".$meta['el_class']."'>".$output."</div></div><span class='image-overlay overlay-type-extern' style='display: none;'><span class='image-overlay-inside'></span></span></li></ul></div>";
				endif;
				
				return $output;
			}
	
	}
}
