<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Shortlink
 * Displays the shortlink to the current page.
 */
 
 if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_prodgallery', 'avia_please_install_woo');
	return;
}
 
if ( !class_exists( 'avia_prodgallery' ) )
{
	class avia_prodgallery extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Product Gallery', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."prod-gallery.png";
			$this->config['order']		= 96;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_prodgallery';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays the product gallery images.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Styling Options",'avia_framework' ),
							'nodescription' => true
						), 
						
					array(
						"name" 	=> "",
						"desc" 	=> __("The gallery thumbnails are set to pull the 'shop_catalog' image assuming you have not changed the default dimensions in the WooCommerce settings from 450x450.", 'avia_framework' ),
						"type" 	=> "heading",
						"description_class" => "av-builder-note av-neutral",),
					array(	
						"name" 	=> __("Thumbnail Source Override", 'avia_framework' ),
						"desc" 	=> __("Enter the slug for the source image you want to be called for the thumbnail to override the default setting. (ex. square or thumbnail)", 'avia_framework' ),
						"id" 	=> "img_override",
						"std" 	=> "",
						"type" 	=> "input"),
					array(	
							"name" 	=> __("Thumbnail Columns", 'avia_framework' ),
							"desc" 	=> __("Select the number of colums to display per row of thumbnails.", 'avia_framework' ),
							"id" 	=> "columns",
							"type" 	=> "select",
							"std" 	=> "three-col",
							"subtype" => array( __("Two Columns", 'avia_framework' )=>'two-col',  __("Three Columns", 'avia_framework' )=>'three-col',  __("Four Columns", 'avia_framework' )=>'four-col',  __("Five Columns", 'avia_framework' )=>'five-col',  __("Six Columns", 'avia_framework' )=>'six-col')
							),
							
					array(	
							"name" 	=> __("Custom Border Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your shortlink text here.", 'avia_framework' ),
							"id" 	=> "custom_color",
							"type" 	=> "colorpicker",
							"std" 	=> "",
						),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
								
						
						
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('img_override'=>'','custom_color'=>'','columns'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			// if the color is a custom hex value add the styling for both border and font

	        if ($custom_color){
			$styling .= "{$custom_color};";
			} else {
			$styling = "#b0b0b0;";
			}
			
			if ($columns == 'two-col'){$col_width = 'width:48%; margin: 1%;';}
			if ($columns == 'three-col'){$col_width = 'width:31.33%; margin: 1%;';}
			if ($columns == 'four-col'){$col_width = 'width:23%; margin: 1%;';}
			if ($columns == 'five-col'){$col_width = 'width:18%; margin: 1%;';}
			if ($columns == 'six-col'){$col_width = 'width:14.66%; margin: 1%;';}
	        		
			//finish up the styling string
					
			global $product;
			$product = wc_get_product();
    		$attachment_ids = $product->get_gallery_attachment_ids();
			
			if(is_rtl()):
				$link_style = 'style="float:right; display:inline; '.$col_width.'"';
				$img_style = 'style="border:1px solid '.$styling.' float:right; display:inline;"';
			else:
				$link_style = 'style="float:left; display:inline; '.$col_width.'"';
				$img_style = 'style="border:1px solid '.$styling.' float:left; display:inline;"';
			endif;
			if ($img_override){$override = $img_override;}else{$override = 'shop_catalog';}
					
			//html markup
			$output .= '<div class="'.$av_display_classes.'">';
	        foreach( $attachment_ids as $attachment_id ) {
        	$output .= '<a '. $link_style .' href="'.wp_get_attachment_image_src( $attachment_id, 'large' )[0].'" rel="lightbox"><img src="'. wp_get_attachment_image_src( $attachment_id, $override )[0] .'" alt="'.get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ).'" title="'.get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ).'" '.$img_style.' /></a>';
    		}
			$output .= '</div>';
			return $output;
		}
	}
}
