<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Single Product Listing
 * Displays a single product listing based on either the ID or SKU
 */

// adds the css to make the widget adjust to its container
add_action('wp_head','product_single_style');
function product_single_style( ){echo '<style>.single-product-listing li.product {width:100%!important;}</style>';}

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_wc_single', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_sc_wc_single' ) ) 
{
	class avia_sc_wc_single extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Single Product', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."single-product.png";
				$this->config['order']		= 96;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'av_wc_single';
				$this->config['tooltip'] 	= __('Displays a single product listing based on either the ID or SKU.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['preview'] 	= false;
			}
		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
				    array(
						"name" 	=> __("Which Product?", 'avia_framework' ),
						"desc" 	=> __("Select which product you would like displayed.", 'avia_framework' ),
						"id" 	=> "link",
						"type" 	=> "select",
						"taxonomy" => "single",
						"subtype" => "product",
						),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			function editor_element($params)
			{
				
				$params['args'] = shortcode_atts(array('link' => ''	),
				
				$params['args'], $this->config['shortcode']);
				
				$templateNAME  	= $this->update_template("name", "{{name}}");
				global $product;
				$link = isset( $params['args']['link'] ) ? $params['args']['link'] : '';
				$product = wc_get_product( $link );
				$prod_title = $product->post->post_title;
				
				$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
				if ($link) {$params['innerHtml'].= "<div class='avia-element-label'>".$prod_title."</div>";}
				else {$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";}
				return $params;
			}
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('link' => '', 
			                                 ), $atts, $this->config['shortcode']);
				
			    $link  = $atts['link'];
			    
			    
			    $content_html = "";
			    $content_html .= "<div class='single-product-listing {$av_display_classes}'>[product id='{$link}']</div>";
  
			    $output  = "";
				$output .= do_shortcode( $content_html );
				
				return $output;
			}
			
			
			
	
	}
}
