<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Product Tags
 * Displays a list of product tags.
 */
 
add_action('wp_head','taglist_style');
function taglist_style( ){
	if(is_rtl()):
		echo '<style>ul.product_tags li:first-child {padding-right:0px !important;} ul.product_tags li:last-child {border-left:none !important;} ul.product_tags li a, ul.product_tags li {color:#a1a1a1; text-decoration:none;}</style>';
	else:
		echo '<style>ul.product_tags li:first-child {padding-left:0px !important;} ul.product_tags li:last-child {border-right:none !important;} ul.product_tags li a, ul.product_tags li {color:#a1a1a1; text-decoration:none;}</style>';
	endif;
}

if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_sale_productgrid', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'avia_wc_prod_tags' ) )
{
	class avia_wc_prod_tags extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Product Tags', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."product-tag.png";
			$this->config['order']		= 91;
			$this->config['target']		= 'avia-target-insert';
			$this->config['shortcode'] 	= 'av_wc_prod_tags';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['tooltip'] 	= __('Displays a list of product tags.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}


		/**
		 * Popup Elements
		 *
		 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
		 * opens a modal window that allows to edit the element properties
		 *
		 * @return void
		 */
		function popup_elements()
		{
			$this->elements = array(
					
				array(
						"type" 	=> "tab_container", 'nodescription' => true
					),
					
				array(
							"type" 	=> "tab",
							"name"	=> __("Content & Styling",'avia_framework' ),
							'nodescription' => true
						), 
						
					array(	
						"name" 	=> __("List Title", 'avia_framework' ),
						"desc" 	=> __("Enter an optional title for your tag list.", 'avia_framework' ),
						"id" 	=> "list_title",
						"std" 	=> __("TAGS", 'avia_framework' ),
						"type" 	=> "input"),
				            
				    array(	
							"name" 	=> __("Text Color", 'avia_framework' ),
							"desc" 	=> __("Select a color for the text.", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-product-tag')
							), 
							
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your text here.", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('color','equals','custom-color-product-tag')
						),
						
					array(	
							"name" 	=> __("Tag Style", 'avia_framework' ),
							"desc" 	=> __("Select which style in which you would like your tag list displayed.", 'avia_framework' ),
							"id" 	=> "tag_style",
							"type" 	=> "select",
							"std" 	=> "uppercase",
							"subtype" => array("UPPERCASE"=>'uppercase',"Capitalize"=>'capitalize',"lowercase"=>'lowercase')
							), 
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				

				);
		}


		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		 
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('list_title'=>'', 'color'=>'', 'custom_font'=>'', 'tag_style'=>''), $atts, $this->config['shortcode']));
			
			$meta['el_class'];
			
			global $woocommerce, $product;
			if(!is_object($woocommerce) || !is_object($woocommerce->query) || empty($product)) return;
			
			ob_start();
			
			// get product_tags of the current product
$current_tags = get_the_terms( get_the_ID(), 'product_tag' );

//only start if we have some tags
if ( $current_tags && ! is_wp_error( $current_tags ) ) { 
			if(is_rtl()):
				$li_style = 'style="float:right; list-style:none; margin-right:0px; padding:0 10px; border-left:1px solid #dddddd;"';
				$ul_style = 'style="margin-right:0px; padding:10px 0px;"';
			else:
				$li_style = 'style="float:left; list-style:none; margin-left:0px; padding:0 10px; border-right:1px solid #dddddd;"';
				$ul_style = 'style="margin-left:0px; padding:10px 0px;"';
			endif;
			
			// if the color is a custom hex value add the styling for font
	        		if($color == "custom-color-product-tag" && $custom_font)  
	        		{
	        			$styling .= "color:{$custom_font} !important;";
	        		}
			//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling} text-transform:{$tag_style} !important;'";
					if(empty($styling)) $styling = "style='text-transform:{$tag_style} !important;'";
			
			//Handle the tag title
				if($color == "custom-color-product-tag" && $custom_font) {
					if(is_rtl()){
						if($list_title)
						$list_title = "<li style='float:right; list-style:none; margin-right:0px; padding:0px; font-weight:bold; color:{$custom_font} !important; filter: brightness(65%);'>{$list_title}: </li>";
					} else {
						if($list_title)
						$list_title = "<li style='float:left; list-style:none; margin-left:0px; padding:0px; font-weight:bold; color:{$custom_font} !important; filter: brightness(65%);'>{$list_title}: </li>";
					}
				} else {
					if(is_rtl()){
						if($list_title)
						$list_title = "<li style='float:right; list-style:none; margin-right:0px; padding:0px; font-weight: bold; filter: brightness(85%);'>{$list_title}: </li>";
					} else {
						if($list_title)
						$list_title = "<li style='float:left; list-style:none; margin-left:0px; padding:0px; font-weight: bold; filter: brightness(85%);'>{$list_title}: </li>";
					}
				}
			//html markup
	        		$output .= '<ul class="product_tags {$av_display_classes}" '.$ul_style.'>'.$list_title;
					foreach ($current_tags as $tag) {
        			$tag_title = $tag->name; // tag name
        			$tag_link = get_term_link( $tag );// tag archive link
					$output .= '<li '.$li_style.'><a '.$styling.' href="'.$tag_link.'">'.$tag_title.'</a></li>';
					}
					$output .= '</ul>';
				}
			return $output;
		}
	}
}
