<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Sold Count for WooCommerce Products
 * Displays the product sold count.
 */


if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('wc_product_img_modern', 'avia_please_install_woo');
	return;
}


if ( !class_exists( 'avia_sold_count' ) )
{
	class avia_sold_count extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Units Sold Count', 'avia_framework' );
			$this->config['tab']		= __('WooCommerce', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."sold-count.png";
			$this->config['order']		= 45;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['shortcode'] 	= 'sold_count';
			$this->config['tooltip'] 	= __('Displays the number of units sold for a product.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['posttype'] 	= array('product',__('This element can only be used on single product pages','avia_framework'));
		}
		
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),

					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array(), $atts, $this->config['shortcode']));
			
			global $product;
			$units_sold = get_post_meta( $product->id, 'total_sales', true );
			
			$output  = "";
			if(is_rtl()):
				$output .= '<div class="sold-count '.$av_display_classes.'" itemprop="text" style="padding-bottom:5px;"> <span class="av_font_icon avia_animate_when_visible  0 av-icon-style-  av-no-color avia-icon-pos-left  avia_start_animation avia_start_delayed_animation" style="clear:right:important;"><span class="av-icon-char" ';
			else:
				$output .= '<div class="sold-count '.$av_display_classes.'" itemprop="text" style="padding-bottom:5px;"> <span class="av_font_icon avia_animate_when_visible  0 av-icon-style-  av-no-color avia-icon-pos-left  avia_start_animation avia_start_delayed_animation" style="clear:left:important;"><span class="av-icon-char" ';
			endif;
			$output .= 'aria-hidden="true" data-av_icon="" data-av_iconfont="entypo-fontello"></span></span><span style="font-weight:bold;">UNITS SOLD:</span> ';
			$output .= $units_sold;
			$output .= '</div>';

				return $output;
		}
	}
}



				
